/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.builder.guide.AxisComponent;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLabelSpecFactory;
import org.jetbrains.letsPlot.core.plot.builder.presentation.LabelSpec;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001 B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012JB\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fH\u0002J!\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014H\u0000\u00a2\u0006\u0002\b\u001cJ\u0016\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eJ>\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fH\u0002J\"\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\"\u0010\u001e\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/AxisUtil;", "", "()V", "breaksData", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$BreaksData;", "scaleBreaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "domain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "flipAxis", "", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "axisTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "labelAdjustments", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelAdjustments;", "buildGrid", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "breaks", "", "coordinateSystem", "horizontal", "minorDomainBreaks", "visibleMajorDomainBreak", "minorDomainBreaks$plot_builder", "tickLabelBaseOffset", "toClient", "v", "TickLabelsMap", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nAxisUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AxisUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/AxisUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1549#2:211\n1620#2,3:212\n1569#2,11:215\n1864#2,2:226\n1866#2:229\n1580#2:230\n1549#2:231\n1620#2,3:232\n1549#2:235\n1620#2,2:236\n1622#2:239\n1549#2:240\n1620#2,3:241\n1549#2:244\n1620#2,3:245\n1549#2:248\n1620#2,3:249\n1549#2:252\n1620#2,3:253\n1549#2:256\n1620#2,2:257\n1603#2,9:259\n1855#2:268\n1856#2:270\n1612#2,11:271\n766#2:282\n857#2:283\n1747#2,3:284\n858#2:287\n1#3:228\n1#3:238\n1#3:269\n*S KotlinDebug\n*F\n+ 1 AxisUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/AxisUtil\n*L\n26#1:211\n26#1:212,3\n50#1:215,11\n50#1:226,2\n50#1:229\n50#1:230\n68#1:231\n68#1:232,3\n74#1:235\n74#1:236,2\n74#1:239\n78#1:240\n78#1:241,3\n107#1:244\n107#1:245,3\n112#1:248\n112#1:249,3\n122#1:252\n122#1:253,3\n136#1:256\n136#1:257,2\n136#1:259,9\n136#1:268\n136#1:270\n136#1:271,11\n140#1:282\n140#1:283\n141#1:284,3\n140#1:287\n50#1:228\n136#1:269\n*E\n"})
public final class AxisUtil {
    @NotNull
    public static final AxisUtil INSTANCE = new AxisUtil();

    private AxisUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Double> minorDomainBreaks$plot_builder(@NotNull List<Double> visibleMajorDomainBreak) {
        List list2;
        Intrinsics.checkNotNullParameter(visibleMajorDomainBreak, (String)"visibleMajorDomainBreak");
        if (visibleMajorDomainBreak.size() > 2) {
            void $this$mapTo$iv$iv;
            double step2 = ((Number)visibleMajorDomainBreak.get(1)).doubleValue() - ((Number)visibleMajorDomainBreak.get(0)).doubleValue();
            double start2 = ((Number)visibleMajorDomainBreak.get(0)).doubleValue() - step2 / 2.0;
            Iterable $this$map$iv = (Iterable)new IntRange(0, visibleMajorDomainBreak.size());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(start2 + (double)it * step2);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AxisComponent.BreaksData breaksData(@NotNull ScaleBreaks scaleBreaks, @NotNull CoordinateSystem coord, @NotNull DoubleRectangle domain, boolean flipAxis, @NotNull Orientation orientation, @NotNull AxisTheme axisTheme, @NotNull AxisComponent.TickLabelAdjustments labelAdjustments) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        List list2;
        Collection collection;
        void $this$mapIndexedNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)scaleBreaks, (String)"scaleBreaks");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)axisTheme, (String)"axisTheme");
        Intrinsics.checkNotNullParameter((Object)labelAdjustments, (String)"labelAdjustments");
        List<DoubleVector> majorClientBreaks = this.toClient(scaleBreaks.getTransformedValues(), domain, coord, flipAxis, orientation.isHorizontal());
        DoubleVector tickLabelBaseOffset = this.tickLabelBaseOffset(axisTheme, orientation);
        TickLabelsMap labelsMap = new TickLabelsMap(orientation.isHorizontal(), PlotLabelSpecFactory.INSTANCE.axisTick(axisTheme), labelAdjustments.getRotationDegree());
        Iterable $this$mapIndexedNotNull$iv = CollectionsKt.zip((Iterable)scaleBreaks.getLabels(), (Iterable)majorClientBreaks);
        boolean $i$f$mapIndexedNotNull = false;
        Iterable iterable = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo22 = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed22 = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            Integer n;
            void pair2;
            void element$iv$iv;
            int n2;
            if ((n2 = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n2;
            boolean bl = false;
            Pair pair3 = (Pair)element$iv$iv;
            int i = index$iv$iv;
            boolean bl2 = false;
            if ((DoubleVector)pair2.getSecond() == null) {
                n = null;
            } else {
                DoubleVector br;
                String label2 = (String)pair2.getFirst();
                DoubleVector labelOffset = tickLabelBaseOffset.add(labelAdjustments.additionalOffset(i));
                double loc = orientation.isHorizontal() ? br.getX() : br.getY();
                n = labelsMap.haveSpace(loc, label2, labelOffset) ? Integer.valueOf(i) : null;
            }
            if (n == null) continue;
            Integer it$iv$iv = n;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List visibleBreaks = (List)destination$iv$iv;
        List<String> visibleMajorLabels = SeriesUtil.INSTANCE.pickAtIndices(scaleBreaks.getLabels(), visibleBreaks);
        List<Double> visibleMajorDomainBreak = SeriesUtil.INSTANCE.pickAtIndices(scaleBreaks.getTransformedValues(), visibleBreaks);
        if (visibleMajorDomainBreak.size() > 1) {
            Iterator $this$mapTo$iv$iv3;
            Object item$iv$iv$iv;
            double step2 = ((Number)visibleMajorDomainBreak.get(1)).doubleValue() - ((Number)visibleMajorDomainBreak.get(0)).doubleValue();
            double start2 = ((Number)visibleMajorDomainBreak.get(0)).doubleValue() - step2 / 2.0;
            Iterable $this$map$iv3 = (Iterable)new IntRange(0, visibleMajorDomainBreak.size());
            boolean $i$f$map = false;
            item$iv$iv$iv = $this$map$iv3;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator index$iv$iv = $this$mapTo$iv$iv3.iterator();
            while (index$iv$iv.hasNext()) {
                void it;
                int item$iv$iv;
                int pair2 = item$iv$iv = ((IntIterator)index$iv$iv).nextInt();
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(start2 + (double)it * step2);
            }
            list2 = (List)destination$iv$iv2;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List visibleMinorDomainBreak = list2;
        Iterable $i$f$mapIndexedNotNullTo22 = SeriesUtil.INSTANCE.pickAtIndices(majorClientBreaks, visibleBreaks);
        boolean $i$f$map22 = false;
        void $i$f$forEachIndexed22 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            DoubleVector $i$f$mapTo2 = (DoubleVector)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            void v2 = it;
            if (v2 == null) {
                boolean $i$a$-checkNotNull-AxisUtil$breaksData$visibleMajorClientBreaks$1$22 = false;
                String $i$a$-checkNotNull-AxisUtil$breaksData$visibleMajorClientBreaks$1$22 = "Nulls are not allowed. Properly clean and sync breaks, grids and labels.";
                throw new IllegalStateException($i$a$-checkNotNull-AxisUtil$breaksData$visibleMajorClientBreaks$1$22.toString());
            }
            collection.add(v2);
        }
        List visibleMajorClientBreaks = (List)destination$iv$iv3;
        Iterable $i$f$map22 = this.toClient(visibleMinorDomainBreak, domain, coord, flipAxis, orientation.isHorizontal());
        boolean $i$f$map = false;
        destination$iv$iv3 = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DoubleVector bl = (DoubleVector)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl4 = false;
            void v3 = it;
            if (v3 == null) {
                boolean bl5 = false;
                String string = "Nulls are not allowed. Properly clean and sync breaks, grids and labels.";
                throw new IllegalStateException(string.toString());
            }
            collection.add(v3);
        }
        List visibleMinorClientBreaks = (List)destination$iv$iv4;
        List<List<DoubleVector>> majorGrid = this.buildGrid(visibleMajorDomainBreak, domain, coord, flipAxis, orientation.isHorizontal());
        List<List<DoubleVector>> minorGrid = this.buildGrid(visibleMinorDomainBreak, domain, coord, flipAxis, orientation.isHorizontal());
        return new AxisComponent.BreaksData(visibleMajorClientBreaks, visibleMajorLabels, visibleMinorClientBreaks, majorGrid, minorGrid);
    }

    public static /* synthetic */ AxisComponent.BreaksData breaksData$default(AxisUtil axisUtil, ScaleBreaks scaleBreaks, CoordinateSystem coordinateSystem, DoubleRectangle doubleRectangle, boolean bl, Orientation orientation, AxisTheme axisTheme, AxisComponent.TickLabelAdjustments tickLabelAdjustments, int n, Object object) {
        if ((n & 0x40) != 0) {
            tickLabelAdjustments = new AxisComponent.TickLabelAdjustments(orientation, null, null, 0.0, null, 30, null);
        }
        return axisUtil.breaksData(scaleBreaks, coordinateSystem, doubleRectangle, bl, orientation, axisTheme, tickLabelAdjustments);
    }

    private final DoubleVector toClient(DoubleVector v, CoordinateSystem coordinateSystem, boolean flipAxis) {
        return SeriesUtil.INSTANCE.finiteOrNull(coordinateSystem.toClient(v.flipIf(flipAxis)));
    }

    private final DoubleRectangle toClient(DoubleRectangle v, CoordinateSystem coordinateSystem, boolean flipAxis) {
        return coordinateSystem.toClient(v.flipIf(flipAxis));
    }

    /*
     * WARNING - void declaration
     */
    private final List<DoubleVector> toClient(List<Double> breaks, DoubleRectangle domain, CoordinateSystem coordinateSystem, boolean flipAxis, boolean horizontal) {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = breaks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DoubleVector doubleVector;
            void breakValue;
            double d = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv;
            boolean bl = false;
            boolean bl2 = horizontal;
            if (bl2) {
                doubleVector = new DoubleVector((double)breakValue, domain.yRange().getUpperEnd());
            } else if (!bl2) {
                doubleVector = new DoubleVector(domain.xRange().getLowerEnd(), (double)breakValue);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(doubleVector);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DoubleVector breakValue = (DoubleVector)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            DoubleVector doubleVector = INSTANCE.toClient((DoubleVector)it, coordinateSystem, flipAxis);
            if (doubleVector == null) {
                doubleVector = null;
            }
            collection.add(doubleVector);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<DoubleVector>> buildGrid(List<Double> breaks, DoubleRectangle domain, CoordinateSystem coordinateSystem, boolean flipAxis, boolean horizontal) {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv = breaks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            List list2;
            Object[] objectArray;
            void breakCoord;
            double d = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv;
            boolean bl = false;
            boolean bl2 = horizontal;
            if (bl2) {
                objectArray = new DoubleVector[]{new DoubleVector((double)breakCoord, domain.yRange().getLowerEnd()), new DoubleVector((double)breakCoord, domain.yRange().getUpperEnd())};
                list2 = CollectionsKt.listOf((Object[])objectArray);
            } else if (!bl2) {
                objectArray = new DoubleVector[]{new DoubleVector(domain.xRange().getLowerEnd(), (double)breakCoord), new DoubleVector(domain.xRange().getUpperEnd(), (double)breakCoord)};
                list2 = CollectionsKt.listOf((Object[])objectArray);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(list2);
        }
        List domainGrid = (List)destination$iv$iv;
        Iterable $this$map$iv2 = domainGrid;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            void line2;
            List list3 = (List)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = (Iterable)line2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                DoubleVector it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl3 = false;
                DoubleVector it = (DoubleVector)element$iv$iv;
                boolean bl4 = false;
                if (INSTANCE.toClient(it, coordinateSystem, flipAxis) == null) continue;
                boolean bl5 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            collection.add((List)destination$iv$iv3);
        }
        List clientGrid = (List)destination$iv$iv2;
        DoubleRectangle doubleRectangle = this.toClient(domain, coordinateSystem, flipAxis);
        if (doubleRectangle == null || (doubleRectangle = doubleRectangle.inflate(-6.0)) == null) {
            throw new IllegalStateException("Cannot transform domain".toString());
        }
        DoubleRectangle gridArea = doubleRectangle;
        Iterable $this$filter$iv = clientGrid;
        boolean $i$f$filter = false;
        destination$iv$iv2 = $this$filter$iv;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block12: {
                List line3 = (List)element$iv$iv;
                boolean bl6 = false;
                Iterable $this$any$iv = line3;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DoubleVector it = (DoubleVector)element$iv;
                        boolean bl7 = false;
                        boolean bl8 = horizontal ? gridArea.xRange().contains(it.getX()) : gridArea.yRange().contains(it.getY());
                        if (!bl8) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        return (List)destination$iv$iv4;
    }

    @NotNull
    public final DoubleVector tickLabelBaseOffset(@NotNull AxisTheme axisTheme, @NotNull Orientation orientation) {
        DoubleVector doubleVector;
        Intrinsics.checkNotNullParameter((Object)axisTheme, (String)"axisTheme");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        double distance = axisTheme.tickLabelDistance(orientation.isHorizontal());
        switch (WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
            case 1: {
                doubleVector = new DoubleVector(axisTheme.tickLabelMargins().getLeft() - distance, 0.0);
                break;
            }
            case 2: {
                doubleVector = new DoubleVector(distance - axisTheme.tickLabelMargins().getRight(), 0.0);
                break;
            }
            case 3: {
                doubleVector = new DoubleVector(0.0, axisTheme.tickLabelMargins().getTop() - distance);
                break;
            }
            case 4: {
                doubleVector = new DoubleVector(0.0, distance - axisTheme.tickLabelMargins().getBottom());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return doubleVector;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J(\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/AxisUtil$TickLabelsMap;", "", "horizontalAxis", "", "labelSpec", "Lorg/jetbrains/letsPlot/core/plot/builder/presentation/LabelSpec;", "rotationDegree", "", "(ZLorg/jetbrains/letsPlot/core/plot/builder/presentation/LabelSpec;D)V", "filledAreas", "Ljava/util/ArrayList;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "Lkotlin/collections/ArrayList;", "haveSpace", "loc", "label", "", "labelOffset", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "isHorizontal", "isRelevant", "isVertical", "labelRect", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nAxisUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AxisUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/AxisUtil$TickLabelsMap\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n1747#2,3:211\n*S KotlinDebug\n*F\n+ 1 AxisUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/AxisUtil$TickLabelsMap\n*L\n174#1:211,3\n*E\n"})
    public static final class TickLabelsMap {
        private final boolean horizontalAxis;
        @NotNull
        private final LabelSpec labelSpec;
        private final double rotationDegree;
        @NotNull
        private final ArrayList<DoubleRectangle> filledAreas;

        public TickLabelsMap(boolean horizontalAxis, @NotNull LabelSpec labelSpec, double rotationDegree) {
            Intrinsics.checkNotNullParameter((Object)labelSpec, (String)"labelSpec");
            this.horizontalAxis = horizontalAxis;
            this.labelSpec = labelSpec;
            this.rotationDegree = rotationDegree;
            this.filledAreas = new ArrayList();
        }

        public final boolean haveSpace(double loc, @NotNull String label2, @NotNull DoubleVector labelOffset) {
            boolean bl;
            DoubleRectangle rect2;
            block5: {
                Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
                Intrinsics.checkNotNullParameter((Object)labelOffset, (String)"labelOffset");
                if (!this.isRelevant(this.rotationDegree)) {
                    return true;
                }
                rect2 = this.labelRect(loc, label2, this.rotationDegree, labelOffset);
                Iterable $this$any$iv = this.filledAreas;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DoubleRectangle it = (DoubleRectangle)element$iv;
                        boolean bl2 = false;
                        if (!it.intersects(rect2)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return false;
            }
            this.filledAreas.add(rect2);
            return true;
        }

        private final boolean isRelevant(double rotationDegree) {
            return this.isVertical(rotationDegree) || this.isHorizontal(rotationDegree);
        }

        private final boolean isHorizontal(double rotationDegree) {
            return rotationDegree % (double)180 == 0.0;
        }

        private final boolean isVertical(double rotationDegree) {
            return Math.abs(rotationDegree / (double)90) % (double)2 == 1.0;
        }

        private final DoubleRectangle labelRect(double loc, String label2, double rotationDegree, DoubleVector labelOffset) {
            DoubleVector labelNormalSize = this.labelSpec.dimensions(label2);
            DoubleVector wh = labelNormalSize.flipIf(this.isVertical(rotationDegree));
            DoubleVector origin = this.horizontalAxis ? new DoubleVector(loc, 0.0) : new DoubleVector(0.0, loc);
            return new DoubleRectangle(origin, wh).subtract(wh.mul(0.5)).add(labelOffset);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Orientation.values().length];
            try {
                nArray[Orientation.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.TOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.BOTTOM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

