/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale.breaks;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.formatting.datetime.DateTimeFormatUtil;
import org.jetbrains.letsPlot.core.commons.time.interval.NiceTimeInterval;
import org.jetbrains.letsPlot.core.commons.time.interval.TimeInterval;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u0007\u001a\u00020\bR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/breaks/TimeScaleTickFormatterFactory;", "", "minInterval", "Lorg/jetbrains/letsPlot/core/commons/time/interval/TimeInterval;", "(Lorg/jetbrains/letsPlot/core/commons/time/interval/TimeInterval;)V", "formatPattern", "", "step", "", "getFormatter", "Lkotlin/Function1;", "", "plot-base"})
public final class TimeScaleTickFormatterFactory {
    @Nullable
    private final TimeInterval minInterval;

    public TimeScaleTickFormatterFactory(@Nullable TimeInterval minInterval) {
        this.minInterval = minInterval;
    }

    @NotNull
    public final Function1<Number, String> getFormatter(double step2) {
        return DateTimeFormatUtil.INSTANCE.formatterDateUTC(this.formatPattern(step2));
    }

    private final String formatPattern(double step2) {
        double end;
        double start2;
        int intervalCount;
        int stepCount;
        if (step2 < 1000.0) {
            return TimeInterval.Companion.milliseconds(1).getTickFormatPattern();
        }
        if (this.minInterval != null && (stepCount = 100) >= (intervalCount = this.minInterval.range(start2 = 0.0, end = step2 * (double)stepCount).size())) {
            return this.minInterval.getTickFormatPattern();
        }
        if (step2 > 3.1536E10) {
            return "%Y";
        }
        TimeInterval interval = NiceTimeInterval.INSTANCE.forMillis(step2);
        return interval.getTickFormatPattern();
    }
}

