/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.algorithms.GeometryKt;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintColorUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.PathData;
import org.jetbrains.letsPlot.core.plot.base.geom.util.TargetCollectorHelper;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetCollector;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\n2\u0006\u0010\u0012\u001a\u00020\tJ\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010\u0018\u001a\u00020\u000f2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00150\u001aJ\u001a\u0010\u001c\u001a\u00020\u000f2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00150\u001aJ \u0010\u001e\u001a\u00020\u000f2\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\n0\u001aJ\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/util/TargetCollectorHelper;", "", "geomKind", "Lorg/jetbrains/letsPlot/core/plot/base/GeomKind;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "(Lorg/jetbrains/letsPlot/core/plot/base/GeomKind;Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;)V", "colorMarkerMapper", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "", "Lorg/jetbrains/letsPlot/commons/values/Color;", "targetCollector", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetCollector;", "addLine", "", "lineString", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "p", "addPath", "path", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/PathData;", "tooltipParams", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetCollector$TooltipParams;", "addPaths", "paths", "", "", "addPolygons", "pathDataList", "addVariadicPaths", "reduce", "plot-base"})
@SourceDebugExtension(value={"SMAP\nTargetCollectorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetCollectorHelper.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/TargetCollectorHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1549#2:87\n1620#2,3:88\n1360#2:91\n1446#2,5:92\n1855#2,2:97\n1#3:99\n*S KotlinDebug\n*F\n+ 1 TargetCollectorHelper.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/TargetCollectorHelper\n*L\n35#1:87\n35#1:88,3\n49#1:91\n49#1:92,5\n55#1:97,2\n*E\n"})
public final class TargetCollectorHelper {
    @NotNull
    private final GeomContext ctx;
    @NotNull
    private final Function1<DataPointAesthetics, List<Color>> colorMarkerMapper;
    @NotNull
    private final GeomTargetCollector targetCollector;

    public TargetCollectorHelper(@NotNull GeomKind geomKind, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)((Object)geomKind), (String)"geomKind");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        this.ctx = ctx2;
        this.colorMarkerMapper = HintColorUtil.INSTANCE.createColorMarkerMapper(geomKind, this.ctx);
        this.targetCollector = this.ctx.getTargetCollector();
    }

    public final void addPaths(@NotNull Map<Integer, PathData> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        for (Map.Entry<Integer, PathData> path2 : paths.entrySet()) {
            PathData simplifiedPath = this.reduce(path2.getValue());
            this.addPath(simplifiedPath, new GeomTargetCollector.TooltipParams(null, null, null, (List)this.colorMarkerMapper.invoke((Object)simplifiedPath.getAes()), 7, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addVariadicPaths(@NotNull Map<Integer, ? extends List<PathData>> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        for (List<PathData> list2 : paths.values()) {
            void $this$flatMapTo$iv$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                PathData pathData = (PathData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.reduce((PathData)p0));
            }
            List simplifiedSubPaths = (List)destination$iv$iv;
            Map subPathAesIndex = new LinkedHashMap();
            for (PathData subPath : simplifiedSubPaths) {
                for (DataPointAesthetics p : subPath.getAesthetics()) {
                    subPathAesIndex.put(p.index(), subPath.getAes());
                }
            }
            Iterable $this$flatMap$iv = simplifiedSubPaths;
            boolean $i$f$flatMap = false;
            Iterable p = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                PathData p0 = (PathData)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = p0.getPoints();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List list22 = (List)destination$iv$iv2;
            PathData flattenPath = new PathData(list22);
            this.addPath(flattenPath, new GeomTargetCollector.TooltipParams(null, null, null, (Function1)new Function1<Integer, List<? extends Color>>(this, (Map<Integer, DataPointAesthetics>)subPathAesIndex){
                final /* synthetic */ TargetCollectorHelper this$0;
                final /* synthetic */ Map<Integer, DataPointAesthetics> $subPathAesIndex;
                {
                    this.this$0 = $receiver;
                    this.$subPathAesIndex = $subPathAesIndex;
                    super(1);
                }

                @NotNull
                public final List<Color> invoke(int i) {
                    Function1 function1 = TargetCollectorHelper.access$getColorMarkerMapper$p(this.this$0);
                    DataPointAesthetics dataPointAesthetics = this.$subPathAesIndex.get(i);
                    Intrinsics.checkNotNull((Object)dataPointAesthetics);
                    return (List)function1.invoke((Object)dataPointAesthetics);
                }
            }, 7, null));
        }
    }

    public final void addPolygons(@NotNull Map<Integer, PathData> pathDataList) {
        Intrinsics.checkNotNullParameter(pathDataList, (String)"pathDataList");
        Iterable $this$forEach$iv = pathDataList.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PathData pathData = (PathData)element$iv;
            boolean bl = false;
            this.targetCollector.addPolygon(pathData.getCoordinates(), pathData.getAes().index(), new GeomTargetCollector.TooltipParams(null, null, null, (List)this.colorMarkerMapper.invoke((Object)pathData.getAes()), 7, null), TipLayoutHint.Kind.CURSOR_TOOLTIP);
        }
    }

    private final void addPath(PathData path2, GeomTargetCollector.TooltipParams tooltipParams) {
        TipLayoutHint.Kind kind;
        TipLayoutHint.Kind kind2 = kind = TipLayoutHint.Kind.VERTICAL_TOOLTIP;
        GeomTargetCollector.TooltipParams tooltipParams2 = tooltipParams;
        Function1 function1 = (Function1)new Function1<Integer, Integer>(path2){
            final /* synthetic */ PathData $path;
            {
                this.$path = $path;
                super(1);
            }

            @NotNull
            public final Integer invoke(int i) {
                return this.$path.getAesthetics().get(i).index();
            }
        };
        List<DoubleVector> list2 = path2.getCoordinates();
        GeomTargetCollector geomTargetCollector = this.targetCollector;
        boolean bl = false;
        boolean bl2 = this.ctx.getFlipped();
        TipLayoutHint.Kind kind3 = bl2 ? kind : null;
        if (kind3 == null) {
            kind3 = TipLayoutHint.Kind.HORIZONTAL_TOOLTIP;
        }
        geomTargetCollector.addPath(list2, (Function1<? super Integer, Integer>)function1, tooltipParams2, kind3);
    }

    private final PathData reduce(PathData path2) {
        return new PathData(GeometryKt.reduce(path2.getPoints(), 0.5, reduce.1.INSTANCE));
    }

    public final void addLine(@NotNull List<DoubleVector> lineString2, @NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter(lineString2, (String)"lineString");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        this.targetCollector.addPath(lineString2, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(p){
            final /* synthetic */ DataPointAesthetics $p;
            {
                this.$p = $p;
                super(1);
            }

            @NotNull
            public final Integer invoke(int it) {
                return this.$p.index();
            }
        }), new GeomTargetCollector.TooltipParams(null, null, null, (List)this.colorMarkerMapper.invoke((Object)p), 7, null), TipLayoutHint.Kind.HORIZONTAL_TOOLTIP);
    }

    public static final /* synthetic */ Function1 access$getColorMarkerMapper$p(TargetCollectorHelper $this) {
        return $this.colorMarkerMapper;
    }
}

