/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.CollectionsExKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.algorithms.AdaptiveResampler;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.algorithms.GeometryKt;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.commons.values.Colors;
import org.jetbrains.letsPlot.core.commons.geometry.PolylineSimplifier;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.Scale;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.aes.AestheticsUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.LinesHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.LinesHelper$renderPaths$;
import org.jetbrains.letsPlot.core.plot.base.geom.util.PathData;
import org.jetbrains.letsPlot.core.plot.base.geom.util.PathPoint;
import org.jetbrains.letsPlot.core.plot.base.render.linetype.LineType;
import org.jetbrains.letsPlot.core.plot.base.render.svg.LinePath;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\r\b\u0016\u0018\u0000 ;2\u00020\u0001:\u0001;B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJP\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00132\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00132\b\b\u0002\u0010\u0016\u001a\u00020\nJ0\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013JH\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\r0\u001a2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0016\b\u0002\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00132\b\b\u0002\u0010\u001e\u001a\u00020\nJ6\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013J(\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a2\u0006\u0010\"\u001a\u00020\nJ4\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\n2\u0014\b\u0002\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020)0\u0013J\u0018\u0010*\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u0011H\u0002J\u0006\u0010+\u001a\u00020\nJF\u0010,\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\r0\u001a2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00132\u0006\u0010\u001e\u001a\u00020\nH\u0002JV\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00132\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00132\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\nJ\"\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001c0/2\u0006\u0010'\u001a\u00020\nJ.\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\r0\u001a2\u0006\u0010'\u001a\u00020\nJ&\u0010.\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u00112\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00140\r2\u0006\u0010'\u001a\u00020\nH\u0002J4\u00102\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\r0\u001a2\u0018\u00103\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\r0\u001aH\u0002J\u000e\u00104\u001a\u00020$2\u0006\u00105\u001a\u00020\nJ\u000e\u00106\u001a\u00020$2\u0006\u00107\u001a\u00020\nJ\u001c\u00108\u001a\b\u0012\u0004\u0012\u00020\u00140\r2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00140\rH\u0002J4\u00109\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\r0\u001a2\u0018\u0010:\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\r0\u001aH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/util/LinesHelper;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "(Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;)V", "myAlphaEnabled", "", "myResamplingEnabled", "createBands", "", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/LinePath;", "dataPoints", "", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "toLocationUpper", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "toLocationLower", "simplifyBorders", "createLines", "toLocation", "createPathData", "", "", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/PathData;", "locationTransform", "closePath", "createPathDataByGroup", "createSteps", "paths", "horizontalThenVertical", "decorate", "", "path", "p", "filled", "strokeScaler", "", "decorateFillingPart", "meetsRadarPlotReq", "preparePathData", "renderBands", "renderPaths", "", "aes", "points", "resamplePathData", "pathData", "setAlphaEnabled", "b", "setResamplingEnabled", "resample", "simplify", "toClient", "domainPathData", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nLinesHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinesHelper.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/LinesHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Geometry.kt\norg/jetbrains/letsPlot/commons/intern/typedGeometry/algorithms/GeometryKt\n*L\n1#1,344:1\n1549#2:345\n1620#2,3:346\n1855#2,2:349\n1238#2,2:353\n1549#2:355\n1620#2,3:356\n1241#2:359\n1603#2,9:360\n1855#2:369\n1856#2:371\n1612#2:372\n1549#2:374\n1620#2,3:375\n1238#2,4:381\n1238#2,2:387\n1360#2:389\n1446#2,5:390\n1241#2:395\n1238#2,2:398\n1549#2:400\n1620#2,2:401\n1603#2,9:403\n1855#2:412\n1856#2:414\n1612#2:415\n1622#2:416\n1241#2:417\n1238#2,2:420\n1360#2:422\n1446#2,5:423\n1241#2:428\n1238#2,2:431\n1549#2:433\n1620#2,2:434\n1549#2:436\n1620#2,3:437\n1360#2:440\n1446#2,2:441\n1549#2:443\n1620#2,3:444\n1448#2,3:447\n1622#2:450\n1241#2:451\n453#3:351\n403#3:352\n453#3:379\n403#3:380\n453#3:385\n403#3:386\n453#3:396\n403#3:397\n453#3:418\n403#3:419\n453#3:429\n403#3:430\n1#4:370\n1#4:378\n1#4:413\n22#5:373\n*S KotlinDebug\n*F\n+ 1 LinesHelper.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/LinesHelper\n*L\n57#1:345\n57#1:346,3\n82#1:349,2\n126#1:353,2\n139#1:355\n139#1:356,3\n126#1:359\n144#1:360,9\n144#1:369\n144#1:371\n144#1:372\n200#1:374\n200#1:375,3\n213#1:381,4\n219#1:387,2\n219#1:389\n219#1:390,5\n219#1:395\n224#1:398,2\n225#1:400\n225#1:401,2\n227#1:403,9\n227#1:412\n227#1:414\n227#1:415\n225#1:416\n224#1:417\n235#1:420,2\n235#1:422\n235#1:423,5\n235#1:428\n243#1:431,2\n244#1:433\n244#1:434,2\n247#1:436\n247#1:437,3\n248#1:440\n248#1:441,2\n248#1:443\n248#1:444,3\n248#1:447,3\n244#1:450\n243#1:451\n126#1:351\n126#1:352\n213#1:379\n213#1:380\n219#1:385\n219#1:386\n224#1:396\n224#1:397\n235#1:418\n235#1:419\n243#1:429\n243#1:430\n144#1:370\n227#1:413\n200#1:373\n*E\n"})
public class LinesHelper
extends GeomHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean myAlphaEnabled;
    private boolean myResamplingEnabled;

    public LinesHelper(@NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        super(pos, coord, ctx2);
        this.myAlphaEnabled = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean meetsRadarPlotReq() {
        if (!this.getCoord().isPolar()) return false;
        PlotContext plotContext = this.getCtx$plot_base().getPlotContext();
        Object object = plotContext;
        if (plotContext == null) return true;
        Scale scale = object.getScale(Aes.Companion.getX());
        object = scale;
        if (scale == null) return true;
        if (!object.isContinuous()) return true;
        return false;
    }

    public final void setAlphaEnabled(boolean b2) {
        this.myAlphaEnabled = b2;
    }

    public final void setResamplingEnabled(boolean resample) {
        this.myResamplingEnabled = resample;
    }

    @NotNull
    public final List<LinePath> createLines(@NotNull Iterable<? extends DataPointAesthetics> dataPoints2, @NotNull Function1<? super DataPointAesthetics, DoubleVector> toLocation2) {
        Intrinsics.checkNotNullParameter(dataPoints2, (String)"dataPoints");
        Intrinsics.checkNotNullParameter(toLocation2, (String)"toLocation");
        Map<Integer, PathData> pathDataByGroup = this.createPathDataByGroup(dataPoints2, toLocation2);
        return this.renderPaths(pathDataByGroup.values(), false);
    }

    @NotNull
    public final List<LinePath> renderPaths(@NotNull Map<Integer, ? extends List<PathData>> paths, boolean filled) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        return this.renderPaths(CollectionsKt.flatten((Iterable)paths.values()), filled);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LinePath> renderPaths(@NotNull Collection<PathData> paths, boolean filled) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Iterable $this$map$iv = paths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void path2;
            PathData pathData = (PathData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.renderPaths(path2.getAes(), path2.getCoordinates(), filled));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Map<Integer, List<PathData>> createPathData(@NotNull Iterable<? extends DataPointAesthetics> dataPoints2, @NotNull Function1<? super DataPointAesthetics, DoubleVector> locationTransform, boolean closePath) {
        Intrinsics.checkNotNullParameter(dataPoints2, (String)"dataPoints");
        Intrinsics.checkNotNullParameter(locationTransform, (String)"locationTransform");
        Map<Integer, List<PathData>> domainInterpolatedData = this.preparePathData(dataPoints2, locationTransform, closePath);
        return this.toClient(domainInterpolatedData);
    }

    public static /* synthetic */ Map createPathData$default(LinesHelper linesHelper, Iterable iterable, Function1 function1, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createPathData");
        }
        if ((n & 2) != 0) {
            function1 = GeomUtil.INSTANCE.getTO_LOCATION_X_Y();
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return linesHelper.createPathData(iterable, function1, bl);
    }

    @NotNull
    public final Map<Integer, PathData> createPathDataByGroup(@NotNull Iterable<? extends DataPointAesthetics> dataPoints2, @NotNull Function1<? super DataPointAesthetics, DoubleVector> toLocation2) {
        Intrinsics.checkNotNullParameter(dataPoints2, (String)"dataPoints");
        Intrinsics.checkNotNullParameter(toLocation2, (String)"toLocation");
        return GeomUtil.INSTANCE.createPathGroups(dataPoints2, this.toClientLocation$plot_base(toLocation2), true, false);
    }

    @NotNull
    public final List<LinePath> createSteps(@NotNull Map<Integer, PathData> paths, boolean horizontalThenVertical) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        ArrayList<LinePath> linePaths = new ArrayList<LinePath>();
        Iterable $this$forEach$iv = paths.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PathData subPath = (PathData)element$iv;
            boolean bl = false;
            List<DoubleVector> points = subPath.getCoordinates();
            if (!(!((Collection)points).isEmpty())) continue;
            ArrayList<DoubleVector> newPoints = new ArrayList<DoubleVector>();
            DoubleVector prev = null;
            for (DoubleVector point2 : points) {
                if (prev != null) {
                    double x2 = horizontalThenVertical ? point2.getX() : prev.getX();
                    double y2 = horizontalThenVertical ? prev.getY() : point2.getY();
                    newPoints.add(new DoubleVector(x2, y2));
                }
                newPoints.add(point2);
                prev = point2;
            }
            LinePath line2 = LinePath.Companion.line((Iterable<DoubleVector>)newPoints);
            LinesHelper.decorate$default(this, line2, subPath.getAes(), false, null, 8, null);
            linePaths.add(line2);
        }
        return linePaths;
    }

    @NotNull
    public final List<LinePath> createBands(@NotNull Iterable<? extends DataPointAesthetics> dataPoints2, @NotNull Function1<? super DataPointAesthetics, DoubleVector> toLocationUpper, @NotNull Function1<? super DataPointAesthetics, DoubleVector> toLocationLower, boolean simplifyBorders) {
        Intrinsics.checkNotNullParameter(dataPoints2, (String)"dataPoints");
        Intrinsics.checkNotNullParameter(toLocationUpper, (String)"toLocationUpper");
        Intrinsics.checkNotNullParameter(toLocationLower, (String)"toLocationLower");
        return this.renderBands(dataPoints2, toLocationUpper, toLocationLower, simplifyBorders, false);
    }

    public static /* synthetic */ List createBands$default(LinesHelper linesHelper, Iterable iterable, Function1 function1, Function1 function12, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createBands");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return linesHelper.createBands(iterable, (Function1<? super DataPointAesthetics, DoubleVector>)function1, (Function1<? super DataPointAesthetics, DoubleVector>)function12, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LinePath> renderBands(@NotNull Iterable<? extends DataPointAesthetics> dataPoints2, @NotNull Function1<? super DataPointAesthetics, DoubleVector> toLocationUpper, @NotNull Function1<? super DataPointAesthetics, DoubleVector> toLocationLower, boolean simplifyBorders, boolean closePath) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(dataPoints2, (String)"dataPoints");
        Intrinsics.checkNotNullParameter(toLocationUpper, (String)"toLocationUpper");
        Intrinsics.checkNotNullParameter(toLocationLower, (String)"toLocationLower");
        Map<Integer, List<PathData>> domainUpperPathData = this.preparePathData(dataPoints2, toLocationUpper, closePath);
        Map<Integer, List<PathData>> domainLowerPathData = this.preparePathData(dataPoints2, toLocationLower, closePath);
        Map<Integer, List<PathData>> $this$mapValues$iv = domainUpperPathData;
        boolean $i$f$mapValues = false;
        Map<Integer, List<PathData>> map2 = $this$mapValues$iv;
        Object destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            List<PathData> lowerPathData;
            List list2;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            int group2 = ((Number)entry2.getKey()).intValue();
            List upperPathData = (List)entry2.getValue();
            if (domainLowerPathData.get(group2) == null) {
                list2 = CollectionsKt.emptyList();
            } else if (upperPathData.isEmpty() || lowerPathData.isEmpty()) {
                list2 = CollectionsKt.emptyList();
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                if (!(upperPathData.size() == lowerPathData.size())) {
                    boolean $i$a$-require-LinesHelper$renderBands$domainBandsPathData$1$22 = false;
                    String $i$a$-require-LinesHelper$renderBands$domainBandsPathData$1$22 = "Upper and lower path data should contain the same number of paths";
                    throw new IllegalArgumentException($i$a$-require-LinesHelper$renderBands$domainBandsPathData$1$22.toString());
                }
                Iterable iterable = CollectionsKt.zip((Iterable)upperPathData, (Iterable)lowerPathData);
                boolean $i$f$map = false;
                void var28_35 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Pair pair2 = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl3 = false;
                    PathData upperPath = (PathData)pair2.component1();
                    PathData lowerPath = (PathData)pair2.component2();
                    collection.add(new PathData(CollectionsKt.plus((Collection)upperPath.getPoints(), (Iterable)CollectionsKt.reversed((Iterable)lowerPath.getPoints()))));
                }
                list2 = (List)destination$iv$iv2;
            }
            List list3 = list2;
            map4.put(k, list3);
        }
        Map domainBandsPathData = destination$iv$iv;
        Map<Integer, List<PathData>> clientBandsPathData = this.toClient(domainBandsPathData);
        Iterable $this$mapNotNull$iv = CollectionsKt.flatten((Iterable)clientBandsPathData.values());
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            LinePath linePath;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            PathData pathData = (PathData)element$iv$iv;
            boolean bl4 = false;
            List<DoubleVector> points = pathData.getCoordinates();
            if (!((Collection)points).isEmpty()) {
                LinePath path2 = LinePath.Companion.polygon((Iterable<DoubleVector>)(simplifyBorders ? this.simplify(points) : points));
                this.decorateFillingPart(path2, pathData.getAes());
                linePath = path2;
            } else {
                linePath = null;
            }
            if (linePath == null) continue;
            LinePath it$iv$iv = linePath;
            boolean bl5 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        return (List)destination$iv$iv3;
    }

    private final List<DoubleVector> simplify(List<DoubleVector> points) {
        double weightLimit = 0.25;
        return PolylineSimplifier.Companion.douglasPeucker(points).setWeightLimit(weightLimit).getPoints();
    }

    public final void decorate(@NotNull LinePath path2, @NotNull DataPointAesthetics p, boolean filled, @NotNull Function1<? super DataPointAesthetics, Double> strokeScaler2) {
        Color stroke;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(strokeScaler2, (String)"strokeScaler");
        Color color = stroke = p.color();
        Intrinsics.checkNotNull((Object)color);
        double strokeAlpha = AestheticsUtil.INSTANCE.alpha(color, p);
        path2.color().set(Colors.INSTANCE.withOpacity(stroke, strokeAlpha));
        if (filled || !this.myAlphaEnabled) {
            path2.color().set(stroke);
        }
        if (filled) {
            this.decorateFillingPart(path2, p);
        }
        double size2 = ((Number)strokeScaler2.invoke((Object)p)).doubleValue();
        path2.width().set(size2);
        LineType lineType = p.lineType();
        if (!lineType.isBlank() && !lineType.isSolid()) {
            path2.dashArray().set(lineType.getDashArray());
        }
    }

    public static /* synthetic */ void decorate$default(LinesHelper linesHelper, LinePath linePath, DataPointAesthetics dataPointAesthetics, boolean bl, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decorate");
        }
        if ((n & 8) != 0) {
            function1 = (Function1)new Function1<DataPointAesthetics, Double>((Object)AesScaling.INSTANCE){

                @NotNull
                public final Double invoke(@NotNull DataPointAesthetics p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((AesScaling)this.receiver).strokeWidth(p0);
                }
            };
        }
        linesHelper.decorate(linePath, dataPointAesthetics, bl, (Function1<? super DataPointAesthetics, Double>)function1);
    }

    private final void decorateFillingPart(LinePath path2, DataPointAesthetics p) {
        Color fill2;
        Color color = fill2 = p.fill();
        Intrinsics.checkNotNull((Object)color);
        double fillAlpha = AestheticsUtil.INSTANCE.alpha(color, p);
        path2.fill().set(Colors.INSTANCE.withOpacity(fill2, fillAlpha));
    }

    /*
     * WARNING - void declaration
     */
    private final LinePath renderPaths(DataPointAesthetics aes2, List<DoubleVector> points, boolean filled) {
        LinePath linePath;
        boolean bl = filled;
        if (bl) {
            void p0;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean $i$f$splitRings22 = false;
            Iterable $i$f$splitRings22 = GeometryKt.splitRings(points, renderPaths$$inlined$splitRings$1.INSTANCE);
            Companion companion = Companion;
            LinePath.Companion companion2 = LinePath.Companion;
            boolean $i$f$map22 = false;
            void var9_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p02;
                List list2 = (List)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(companion.reduce((List)p02));
            }
            List list3 = (List)destination$iv$iv;
            companion = Companion;
            Iterable $i$f$map22 = list3;
            boolean bl3 = false;
            linePath = companion2.polygon(companion.insertPathSeparators((Iterable)p0));
        } else if (!bl) {
            linePath = LinePath.Companion.line(LinesHelper.Companion.reduce(points));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        LinePath element = linePath;
        LinesHelper.decorate$default(this, element, aes2, filled, null, 8, null);
        return element;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Integer, List<PathData>> preparePathData(Iterable<? extends DataPointAesthetics> dataPoints2, Function1<? super DataPointAesthetics, DoubleVector> locationTransform, boolean closePath) {
        void $this$mapValuesTo$iv$iv;
        Map<Integer, PathData> domainPathData;
        Map<Integer, PathData> $this$mapValues$iv = domainPathData = GeomUtil.INSTANCE.createPathGroups(dataPoints2, locationTransform, true, closePath);
        boolean $i$f$mapValues = false;
        Map<Integer, PathData> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            PathData pathData = (PathData)entry2.getValue();
            List list2 = CollectionsKt.listOf((Object)pathData);
            map4.put(k, list2);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Integer, List<PathData>> toClient(Map<Integer, ? extends List<PathData>> domainPathData) {
        Map<Integer, List<PathData>> map2;
        boolean bl = this.myResamplingEnabled;
        if (bl) {
            void $this$mapValuesTo$iv$iv2;
            Map<Integer, ? extends List<PathData>> $this$mapValues$iv = domainPathData;
            boolean $i$f$mapValues = false;
            Map<Integer, ? extends List<PathData>> map3 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv2.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map4 = destination$iv$iv;
                boolean bl2 = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map5 = map4;
                boolean bl3 = false;
                List groupPath = (List)entry2.getValue();
                Iterable iterable = groupPath;
                Companion companion = Companion;
                boolean $i$f$flatMap = false;
                void var22_50 = $this$flatMap$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    PathData p0 = (PathData)element$iv$iv;
                    boolean bl4 = false;
                    Iterable list$iv$iv = companion.splitByStyle(p0);
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                List list2 = (List)destination$iv$iv2;
                map5.put(k, list2);
            }
            Map domainVariadicPathData = destination$iv$iv;
            Map<Integer, List<PathData>> domainInterpolatedPathData = Companion.interpolatePathData(domainVariadicPathData);
            map2 = this.resamplePathData(domainInterpolatedPathData);
        } else if (!bl) {
            void $this$mapValuesTo$iv$iv;
            Map clientPathData;
            List list3;
            Map map6;
            Object k;
            Object object;
            Map<Integer, ? extends List<PathData>> $this$mapValues$iv = domainPathData;
            boolean $i$f$mapValues = false;
            Map<Integer, ? extends List<PathData>> $this$mapValuesTo$iv$iv2 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv2.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void $this$mapTo$iv$iv;
                Map.Entry it$iv$iv = (Map.Entry)element$iv$iv$iv;
                object = destination$iv$iv;
                boolean bl5 = false;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map6 = object;
                boolean bl6 = false;
                List groupPath = (List)entry.getValue();
                Iterable $this$map$iv = groupPath;
                boolean $i$f$map = false;
                Iterable $i$f$flatMap = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void $this$mapNotNullTo$iv$iv;
                    void segment2;
                    PathData element$iv$iv = (PathData)item$iv$iv;
                    Collection list$iv$iv = destination$iv$iv3;
                    boolean bl7 = false;
                    Iterable $this$mapNotNull$iv = segment2.getPoints();
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv4 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        PathPoint pathPoint;
                        Object element$iv$iv$iv2;
                        Object element$iv$iv2 = element$iv$iv$iv2 = iterator2.next();
                        boolean bl8 = false;
                        PathPoint p = (PathPoint)element$iv$iv2;
                        boolean bl9 = false;
                        DoubleVector doubleVector = this.toClient(p.getCoord(), p.getAes());
                        if (doubleVector != null) {
                            DoubleVector it = doubleVector;
                            boolean bl10 = false;
                            pathPoint = new PathPoint(p.getAes(), it);
                        } else {
                            pathPoint = null;
                        }
                        if (pathPoint == null) continue;
                        PathPoint it$iv$iv2 = pathPoint;
                        boolean bl11 = false;
                        destination$iv$iv4.add(it$iv$iv2);
                    }
                    List points = (List)destination$iv$iv4;
                    list$iv$iv.add(new PathData(points));
                }
                list3 = (List)destination$iv$iv3;
                map6.put(k, list3);
            }
            Map $this$mapValues$iv2 = clientPathData = destination$iv$iv;
            boolean $i$f$mapValues2 = false;
            destination$iv$iv = $this$mapValues$iv2;
            Map destination$iv$iv5 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
            boolean $i$f$mapValuesTo2 = false;
            Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo2 = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                void it$iv$iv;
                object = (Map.Entry)element$iv$iv$iv;
                Map map7 = destination$iv$iv5;
                boolean bl12 = false;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map6 = map7;
                boolean bl13 = false;
                List pathData = (List)entry.getValue();
                Iterable $i$f$map = pathData;
                Companion companion = Companion;
                boolean $i$f$flatMap = false;
                void $i$f$mapTo = $this$flatMap$iv;
                Collection destination$iv$iv6 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    PathData p0 = (PathData)element$iv$iv;
                    boolean bl14 = false;
                    Iterable list$iv$iv = companion.splitByStyle(p0);
                    CollectionsKt.addAll((Collection)destination$iv$iv6, (Iterable)list$iv$iv);
                }
                list3 = (List)destination$iv$iv6;
                map6.put(k, list3);
            }
            Map clientVariadicPathData = destination$iv$iv5;
            map2 = Companion.interpolatePathData(clientVariadicPathData);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Integer, List<PathData>> resamplePathData(Map<Integer, ? extends List<PathData>> pathData) {
        void $this$mapValuesTo$iv$iv;
        Map<Integer, ? extends List<PathData>> $this$mapValues$iv = pathData;
        boolean $i$f$mapValues = false;
        Map<Integer, ? extends List<PathData>> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            List path2 = (List)entry2.getValue();
            Iterable $this$map$iv = path2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                List list2;
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv2;
                void segment2;
                PathData pathData2 = (PathData)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                Iterable iterable2 = CollectionsKt.windowed$default((Iterable)segment2.getPoints(), (int)2, (int)0, (boolean)false, (int)6, null);
                boolean $i$f$map2 = false;
                void var29_29 = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    list2 = (List)item$iv$iv2;
                    Collection collection2 = destination$iv$iv3;
                    boolean bl4 = false;
                    PathPoint p1 = (PathPoint)list2.get(0);
                    PathPoint p2 = (PathPoint)list2.get(1);
                    collection2.add(TuplesKt.to((Object)p1.getAes(), AdaptiveResampler.Companion.resample(p1.getCoord(), p2.getCoord(), 0.5, (Function1<? super DoubleVector, DoubleVector>)((Function1)new Function1<DoubleVector, DoubleVector>(this, p1){
                        final /* synthetic */ LinesHelper this$0;
                        final /* synthetic */ PathPoint $p1;
                        {
                            this.this$0 = $receiver;
                            this.$p1 = $p1;
                            super(1);
                        }

                        @Nullable
                        public final DoubleVector invoke(@NotNull DoubleVector it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return this.this$0.toClient(it, this.$p1.getAes());
                        }
                    }))));
                }
                $this$map$iv2 = (List)destination$iv$iv3;
                boolean $i$f$flatMap = false;
                $this$mapTo$iv$iv2 = $this$flatMap$iv;
                destination$iv$iv3 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    void $this$mapTo$iv$iv3;
                    list2 = (Pair)element$iv$iv;
                    boolean bl5 = false;
                    DataPointAesthetics aes2 = (DataPointAesthetics)list2.component1();
                    List points = (List)list2.component2();
                    Iterable $this$map$iv3 = points;
                    boolean $i$f$map3 = false;
                    Iterable iterable3 = $this$map$iv3;
                    Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                    boolean $i$f$mapTo3 = false;
                    for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                        void it;
                        DoubleVector doubleVector = (DoubleVector)item$iv$iv3;
                        Collection collection3 = destination$iv$iv4;
                        boolean bl6 = false;
                        collection3.add(new PathPoint(aes2, (DoubleVector)it));
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv4;
                    CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                }
                List smoothed2 = (List)destination$iv$iv3;
                collection.add(new PathData(smoothed2));
            }
            List list3 = (List)destination$iv$iv2;
            map4.put(k, list3);
        }
        return destination$iv$iv;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0007H\u0002J2\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00040\t2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00040\tJ \u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004H\u0002J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u0017\u001a\u00020\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/util/LinesHelper$Companion;", "", "()V", "insertPathSeparators", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "rings", "", "interpolatePathData", "", "", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/PathData;", "variadicPath", "lerp", "p1", "p2", "progress", "", "midPointsPathInterpolator", "path", "reduce", "points", "splitByStyle", "pathData", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nLinesHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinesHelper.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/LinesHelper$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,344:1\n1549#2:345\n1620#2,3:346\n1549#2:349\n1620#2,3:350\n1559#2:353\n1590#2,4:354\n1238#2,4:360\n453#3:358\n403#3:359\n*S KotlinDebug\n*F\n+ 1 LinesHelper.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/LinesHelper$Companion\n*L\n283#1:345\n283#1:346,3\n293#1:349\n293#1:350,3\n301#1:353\n301#1:354,4\n327#1:360,4\n327#1:358\n327#1:359\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final List<DoubleVector> reduce(List<DoubleVector> points) {
            return GeometryKt.reduce(points, 0.999, reduce.1.INSTANCE);
        }

        private final List<DoubleVector> insertPathSeparators(Iterable<? extends List<DoubleVector>> rings) {
            ArrayList<DoubleVector> result2 = new ArrayList<DoubleVector>();
            for (List<DoubleVector> list2 : rings) {
                if (!result2.isEmpty()) {
                    result2.add(LinePath.Companion.getEND_OF_SUBPATH());
                }
                result2.addAll((Collection)list2);
            }
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<PathData> splitByStyle(@NotNull PathData pathData) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)pathData, (String)"pathData");
            Function1[] function1Array = new Function1[]{splitByStyle.1.INSTANCE, splitByStyle.2.INSTANCE, splitByStyle.3.INSTANCE, splitByStyle.4.INSTANCE, splitByStyle.5.INSTANCE};
            Iterable $this$map$iv = CollectionsExKt.splitBy((Collection)pathData.getPoints(), ComparisonsKt.compareBy((Function1[])function1Array));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                List list2 = (List)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new PathData((List<PathPoint>)p0));
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<PathData> midPointsPathInterpolator(List<PathData> path2) {
            void $this$mapIndexedTo$iv$iv;
            PathData prevSubPath;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            if (path2.size() == 1) {
                return path2;
            }
            Iterable $this$map$iv = CollectionsKt.windowed$default((Iterable)path2, (int)2, (int)1, (boolean)false, (int)4, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                List list2 = (List)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                prevSubPath = (PathData)list2.get(0);
                PathData nextSubPath = (PathData)list2.get(1);
                DoubleVector prevSubPathEnd = (DoubleVector)CollectionsKt.last(prevSubPath.getCoordinates());
                DoubleVector nextSubPathStart = (DoubleVector)CollectionsKt.first(nextSubPath.getCoordinates());
                DoubleVector midPoint = Companion.lerp(prevSubPathEnd, nextSubPathStart, 0.5);
                collection.add(midPoint);
            }
            List jointPoints = (List)destination$iv$iv;
            Iterable $this$mapIndexed$iv = path2;
            boolean $i$f$mapIndexed = false;
            $this$mapTo$iv$iv = $this$mapIndexed$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                PathPoint leftJointPoint;
                PathData pathData;
                void subPath;
                void i;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                prevSubPath = (PathData)item$iv$iv;
                int nextSubPath = n;
                collection = destination$iv$iv;
                boolean bl = false;
                void var15_18 = i;
                if (var15_18 == false) {
                    PathPoint rightJointPoint = PathPoint.copy$default((PathPoint)CollectionsKt.last(subPath.getPoints()), null, (DoubleVector)jointPoints.get((int)i), 1, null);
                    pathData = new PathData(CollectionsKt.plus((Collection)subPath.getPoints(), (Object)rightJointPoint));
                } else if (var15_18 == CollectionsKt.getLastIndex(path2)) {
                    leftJointPoint = PathPoint.copy$default((PathPoint)CollectionsKt.first(subPath.getPoints()), null, (DoubleVector)jointPoints.get((int)(i - true)), 1, null);
                    pathData = new PathData(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)leftJointPoint), (Iterable)subPath.getPoints()));
                } else {
                    leftJointPoint = PathPoint.copy$default((PathPoint)CollectionsKt.first(subPath.getPoints()), null, (DoubleVector)jointPoints.get((int)(i - true)), 1, null);
                    PathPoint rightJointPoint = PathPoint.copy$default((PathPoint)CollectionsKt.last(subPath.getPoints()), null, (DoubleVector)jointPoints.get((int)i), 1, null);
                    pathData = new PathData(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)leftJointPoint), (Iterable)subPath.getPoints()), (Object)rightJointPoint));
                }
                collection.add(pathData);
            }
            return (List)destination$iv$iv;
        }

        private final DoubleVector lerp(DoubleVector p1, DoubleVector p2, double progress) {
            return p1.add(p2.subtract(p1).mul(progress));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<Integer, List<PathData>> interpolatePathData(@NotNull Map<Integer, ? extends List<PathData>> variadicPath) {
            void $this$mapValuesTo$iv$iv;
            Intrinsics.checkNotNullParameter(variadicPath, (String)"variadicPath");
            Map<Integer, ? extends List<PathData>> $this$mapValues$iv = variadicPath;
            boolean $i$f$mapValues = false;
            Map<Integer, ? extends List<PathData>> map2 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl2 = false;
                List pathSegments = (List)entry2.getValue();
                List<PathData> list2 = Companion.midPointsPathInterpolator(pathSegments);
                map4.put(k, list2);
            }
            return destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

