/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.geom.util.DataPointAestheticsDelegate;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.render.linetype.NamedLineType;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathDataBuilder;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 \u00152\u00020\u0001:\u0003\u0015\u0016\u0017B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec;", "", "angle", "", "length", "end", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec$End;", "type", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec$Type;", "(DDLorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec$End;Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec$Type;)V", "getAngle", "()D", "getEnd", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec$End;", "isOnFirstEnd", "", "()Z", "isOnLastEnd", "getLength", "getType", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec$Type;", "Companion", "End", "Type", "plot-base"})
public final class ArrowSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double angle;
    private final double length;
    @NotNull
    private final End end;
    @NotNull
    private final Type type;

    public ArrowSpec(double angle, double length, @NotNull End end, @NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)end), (String)"end");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.angle = angle;
        this.length = length;
        this.end = end;
        this.type = type;
    }

    public final double getAngle() {
        return this.angle;
    }

    public final double getLength() {
        return this.length;
    }

    @NotNull
    public final End getEnd() {
        return this.end;
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    public final boolean isOnFirstEnd() {
        return this.end == End.FIRST || this.end == End.BOTH;
    }

    public final boolean isOnLastEnd() {
        return this.end == End.LAST || this.end == End.BOTH;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J*\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\n\u001a\u00020\u000bJ(\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011J\u0014\u0010\u0017\u001a\u00020\u0006*\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec$Companion;", "", "()V", "createArrowAtEnd", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgPathElement;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "start", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "end", "arrowSpec", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec;", "createArrows", "", "geometry", "createElement", "polarAngle", "", "x", "y", "miterLength", "headAngle", "strokeWidth", "toArrowAes", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nArrowSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrowSpec.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1#2:129\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<SvgPathElement> createArrows(@NotNull DataPointAesthetics p, @NotNull List<DoubleVector> geometry, @NotNull ArrowSpec arrowSpec) {
            DoubleVector end;
            DoubleVector start2;
            List list2;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter(geometry, (String)"geometry");
            Intrinsics.checkNotNullParameter((Object)arrowSpec, (String)"arrowSpec");
            List arrows = new ArrayList();
            if (arrowSpec.isOnFirstEnd()) {
                list2 = CollectionsKt.reversed((Iterable)CollectionsKt.take((Iterable)geometry, (int)2));
                start2 = (DoubleVector)list2.get(0);
                end = (DoubleVector)list2.get(1);
                ((Collection)arrows).add(this.createArrowAtEnd(p, start2, end, arrowSpec));
            }
            if (arrowSpec.isOnLastEnd()) {
                list2 = CollectionsKt.takeLast(geometry, (int)2);
                start2 = (DoubleVector)list2.get(0);
                end = (DoubleVector)list2.get(1);
                ((Collection)arrows).add(this.createArrowAtEnd(p, start2, end, arrowSpec));
            }
            return CollectionsKt.filterNotNull((Iterable)arrows);
        }

        private final SvgPathElement createArrowAtEnd(DataPointAesthetics p, DoubleVector start2, DoubleVector end, ArrowSpec arrowSpec) {
            double abscissa = end.getX() - start2.getX();
            double ordinate = end.getY() - start2.getY();
            if (abscissa == 0.0 && ordinate == 0.0) {
                return null;
            }
            double polarAngle = Math.atan2(ordinate, abscissa);
            DataPointAesthetics arrowAes = this.toArrowAes(arrowSpec, p);
            SvgPathElement arrow = this.createElement(polarAngle, end.getX(), end.getY(), arrowSpec);
            KFunction strokeScaler2 = (KFunction)new Function1<DataPointAesthetics, Double>((Object)AesScaling.INSTANCE){

                @NotNull
                public final Double invoke(@NotNull DataPointAesthetics p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((AesScaling)this.receiver).strokeWidth(p0);
                }
            };
            GeomHelper.Companion.decorate(arrow, arrowAes, true, (Function1<? super DataPointAesthetics, Double>)((Function1)strokeScaler2), arrowSpec.getType() == Type.CLOSED);
            double miterLimit = this.miterLength(arrowSpec.getAngle() * (double)2, ((Number)((Function1)strokeScaler2).invoke((Object)p)).doubleValue());
            arrow.strokeMiterLimit().set(Math.abs(miterLimit));
            return arrow;
        }

        private final SvgPathElement createElement(double polarAngle, double x2, double y2, ArrowSpec arrowSpec) {
            ArrowSpec $this$createElement_u24lambda_u240 = arrowSpec;
            boolean bl = false;
            double[] dArray = new double[]{x2 - $this$createElement_u24lambda_u240.getLength() * Math.cos(polarAngle - $this$createElement_u24lambda_u240.getAngle()), x2, x2 - $this$createElement_u24lambda_u240.getLength() * Math.cos(polarAngle + $this$createElement_u24lambda_u240.getAngle())};
            double[] xs = dArray;
            ArrowSpec $this$createElement_u24lambda_u241 = arrowSpec;
            boolean bl2 = false;
            double[] dArray2 = new double[]{y2 - $this$createElement_u24lambda_u241.getLength() * Math.sin(polarAngle - $this$createElement_u24lambda_u241.getAngle()), y2, y2 - $this$createElement_u24lambda_u241.getLength() * Math.sin(polarAngle + $this$createElement_u24lambda_u241.getAngle())};
            double[] ys = dArray2;
            SvgPathDataBuilder b2 = SvgPathDataBuilder.moveTo$default(new SvgPathDataBuilder(true), xs[0], ys[0], false, 4, null);
            for (int i = 1; i < 3; ++i) {
                b2.lineTo(xs[i], ys[i], true);
            }
            if (arrowSpec.getType() == Type.CLOSED) {
                b2.closePath();
            }
            return new SvgPathElement(b2.build());
        }

        private final DataPointAesthetics toArrowAes(ArrowSpec $this$toArrowAes, DataPointAesthetics p) {
            return new DataPointAestheticsDelegate($this$toArrowAes, p){
                private final boolean filled;
                {
                    this.filled = $receiver.getType() == Type.CLOSED;
                }

                @Nullable
                public <T> T get(@NotNull Aes<T> aes2) {
                    Intrinsics.checkNotNullParameter(aes2, (String)"aes");
                    Aes<T> aes3 = aes2;
                    Object value = Intrinsics.areEqual(aes3, Aes.Companion.getFILL()) ? (this.filled ? super.get(Aes.Companion.getCOLOR()) : Color.Companion.getTRANSPARENT()) : (Intrinsics.areEqual(aes3, Aes.Companion.getLINETYPE()) ? NamedLineType.SOLID : super.get(aes2));
                    return (T)value;
                }
            };
        }

        public final double miterLength(double headAngle, double strokeWidth) {
            return strokeWidth / Math.sin(headAngle / (double)2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec$End;", "", "(Ljava/lang/String;I)V", "LAST", "FIRST", "BOTH", "plot-base"})
    public static final class End
    extends Enum<End> {
        public static final /* enum */ End LAST = new End();
        public static final /* enum */ End FIRST = new End();
        public static final /* enum */ End BOTH = new End();
        private static final /* synthetic */ End[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static End[] values() {
            return (End[])$VALUES.clone();
        }

        public static End valueOf(String value) {
            return Enum.valueOf(End.class, value);
        }

        @NotNull
        public static EnumEntries<End> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = endArray = new End[]{End.LAST, End.FIRST, End.BOTH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec$Type;", "", "(Ljava/lang/String;I)V", "OPEN", "CLOSED", "plot-base"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type OPEN = new Type();
        public static final /* enum */ Type CLOSED = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.OPEN, Type.CLOSED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

