/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom.util;

import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.colorspace.HSL;
import org.jetbrains.letsPlot.commons.colorspace.HSLKt;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.commons.values.Colors;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.aes.AestheticsBuilder;
import org.jetbrains.letsPlot.core.plot.base.geom.LabelGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.TextGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.util.DataPointAestheticsDelegate;
import org.jetbrains.letsPlot.core.plot.base.geom.util.TextUtil;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.style.TextStyle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000eJ&\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J(\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000e0\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012J\u001a\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u001c\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/util/AnnotationsUtil;", "", "()V", "CONTRAST_RATIO", "", "chooseColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "background", "textColor", "createLabelElement", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "text", "", "location", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "textParams", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/AnnotationsUtil$TextParams;", "geomContext", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "boundsCenter", "createTextElement", "textSizeGetter", "Lkotlin/Function2;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "textStyle", "Lorg/jetbrains/letsPlot/datamodel/svg/style/TextStyle;", "ctx", "toTextDataPointAesthetics", "p", "TextParams", "plot-base"})
@SourceDebugExtension(value={"SMAP\nAnnotationsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationsUtil.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/AnnotationsUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1#2:133\n*E\n"})
public final class AnnotationsUtil {
    @NotNull
    public static final AnnotationsUtil INSTANCE = new AnnotationsUtil();
    private static final double CONTRAST_RATIO = 4.5;

    private AnnotationsUtil() {
    }

    @NotNull
    public final Function2<String, DataPointAesthetics, DoubleVector> textSizeGetter(@NotNull TextStyle textStyle, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        return (Function2)new Function2<String, DataPointAesthetics, DoubleVector>(textStyle, ctx2){
            final /* synthetic */ TextStyle $textStyle;
            final /* synthetic */ GeomContext $ctx;
            {
                this.$textStyle = $textStyle;
                this.$ctx = $ctx;
                super(2);
            }

            @NotNull
            public final DoubleVector invoke(@NotNull String text2, @NotNull DataPointAesthetics p) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                return TextUtil.measure$default(TextUtil.INSTANCE, text2, AnnotationsUtil.access$toTextDataPointAesthetics(AnnotationsUtil.INSTANCE, new TextParams(this.$textStyle, null, null, null, null, null, null, 126, null), p), this.$ctx, 0.0, 8, null);
            }
        };
    }

    @NotNull
    public final Color chooseColor(@NotNull Color background) {
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        return Colors.INSTANCE.luminance(background) < 0.5 ? Color.Companion.getWHITE() : Color.Companion.getBLACK();
    }

    @NotNull
    public final Color chooseColor(@NotNull Color textColor2, @NotNull Color background) {
        Intrinsics.checkNotNullParameter((Object)textColor2, (String)"textColor");
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        double contrastRatio = Colors.INSTANCE.contrastRatio(background, textColor2);
        double step2 = Colors.INSTANCE.luminance(background) < 0.5 ? 0.05 : -0.05;
        double newLightness = HSLKt.hslFromRgb(textColor2).getL() + step2;
        Color newColor = textColor2;
        while (contrastRatio < 4.5) {
            boolean bl = 0.0 <= newLightness ? newLightness <= 1.0 : false;
            if (!bl) break;
            newColor = AnnotationsUtil.chooseColor$correctLightness(textColor2, newLightness);
            contrastRatio = Colors.INSTANCE.contrastRatio(background, newColor);
            newLightness += step2;
        }
        return newColor;
    }

    private final DataPointAesthetics toTextDataPointAesthetics(TextParams textParams, DataPointAesthetics p) {
        return new DataPointAestheticsDelegate(p, textParams){
            final /* synthetic */ TextParams $textParams;
            {
                this.$textParams = $textParams;
                super($p);
            }

            @Nullable
            public <T> T get(@NotNull Aes<T> aes2) {
                Object object;
                Intrinsics.checkNotNullParameter(aes2, (String)"aes");
                Aes<T> aes3 = aes2;
                if (Intrinsics.areEqual(aes3, Aes.Companion.getSIZE())) {
                    object = this.$textParams.getStyle().getSize() / (double)2;
                } else if (Intrinsics.areEqual(aes3, Aes.Companion.getFAMILY())) {
                    object = this.$textParams.getStyle().getFamily();
                } else if (Intrinsics.areEqual(aes3, Aes.Companion.getFONTFACE())) {
                    object = this.$textParams.getStyle().getFace().toString();
                } else if (Intrinsics.areEqual(aes3, Aes.Companion.getCOLOR())) {
                    object = this.$textParams.getColor();
                    if (object == null) {
                        object = this.$textParams.getStyle().getColor();
                    }
                } else if (Intrinsics.areEqual(aes3, Aes.Companion.getHJUST())) {
                    object = this.$textParams.getHjust();
                    if (object == null) {
                        object = "middle";
                    }
                } else if (Intrinsics.areEqual(aes3, Aes.Companion.getVJUST())) {
                    object = this.$textParams.getVjust();
                    if (object == null) {
                        object = "center";
                    }
                } else if (Intrinsics.areEqual(aes3, Aes.Companion.getFILL())) {
                    object = this.$textParams.getFill();
                    if (object == null) {
                        object = Color.Companion.getTRANSPARENT();
                    }
                } else if (Intrinsics.areEqual(aes3, Aes.Companion.getANGLE())) {
                    Double d = this.$textParams.getAngle();
                    object = d != null ? d : 0.0;
                } else if (Intrinsics.areEqual(aes3, Aes.Companion.getALPHA())) {
                    Double d = this.$textParams.getAlpha();
                    object = d != null ? d : 1.0;
                } else {
                    object = super.get(aes2);
                }
                Object value = object;
                return (T)value;
            }
        };
    }

    static /* synthetic */ DataPointAesthetics toTextDataPointAesthetics$default(AnnotationsUtil annotationsUtil, TextParams textParams, DataPointAesthetics dataPointAesthetics, int n, Object object) {
        if ((n & 2) != 0) {
            dataPointAesthetics = new AestheticsBuilder(0, 1, null).build().dataPointAt(0);
        }
        return annotationsUtil.toTextDataPointAesthetics(textParams, dataPointAesthetics);
    }

    @NotNull
    public final SvgGElement createTextElement(@NotNull String text2, @NotNull DoubleVector location2, @NotNull TextParams textParams, @NotNull GeomContext geomContext) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)textParams, (String)"textParams");
        Intrinsics.checkNotNullParameter((Object)geomContext, (String)"geomContext");
        return new TextGeom().buildTextComponent(AnnotationsUtil.toTextDataPointAesthetics$default(this, textParams, null, 2, null), location2, text2, 1.0, geomContext, null);
    }

    @NotNull
    public final SvgGElement createLabelElement(@NotNull String text2, @NotNull DoubleVector location2, @NotNull TextParams textParams, @NotNull GeomContext geomContext, @Nullable DoubleVector boundsCenter) {
        LabelGeom labelGeom;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)textParams, (String)"textParams");
        Intrinsics.checkNotNullParameter((Object)geomContext, (String)"geomContext");
        LabelGeom $this$createLabelElement_u24lambda_u240 = labelGeom = new LabelGeom();
        boolean bl = false;
        $this$createLabelElement_u24lambda_u240.setBorderWidth(0.0);
        $this$createLabelElement_u24lambda_u240.setPaddingFactor(0.0);
        return labelGeom.buildTextComponent(AnnotationsUtil.toTextDataPointAesthetics$default(this, textParams, null, 2, null), location2, text2, 1.0, geomContext, boundsCenter);
    }

    private static final Color chooseColor$correctLightness(Color color, double newLightness) {
        HSL hsl = HSLKt.hslFromRgb(color);
        return HSLKt.rgbFromHsl$default(new HSL(hsl.getH(), hsl.getS(), newLightness), 0.0, 2, null);
    }

    public static final /* synthetic */ DataPointAesthetics access$toTextDataPointAesthetics(AnnotationsUtil $this, TextParams textParams, DataPointAesthetics p) {
        return $this.toTextDataPointAesthetics(textParams, p);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\rJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\nH\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0010\u0010 \u001a\u0004\u0018\u00010\nH\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ`\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\nH\u00c6\u0001\u00a2\u0006\u0002\u0010\"J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\u0007H\u00d6\u0001R\u0015\u0010\f\u001a\u0004\u0018\u00010\n\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u0011\u0010\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016\u00a8\u0006)"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/util/AnnotationsUtil$TextParams;", "", "style", "Lorg/jetbrains/letsPlot/datamodel/svg/style/TextStyle;", "color", "Lorg/jetbrains/letsPlot/commons/values/Color;", "hjust", "", "vjust", "angle", "", "fill", "alpha", "(Lorg/jetbrains/letsPlot/datamodel/svg/style/TextStyle;Lorg/jetbrains/letsPlot/commons/values/Color;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Double;Lorg/jetbrains/letsPlot/commons/values/Color;Ljava/lang/Double;)V", "getAlpha", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getAngle", "getColor", "()Lorg/jetbrains/letsPlot/commons/values/Color;", "getFill", "getHjust", "()Ljava/lang/String;", "getStyle", "()Lorg/jetbrains/letsPlot/datamodel/svg/style/TextStyle;", "getVjust", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(Lorg/jetbrains/letsPlot/datamodel/svg/style/TextStyle;Lorg/jetbrains/letsPlot/commons/values/Color;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Double;Lorg/jetbrains/letsPlot/commons/values/Color;Ljava/lang/Double;)Lorg/jetbrains/letsPlot/core/plot/base/geom/util/AnnotationsUtil$TextParams;", "equals", "", "other", "hashCode", "", "toString", "plot-base"})
    public static final class TextParams {
        @NotNull
        private final TextStyle style;
        @Nullable
        private final Color color;
        @Nullable
        private final String hjust;
        @Nullable
        private final String vjust;
        @Nullable
        private final Double angle;
        @Nullable
        private final Color fill;
        @Nullable
        private final Double alpha;

        public TextParams(@NotNull TextStyle style, @Nullable Color color, @Nullable String hjust, @Nullable String vjust, @Nullable Double angle, @Nullable Color fill2, @Nullable Double alpha) {
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            this.style = style;
            this.color = color;
            this.hjust = hjust;
            this.vjust = vjust;
            this.angle = angle;
            this.fill = fill2;
            this.alpha = alpha;
        }

        public /* synthetic */ TextParams(TextStyle textStyle, Color color, String string, String string2, Double d, Color color2, Double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                color = null;
            }
            if ((n & 4) != 0) {
                string = null;
            }
            if ((n & 8) != 0) {
                string2 = null;
            }
            if ((n & 0x10) != 0) {
                d = null;
            }
            if ((n & 0x20) != 0) {
                color2 = null;
            }
            if ((n & 0x40) != 0) {
                d2 = null;
            }
            this(textStyle, color, string, string2, d, color2, d2);
        }

        @NotNull
        public final TextStyle getStyle() {
            return this.style;
        }

        @Nullable
        public final Color getColor() {
            return this.color;
        }

        @Nullable
        public final String getHjust() {
            return this.hjust;
        }

        @Nullable
        public final String getVjust() {
            return this.vjust;
        }

        @Nullable
        public final Double getAngle() {
            return this.angle;
        }

        @Nullable
        public final Color getFill() {
            return this.fill;
        }

        @Nullable
        public final Double getAlpha() {
            return this.alpha;
        }

        @NotNull
        public final TextStyle component1() {
            return this.style;
        }

        @Nullable
        public final Color component2() {
            return this.color;
        }

        @Nullable
        public final String component3() {
            return this.hjust;
        }

        @Nullable
        public final String component4() {
            return this.vjust;
        }

        @Nullable
        public final Double component5() {
            return this.angle;
        }

        @Nullable
        public final Color component6() {
            return this.fill;
        }

        @Nullable
        public final Double component7() {
            return this.alpha;
        }

        @NotNull
        public final TextParams copy(@NotNull TextStyle style, @Nullable Color color, @Nullable String hjust, @Nullable String vjust, @Nullable Double angle, @Nullable Color fill2, @Nullable Double alpha) {
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            return new TextParams(style, color, hjust, vjust, angle, fill2, alpha);
        }

        public static /* synthetic */ TextParams copy$default(TextParams textParams, TextStyle textStyle, Color color, String string, String string2, Double d, Color color2, Double d2, int n, Object object) {
            if ((n & 1) != 0) {
                textStyle = textParams.style;
            }
            if ((n & 2) != 0) {
                color = textParams.color;
            }
            if ((n & 4) != 0) {
                string = textParams.hjust;
            }
            if ((n & 8) != 0) {
                string2 = textParams.vjust;
            }
            if ((n & 0x10) != 0) {
                d = textParams.angle;
            }
            if ((n & 0x20) != 0) {
                color2 = textParams.fill;
            }
            if ((n & 0x40) != 0) {
                d2 = textParams.alpha;
            }
            return textParams.copy(textStyle, color, string, string2, d, color2, d2);
        }

        @NotNull
        public String toString() {
            return "TextParams(style=" + this.style + ", color=" + this.color + ", hjust=" + this.hjust + ", vjust=" + this.vjust + ", angle=" + this.angle + ", fill=" + this.fill + ", alpha=" + this.alpha + ')';
        }

        public int hashCode() {
            int result2 = this.style.hashCode();
            result2 = result2 * 31 + (this.color == null ? 0 : this.color.hashCode());
            result2 = result2 * 31 + (this.hjust == null ? 0 : this.hjust.hashCode());
            result2 = result2 * 31 + (this.vjust == null ? 0 : this.vjust.hashCode());
            result2 = result2 * 31 + (this.angle == null ? 0 : ((Object)this.angle).hashCode());
            result2 = result2 * 31 + (this.fill == null ? 0 : this.fill.hashCode());
            result2 = result2 * 31 + (this.alpha == null ? 0 : ((Object)this.alpha).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TextParams)) {
                return false;
            }
            TextParams textParams = (TextParams)other;
            if (!Intrinsics.areEqual((Object)this.style, (Object)textParams.style)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.color, (Object)textParams.color)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.hjust, (Object)textParams.hjust)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.vjust, (Object)textParams.vjust)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.angle, (Object)textParams.angle)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fill, (Object)textParams.fill)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.alpha, (Object)textParams.alpha);
        }
    }
}

