/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.util.RectangleTooltipHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.RectanglesHelper;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimGroup;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/TileGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "()V", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "Companion", "plot-base"})
public class TileGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final boolean HANDLES_GROUPS = false;

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        RectangleTooltipHelper tooltipHelper = new RectangleTooltipHelper(pos, coord, ctx2, null, TipLayoutHint.Kind.CURSOR_TOOLTIP, null, null, 104, null);
        RectanglesHelper helper2 = new RectanglesHelper(aesthetics2, pos, coord, ctx2, (Function1<? super DataPointAesthetics, DoubleRectangle>)TileGeom.Companion.clientRectByDataPoint(ctx2));
        RectanglesHelper.SvgRectHelper svgRectHelper = helper2.createSvgRectHelper();
        svgRectHelper.setResamplingEnabled(!coord.isLinear());
        svgRectHelper.onGeometry((Function3<? super DataPointAesthetics, ? super DoubleRectangle, ? super List<DoubleVector>, Unit>)((Function3)new Function3<DataPointAesthetics, DoubleRectangle, List<? extends DoubleVector>, Unit>(tooltipHelper){
            final /* synthetic */ RectangleTooltipHelper $tooltipHelper;
            {
                this.$tooltipHelper = $tooltipHelper;
                super(3);
            }

            public final void invoke(@NotNull DataPointAesthetics p, @Nullable DoubleRectangle rect2, @Nullable List<DoubleVector> polygon2) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                if (polygon2 != null) {
                    this.$tooltipHelper.addTarget(p, polygon2);
                } else if (rect2 != null) {
                    this.$tooltipHelper.addTarget(p, rect2);
                }
            }
        }));
        SvgSlimGroup slimGroup = svgRectHelper.createSlimRectangles();
        root.add(GeomBase.Companion.wrap(slimGroup));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00062\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/TileGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "clientRectByDataPoint", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        private final Function1<DataPointAesthetics, DoubleRectangle> clientRectByDataPoint(GeomContext ctx2) {
            return (Function1)new Function1<DataPointAesthetics, DoubleRectangle>(ctx2){
                final /* synthetic */ GeomContext $ctx;
                {
                    this.$ctx = $ctx;
                    super(1, Intrinsics.Kotlin.class, "factory", "clientRectByDataPoint$factory(Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;)Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", 0);
                }

                @Nullable
                public final DoubleRectangle invoke(@NotNull DataPointAesthetics p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return org.jetbrains.letsPlot.core.plot.base.geom.TileGeom$Companion.access$clientRectByDataPoint$factory(this.$ctx, p0);
                }
            };
        }

        private static final DoubleRectangle clientRectByDataPoint$factory(GeomContext $ctx, DataPointAesthetics p) {
            Double d = SeriesUtil.INSTANCE.finiteOrNull(p.x());
            if (d == null) {
                return null;
            }
            double x2 = d;
            Double d2 = SeriesUtil.INSTANCE.finiteOrNull(p.y());
            if (d2 == null) {
                return null;
            }
            double y2 = d2;
            Double d3 = SeriesUtil.INSTANCE.finiteOrNull(p.width());
            if (d3 == null) {
                return null;
            }
            double w = d3;
            Double d4 = SeriesUtil.INSTANCE.finiteOrNull(p.height());
            if (d4 == null) {
                return null;
            }
            double h = d4;
            double width2 = w * $ctx.getResolution(Aes.Companion.getX());
            double height = h * $ctx.getResolution(Aes.Companion.getY());
            DoubleVector origin = new DoubleVector(x2 - width2 / (double)2, y2 - height / (double)2);
            DoubleVector dimensions = new DoubleVector(width2, height);
            return new DoubleRectangle(origin, dimensions);
        }

        public static final /* synthetic */ DoubleRectangle access$clientRectByDataPoint$factory(GeomContext $ctx, DataPointAesthetics p) {
            return org.jetbrains.letsPlot.core.plot.base.geom.TileGeom$Companion.clientRectByDataPoint$factory($ctx, p);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

