/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.WithHeight;
import org.jetbrains.letsPlot.core.plot.base.geom.WithWidth;
import org.jetbrains.letsPlot.core.plot.base.geom.legend.HLineLegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.TargetCollectorHelper;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 .2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002./B\u0005\u00a2\u0006\u0002\u0010\u0004J0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J.\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$H\u0002J\u0018\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$H\u0002J0\u0010(\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020+H\u0016J\u0012\u0010,\u001a\u0004\u0018\u00010$2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J0\u0010-\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020+H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u00060"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/SpokeGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/WithWidth;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/WithHeight;", "()V", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "pivot", "Lorg/jetbrains/letsPlot/core/plot/base/geom/SpokeGeom$Pivot;", "getPivot", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/SpokeGeom$Pivot;", "setPivot", "(Lorg/jetbrains/letsPlot/core/plot/base/geom/SpokeGeom$Pivot;)V", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "calculateSpan", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "coordAes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "", "spanAxisAes", "getEnd", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "base", "spoke", "getStart", "heightSpan", "resolution", "isDiscrete", "", "toSpoke", "widthSpan", "Companion", "Pivot", "plot-base"})
public final class SpokeGeom
extends GeomBase
implements WithWidth,
WithHeight {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Pivot pivot = DEF_PIVOT;
    @NotNull
    private static final Pivot DEF_PIVOT = Pivot.TAIL;
    public static final boolean HANDLES_GROUPS = false;

    @NotNull
    public final Pivot getPivot() {
        return this.pivot;
    }

    public final void setPivot(@NotNull Pivot pivot) {
        Intrinsics.checkNotNullParameter((Object)((Object)pivot), (String)"<set-?>");
        this.pivot = pivot;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return new HLineLegendKeyElementFactory();
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        TargetCollectorHelper tooltipHelper = new TargetCollectorHelper(GeomKind.SPOKE, ctx2);
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx2);
        GeomHelper.SvgElementHelper svgElementHelper = geomHelper.createSvgElementHelper();
        svgElementHelper.setStrokeAlphaEnabled(true);
        svgElementHelper.setGeometryHandler((Function2<? super DataPointAesthetics, ? super List<DoubleVector>, Unit>)((Function2)new Function2<DataPointAesthetics, List<? extends DoubleVector>, Unit>(tooltipHelper){
            final /* synthetic */ TargetCollectorHelper $tooltipHelper;
            {
                this.$tooltipHelper = $tooltipHelper;
                super(2);
            }

            public final void invoke(@NotNull DataPointAesthetics aes2, @NotNull List<DoubleVector> lineString2) {
                Intrinsics.checkNotNullParameter((Object)aes2, (String)"aes");
                Intrinsics.checkNotNullParameter(lineString2, (String)"lineString");
                this.$tooltipHelper.addLine(lineString2, aes2);
            }
        }));
        for (DataPointAesthetics p : aesthetics2.dataPoints()) {
            SvgNode line2;
            DoubleVector end;
            DoubleVector spoke;
            DoubleVector base;
            DoubleVector start2;
            Double d = SeriesUtil.INSTANCE.finiteOrNull(p.x());
            if (d == null) {
                continue;
            }
            double x2 = d;
            Double d2 = SeriesUtil.INSTANCE.finiteOrNull(p.y());
            if (d2 == null) {
                continue;
            }
            double y2 = d2;
            if (this.toSpoke(p) == null || GeomHelper.SvgElementHelper.createLine$default(svgElementHelper, start2 = this.getStart(base = new DoubleVector(x2, y2), spoke), end = this.getEnd(base, spoke), p, null, 8, null) == null) continue;
            root.add(line2);
        }
    }

    @Override
    @Nullable
    public DoubleSpan widthSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, double resolution, boolean isDiscrete) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        return this.calculateSpan(p, coordAes, Aes.Companion.getX());
    }

    @Override
    @Nullable
    public DoubleSpan heightSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, double resolution, boolean isDiscrete) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        return this.calculateSpan(p, coordAes, Aes.Companion.getY());
    }

    private final DoubleSpan calculateSpan(DataPointAesthetics p, Aes<Double> coordAes, Aes<Double> spanAxisAes) {
        DoubleVector doubleVector = (DoubleVector)GeomUtil.INSTANCE.getTO_LOCATION_X_Y().invoke((Object)p);
        if (doubleVector == null) {
            return null;
        }
        DoubleVector loc = doubleVector;
        DoubleVector base = Intrinsics.areEqual(coordAes, spanAxisAes) ? loc : loc.flip();
        DoubleVector doubleVector2 = this.toSpoke(p);
        if (doubleVector2 == null) {
            return null;
        }
        DoubleVector spoke = doubleVector2;
        DoubleVector start2 = this.getStart(base, spoke);
        DoubleVector end = this.getEnd(base, spoke);
        return Intrinsics.areEqual(spanAxisAes, Aes.Companion.getX()) ? new DoubleSpan(start2.getX(), end.getX()) : new DoubleSpan(start2.getY(), end.getY());
    }

    private final DoubleVector toSpoke(DataPointAesthetics p) {
        Double d = SeriesUtil.INSTANCE.finiteOrNull(p.angle());
        if (d == null) {
            return null;
        }
        double angle = d;
        Double d2 = SeriesUtil.INSTANCE.finiteOrNull(p.radius());
        if (d2 == null) {
            return null;
        }
        double radius = d2;
        return new DoubleVector(radius * Math.cos(angle), radius * Math.sin(angle));
    }

    private final DoubleVector getStart(DoubleVector base, DoubleVector spoke) {
        DoubleVector doubleVector;
        switch (WhenMappings.$EnumSwitchMapping$0[this.pivot.ordinal()]) {
            case 1: {
                doubleVector = base;
                break;
            }
            case 2: {
                doubleVector = base.subtract(spoke.mul(0.5));
                break;
            }
            case 3: {
                doubleVector = base.subtract(spoke);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return doubleVector;
    }

    private final DoubleVector getEnd(DoubleVector base, DoubleVector spoke) {
        DoubleVector doubleVector;
        switch (WhenMappings.$EnumSwitchMapping$0[this.pivot.ordinal()]) {
            case 1: {
                doubleVector = base.add(spoke);
                break;
            }
            case 2: {
                doubleVector = base.add(spoke.mul(0.5));
                break;
            }
            case 3: {
                doubleVector = base;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return doubleVector;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/SpokeGeom$Companion;", "", "()V", "DEF_PIVOT", "Lorg/jetbrains/letsPlot/core/plot/base/geom/SpokeGeom$Pivot;", "getDEF_PIVOT", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/SpokeGeom$Pivot;", "HANDLES_GROUPS", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pivot getDEF_PIVOT() {
            return DEF_PIVOT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/SpokeGeom$Pivot;", "", "(Ljava/lang/String;I)V", "TAIL", "MIDDLE", "TIP", "plot-base"})
    public static final class Pivot
    extends Enum<Pivot> {
        public static final /* enum */ Pivot TAIL = new Pivot();
        public static final /* enum */ Pivot MIDDLE = new Pivot();
        public static final /* enum */ Pivot TIP = new Pivot();
        private static final /* synthetic */ Pivot[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Pivot[] values() {
            return (Pivot[])$VALUES.clone();
        }

        public static Pivot valueOf(String value) {
            return Enum.valueOf(Pivot.class, value);
        }

        @NotNull
        public static EnumEntries<Pivot> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = pivotArray = new Pivot[]{Pivot.TAIL, Pivot.MIDDLE, Pivot.TIP};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Pivot.values().length];
            try {
                nArray[Pivot.TAIL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Pivot.MIDDLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Pivot.TIP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

