/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.HLineGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.SegmentGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.util.ArrowSpec;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.TargetCollectorHelper;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.render.svg.PathUtilKt;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathDataBuilder;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 62\u00020\u0001:\u00016B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0014J$\u0010.\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010/2\u0006\u00101\u001a\u0002022\n\u00103\u001a\u000604R\u000205H\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u00067"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/SegmentGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "()V", "animation", "", "getAnimation", "()Ljava/lang/Object;", "setAnimation", "(Ljava/lang/Object;)V", "arrowSpec", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec;", "getArrowSpec", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec;", "setArrowSpec", "(Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec;)V", "flat", "", "getFlat", "()Z", "setFlat", "(Z)V", "geodesic", "getGeodesic", "setGeodesic", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "spacer", "", "getSpacer", "()D", "setSpacer", "(D)V", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "createSegmentGeometry", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "geomHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper$SvgElementHelper;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nSegmentGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SegmentGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/SegmentGeom\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n1#2:159\n1855#3,2:160\n*S KotlinDebug\n*F\n+ 1 SegmentGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/SegmentGeom\n*L\n66#1:160,2\n*E\n"})
public final class SegmentGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ArrowSpec arrowSpec;
    @Nullable
    private Object animation;
    private boolean flat;
    private boolean geodesic;
    private double spacer;
    public static final boolean HANDLES_GROUPS = false;

    @Nullable
    public final ArrowSpec getArrowSpec() {
        return this.arrowSpec;
    }

    public final void setArrowSpec(@Nullable ArrowSpec arrowSpec) {
        this.arrowSpec = arrowSpec;
    }

    @Nullable
    public final Object getAnimation() {
        return this.animation;
    }

    public final void setAnimation(@Nullable Object object) {
        this.animation = object;
    }

    public final boolean getFlat() {
        return this.flat;
    }

    public final void setFlat(boolean bl) {
        this.flat = bl;
    }

    public final boolean getGeodesic() {
        return this.geodesic;
    }

    public final void setGeodesic(boolean bl) {
        this.geodesic = bl;
    }

    public final double getSpacer() {
        return this.spacer;
    }

    public final void setSpacer(double d) {
        this.spacer = d;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return HLineGeom.Companion.getLEGEND_KEY_ELEMENT_FACTORY();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        TargetCollectorHelper tooltipHelper = new TargetCollectorHelper(GeomKind.SEGMENT, ctx2);
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx2);
        GeomHelper.SvgElementHelper svgHelper = geomHelper.createSvgElementHelper().setResamplingEnabled(!coord.isLinear() && !this.flat);
        for (DataPointAesthetics p : aesthetics2.dataPoints()) {
            List<DoubleVector> segmentGeometry;
            if (this.createSegmentGeometry(p, svgHelper) == null) continue;
            double startPadding = Companion.padding(p, this.arrowSpec, this.spacer, true);
            double endPadding = Companion.padding(p, this.arrowSpec, this.spacer, false);
            List<DoubleVector> adjustedSegmentGeometry = Companion.padLineString(segmentGeometry, startPadding, endPadding);
            SvgPathElement svgSegmentElement = new SvgPathElement(PathUtilKt.lineString(new SvgPathDataBuilder(false, 1, null), adjustedSegmentGeometry).build());
            GeomHelper.Companion.decorate$default(GeomHelper.Companion, svgSegmentElement, p, true, null, false, 8, null);
            root.add(svgSegmentElement);
            ArrowSpec arrowSpec = this.arrowSpec;
            if (arrowSpec != null) {
                ArrowSpec it = arrowSpec;
                boolean bl = false;
                List<SvgPathElement> list2 = ArrowSpec.Companion.createArrows(p, adjustedSegmentGeometry, it);
                if (list2 != null) {
                    void $this$forEach$iv;
                    Iterable iterable = list2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        SvgNode p0 = (SvgNode)element$iv;
                        boolean bl2 = false;
                        root.add(p0);
                    }
                }
            }
            tooltipHelper.addLine(adjustedSegmentGeometry, p);
        }
    }

    private final List<DoubleVector> createSegmentGeometry(DataPointAesthetics p, GeomHelper.SvgElementHelper geomHelper) {
        Double d = SeriesUtil.INSTANCE.finiteOrNull(p.x());
        if (d == null) {
            return null;
        }
        double x2 = d;
        Double d2 = SeriesUtil.INSTANCE.finiteOrNull(p.y());
        if (d2 == null) {
            return null;
        }
        double y2 = d2;
        Double d3 = SeriesUtil.INSTANCE.finiteOrNull(p.xend());
        if (d3 == null) {
            return null;
        }
        double xend = d3;
        Double d4 = SeriesUtil.INSTANCE.finiteOrNull(p.yend());
        if (d4 == null) {
            return null;
        }
        double yend = d4;
        DoubleVector start2 = new DoubleVector(x2, y2);
        DoubleVector end = new DoubleVector(xend, yend);
        return geomHelper.createLineGeometry(start2, end, p);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J*\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fJ$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0004J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/SegmentGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "pad", "Lkotlin/Pair;", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "lineString", "", "padding", "", "padEnd", "padLineString", "startPadding", "endPadding", "padStart", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "arrowSpec", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec;", "spacer", "atStart", "targetSize", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nSegmentGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SegmentGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/SegmentGeom$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n350#2,7:159\n*S KotlinDebug\n*F\n+ 1 SegmentGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/SegmentGeom$Companion\n*L\n93#1:159,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Pair<Integer, DoubleVector> pad(List<DoubleVector> lineString2, double padding) {
            int indexOutsidePadding;
            block4: {
                int n;
                if (lineString2.size() < 2) {
                    return null;
                }
                double padding2 = padding * padding;
                List<DoubleVector> $this$indexOfFirst$iv = lineString2;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<DoubleVector> iterator2 = $this$indexOfFirst$iv.iterator();
                while (iterator2.hasNext()) {
                    DoubleVector item$iv;
                    DoubleVector it = item$iv = iterator2.next();
                    boolean bl = false;
                    if (MathKt.distance2((DoubleVector)CollectionsKt.first(lineString2), it) >= padding2) {
                        n = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n = indexOutsidePadding = -1;
            }
            if (indexOutsidePadding < 1) {
                return null;
            }
            Companion $this$pad_u24lambda_u241 = this;
            boolean bl = false;
            DoubleVector insidePadding = lineString2.get(indexOutsidePadding - 1);
            DoubleVector outsidePadding = lineString2.get(indexOutsidePadding);
            double overPadding = MathKt.distance((DoubleVector)CollectionsKt.first(lineString2), outsidePadding) - padding;
            DoubleVector adjustedStartPoint = MathKt.pointOnLine(outsidePadding, insidePadding, overPadding);
            return TuplesKt.to((Object)indexOutsidePadding, (Object)adjustedStartPoint);
        }

        private final List<DoubleVector> padStart(List<DoubleVector> lineString2, double padding) {
            Pair<Integer, DoubleVector> pair2 = this.pad(lineString2, padding);
            if (pair2 == null) {
                return lineString2;
            }
            Pair<Integer, DoubleVector> pair3 = pair2;
            int index = ((Number)pair3.component1()).intValue();
            DoubleVector adjustedStartPoint = (DoubleVector)pair3.component2();
            return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)adjustedStartPoint), (Iterable)lineString2.subList(index, lineString2.size()));
        }

        private final List<DoubleVector> padEnd(List<DoubleVector> lineString2, double padding) {
            Pair<Integer, DoubleVector> pair2 = this.pad(CollectionsKt.asReversed(lineString2), padding);
            if (pair2 == null) {
                return lineString2;
            }
            Pair<Integer, DoubleVector> pair3 = pair2;
            int index = ((Number)pair3.component1()).intValue();
            DoubleVector adjustedEndPoint = (DoubleVector)pair3.component2();
            return CollectionsKt.plus((Collection)lineString2.subList(0, lineString2.size() - index), (Object)adjustedEndPoint);
        }

        @NotNull
        public final List<DoubleVector> padLineString(@NotNull List<DoubleVector> lineString2, double startPadding, double endPadding) {
            Intrinsics.checkNotNullParameter(lineString2, (String)"lineString");
            List<DoubleVector> startPadded = this.padStart(lineString2, startPadding);
            return this.padEnd(startPadded, endPadding);
        }

        private final double targetSize(DataPointAesthetics p, boolean atStart) {
            KFunction sizeAes2 = atStart ? (KFunction)targetSize.sizeAes.1.INSTANCE : (KFunction)targetSize.sizeAes.2.INSTANCE;
            KFunction strokeAes2 = atStart ? (KFunction)targetSize.strokeAes.1.INSTANCE : (KFunction)targetSize.strokeAes.2.INSTANCE;
            return AesScaling.INSTANCE.circleDiameter(p, (Function1<? super DataPointAesthetics, Double>)((Function1)sizeAes2)) / (double)2 + AesScaling.INSTANCE.pointStrokeWidth(p, (Function1<? super DataPointAesthetics, Double>)((Function1)strokeAes2));
        }

        public final double padding(@NotNull DataPointAesthetics p, @Nullable ArrowSpec arrowSpec, double spacer, boolean atStart) {
            double d;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            double targetSize2 = this.targetSize(p, atStart);
            ArrowSpec arrowSpec2 = arrowSpec;
            if (arrowSpec2 != null) {
                boolean hasArrow;
                ArrowSpec it = arrowSpec2;
                boolean bl = false;
                boolean bl2 = hasArrow = atStart ? arrowSpec.isOnFirstEnd() : arrowSpec.isOnLastEnd();
                if (hasArrow) {
                    double strokeWidth = AesScaling.INSTANCE.strokeWidth(p);
                    double miterLength = ArrowSpec.Companion.miterLength(arrowSpec.getAngle() * (double)2, strokeWidth);
                    double miterSign = Math.signum(Math.sin(arrowSpec.getAngle() * (double)2));
                    d = miterLength * miterSign / (double)2;
                } else {
                    d = 0.0;
                }
            } else {
                d = 0.0;
            }
            double miterOffset = d;
            return targetSize2 + spacer + miterOffset;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

