/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.util.RectangleTooltipHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.RectanglesHelper;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/RectGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "()V", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "Companion", "plot-base"})
public final class RectGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final boolean HANDLES_GROUPS = true;

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        RectanglesHelper helper2 = new RectanglesHelper(aesthetics2, pos, coord, ctx2, (Function1<? super DataPointAesthetics, DoubleRectangle>)((Function1)new Function1<DataPointAesthetics, DoubleRectangle>((Object)Companion){

            @Nullable
            public final DoubleRectangle invoke(@NotNull DataPointAesthetics p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return org.jetbrains.letsPlot.core.plot.base.geom.RectGeom$Companion.access$clientRectByDataPoint((Companion)this.receiver, p0);
            }
        }));
        RectangleTooltipHelper tooltipHelper = new RectangleTooltipHelper(pos, coord, ctx2, null, TipLayoutHint.Kind.CURSOR_TOOLTIP, null, null, 104, null);
        if (coord.isLinear()) {
            helper2.createRectangles((Function3<? super DataPointAesthetics, ? super SvgNode, ? super DoubleRectangle, Unit>)((Function3)new Function3<DataPointAesthetics, SvgNode, DoubleRectangle, Unit>(root, tooltipHelper){
                final /* synthetic */ SvgRoot $root;
                final /* synthetic */ RectangleTooltipHelper $tooltipHelper;
                {
                    this.$root = $root;
                    this.$tooltipHelper = $tooltipHelper;
                    super(3);
                }

                public final void invoke(@NotNull DataPointAesthetics aes2, @NotNull SvgNode svgNode, @NotNull DoubleRectangle rect2) {
                    Intrinsics.checkNotNullParameter((Object)aes2, (String)"aes");
                    Intrinsics.checkNotNullParameter((Object)svgNode, (String)"svgNode");
                    Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
                    this.$root.add(svgNode);
                    this.$tooltipHelper.addTarget(aes2, rect2);
                }
            }));
        } else {
            helper2.createNonLinearRectangles((Function3<? super DataPointAesthetics, ? super SvgNode, ? super List<DoubleVector>, Unit>)((Function3)new Function3<DataPointAesthetics, SvgNode, List<? extends DoubleVector>, Unit>(root, tooltipHelper){
                final /* synthetic */ SvgRoot $root;
                final /* synthetic */ RectangleTooltipHelper $tooltipHelper;
                {
                    this.$root = $root;
                    this.$tooltipHelper = $tooltipHelper;
                    super(3);
                }

                public final void invoke(@NotNull DataPointAesthetics aes2, @NotNull SvgNode svgNode, @NotNull List<DoubleVector> polygon2) {
                    Intrinsics.checkNotNullParameter((Object)aes2, (String)"aes");
                    Intrinsics.checkNotNullParameter((Object)svgNode, (String)"svgNode");
                    Intrinsics.checkNotNullParameter(polygon2, (String)"polygon");
                    this.$root.add(svgNode);
                    this.$tooltipHelper.addTarget(aes2, polygon2);
                }
            }));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/RectGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "clientRectByDataPoint", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        private final DoubleRectangle clientRectByDataPoint(DataPointAesthetics p) {
            Double d = SeriesUtil.INSTANCE.finiteOrNull(p.xmin());
            if (d == null) {
                return null;
            }
            double xmin = d;
            Double d2 = SeriesUtil.INSTANCE.finiteOrNull(p.xmax());
            if (d2 == null) {
                return null;
            }
            double xmax = d2;
            Double d3 = SeriesUtil.INSTANCE.finiteOrNull(p.ymin());
            if (d3 == null) {
                return null;
            }
            double ymin = d3;
            Double d4 = SeriesUtil.INSTANCE.finiteOrNull(p.ymax());
            if (d4 == null) {
                return null;
            }
            double ymax = d4;
            return DoubleRectangle.Companion.LTRB(xmin, ymin, xmax, ymax);
        }

        public static final /* synthetic */ DoubleRectangle access$clientRectByDataPoint(Companion $this, DataPointAesthetics p) {
            return $this.clientRectByDataPoint(p);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

