/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.intern.observable.property.Property;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.HLineGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.SegmentGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.util.ArrowSpec;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathData;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathDataBuilder;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0014R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0007\"\u0004\b\u001f\u0010\t\u00a8\u0006-"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/CurveGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "()V", "value", "", "angle", "getAngle", "()D", "setAngle", "(D)V", "arrowSpec", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec;", "getArrowSpec", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec;", "setArrowSpec", "(Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec;)V", "curvature", "getCurvature", "setCurvature", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "ncp", "", "getNcp", "()I", "setNcp", "(I)V", "spacer", "getSpacer", "setSpacer", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nCurveGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurveGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/CurveGeom\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,251:1\n1#2:252\n1855#3,2:253\n*S KotlinDebug\n*F\n+ 1 CurveGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/CurveGeom\n*L\n91#1:253,2\n*E\n"})
public final class CurveGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double curvature = 0.5;
    private double angle = 90.0;
    private int ncp = 5;
    @Nullable
    private ArrowSpec arrowSpec;
    private double spacer;
    public static final boolean HANDLES_GROUPS = false;
    public static final double DEF_ANGLE = 90.0;
    public static final double DEF_CURVATURE = 0.5;
    public static final int DEF_NCP = 5;
    public static final double DEF_SPACER = 0.0;

    public final double getCurvature() {
        return this.curvature;
    }

    public final void setCurvature(double d) {
        this.curvature = d;
    }

    public final double getAngle() {
        return this.angle;
    }

    public final void setAngle(double value) {
        this.angle = value % (double)180;
        if (this.angle < 0.0) {
            this.angle += (double)180;
        }
    }

    public final int getNcp() {
        return this.ncp;
    }

    public final void setNcp(int n) {
        this.ncp = n;
    }

    @Nullable
    public final ArrowSpec getArrowSpec() {
        return this.arrowSpec;
    }

    public final void setArrowSpec(@Nullable ArrowSpec arrowSpec) {
        this.arrowSpec = arrowSpec;
    }

    public final double getSpacer() {
        return this.spacer;
    }

    public final void setSpacer(double d) {
        this.spacer = d;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return HLineGeom.Companion.getLEGEND_KEY_ELEMENT_FACTORY();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx2);
        for (DataPointAesthetics p : aesthetics2.dataPoints()) {
            void $this$forEach$iv;
            void $this$buildIntern_u24lambda_u242_u24lambda_u241;
            List<DoubleVector> list2;
            DoubleVector clientEnd;
            DoubleVector clientStart;
            Double d = SeriesUtil.INSTANCE.finiteOrNull(p.x());
            if (d == null) {
                continue;
            }
            double x2 = d;
            Double d2 = SeriesUtil.INSTANCE.finiteOrNull(p.y());
            if (d2 == null) {
                continue;
            }
            double y2 = d2;
            Double d3 = SeriesUtil.INSTANCE.finiteOrNull(p.xend());
            if (d3 == null) {
                continue;
            }
            double xend = d3;
            Double d4 = SeriesUtil.INSTANCE.finiteOrNull(p.yend());
            if (d4 == null) {
                continue;
            }
            double yend = d4;
            if (geomHelper.toClient(new DoubleVector(x2, y2), p) == null || geomHelper.toClient(new DoubleVector(xend, yend), p) == null) continue;
            List<DoubleVector> geometry = Companion.createGeometry(clientStart, clientEnd, this.curvature, -this.angle, this.ncp);
            boolean bl = false;
            if (geometry.isEmpty()) {
                list2 = null;
            } else {
                double startPadding = SegmentGeom.Companion.padding(p, this.arrowSpec, this.spacer, true);
                double endPadding = SegmentGeom.Companion.padding(p, this.arrowSpec, this.spacer, false);
                list2 = SegmentGeom.Companion.padLineString(geometry, startPadding, endPadding);
            }
            if (list2 == null) continue;
            List<DoubleVector> adjustedGeometry = list2;
            Object object = new SvgPathElement();
            SvgPathElement $this$buildIntern_u24lambda_u242 = object;
            boolean bl2 = false;
            SvgPathDataBuilder startPadding = bl = new SvgPathDataBuilder(false, 1, null);
            Property<SvgPathData> property2 = $this$buildIntern_u24lambda_u242.d();
            boolean bl3 = false;
            $this$buildIntern_u24lambda_u242_u24lambda_u241.moveTo((DoubleVector)CollectionsKt.first(adjustedGeometry));
            $this$buildIntern_u24lambda_u242_u24lambda_u241.interpolatePoints((Collection<DoubleVector>)adjustedGeometry, SvgPathDataBuilder.Interpolation.BSPLINE);
            property2.set(bl.build());
            GeomHelper.Companion.decorate$default(GeomHelper.Companion, $this$buildIntern_u24lambda_u242, p, true, null, false, 8, null);
            SvgNode p0 = (SvgNode)object;
            boolean $i$a$-also-CurveGeom$buildIntern$32 = false;
            root.add(p0);
            object = this.arrowSpec;
            if (object == null) continue;
            Object it = object;
            boolean bl4 = false;
            List<SvgPathElement> list3 = ArrowSpec.Companion.createArrows(p, adjustedGeometry, (ArrowSpec)it);
            if (list3 == null) continue;
            Iterable $i$a$-also-CurveGeom$buildIntern$32 = list3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SvgNode p02 = (SvgNode)element$iv;
                boolean bl5 = false;
                root.add(p02);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J \u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J4\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/CurveGeom$Companion;", "", "()V", "DEF_ANGLE", "", "DEF_CURVATURE", "DEF_NCP", "", "DEF_SPACER", "HANDLES_GROUPS", "", "calcControlPoints", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "start", "end", "curvature", "angle", "ncp", "calcOrigin", "ps", "pe", "origin", "createGeometry", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nCurveGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurveGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/CurveGeom$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,251:1\n1549#2:252\n1620#2,3:253\n1549#2:257\n1620#2,3:258\n1549#2:261\n1620#2,3:262\n1549#2:265\n1620#2,3:266\n1#3:256\n*S KotlinDebug\n*F\n+ 1 CurveGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/CurveGeom$Companion\n*L\n182#1:252\n182#1:253,3\n194#1:257\n194#1:258,3\n201#1:261\n201#1:262,3\n208#1:265\n208#1:266,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<DoubleVector> createGeometry(@NotNull DoubleVector start2, @NotNull DoubleVector end, double curvature, double angle, int ncp) {
            Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            if (Intrinsics.areEqual((Object)start2, (Object)end)) {
                return CollectionsKt.emptyList();
            }
            List<DoubleVector> controlPoints = this.calcControlPoints(start2, end, curvature, angle, ncp);
            return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)start2), (Iterable)controlPoints), (Iterable)CollectionsKt.listOf((Object)end));
        }

        /*
         * WARNING - void declaration
         */
        private final List<DoubleVector> calcControlPoints(DoubleVector start2, DoubleVector end, double curvature, double angle, int ncp) {
            Iterable $this$mapTo$iv$iv;
            Collection<DoubleVector> collection;
            ArrayList<Double> $this$mapTo$iv$iv2;
            void $this$map$iv;
            block9: {
                block8: {
                    if (curvature == 0.0) break block8;
                    double d = Math.abs(angle);
                    if (1.0 <= d ? d <= 179.0 : false) break block9;
                }
                return CollectionsKt.emptyList();
            }
            DoubleVector mid = start2.add(end).mul(0.5);
            DoubleVector d = end.subtract(start2);
            double rAngle = MathKt.toRadians(angle);
            DoubleVector corner = mid.add(start2.subtract(mid).rotate(rAngle));
            double beta = -Math.atan(MathKt.lineSlope(start2, corner));
            DoubleVector doubleVector = start2.add(d.rotate(beta));
            double scaleX = MathKt.lineSlope(start2, doubleVector);
            double ratio = (double)2 * Math.pow(Math.sin(Math.atan(curvature)), 2);
            double origin = curvature - curvature / ratio;
            DoubleVector ps = new DoubleVector(start2.getX() * scaleX, start2.getY());
            DoubleVector oxy = this.calcOrigin(ps, new DoubleVector(doubleVector.getX() * scaleX, doubleVector.getY()), origin);
            double dir = Math.signum(curvature);
            double maxTheta = Math.PI + Math.signum(origin * dir) * (double)2 * Math.atan(Math.abs(origin));
            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)(ncp + 2));
            int $i$f$map = 0;
            void var31_23 = $this$map$iv;
            ArrayList<Double> destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            int $i$f$mapTo = 0;
            Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                collection = destination$iv$iv22;
                boolean bl = false;
                collection.add((DoubleVector)((Object)Double.valueOf((double)it * dir * maxTheta / (double)(ncp + 1))));
            }
            List theta = CollectionsKt.dropLast((List)CollectionsKt.drop((Iterable)destination$iv$iv22, (int)1), (int)1);
            $i$f$map = theta.size();
            $this$mapTo$iv$iv2 = new ArrayList<Double>($i$f$map);
            int destination$iv$iv22 = 0;
            while (destination$iv$iv22 < $i$f$map) {
                void index;
                int n = $i$f$mapTo = destination$iv$iv22++;
                collection = $this$mapTo$iv$iv2;
                boolean bl = false;
                ((ArrayList)collection).add((DoubleVector)((Object)Integer.valueOf((int)index)));
            }
            List indices = $this$mapTo$iv$iv2;
            DoubleVector p = ps.subtract(oxy);
            Iterable $this$map$iv2 = indices;
            boolean $i$f$map2 = false;
            Iterable index = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void index2;
                int n = ((Number)item$iv$iv).intValue();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(oxy.add(p.rotate(((Number)theta.get((int)index2)).doubleValue())));
            }
            $this$map$iv2 = (List)destination$iv$iv;
            $i$f$map2 = false;
            $this$mapTo$iv$iv = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DoubleVector index2 = (DoubleVector)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new DoubleVector(it.getX() / scaleX, it.getY()));
            }
            List cp = (List)destination$iv$iv;
            $this$map$iv2 = indices;
            $i$f$map2 = false;
            $this$mapTo$iv$iv = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void index3;
                int it = ((Number)item$iv$iv).intValue();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(start2.add(((DoubleVector)cp.get((int)index3)).subtract(start2).rotate(-beta)));
            }
            return (List)destination$iv$iv;
        }

        private final DoubleVector calcOrigin(DoubleVector ps, DoubleVector pe, double origin) {
            DoubleVector mid = ps.add(pe).mul(0.5);
            DoubleVector d = pe.subtract(ps);
            double slope = MathKt.lineSlope(ps, pe);
            double oSlope = (double)-1 / slope;
            double d2 = slope;
            double tmpOX = !(!Double.isInfinite(d2) && !Double.isNaN(d2)) ? 0.0 : (!(!Double.isInfinite(d2 = oSlope) && !Double.isNaN(d2)) ? origin * d.getX() / (double)2 : origin * d.getX() / (double)2);
            double d3 = slope;
            double tmpOY = !(!Double.isInfinite(d3) && !Double.isNaN(d3)) ? origin * d.getY() / (double)2 : (!(!Double.isInfinite(d3 = oSlope) && !Double.isNaN(d3)) ? 0.0 : origin * d.getY() / (double)2);
            return new DoubleVector(mid.getX() + tmpOY, mid.getY() - tmpOX);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

