/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.aes.AestheticsDefaults;
import org.jetbrains.letsPlot.core.plot.base.geom.CrossBarGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.util.BoxHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.FlippableGeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomUtil;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgShape;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 32\u00020\u0001:\u00013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0010\u0010\u0016\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0002J0\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0014J0\u0010(\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010&\u001a\u00020'2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0006H\u0002J.\u0010,\u001a\u0010\u0012\u0004\u0012\u00020.\u0012\u0006\u0012\u0004\u0018\u00010\u00170-2\u0006\u0010&\u001a\u00020'2\u0006\u0010)\u001a\u00020*2\u0006\u0010/\u001a\u00020\u0003H\u0002J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000201H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00064"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/CrossBarGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "isVertical", "", "(Z)V", "fattenMidline", "", "getFattenMidline", "()D", "setFattenMidline", "(D)V", "flipHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/FlippableGeomHelper;", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "wontRender", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "getWontRender", "()Ljava/util/List;", "afterRotation", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "rectangle", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "vector", "aes", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "buildMidlines", "geomHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "fatten", "clientRectByDataPoint", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "isHintRect", "updateAestheticsDefaults", "Lorg/jetbrains/letsPlot/core/plot/base/aes/AestheticsDefaults;", "aestheticDefaults", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nCrossBarGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrossBarGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/CrossBarGeom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n1549#2:158\n1620#2,3:159\n1549#2:162\n1620#2,3:163\n*S KotlinDebug\n*F\n+ 1 CrossBarGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/CrossBarGeom\n*L\n30#1:158\n30#1:159,3\n68#1:162\n68#1:163,3\n*E\n"})
public final class CrossBarGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isVertical;
    @NotNull
    private final FlippableGeomHelper flipHelper;
    private double fattenMidline;
    public static final boolean HANDLES_GROUPS = false;
    @NotNull
    private static final LegendKeyElementFactory LEGEND_FACTORY = BoxHelper.INSTANCE.legendFactory(false);

    public CrossBarGeom(boolean isVertical) {
        this.isVertical = isVertical;
        this.flipHelper = new FlippableGeomHelper(this.isVertical);
        this.fattenMidline = 2.5;
    }

    public final double getFattenMidline() {
        return this.fattenMidline;
    }

    public final void setFattenMidline(double d) {
        this.fattenMidline = d;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return LEGEND_FACTORY;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Aes<?>> getWontRender() {
        void $this$mapTo$iv$iv;
        Object[] objectArray = new Aes[]{Aes.Companion.getXMIN(), Aes.Companion.getXMAX()};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Aes aes2 = (Aes)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.afterRotation((Aes<Double>)p0));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public AestheticsDefaults updateAestheticsDefaults(@NotNull AestheticsDefaults aestheticDefaults) {
        Intrinsics.checkNotNullParameter((Object)aestheticDefaults, (String)"aestheticDefaults");
        return this.isVertical ? aestheticDefaults.with(Aes.Companion.getY(), Double.NaN) : aestheticDefaults.with(Aes.Companion.getX(), Double.NaN);
    }

    private final Aes<Double> afterRotation(Aes<Double> aes2) {
        return this.flipHelper.getEffectiveAes(aes2);
    }

    private final DoubleRectangle afterRotation(DoubleRectangle rectangle) {
        return this.flipHelper.flip(rectangle);
    }

    private final DoubleVector afterRotation(DoubleVector vector) {
        return this.flipHelper.flip(vector);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx2);
        BoxHelper.INSTANCE.buildBoxes(root, aesthetics2, pos, coord, ctx2, this.clientRectByDataPoint(ctx2, geomHelper, false));
        this.buildMidlines(root, aesthetics2, ctx2, geomHelper, this.fattenMidline);
        Object object = new Aes[]{Aes.Companion.getYMIN(), Aes.Companion.getYMAX()};
        object = CollectionsKt.listOf((Object[])object);
        FlippableGeomHelper flippableGeomHelper = this.flipHelper;
        boolean $i$f$map = false;
        void var9_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Aes aes2 = (Aes)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.afterRotation((Aes<Double>)p0));
        }
        FlippableGeomHelper.buildHints$default(flippableGeomHelper, (List)destination$iv$iv, aesthetics2, pos, coord, ctx2, this.clientRectByDataPoint(ctx2, geomHelper, true), buildIntern.2.INSTANCE, null, null, 384, null);
    }

    private final Function1<DataPointAesthetics, DoubleRectangle> clientRectByDataPoint(GeomContext ctx2, GeomHelper geomHelper, boolean isHintRect) {
        Aes<Double> xAes = this.afterRotation(Aes.Companion.getX());
        Aes<Double> yAes = this.afterRotation(Aes.Companion.getY());
        Aes<Double> minAes = this.afterRotation(Aes.Companion.getYMIN());
        Aes<Double> maxAes = this.afterRotation(Aes.Companion.getYMAX());
        Aes<Double> sizeAes2 = Aes.Companion.getWIDTH();
        return (Function1)new Function1<DataPointAesthetics, DoubleRectangle>(xAes, minAes, maxAes, sizeAes2, ctx2, isHintRect, yAes, geomHelper, this){
            final /* synthetic */ Aes<Double> $xAes;
            final /* synthetic */ Aes<Double> $minAes;
            final /* synthetic */ Aes<Double> $maxAes;
            final /* synthetic */ Aes<Double> $sizeAes;
            final /* synthetic */ GeomContext $ctx;
            final /* synthetic */ boolean $isHintRect;
            final /* synthetic */ Aes<Double> $yAes;
            final /* synthetic */ GeomHelper $geomHelper;
            final /* synthetic */ CrossBarGeom this$0;
            {
                this.$xAes = $xAes;
                this.$minAes = $minAes;
                this.$maxAes = $maxAes;
                this.$sizeAes = $sizeAes;
                this.$ctx = $ctx;
                this.$isHintRect = $isHintRect;
                this.$yAes = $yAes;
                this.$geomHelper = $geomHelper;
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final DoubleRectangle invoke(@NotNull DataPointAesthetics p) {
                DoubleRectangle doubleRectangle;
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                DoubleRectangle doubleRectangle2 = CrossBarGeom.access$clientRectByDataPoint$factory(this.$xAes, this.$minAes, this.$maxAes, this.$sizeAes, this.$ctx, this.$isHintRect, this.$yAes, p);
                if (doubleRectangle2 != null) {
                    DoubleRectangle doubleRectangle3 = doubleRectangle2;
                    GeomHelper geomHelper = this.$geomHelper;
                    CrossBarGeom crossBarGeom = this.this$0;
                    DoubleRectangle rect2 = doubleRectangle3;
                    boolean bl = false;
                    doubleRectangle = geomHelper.toClient(CrossBarGeom.access$afterRotation(crossBarGeom, rect2), p);
                } else {
                    doubleRectangle = null;
                }
                return doubleRectangle;
            }
        };
    }

    private final void buildMidlines(SvgRoot root, Aesthetics aesthetics2, GeomContext ctx2, GeomHelper geomHelper, double fatten) {
        GeomHelper.SvgElementHelper elementHelper = geomHelper.createSvgElementHelper();
        Aes<Double> xAes = this.afterRotation(Aes.Companion.getX());
        Aes<Double> yAes = this.afterRotation(Aes.Companion.getY());
        Aes<Double> sizeAes2 = Aes.Companion.getWIDTH();
        for (DataPointAesthetics p : GeomUtil.INSTANCE.withDefined(aesthetics2.dataPoints(), xAes, yAes, sizeAes2)) {
            SvgNode line2;
            Double d = p.get(xAes);
            Intrinsics.checkNotNull((Object)d);
            double x2 = ((Number)d).doubleValue();
            Double d2 = p.get(yAes);
            Intrinsics.checkNotNull((Object)d2);
            double middle = ((Number)d2).doubleValue();
            Double d3 = p.get(sizeAes2);
            Intrinsics.checkNotNull((Object)d3);
            double width2 = ((Number)d3).doubleValue() * ctx2.getResolution(xAes);
            Intrinsics.checkNotNull((Object)GeomHelper.SvgElementHelper.createLine$default(elementHelper, this.afterRotation(new DoubleVector(x2 - width2 / (double)2, middle)), this.afterRotation(new DoubleVector(x2 + width2 / (double)2, middle)), p, null, 8, null));
            if (!(line2 instanceof SvgShape)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Object ValueT = ((SvgShape)((Object)line2)).strokeWidth().get();
            Intrinsics.checkNotNull(ValueT);
            double thickness = ((Number)ValueT).doubleValue();
            ((SvgShape)((Object)line2)).strokeWidth().set(thickness * fatten);
            root.add(line2);
        }
    }

    private static final DoubleRectangle clientRectByDataPoint$factory(Aes<Double> xAes, Aes<Double> minAes, Aes<Double> maxAes, Aes<Double> sizeAes2, GeomContext $ctx, boolean $isHintRect, Aes<Double> yAes, DataPointAesthetics p) {
        Double d = SeriesUtil.INSTANCE.finiteOrNull(p.get(xAes));
        if (d == null) {
            return null;
        }
        double x2 = d;
        Double d2 = SeriesUtil.INSTANCE.finiteOrNull(p.get(minAes));
        if (d2 == null) {
            return null;
        }
        double ymin = d2;
        Double d3 = SeriesUtil.INSTANCE.finiteOrNull(p.get(maxAes));
        if (d3 == null) {
            return null;
        }
        double ymax = d3;
        Double d4 = SeriesUtil.INSTANCE.finiteOrNull(p.get(sizeAes2));
        if (d4 == null) {
            return null;
        }
        double w = d4;
        double width2 = w * $ctx.getResolution(xAes);
        DoubleVector origin = null;
        DoubleVector dimension = null;
        if ($isHintRect) {
            Double d5 = p.get(yAes);
            double y2 = d5 != null ? d5 : (ymin + ymax) / (double)2;
            origin = new DoubleVector(x2 - width2 / (double)2, y2);
            dimension = new DoubleVector(width2, 0.0);
        } else {
            origin = new DoubleVector(x2 - width2 / (double)2, ymin);
            dimension = new DoubleVector(width2, ymax - ymin);
        }
        return new DoubleRectangle(origin, dimension);
    }

    public static final /* synthetic */ DoubleRectangle access$clientRectByDataPoint$factory(Aes xAes, Aes minAes, Aes maxAes, Aes sizeAes2, GeomContext $ctx, boolean $isHintRect, Aes yAes, DataPointAesthetics p) {
        return CrossBarGeom.clientRectByDataPoint$factory(xAes, minAes, maxAes, sizeAes2, $ctx, $isHintRect, yAes, p);
    }

    public static final /* synthetic */ DoubleRectangle access$afterRotation(CrossBarGeom $this, DoubleRectangle rectangle) {
        return $this.afterRotation(rectangle);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/CrossBarGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "LEGEND_FACTORY", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

