/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.BoxplotGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.util.BarTooltipHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.BoxHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomUtil;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J(\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0006\"\u0004\b\u000f\u0010\b\u00a8\u0006 "}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/BoxplotGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "()V", "fattenMidline", "", "getFattenMidline", "()D", "setFattenMidline", "(D)V", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "whiskerWidth", "getWhiskerWidth", "setWhiskerWidth", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "buildLines", "geomHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nBoxplotGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoxplotGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/BoxplotGeom\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n1#2:158\n1855#3,2:159\n*S KotlinDebug\n*F\n+ 1 BoxplotGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/BoxplotGeom\n*L\n111#1:159,2\n*E\n"})
public final class BoxplotGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double fattenMidline = 2.0;
    private double whiskerWidth = 0.5;
    public static final double DEF_FATTEN_MIDLINE = 2.0;
    public static final double DEF_WHISKER_WIDTH = 0.5;
    public static final boolean HANDLES_GROUPS = false;
    @NotNull
    private static final LegendKeyElementFactory LEGEND_FACTORY = BoxHelper.INSTANCE.legendFactory(true);

    public final double getFattenMidline() {
        return this.fattenMidline;
    }

    public final void setFattenMidline(double d) {
        this.fattenMidline = d;
    }

    public final double getWhiskerWidth() {
        return this.whiskerWidth;
    }

    public final void setWhiskerWidth(double d) {
        this.whiskerWidth = d;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return LEGEND_FACTORY;
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx2);
        BoxHelper.INSTANCE.buildBoxes(root, aesthetics2, pos, coord, ctx2, (Function1<? super DataPointAesthetics, DoubleRectangle>)BoxplotGeom.Companion.clientRectByDataPoint(ctx2, geomHelper, false));
        this.buildLines(root, aesthetics2, ctx2, geomHelper);
        Object[] objectArray = new Aes[]{Aes.Companion.getYMAX(), Aes.Companion.getUPPER(), Aes.Companion.getMIDDLE(), Aes.Companion.getLOWER(), Aes.Companion.getYMIN()};
        BarTooltipHelper.collectRectangleTargets$default(BarTooltipHelper.INSTANCE, CollectionsKt.listOf((Object[])objectArray), aesthetics2, pos, coord, ctx2, BoxplotGeom.Companion.clientRectByDataPoint(ctx2, geomHelper, true), buildIntern.1.INSTANCE, null, TipLayoutHint.Kind.CURSOR_TOOLTIP, 128, null);
    }

    private final void buildLines(SvgRoot root, Aesthetics aesthetics2, GeomContext ctx2, GeomHelper geomHelper) {
        BoxHelper.INSTANCE.buildMidlines(root, aesthetics2, Aes.Companion.getMIDDLE(), ctx2, geomHelper, this.fattenMidline);
        GeomHelper.SvgElementHelper elementHelper = geomHelper.createSvgElementHelper();
        for (DataPointAesthetics p : GeomUtil.INSTANCE.withDefined(aesthetics2.dataPoints(), Aes.Companion.getX())) {
            double fence;
            double hinge;
            double d;
            Double d2 = p.x();
            Intrinsics.checkNotNull((Object)d2);
            double x2 = d2;
            Double d3 = p.width();
            if (d3 != null) {
                double it = ((Number)d3).doubleValue();
                boolean bl = false;
                d = it * ctx2.getResolution(Aes.Companion.getX()) / (double)2;
            } else {
                d = 0.0;
            }
            double halfWidth = d;
            double halfFenceWidth = halfWidth * this.whiskerWidth;
            ArrayList<SvgNode> lines = new ArrayList<SvgNode>();
            if (p.defined(Aes.Companion.getLOWER()) && p.defined(Aes.Companion.getYMIN())) {
                Double d4 = p.lower();
                Intrinsics.checkNotNull((Object)d4);
                hinge = d4;
                Double d5 = p.ymin();
                Intrinsics.checkNotNull((Object)d5);
                fence = d5;
                SvgNode svgNode = GeomHelper.SvgElementHelper.createLine$default(elementHelper, new DoubleVector(x2, hinge), new DoubleVector(x2, fence), p, null, 8, null);
                Intrinsics.checkNotNull((Object)svgNode);
                lines.add(svgNode);
                SvgNode svgNode2 = GeomHelper.SvgElementHelper.createLine$default(elementHelper, new DoubleVector(x2 - halfFenceWidth, fence), new DoubleVector(x2 + halfFenceWidth, fence), p, null, 8, null);
                Intrinsics.checkNotNull((Object)svgNode2);
                lines.add(svgNode2);
            }
            if (!p.defined(Aes.Companion.getUPPER()) || !p.defined(Aes.Companion.getYMAX())) continue;
            Double d6 = p.upper();
            Intrinsics.checkNotNull((Object)d6);
            hinge = d6;
            Double d7 = p.ymax();
            Intrinsics.checkNotNull((Object)d7);
            fence = d7;
            SvgNode svgNode = GeomHelper.SvgElementHelper.createLine$default(elementHelper, new DoubleVector(x2, hinge), new DoubleVector(x2, fence), p, null, 8, null);
            Intrinsics.checkNotNull((Object)svgNode);
            lines.add(svgNode);
            SvgNode svgNode3 = GeomHelper.SvgElementHelper.createLine$default(elementHelper, new DoubleVector(x2 - halfFenceWidth, fence), new DoubleVector(x2 + halfFenceWidth, fence), p, null, 8, null);
            Intrinsics.checkNotNull((Object)svgNode3);
            lines.add(svgNode3);
            Iterable $this$forEach$iv = lines;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SvgNode it = (SvgNode)element$iv;
                boolean bl = false;
                root.add(it);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/BoxplotGeom$Companion;", "", "()V", "DEF_FATTEN_MIDLINE", "", "DEF_WHISKER_WIDTH", "HANDLES_GROUPS", "", "LEGEND_FACTORY", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "clientRectByDataPoint", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "geomHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "isHintRect", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        private final Function1<DataPointAesthetics, DoubleRectangle> clientRectByDataPoint(GeomContext ctx2, GeomHelper geomHelper, boolean isHintRect) {
            return (Function1)new Function1<DataPointAesthetics, DoubleRectangle>(ctx2, geomHelper, isHintRect){
                final /* synthetic */ GeomContext $ctx;
                final /* synthetic */ GeomHelper $geomHelper;
                final /* synthetic */ boolean $isHintRect;
                {
                    this.$ctx = $ctx;
                    this.$geomHelper = $geomHelper;
                    this.$isHintRect = $isHintRect;
                    super(1);
                }

                @Nullable
                public final DoubleRectangle invoke(@NotNull DataPointAesthetics p) {
                    DoubleRectangle doubleRectangle;
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (p.defined(Aes.Companion.getX()) && p.defined(Aes.Companion.getLOWER()) && p.defined(Aes.Companion.getUPPER()) && p.defined(Aes.Companion.getWIDTH())) {
                        Double d = p.x();
                        Intrinsics.checkNotNull((Object)d);
                        double x2 = d;
                        Double d2 = p.lower();
                        Intrinsics.checkNotNull((Object)d2);
                        double lower2 = d2;
                        Double d3 = p.upper();
                        Intrinsics.checkNotNull((Object)d3);
                        double upper2 = d3;
                        Double d4 = p.width();
                        Intrinsics.checkNotNull((Object)d4);
                        double width2 = d4 * this.$ctx.getResolution(Aes.Companion.getX());
                        DoubleRectangle doubleRectangle2 = this.$geomHelper.toClient(DoubleRectangle.Companion.XYWH(x2 - width2 / (double)2, lower2, width2, upper2 - lower2), p);
                        if (doubleRectangle2 != null) {
                            DoubleRectangle doubleRectangle3 = doubleRectangle2;
                            boolean bl = this.$isHintRect;
                            GeomContext geomContext = this.$ctx;
                            DoubleRectangle it = doubleRectangle3;
                            boolean bl2 = false;
                            doubleRectangle = bl && upper2 == lower2 ? GeomUtil.INSTANCE.extendHeight$plot_base(it, 2.0, geomContext.getFlipped()) : it;
                        } else {
                            doubleRectangle = null;
                        }
                    } else {
                        doubleRectangle = null;
                    }
                    DoubleRectangle clientRect = doubleRectangle;
                    return clientRect;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

