/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.annotations.Annotations;
import org.jetbrains.letsPlot.core.plot.base.geom.BarGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.util.AnnotationsUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.RectangleTooltipHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.RectanglesHelper;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.render.svg.MultilineLabel;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.style.TextStyle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 -2\u00020\u0001:\u0002-.B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J0\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J(\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J0\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002JV\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001e2\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0002J\u0014\u0010'\u001a\u00020%2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030)H\u0016J\u0019\u0010*\u001a\u00020%*\u00020\u00142\u0006\u0010+\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b,\u00a8\u0006/"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/BarGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "()V", "buildAnnotations", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "rectanglesHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/RectanglesHelper;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "buildIntern", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "buildNonLinearAnnotations", "createLabelRect", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "hPlacement", "Lorg/jetbrains/letsPlot/core/plot/base/geom/BarGeom$PlacementInsideBar;", "vPlacement", "barRect", "textSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "padding", "", "placeLabel", "Lkotlin/Pair;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$HorizontalAnchor;", "index", "", "barsCount", "viewPort", "isHorizontallyOriented", "", "isNegative", "rangeIncludesZero", "aes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "contains", "other", "contains$plot_base", "Companion", "PlacementInsideBar", "plot-base"})
@SourceDebugExtension(value={"SMAP\nBarGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/BarGeom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,365:1\n1855#2,2:366\n1477#2:369\n1502#2,3:370\n1505#2,3:380\n1045#2:384\n1864#2,2:385\n1549#2:387\n1620#2,3:388\n1855#2,2:391\n1866#2:393\n1#3:368\n372#4,7:373\n215#5:383\n216#5:394\n*S KotlinDebug\n*F\n+ 1 BarGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/BarGeom\n*L\n51#1:366,2\n131#1:369\n131#1:370,3\n131#1:380,3\n137#1:384\n140#1:385,2\n178#1:387\n178#1:388,3\n196#1:391,2\n140#1:393\n131#1:373,7\n134#1:383\n134#1:394\n*E\n"})
public class BarGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final boolean HANDLES_GROUPS = false;

    @Override
    public boolean rangeIncludesZero(@NotNull Aes<?> aes2) {
        Intrinsics.checkNotNullParameter(aes2, (String)"aes");
        return Intrinsics.areEqual(aes2, Aes.Companion.getY());
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
            Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
            RectanglesHelper helper2 = new RectanglesHelper(aesthetics2, pos, coord, ctx2, (Function1<? super DataPointAesthetics, DoubleRectangle>)BarGeom.Companion.visualRectByDataPoint(ctx2));
            RectangleTooltipHelper tooltipHelper = new RectangleTooltipHelper(pos, coord, ctx2, null, null, null, null, 120, null);
            List rectangles = new ArrayList();
            if (coord.isLinear()) {
                helper2.createRectangles((Function3<? super DataPointAesthetics, ? super SvgNode, ? super DoubleRectangle, Unit>)((Function3)new Function3<DataPointAesthetics, SvgNode, DoubleRectangle, Unit>((List<SvgNode>)rectangles){
                    final /* synthetic */ List<SvgNode> $rectangles;
                    {
                        this.$rectangles = $rectangles;
                        super(3);
                    }

                    public final void invoke(@NotNull DataPointAesthetics dataPointAesthetics, @NotNull SvgNode svgNode, @NotNull DoubleRectangle doubleRectangle) {
                        Intrinsics.checkNotNullParameter((Object)dataPointAesthetics, (String)"<anonymous parameter 0>");
                        Intrinsics.checkNotNullParameter((Object)svgNode, (String)"svgNode");
                        Intrinsics.checkNotNullParameter((Object)doubleRectangle, (String)"<anonymous parameter 2>");
                        this.$rectangles.add(svgNode);
                    }
                }));
                RectanglesHelper hintHelper = new RectanglesHelper(aesthetics2, pos, coord, ctx2, (Function1<? super DataPointAesthetics, DoubleRectangle>)BarGeom.Companion.hintRectByDataPoint(ctx2));
                hintHelper.createRectangles((Function3<? super DataPointAesthetics, ? super SvgNode, ? super DoubleRectangle, Unit>)((Function3)new Function3<DataPointAesthetics, SvgNode, DoubleRectangle, Unit>(tooltipHelper){
                    final /* synthetic */ RectangleTooltipHelper $tooltipHelper;
                    {
                        this.$tooltipHelper = $tooltipHelper;
                        super(3);
                    }

                    public final void invoke(@NotNull DataPointAesthetics aes2, @NotNull SvgNode svgNode, @NotNull DoubleRectangle rect2) {
                        Intrinsics.checkNotNullParameter((Object)aes2, (String)"aes");
                        Intrinsics.checkNotNullParameter((Object)svgNode, (String)"<anonymous parameter 1>");
                        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
                        this.$tooltipHelper.addTarget(aes2, rect2);
                    }
                }));
            } else {
                helper2.createNonLinearRectangles((Function3<? super DataPointAesthetics, ? super SvgNode, ? super List<DoubleVector>, Unit>)((Function3)new Function3<DataPointAesthetics, SvgNode, List<? extends DoubleVector>, Unit>((List<SvgNode>)rectangles, tooltipHelper){
                    final /* synthetic */ List<SvgNode> $rectangles;
                    final /* synthetic */ RectangleTooltipHelper $tooltipHelper;
                    {
                        this.$rectangles = $rectangles;
                        this.$tooltipHelper = $tooltipHelper;
                        super(3);
                    }

                    public final void invoke(@NotNull DataPointAesthetics aes2, @NotNull SvgNode svgNode, @NotNull List<DoubleVector> polygon2) {
                        Intrinsics.checkNotNullParameter((Object)aes2, (String)"aes");
                        Intrinsics.checkNotNullParameter((Object)svgNode, (String)"svgNode");
                        Intrinsics.checkNotNullParameter(polygon2, (String)"polygon");
                        this.$rectangles.add(svgNode);
                        this.$tooltipHelper.addTarget(aes2, polygon2);
                    }
                }));
            }
            CollectionsKt.reverse((List)rectangles);
            Iterable $this$forEach$iv = rectangles;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SvgNode p0 = (SvgNode)element$iv;
                boolean bl = false;
                root.add(p0);
            }
            Annotations annotations = ctx2.getAnnotations();
            if (annotations == null) break block5;
            Annotations it = annotations;
            boolean bl = false;
            if (coord.isLinear()) {
                this.buildAnnotations(root, helper2, coord, ctx2);
            } else {
                this.buildNonLinearAnnotations(root, helper2, coord, ctx2);
            }
        }
    }

    private final void buildNonLinearAnnotations(SvgRoot root, RectanglesHelper rectanglesHelper, CoordinateSystem coord, GeomContext ctx2) {
        Annotations annotations = ctx2.getAnnotations();
        if (annotations == null) {
            return;
        }
        Annotations annotations2 = annotations;
        DoubleRectangle p0 = GeomBase.Companion.overallAesBounds(ctx2);
        boolean bl = false;
        DoubleRectangle doubleRectangle = coord.toClient(p0);
        if (doubleRectangle == null) {
            return;
        }
        DoubleRectangle viewPort = doubleRectangle;
        rectanglesHelper.iterateRectangleGeometry((Function2<? super DataPointAesthetics, ? super DoubleRectangle, Unit>)((Function2)new Function2<DataPointAesthetics, DoubleRectangle, Unit>(rectanglesHelper, ctx2, annotations2, viewPort, root){
            final /* synthetic */ RectanglesHelper $rectanglesHelper;
            final /* synthetic */ GeomContext $ctx;
            final /* synthetic */ Annotations $annotations;
            final /* synthetic */ DoubleRectangle $viewPort;
            final /* synthetic */ SvgRoot $root;
            {
                this.$rectanglesHelper = $rectanglesHelper;
                this.$ctx = $ctx;
                this.$annotations = $annotations;
                this.$viewPort = $viewPort;
                this.$root = $root;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull DataPointAesthetics p, @NotNull DoubleRectangle rect2) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
                DoubleVector doubleVector = this.$rectanglesHelper.toClient(rect2.getCenter(), p);
                if (doubleVector == null) {
                    return;
                }
                DoubleVector clientBarCenter = doubleVector;
                Object $this$invoke_u24lambda_u240 = rect2.flipIf(this.$ctx.getFlipped());
                boolean bl = false;
                Object[] objectArray = new DoubleVector[]{new DoubleVector(((DoubleRectangle)$this$invoke_u24lambda_u240).getLeft(), ((DoubleRectangle)$this$invoke_u24lambda_u240).getBottom()), new DoubleVector(((DoubleRectangle)$this$invoke_u24lambda_u240).getRight(), ((DoubleRectangle)$this$invoke_u24lambda_u240).getBottom())};
                Iterable iterable = CollectionsKt.listOf((Object[])objectArray);
                $this$invoke_u24lambda_u240 = this.$rectanglesHelper;
                GeomContext geomContext = this.$ctx;
                boolean $i$f$mapNotNull = false;
                void var9_12 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv22 = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator2 = $this$forEach$iv$iv$iv22.iterator();
                while (iterator2.hasNext()) {
                    DoubleVector it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    DoubleVector it = (DoubleVector)element$iv$iv;
                    boolean bl3 = false;
                    if (((GeomHelper)$this$invoke_u24lambda_u240).toClient(it.flipIf(geomContext.getFlipped()), p) == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List barBorder = (List)destination$iv$iv;
                if (barBorder.size() != 2) {
                    return;
                }
                DoubleVector v = ((DoubleVector)barBorder.get(1)).subtract((DoubleVector)barBorder.get(0));
                double it = Math.atan2(v.getY(), v.getX());
                boolean $i$a$-let-BarGeom$buildNonLinearAnnotations$1$angle$22 = false;
                double $this$forEach$iv$iv$iv22 = Math.abs(it);
                double angle = (1.5707963267948966 <= $this$forEach$iv$iv$iv22 ? $this$forEach$iv$iv$iv22 <= 4.71238898038469 : false) ? Math.PI - it : Math.PI * 2 - it;
                String text2 = this.$annotations.getAnnotationText(p.index(), this.$ctx.getPlotContext());
                Object object = this.$annotations.getTextStyle();
                Object object2 = this.$annotations.getTextColor(p.fill());
                double $i$a$-let-BarGeom$buildNonLinearAnnotations$1$angle$22 = MathKt.toDegrees(angle);
                object = AnnotationsUtil.INSTANCE.createLabelElement(text2, clientBarCenter, new AnnotationsUtil.TextParams((TextStyle)object, (Color)object2, "middle", "center", $i$a$-let-BarGeom$buildNonLinearAnnotations$1$angle$22, null, 0.0, 32, null), this.$ctx, this.$viewPort.getCenter());
                object2 = this.$root;
                SvgNode p0 = (SvgNode)object;
                boolean bl5 = false;
                object2.add(p0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void buildAnnotations(SvgRoot root, RectanglesHelper rectanglesHelper, CoordinateSystem coord, GeomContext ctx2) {
        void $this$forEach$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Annotations annotations = ctx2.getAnnotations();
        if (annotations == null) {
            return;
        }
        Annotations annotations2 = annotations;
        DoubleRectangle p0 = GeomBase.Companion.overallAesBounds(ctx2);
        boolean bl = false;
        DoubleRectangle doubleRectangle = coord.toClient(p0);
        if (doubleRectangle == null) {
            return;
        }
        DoubleRectangle viewPort = doubleRectangle;
        double padding = annotations2.getTextStyle().getSize() / (double)2;
        boolean isHorizontallyOriented = ctx2.getFlipped();
        List rectangles = new ArrayList();
        rectanglesHelper.iterateRectangleGeometry((Function2<? super DataPointAesthetics, ? super DoubleRectangle, Unit>)((Function2)new Function2<DataPointAesthetics, DoubleRectangle, Unit>(rectanglesHelper, viewPort, (List<Triple<DataPointAesthetics, DoubleRectangle, Boolean>>)rectangles){
            final /* synthetic */ RectanglesHelper $rectanglesHelper;
            final /* synthetic */ DoubleRectangle $viewPort;
            final /* synthetic */ List<Triple<DataPointAesthetics, DoubleRectangle, Boolean>> $rectangles;
            {
                this.$rectanglesHelper = $rectanglesHelper;
                this.$viewPort = $viewPort;
                this.$rectangles = $rectangles;
                super(2);
            }

            public final void invoke(@NotNull DataPointAesthetics p, @NotNull DoubleRectangle rect2) {
                DoubleRectangle doubleRectangle;
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
                DoubleRectangle doubleRectangle2 = this.$rectanglesHelper.toClient(rect2, p);
                if (doubleRectangle2 == null || (doubleRectangle = doubleRectangle2.intersect(this.$viewPort)) == null) {
                    return;
                }
                DoubleRectangle clientRect = doubleRectangle;
                boolean isNegative = rect2.getDimension().getY() < 0.0;
                this.$rectangles.add((Triple<DataPointAesthetics, DoubleRectangle, Boolean>)new Triple((Object)p, (Object)clientRect, (Object)isNegative));
            }
        }));
        Iterable iterable = rectangles;
        boolean $i$f$groupBy = false;
        Iterator iterator2 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Triple triple = (Triple)element$iv$iv;
            boolean bl2 = false;
            DoubleRectangle rect2 = (DoubleRectangle)triple.component2();
            Double key$iv$iv = isHorizontallyOriented ? rect2.getCenter().getY() : rect2.getCenter().getX();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$forEachIndexed$iv;
            Iterable $this$sortedBy$iv;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl4 = false;
            List bars = (List)entry.getValue();
            int barsCount = bars.size();
            Iterable bl2 = bars;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(isHorizontallyOriented){
                final /* synthetic */ boolean $isHorizontallyOriented$inlined;
                {
                    this.$isHorizontallyOriented$inlined = bl;
                }

                public final int compare(T a2, T b2) {
                    Triple triple = (Triple)a2;
                    boolean bl = false;
                    DoubleRectangle rect2 = (DoubleRectangle)triple.component2();
                    triple = (Triple)b2;
                    Comparable comparable = Double.valueOf(this.$isHorizontallyOriented$inlined ? rect2.getCenter().getX() : rect2.getCenter().getY());
                    bl = false;
                    rect2 = (DoubleRectangle)triple.component2();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Double.valueOf(this.$isHorizontallyOriented$inlined ? rect2.getCenter().getX() : rect2.getCenter().getY()));
                }
            });
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void $this$mapTo$iv$iv;
                double d;
                Color color;
                Pair<Text.HorizontalAnchor, DoubleRectangle> pair2;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Triple triple = (Triple)item$iv;
                int index = n;
                boolean bl5 = false;
                DataPointAesthetics p = (DataPointAesthetics)triple.component1();
                DoubleRectangle barRect = (DoubleRectangle)triple.component2();
                boolean isNegative = (Boolean)triple.component3();
                String text2 = annotations2.getAnnotationText(p.index(), ctx2.getPlotContext());
                DoubleVector textSize = (DoubleVector)AnnotationsUtil.INSTANCE.textSizeGetter(annotations2.getTextStyle(), ctx2).invoke((Object)text2, (Object)p);
                if (this.placeLabel(barRect, index, barsCount, textSize, padding, viewPort, isHorizontallyOriented, isNegative) == null) continue;
                Text.HorizontalAnchor hAlignment = (Text.HorizontalAnchor)((Object)pair2.component1());
                DoubleRectangle textRect = (DoubleRectangle)pair2.component2();
                double alpha = 0.0;
                if (this.contains$plot_base(barRect, textRect)) {
                    alpha = 0.0;
                    color = annotations2.getTextColor(p.fill());
                } else {
                    alpha = 0.75;
                    color = Annotations.getTextColor$default(annotations2, null, 1, null);
                }
                Color labelColor = color;
                DoubleVector location2 = null;
                switch (WhenMappings.$EnumSwitchMapping$0[hAlignment.ordinal()]) {
                    case 1: {
                        d = textRect.getLeft();
                        break;
                    }
                    case 2: {
                        d = textRect.getRight();
                        break;
                    }
                    case 3: {
                        d = textRect.getCenter().getX();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                location2 = new DoubleVector(d, textRect.getTop());
                Iterable $this$map$iv = MultilineLabel.Companion.splitLines(text2);
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void line2;
                    SvgGElement svgGElement;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl6 = false;
                    TextStyle textStyle = annotations2.getTextStyle();
                    String string2 = hAlignment.toString().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    SvgGElement it = svgGElement = AnnotationsUtil.INSTANCE.createLabelElement((String)line2, location2, new AnnotationsUtil.TextParams(textStyle, labelColor, string2, "top", null, ctx2.getBackgroundColor(), alpha, 16, null), ctx2, viewPort.getCenter());
                    boolean bl7 = false;
                    location2 = location2.add(new DoubleVector(0.0, annotations2.getTextStyle().getSize()));
                    collection.add(svgGElement);
                }
                List labels = (List)destination$iv$iv2;
                Iterable $this$forEach$iv2 = labels;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    SvgNode p02 = (SvgNode)element$iv2;
                    boolean bl8 = false;
                    root.add(p02);
                }
            }
        }
    }

    public final boolean contains$plot_base(@NotNull DoubleRectangle $this$contains, @NotNull DoubleRectangle other) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return $this$contains.xRange().contains(other.xRange()) && $this$contains.yRange().contains(other.yRange());
    }

    private final Pair<Text.HorizontalAnchor, DoubleRectangle> placeLabel(DoubleRectangle barRect, int index, int barsCount, DoubleVector textSize, double padding, DoubleRectangle viewPort, boolean isHorizontallyOriented, boolean isNegative) {
        DoubleRectangle doubleRectangle;
        double pos;
        Function1 coordSelector2 = isHorizontallyOriented ? (Function1)placeLabel.coordSelector.1.INSTANCE : (Function1)placeLabel.coordSelector.2.INSTANCE;
        PlacementInsideBar insideBar = barsCount == 1 ? (isHorizontallyOriented ? PlacementInsideBar.MIN : PlacementInsideBar.MAX) : (index == 0 ? PlacementInsideBar.MIN : (index == barsCount - 1 ? PlacementInsideBar.MAX : PlacementInsideBar.MIDDLE));
        Pair<Text.HorizontalAnchor, DoubleRectangle> pair2 = BarGeom.placeLabel$place(this, isHorizontallyOriented, barRect, textSize, padding, insideBar);
        Text.HorizontalAnchor hAlignment = (Text.HorizontalAnchor)((Object)pair2.component1());
        DoubleRectangle textRect = (DoubleRectangle)pair2.component2();
        if (this.contains$plot_base(barRect, textRect)) {
            return TuplesKt.to((Object)((Object)hAlignment), (Object)textRect);
        }
        if (index != 0 && index != barsCount - 1) {
            return null;
        }
        if (barsCount == 1) {
            PlacementInsideBar placementInsideBar = insideBar = isHorizontallyOriented ? PlacementInsideBar.MAX : PlacementInsideBar.MIN;
            if (isNegative) {
                insideBar = insideBar.flip();
            }
        }
        if (insideBar == PlacementInsideBar.MAX) {
            if (isHorizontallyOriented) {
                hAlignment = Text.HorizontalAnchor.LEFT;
            }
            pos = ((Number)coordSelector2.invoke((Object)barRect.getOrigin())).doubleValue() + ((Number)coordSelector2.invoke((Object)barRect.getDimension())).doubleValue() + padding / (double)2;
            doubleRectangle = BarGeom.placeLabel$moveTo(textRect, isHorizontallyOriented, pos);
        } else {
            if (isHorizontallyOriented) {
                hAlignment = Text.HorizontalAnchor.RIGHT;
            }
            pos = ((Number)coordSelector2.invoke((Object)barRect.getOrigin())).doubleValue() - ((Number)coordSelector2.invoke((Object)textSize)).doubleValue() - padding / (double)2;
            doubleRectangle = textRect = BarGeom.placeLabel$moveTo(textRect, isHorizontallyOriented, pos);
        }
        if (this.contains$plot_base(viewPort, textRect)) {
            return TuplesKt.to((Object)((Object)hAlignment), (Object)textRect);
        }
        if (((Number)coordSelector2.invoke((Object)textSize)).doubleValue() + padding > ((Number)coordSelector2.invoke((Object)barRect.getDimension())).doubleValue()) {
            return null;
        }
        return BarGeom.placeLabel$place(this, isHorizontallyOriented, barRect, textSize, padding, insideBar);
    }

    private final DoubleRectangle createLabelRect(PlacementInsideBar hPlacement, PlacementInsideBar vPlacement, DoubleRectangle barRect, DoubleVector textSize, double padding) {
        double originX2 = BarGeom.createLabelRect$getCoord(barRect, padding, textSize, (Function1<? super DoubleVector, Double>)((Function1)createLabelRect.originX.1.INSTANCE), hPlacement);
        double originY2 = BarGeom.createLabelRect$getCoord(barRect, padding, textSize, (Function1<? super DoubleVector, Double>)((Function1)createLabelRect.originY.1.INSTANCE), vPlacement);
        return new DoubleRectangle(originX2, originY2, textSize.getX(), textSize.getY());
    }

    private static final Pair<Text.HorizontalAnchor, DoubleRectangle> placeLabel$place(BarGeom this$0, boolean $isHorizontallyOriented, DoubleRectangle $barRect, DoubleVector $textSize, double $padding, PlacementInsideBar placement) {
        Text.HorizontalAnchor horizontalAnchor;
        DoubleRectangle textRect;
        block6: {
            block5: {
                textRect = this$0.createLabelRect($isHorizontallyOriented ? placement : PlacementInsideBar.MIDDLE, $isHorizontallyOriented ? PlacementInsideBar.MIDDLE : placement, $barRect, $textSize, $padding);
                if (!$isHorizontallyOriented) break block5;
                switch (WhenMappings.$EnumSwitchMapping$1[placement.ordinal()]) {
                    case 1: {
                        horizontalAnchor = Text.HorizontalAnchor.LEFT;
                        break block6;
                    }
                    case 2: {
                        horizontalAnchor = Text.HorizontalAnchor.RIGHT;
                        break block6;
                    }
                    case 3: {
                        horizontalAnchor = Text.HorizontalAnchor.MIDDLE;
                        break block6;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            horizontalAnchor = Text.HorizontalAnchor.MIDDLE;
        }
        Text.HorizontalAnchor hAlignment = horizontalAnchor;
        return TuplesKt.to((Object)((Object)hAlignment), (Object)textRect);
    }

    private static final DoubleRectangle placeLabel$moveTo(DoubleRectangle $this$placeLabel_u24moveTo, boolean $isHorizontallyOriented, double value) {
        DoubleVector newOrigin = $isHorizontallyOriented ? new DoubleVector(value, $this$placeLabel_u24moveTo.getOrigin().getY()) : new DoubleVector($this$placeLabel_u24moveTo.getOrigin().getX(), value);
        return new DoubleRectangle(newOrigin, $this$placeLabel_u24moveTo.getDimension());
    }

    private static final double createLabelRect$getCoord(DoubleRectangle $barRect, double $padding, DoubleVector $textSize, Function1<? super DoubleVector, Double> coordSelector2, PlacementInsideBar align) {
        double d;
        switch (WhenMappings.$EnumSwitchMapping$1[align.ordinal()]) {
            case 1: {
                d = ((Number)coordSelector2.invoke((Object)$barRect.getOrigin())).doubleValue() + $padding;
                break;
            }
            case 2: {
                d = ((Number)coordSelector2.invoke((Object)$barRect.getOrigin())).doubleValue() + ((Number)coordSelector2.invoke((Object)$barRect.getDimension())).doubleValue() - ((Number)coordSelector2.invoke((Object)$textSize)).doubleValue() - $padding;
                break;
            }
            case 3: {
                d = ((Number)coordSelector2.invoke((Object)$barRect.getCenter())).doubleValue() - ((Number)coordSelector2.invoke((Object)$textSize)).doubleValue() / (double)2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J,\u0010\f\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/BarGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "hintRectByDataPoint", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "visualRectByDataPoint", "xyw", "Lkotlin/Triple;", "", "p", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        private final Triple<Double, Double, Double> xyw(DataPointAesthetics p, GeomContext ctx2) {
            Double d = SeriesUtil.INSTANCE.finiteOrNull(p.x());
            if (d == null) {
                return null;
            }
            double x2 = d;
            Double d2 = SeriesUtil.INSTANCE.finiteOrNull(p.y());
            if (d2 == null) {
                return null;
            }
            double y2 = d2;
            Double d3 = SeriesUtil.INSTANCE.finiteOrNull(p.width());
            if (d3 == null) {
                return null;
            }
            double w = d3;
            return new Triple((Object)x2, (Object)y2, (Object)(w * ctx2.getResolution(Aes.Companion.getX())));
        }

        private final Function1<DataPointAesthetics, DoubleRectangle> hintRectByDataPoint(GeomContext ctx2) {
            return (Function1)new Function1<DataPointAesthetics, DoubleRectangle>(ctx2){
                final /* synthetic */ GeomContext $ctx;
                {
                    this.$ctx = $ctx;
                    super(1, Intrinsics.Kotlin.class, "factory", "hintRectByDataPoint$factory(Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;)Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", 0);
                }

                @Nullable
                public final DoubleRectangle invoke(@NotNull DataPointAesthetics p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return org.jetbrains.letsPlot.core.plot.base.geom.BarGeom$Companion.access$hintRectByDataPoint$factory(this.$ctx, p0);
                }
            };
        }

        private final Function1<DataPointAesthetics, DoubleRectangle> visualRectByDataPoint(GeomContext ctx2) {
            return (Function1)new Function1<DataPointAesthetics, DoubleRectangle>(ctx2){
                final /* synthetic */ GeomContext $ctx;
                {
                    this.$ctx = $ctx;
                    super(1, Intrinsics.Kotlin.class, "factory", "visualRectByDataPoint$factory$0(Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;)Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", 0);
                }

                @Nullable
                public final DoubleRectangle invoke(@NotNull DataPointAesthetics p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return org.jetbrains.letsPlot.core.plot.base.geom.BarGeom$Companion.access$visualRectByDataPoint$factory$0(this.$ctx, p0);
                }
            };
        }

        private static final DoubleRectangle hintRectByDataPoint$factory(GeomContext $ctx, DataPointAesthetics p) {
            Triple<Double, Double, Double> triple = Companion.xyw(p, $ctx);
            if (triple == null) {
                return null;
            }
            Triple<Double, Double, Double> triple2 = triple;
            double x2 = ((Number)triple2.component1()).doubleValue();
            double y2 = ((Number)triple2.component2()).doubleValue();
            double w = ((Number)triple2.component3()).doubleValue();
            DoubleVector origin = new DoubleVector(x2 - w / (double)2, y2);
            DoubleVector dimension = new DoubleVector(w, 0.0);
            return new DoubleRectangle(origin, dimension);
        }

        private static final DoubleRectangle visualRectByDataPoint$factory$0(GeomContext $ctx, DataPointAesthetics p) {
            Triple<Double, Double, Double> triple = Companion.xyw(p, $ctx);
            if (triple == null) {
                return null;
            }
            Triple<Double, Double, Double> triple2 = triple;
            double x2 = ((Number)triple2.component1()).doubleValue();
            double y2 = ((Number)triple2.component2()).doubleValue();
            double w = ((Number)triple2.component3()).doubleValue();
            DoubleVector origin = null;
            DoubleVector dimension = null;
            if (y2 >= 0.0) {
                origin = new DoubleVector(x2 - w / (double)2, 0.0);
                dimension = new DoubleVector(w, y2);
            } else {
                origin = new DoubleVector(x2 - w / (double)2, y2);
                dimension = new DoubleVector(w, -y2);
            }
            return new DoubleRectangle(origin, dimension);
        }

        public static final /* synthetic */ DoubleRectangle access$hintRectByDataPoint$factory(GeomContext $ctx, DataPointAesthetics p) {
            return org.jetbrains.letsPlot.core.plot.base.geom.BarGeom$Companion.hintRectByDataPoint$factory($ctx, p);
        }

        public static final /* synthetic */ DoubleRectangle access$visualRectByDataPoint$factory$0(GeomContext $ctx, DataPointAesthetics p) {
            return org.jetbrains.letsPlot.core.plot.base.geom.BarGeom$Companion.visualRectByDataPoint$factory$0($ctx, p);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0000j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/BarGeom$PlacementInsideBar;", "", "(Ljava/lang/String;I)V", "flip", "MIN", "MAX", "MIDDLE", "plot-base"})
    private static final class PlacementInsideBar
    extends Enum<PlacementInsideBar> {
        public static final /* enum */ PlacementInsideBar MIN = new PlacementInsideBar();
        public static final /* enum */ PlacementInsideBar MAX = new PlacementInsideBar();
        public static final /* enum */ PlacementInsideBar MIDDLE = new PlacementInsideBar();
        private static final /* synthetic */ PlacementInsideBar[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @NotNull
        public final PlacementInsideBar flip() {
            PlacementInsideBar placementInsideBar;
            switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    placementInsideBar = MAX;
                    break;
                }
                case 2: {
                    placementInsideBar = MIN;
                    break;
                }
                case 3: {
                    placementInsideBar = MIDDLE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return placementInsideBar;
        }

        public static PlacementInsideBar[] values() {
            return (PlacementInsideBar[])$VALUES.clone();
        }

        public static PlacementInsideBar valueOf(String value) {
            return Enum.valueOf(PlacementInsideBar.class, value);
        }

        @NotNull
        public static EnumEntries<PlacementInsideBar> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = placementInsideBarArray = new PlacementInsideBar[]{PlacementInsideBar.MIN, PlacementInsideBar.MAX, PlacementInsideBar.MIDDLE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[PlacementInsideBar.values().length];
                try {
                    nArray[PlacementInsideBar.MIN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PlacementInsideBar.MAX.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PlacementInsideBar.MIDDLE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Text.HorizontalAnchor.values().length];
            try {
                nArray[Text.HorizontalAnchor.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.HorizontalAnchor.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.HorizontalAnchor.MIDDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PlacementInsideBar.values().length];
            try {
                nArray[PlacementInsideBar.MIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlacementInsideBar.MAX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlacementInsideBar.MIDDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

