/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.json;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.json.JsonSupportKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010&\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0003 !\"B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0001J\u0014\u0010\r\u001a\u00020\b2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\b2\u000e\u0010\u0011\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0012H\u0002J \u0010\u0013\u001a\u00020\b2\u0016\u0010\u0014\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0015H\u0002J\u0012\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0002J\u0012\u0010\u0018\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0002JF\u0010\u0019\u001a\u00020\b\"\u0004\b\u0000\u0010\u001a*\b\u0012\u0004\u0012\u0002H\u001a0\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u00020\b0\u001d2\u0018\u0010\u001e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001a0\u001f\u0012\u0004\u0012\u00020\b0\u001dH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/json/JsonFormatter;", "", "pretty", "", "(Z)V", "output", "Lorg/jetbrains/letsPlot/commons/intern/json/JsonFormatter$Output;", "append", "", "s", "", "formatJson", "o", "handleList", "list", "", "handleMap", "map", "", "handlePair", "pair", "", "handleString", "v", "handleValue", "headTail", "E", "", "head", "Lkotlin/Function1;", "tail", "Lkotlin/sequences/Sequence;", "Output", "Pretty", "Simple", "commons"})
public final class JsonFormatter {
    @NotNull
    private final Output output;

    public JsonFormatter(boolean pretty) {
        this.output = pretty ? (Output)new Pretty() : (Output)new Simple();
    }

    public /* synthetic */ JsonFormatter(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @NotNull
    public final String formatJson(@NotNull Object o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        this.handleValue(o);
        return this.output.asString();
    }

    private final void handleList(List<?> list2) {
        this.output.startList();
        this.headTail((Collection)list2, (Function1)new Function1<Object, Unit>(this){
            final /* synthetic */ JsonFormatter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable Object it) {
                JsonFormatter.access$getOutput$p(this.this$0).firstItem();
                JsonFormatter.access$handleValue(this.this$0, it);
            }
        }, (Function1)new Function1<Sequence<? extends Object>, Unit>(this){
            final /* synthetic */ JsonFormatter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Sequence<? extends Object> tail) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter(tail, (String)"tail");
                Sequence<? extends Object> sequence = tail;
                JsonFormatter jsonFormatter = this.this$0;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    E element$iv;
                    E it = element$iv = iterator2.next();
                    boolean bl = false;
                    JsonFormatter.access$getOutput$p(jsonFormatter).nextItem();
                    JsonFormatter.access$handleValue(jsonFormatter, it);
                }
            }
        });
        this.output.endList();
    }

    private final void handleMap(Map<?, ?> map2) {
        this.output.startMap();
        this.headTail((Collection)map2.entrySet(), (Function1)new Function1<Map.Entry<? extends Object, ? extends Object>, Unit>(this){
            final /* synthetic */ JsonFormatter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Map.Entry<? extends Object, ? extends Object> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                JsonFormatter.access$getOutput$p(this.this$0).firstItem();
                JsonFormatter.access$handlePair(this.this$0, it);
            }
        }, (Function1)new Function1<Sequence<? extends Map.Entry<? extends Object, ? extends Object>>, Unit>(this){
            final /* synthetic */ JsonFormatter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Sequence<? extends Map.Entry<? extends Object, ? extends Object>> tail) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter(tail, (String)"tail");
                Sequence<? extends Map.Entry<? extends Object, ? extends Object>> sequence = tail;
                JsonFormatter jsonFormatter = this.this$0;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl = false;
                    JsonFormatter.access$getOutput$p(jsonFormatter).nextItem();
                    JsonFormatter.access$handlePair(jsonFormatter, it);
                }
            }
        });
        this.output.endMap();
    }

    private final void handleValue(Object v) {
        Object object = v;
        if (object == null) {
            this.append("null");
        } else if (object instanceof String) {
            this.handleString(v);
        } else if (object instanceof Boolean) {
            this.append(String.valueOf((Boolean)v));
        } else if (object instanceof Number) {
            this.append(((Number)v).toString());
        } else if (object instanceof Object[]) {
            this.handleList(ArraysKt.asList((Object[])((Object[])v)));
        } else if (object instanceof List) {
            this.handleList((List)v);
        } else if (object instanceof Map) {
            this.handleMap((Map)v);
        } else {
            throw new IllegalArgumentException("Can't serialize object `" + v + "`(type " + Reflection.getOrCreateKotlinClass(v.getClass()).getSimpleName() + "`)");
        }
    }

    private final void handlePair(Map.Entry<? extends Object, ? extends Object> pair2) {
        this.handleString(pair2.getKey());
        this.append(": ");
        this.handleValue(pair2.getValue());
    }

    private final void handleString(Object v) {
        Object object = v;
        if (object != null) {
            if (object instanceof String) {
                this.append('\"' + JsonSupportKt.escape((String)v) + '\"');
            } else {
                throw new IllegalArgumentException("Expected a string, but got '" + Reflection.getOrCreateKotlinClass(v.getClass()).getSimpleName() + '\'');
            }
        }
    }

    private final void append(String s) {
        this.output.append(s);
    }

    private final <E> void headTail(Collection<? extends E> $this$headTail, Function1<? super E, Unit> head, Function1<? super Sequence<? extends E>, Unit> tail) {
        if (!$this$headTail.isEmpty()) {
            head.invoke(CollectionsKt.first((Iterable)$this$headTail));
            tail.invoke((Object)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)$this$headTail), (int)1));
        }
    }

    public JsonFormatter() {
        this(false, 1, null);
    }

    public static final /* synthetic */ Output access$getOutput$p(JsonFormatter $this) {
        return $this.output;
    }

    public static final /* synthetic */ void access$handleValue(JsonFormatter $this, Object v) {
        $this.handleValue(v);
    }

    public static final /* synthetic */ void access$handlePair(JsonFormatter $this, Map.Entry pair2) {
        $this.handlePair(pair2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0005H&J\b\u0010\u0007\u001a\u00020\u0003H&J\b\u0010\b\u001a\u00020\u0003H&J\b\u0010\t\u001a\u00020\u0003H&J\b\u0010\n\u001a\u00020\u0003H&J\b\u0010\u000b\u001a\u00020\u0003H&J\b\u0010\f\u001a\u00020\u0003H&\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/json/JsonFormatter$Output;", "", "append", "", "s", "", "asString", "endList", "endMap", "firstItem", "nextItem", "startList", "startMap", "commons"})
    public static interface Output {
        public void append(@NotNull String var1);

        public void startList();

        public void endList();

        public void startMap();

        public void endMap();

        public void firstItem();

        public void nextItem();

        @NotNull
        public String asString();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0016J\b\u0010\u0006\u001a\u00020\u000bH\u0002J\b\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\tH\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/json/JsonFormatter$Pretty;", "Lorg/jetbrains/letsPlot/commons/intern/json/JsonFormatter$Output;", "()V", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "indent", "", "append", "", "s", "", "asString", "endList", "endMap", "firstItem", "nextItem", "startList", "startMap", "commons"})
    public static final class Pretty
    implements Output {
        private int indent;
        @NotNull
        private StringBuilder buffer = new StringBuilder();

        @Override
        public void startList() {
            this.buffer.append("[");
            int n = this.indent;
            this.indent = n + 1;
        }

        @Override
        public void endList() {
            int n = this.indent;
            this.indent = n + -1;
            this.buffer.append("\n");
            this.buffer.append(this.indent());
            this.buffer.append("]");
        }

        @Override
        public void startMap() {
            this.buffer.append("{");
            int n = this.indent;
            this.indent = n + 1;
        }

        @Override
        public void endMap() {
            int n = this.indent;
            this.indent = n + -1;
            this.buffer.append("\n");
            this.buffer.append(this.indent());
            this.buffer.append("}");
        }

        @Override
        @NotNull
        public String asString() {
            String string = this.buffer.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @Override
        public void append(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            this.buffer.append(s);
        }

        private final String indent() {
            return StringsKt.repeat((CharSequence)"  ", (int)(this.indent * 2));
        }

        @Override
        public void firstItem() {
            this.buffer.append("\n");
            this.buffer.append(this.indent());
        }

        @Override
        public void nextItem() {
            this.buffer.append(", ");
            this.buffer.append("\n");
            this.buffer.append(this.indent());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016J\b\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u0007H\u0016R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/json/JsonFormatter$Simple;", "Lorg/jetbrains/letsPlot/commons/intern/json/JsonFormatter$Output;", "()V", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "append", "", "s", "", "asString", "endList", "endMap", "firstItem", "nextItem", "startList", "startMap", "commons"})
    public static final class Simple
    implements Output {
        @NotNull
        private StringBuilder buffer = new StringBuilder();

        @Override
        public void startList() {
            this.append("[");
        }

        @Override
        public void endList() {
            this.append("]");
        }

        @Override
        public void startMap() {
            this.append("{");
        }

        @Override
        public void endMap() {
            this.append("}");
        }

        @Override
        @NotNull
        public String asString() {
            String string = this.buffer.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @Override
        public void firstItem() {
        }

        @Override
        public void nextItem() {
            this.buffer.append(",");
        }

        @Override
        public void append(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            this.buffer.append(s);
        }
    }
}

