/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bigdatatools.visualization.dataframe;

import com.intellij.bigdatatools.visualization.dataframe.DataFrame;
import com.intellij.bigdatatools.visualization.dataframe.DataFrameImpl;
import com.intellij.bigdatatools.visualization.dataframe.analyzing.AnalyzerState;
import com.intellij.bigdatatools.visualization.dataframe.analyzing.CsvAnalysisSuccess;
import com.intellij.bigdatatools.visualization.dataframe.analyzing.CsvField;
import com.intellij.bigdatatools.visualization.dataframe.analyzing.CsvFileAnalyzer;
import com.intellij.bigdatatools.visualization.dataframe.analyzing.CsvOffsetParser;
import com.intellij.bigdatatools.visualization.dataframe.columns.Column;
import com.intellij.bigdatatools.visualization.dataframe.columns.TableColumnType;
import com.intellij.bigdatatools.visualization.dataframe.utils.DataframeMessagesBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010(\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J;\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000fJ \u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002JG\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u00142\u0006\u0010\u0007\u001a\u00020\u00042\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\r2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\u001bJ>\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u00142\u0006\u0010\u0007\u001a\u00020\u00042\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J<\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u00142\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001f0\u001e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\r2\u0006\u0010 \u001a\u00020\tH\u0002J\u0016\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0002J=\u0010$\u001a\u00020\"2\u000e\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\r2\u0010\u0010&\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0014H\u0002\u00a2\u0006\u0002\u0010'J[\u0010(\u001a\u00020\"2\u000e\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\r2\u0010\u0010&\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u00142\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010*JS\u0010+\u001a\u00020\"2\u000e\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\r2\u0010\u0010&\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u00142\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\u0006\u0010)\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010,R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/bigdatatools/visualization/dataframe/DataFrameCSVAdapter;", "", "()V", "COMMENT_MARKER", "", "fromCsvString", "Lcom/intellij/bigdatatools/visualization/dataframe/DataFrame;", "data", "withDelimiter", "", "strict", "", "offsetMap", "", "", "(Ljava/lang/String;Ljava/lang/Character;ZLjava/util/List;)Lcom/intellij/bigdatatools/visualization/dataframe/DataFrame;", "isCommentMarker", "start", "end", "readData", "", "Lcom/intellij/bigdatatools/visualization/dataframe/columns/Column;", "columnsInfo", "Lcom/intellij/bigdatatools/visualization/dataframe/analyzing/CsvField;", "delimiter", "hasHeader", "quoteChar", "(Ljava/lang/String;Ljava/util/List;CZLjava/lang/Character;)Ljava/util/List;", "readDataInner", "reader", "", "", "addedDel", "showIssuesWarning", "", "linesWithIssues", "writeLine", "strings", "columns", "([Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "writeLongerLine", "lineNo", "([Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;IC)V", "writeShorterLine", "([Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;I)V", "intellij.charts"})
public final class DataFrameCSVAdapter {
    @NotNull
    public static final DataFrameCSVAdapter INSTANCE = new DataFrameCSVAdapter();
    @NotNull
    private static final String COMMENT_MARKER = "<!--TABLE_COMMENT-->";

    private DataFrameCSVAdapter() {
    }

    private final boolean isCommentMarker(String data, int start2, int end) {
        if (start2 == end) {
            return true;
        }
        if (end - start2 != 20) {
            return false;
        }
        int n = COMMENT_MARKER.length();
        for (int i = 0; i < n; ++i) {
            if (data.charAt(start2 + i) == COMMENT_MARKER.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private final List<Column<?>> readDataInner(Iterator<String[]> reader, List<CsvField> columnsInfo, char addedDel) {
        ArrayList columns = new ArrayList(columnsInfo.size());
        for (CsvField element : columnsInfo) {
            columns.add(element.getType().createDataArray());
        }
        int lineNo = 0;
        List linesWithIssues = new ArrayList();
        try {
            Iterator<String[]> iterator2 = reader;
            while (iterator2.hasNext()) {
                String[] strings = iterator2.next();
                ++lineNo;
                if (strings.length == 0 || strings.length == 1 && StringsKt.isBlank((CharSequence)strings[0])) continue;
                if (!Intrinsics.areEqual((Object)strings[0], (Object)COMMENT_MARKER) && (strings.length >= columns.size() || reader.hasNext())) {
                    if (strings.length < columns.size()) {
                        this.writeShorterLine(strings, columnsInfo, columns, linesWithIssues, lineNo);
                        continue;
                    }
                    if (strings.length == columns.size()) {
                        this.writeLine(strings, columnsInfo, columns);
                        continue;
                    }
                    this.writeLongerLine(strings, columnsInfo, columns, linesWithIssues, lineNo, addedDel);
                    continue;
                }
                break;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (!((Collection)linesWithIssues).isEmpty()) {
            this.showIssuesWarning(linesWithIssues);
        }
        ArrayList realColumns = new ArrayList(columnsInfo.size());
        int n = columnsInfo.size();
        for (int p = 0; p < n; ++p) {
            TableColumnType tableColumnType = columnsInfo.get(p).getType();
            String string = columnsInfo.get(p).getName();
            Object e = columns.get(p);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            realColumns.add(tableColumnType.createDataColumn(string, (List)e));
        }
        return realColumns;
    }

    private final List<Column<?>> readData(String data, List<CsvField> columnsInfo, List<Integer> offsetMap, boolean hasHeader) {
        CsvOffsetParser offsetParser = new CsvOffsetParser(data, offsetMap);
        if (hasHeader && offsetParser.hasNext()) {
            offsetParser.next();
        }
        return this.readDataInner(offsetParser, columnsInfo, ',');
    }

    private final List<Column<?>> readData(String data, List<CsvField> columnsInfo, char delimiter, boolean hasHeader, Character quoteChar) {
        CSVParserBuilder cSVParserBuilder;
        CSVParserBuilder $this$readData_u24lambda_u240 = cSVParserBuilder = new CSVParserBuilder();
        boolean bl = false;
        Character c = quoteChar;
        if (c != null) {
            $this$readData_u24lambda_u240.withQuoteChar(c.charValue());
        } else {
            $this$readData_u24lambda_u240.withIgnoreQuotations(true);
        }
        $this$readData_u24lambda_u240.withSeparator(delimiter);
        $this$readData_u24lambda_u240.withEscapeChar('\u0000');
        CSVParser csvParser = cSVParserBuilder.build();
        CSVReader csvReader = new CSVReaderBuilder(new StringReader(data)).withCSVParser(csvParser).withSkipLines(hasHeader ? 1 : 0).build();
        Iterator<String[]> iterator2 = csvReader.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        return this.readDataInner(iterator2, columnsInfo, delimiter);
    }

    private final void writeLongerLine(String[] strings, List<CsvField> columnsInfo, List<List<?>> columns, List<Integer> linesWithIssues, int lineNo, char delimiter) {
        Integer n = lineNo;
        ((Collection)linesWithIssues).add(n);
        int n2 = columnsInfo.size() - 1;
        for (int index = 0; index < n2; ++index) {
            columnsInfo.get(index).getType().appendToDataArray(columns.get(index), strings[index]);
        }
        String lastStringInLine = CollectionsKt.joinToString$default((Iterable)ArraysKt.slice((Object[])strings, (IntRange)RangesKt.until((int)(columnsInfo.size() - 1), (int)strings.length)), (CharSequence)String.valueOf(delimiter), null, null, (int)0, null, null, (int)62, null);
        ((CsvField)CollectionsKt.last(columnsInfo)).getType().appendToDataArray((List)CollectionsKt.last(columns), lastStringInLine);
    }

    private final void writeShorterLine(String[] strings, List<CsvField> columnsInfo, List<List<?>> columns, List<Integer> linesWithIssues, int lineNo) {
        Integer n = lineNo;
        ((Collection)linesWithIssues).add(n);
        this.writeLine(strings, columnsInfo, columns);
        int n2 = columns.size();
        for (int index = strings.length; index < n2; ++index) {
            columnsInfo.get(index).getType().appendToDataArray(columns.get(index), "");
        }
    }

    private final void writeLine(String[] strings, List<CsvField> columnsInfo, List<List<?>> columns) {
        int n = strings.length;
        for (int index = 0; index < n; ++index) {
            columnsInfo.get(index).getType().appendToDataArray(columns.get(index), strings[index]);
        }
    }

    @NotNull
    public final DataFrame fromCsvString(@NotNull String data, @Nullable Character withDelimiter, boolean strict, @Nullable List<Integer> offsetMap) {
        CsvFileAnalyzer analyzer;
        AnalyzerState analyzerState;
        CsvAnalysisSuccess csvAnalysisSuccess;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Object innerData = data;
        if (((CharSequence)data).length() > 0 && data.charAt(data.length() - 1) != '\n') {
            innerData = (String)innerData + "\n";
        }
        if ((csvAnalysisSuccess = (analyzerState = (analyzer = new CsvFileAnalyzer(-1, withDelimiter, strict, false, null, offsetMap, 16, null)).startAnalysis(data)) instanceof CsvAnalysisSuccess ? (CsvAnalysisSuccess)analyzerState : null) == null) {
            csvAnalysisSuccess = analyzer.getCurrentResult();
        }
        CsvAnalysisSuccess meta = csvAnalysisSuccess;
        List<Column<?>> res = offsetMap != null ? this.readData(data, meta.getResult(), offsetMap, meta.getHasHeader()) : this.readData((String)innerData, meta.getResult(), meta.getDelimiter(), meta.getHasHeader(), meta.getQuoteChar());
        return new DataFrameImpl(res);
    }

    public static /* synthetic */ DataFrame fromCsvString$default(DataFrameCSVAdapter dataFrameCSVAdapter, String string, Character c, boolean bl, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            c = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            list2 = null;
        }
        return dataFrameCSVAdapter.fromCsvString(string, c, bl, list2);
    }

    private final void showIssuesWarning(List<Integer> linesWithIssues) {
        if (ApplicationManager.getApplication() == null || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        String string = DataframeMessagesBundle.message("dataframe.csv.parser.error", new Object[0]);
        String string2 = linesWithIssues.size() > 1 ? "dataframe.csv.parser.error.in.lines" : "dataframe.csv.parser.error.in.line";
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)StringUtil.shortenTextWithEllipsis((String)CollectionsKt.joinToString$default((Iterable)linesWithIssues, null, null, null, (int)0, null, null, (int)63, null), (int)200, (int)0), (String)"shortenTextWithEllipsis(...)");
        Notifications.Bus.notify((Notification)new Notification("CSV Files", string, DataframeMessagesBundle.message(string2, objectArray), NotificationType.WARNING));
    }
}

