/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bigdatatools.visualization.charts.settings.ui;

import com.intellij.bigdatatools.visualization.charts.settings.data.ColumnModifier;
import com.intellij.bigdatatools.visualization.charts.settings.data.ColumnModifierType;
import com.intellij.bigdatatools.visualization.charts.settings.data.ColumnSettings;
import com.intellij.bigdatatools.visualization.charts.settings.ui.TokenFieldElement;
import com.intellij.bigdatatools.visualization.charts.statistics.ChartsUsagesCollector;
import com.intellij.bigdatatools.visualization.charts.style.PaletteDialogKt;
import com.intellij.bigdatatools.visualization.charts.utils.ChartMessagesBundle;
import com.intellij.bigdatatools.visualization.dataframe.columns.Column;
import com.intellij.icons.AllIcons;
import com.intellij.icons.ExpUiIcons;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.ChartsIcons;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0011\u0018\u0000 .2\u00020\u0001:\u0001.B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010(\u001a\u00020\fH\u0002J\b\u0010)\u001a\u00020\fH\u0002J\u0006\u0010*\u001a\u00020\u0005J\b\u0010+\u001a\u00020\u001eH\u0002J\b\u0010,\u001a\u00020\u001eH\u0002J\b\u0010-\u001a\u00020\u001eH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/bigdatatools/visualization/charts/settings/ui/TokenFieldElementColumn;", "Lcom/intellij/bigdatatools/visualization/charts/settings/ui/TokenFieldElement;", "type", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnModifierType;", "value", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnSettings;", "icon", "Ljavax/swing/Icon;", "(Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnModifierType;Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnSettings;Ljavax/swing/Icon;)V", "actionsPanel", "Ljavax/swing/JPanel;", "closeActionButton", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "", "closeable", "getCloseable", "()Z", "setCloseable", "(Z)V", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnModifier;", "modifier", "getModifier", "()Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnModifier;", "setModifier", "(Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnModifier;)V", "modifierActionButton", "modifierLabel", "Ljavax/swing/JLabel;", "onChange", "Lkotlin/Function1;", "", "getOnChange", "()Lkotlin/jvm/functions/Function1;", "setOnChange", "(Lkotlin/jvm/functions/Function1;)V", "panel", "getType", "()Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnModifierType;", "setType", "(Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnModifierType;)V", "createCloseButton", "createModifierButton", "getColumnSettings", "updateActions", "updateModifier", "updateTooltipText", "Companion", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nTokenFieldElementColumn.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokenFieldElementColumn.kt\ncom/intellij/bigdatatools/visualization/charts/settings/ui/TokenFieldElementColumn\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,203:1\n1#2:204\n13309#3,2:205\n*S KotlinDebug\n*F\n+ 1 TokenFieldElementColumn.kt\ncom/intellij/bigdatatools/visualization/charts/settings/ui/TokenFieldElementColumn\n*L\n187#1:205,2\n*E\n"})
public final class TokenFieldElementColumn
extends TokenFieldElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ColumnSettings value;
    private boolean closeable;
    @Nullable
    private Function1<? super TokenFieldElementColumn, Unit> onChange;
    @NotNull
    private final JLabel modifierLabel;
    @NotNull
    private ColumnModifier modifier;
    @NotNull
    private ColumnModifierType type;
    @NotNull
    private final JPanel panel;
    @NotNull
    private final JPanel actionsPanel;
    @Nullable
    private ActionButton modifierActionButton;
    @Nullable
    private ActionButton closeActionButton;
    @NotNull
    private static final ColumnModifier[] grouping;
    @NotNull
    private static final ColumnModifier[] aggregation;

    /*
     * WARNING - void declaration
     */
    public TokenFieldElementColumn(@NotNull ColumnModifierType type, @NotNull ColumnSettings value, @Nullable Icon icon) {
        void $this$actionsPanel_u24lambda_u241;
        JComponent $this$modifierLabel_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
        JComponent jComponent = new JLabel();
        JLabel jLabel = jComponent;
        TokenFieldElementColumn tokenFieldElementColumn = this;
        boolean bl = false;
        $this$modifierLabel_u24lambda_u240.setForeground(UIUtil.getLabelInfoForeground());
        tokenFieldElementColumn.modifierLabel = jComponent;
        this.modifier = this.value.getModifier();
        this.type = type;
        this.panel = new JPanel();
        jComponent = new JPanel(new FlowLayout(3, 0, 0));
        $this$modifierLabel_u24lambda_u240 = jComponent;
        tokenFieldElementColumn = this;
        boolean bl2 = false;
        $this$actionsPanel_u24lambda_u241.setOpaque(false);
        tokenFieldElementColumn.actionsPanel = jComponent;
        this.setBorder(IdeBorderFactory.createEmptyBorder((Insets)((Insets)new JBInsets(2, 10, 2, 10))));
        JComponent $this$_init__u24lambda_u242 = jComponent = this.panel;
        boolean bl3 = false;
        $this$_init__u24lambda_u242.setLayout(new BoxLayout($this$_init__u24lambda_u242, 0));
        $this$_init__u24lambda_u242.setBorder(BorderFactory.createEmptyBorder());
        $this$_init__u24lambda_u242.setOpaque(false);
        $this$_init__u24lambda_u242.add(new JLabel(this.value.getColumnId().getName(), icon, 10));
        $this$_init__u24lambda_u242.add(this.modifierLabel);
        this.add((Component)this.panel, "Center");
        this.add((Component)this.actionsPanel, "After");
        this.updateModifier();
    }

    public /* synthetic */ TokenFieldElementColumn(ColumnModifierType columnModifierType, ColumnSettings columnSettings, Icon icon, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            icon = null;
        }
        this(columnModifierType, columnSettings, icon);
    }

    public final boolean getCloseable() {
        return this.closeable;
    }

    public final void setCloseable(boolean value) {
        if (this.closeable == value) {
            return;
        }
        this.closeActionButton = value ? this.createCloseButton() : null;
        this.updateActions();
        this.closeable = value;
    }

    @Nullable
    public final Function1<TokenFieldElementColumn, Unit> getOnChange() {
        return this.onChange;
    }

    public final void setOnChange(@Nullable Function1<? super TokenFieldElementColumn, Unit> function1) {
        this.onChange = function1;
    }

    @NotNull
    public final ColumnModifier getModifier() {
        return this.modifier;
    }

    public final void setModifier(@NotNull ColumnModifier value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        if (this.modifier == value) {
            return;
        }
        this.modifier = value;
        this.modifierLabel.setText((String)(this.modifier == ColumnModifier.None ? "" : " " + this.modifier.getTitle()));
        this.updateTooltipText();
    }

    @NotNull
    public final ColumnModifierType getType() {
        return this.type;
    }

    public final void setType(@NotNull ColumnModifierType value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        if (this.type == value) {
            return;
        }
        this.type = value;
        this.updateModifier();
    }

    private final ActionButton createCloseButton() {
        DumbAwareAction dumbAwareAction;
        DumbAwareAction $this$createCloseButton_u24lambda_u244 = dumbAwareAction = DumbAwareAction.create((String)ChartMessagesBundle.message("token.action.remove", new Object[0]), (Icon)AllIcons.Actions.CloseDarkGrey, arg_0 -> TokenFieldElementColumn.createCloseButton$lambda$3((Function1)new Function1<AnActionEvent, Unit>(this){
            final /* synthetic */ TokenFieldElementColumn this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(AnActionEvent it) {
                block0: {
                    Container container = this.this$0.getParent();
                    if (container == null) break block0;
                    Container container2 = container;
                    TokenFieldElementColumn tokenFieldElementColumn = this.this$0;
                    Container $this$invoke_u24lambda_u240 = container2;
                    boolean bl = false;
                    $this$invoke_u24lambda_u240.remove(tokenFieldElementColumn);
                    $this$invoke_u24lambda_u240.revalidate();
                    $this$invoke_u24lambda_u240.repaint();
                    ChartsUsagesCollector.INSTANCE.getColumnRemoved().log();
                }
            }
        }, arg_0));
        boolean bl = false;
        $this$createCloseButton_u24lambda_u244.getTemplatePresentation().setHoveredIcon(AllIcons.Actions.CloseHovered);
        DumbAwareAction dumbAwareAction2 = dumbAwareAction;
        Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction2, (String)"apply(...)");
        DumbAwareAction closeAction2 = dumbAwareAction2;
        return new ActionButton((AnAction)closeAction2, null, "TokenField", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
    }

    private final void updateTooltipText() {
        String disabledColor = PaletteDialogKt.fromColorToHexString(JBUI.CurrentTheme.Label.disabledForeground().getRGB());
        this.setToolTipText("<html><table><tr><td><font color=\"" + disabledColor + "\">" + ChartMessagesBundle.message("column.token.tooltip.column", new Object[0]) + "</font></td><td>" + this.value.getColumnId().getName() + "</td></tr>");
        if (this.modifier != ColumnModifier.None) {
            this.setToolTipText(this.getToolTipText() + "<tr><td><font color=\"" + disabledColor + "\">" + ChartMessagesBundle.message("column.token.tooltip.modifier", new Object[0]) + "</font></td><td>" + this.modifier.getTitle() + "</td></tr>");
        }
        this.setToolTipText(this.getToolTipText() + "</table></html>");
    }

    private final void updateActions() {
        ActionButton actionButton;
        this.actionsPanel.removeAll();
        ActionButton actionButton2 = this.modifierActionButton;
        if (actionButton2 != null) {
            ActionButton $this$updateActions_u24lambda_u245 = actionButton = actionButton2;
            boolean bl = false;
            this.actionsPanel.add((Component)this.modifierActionButton);
        }
        ActionButton actionButton3 = this.closeActionButton;
        if (actionButton3 != null) {
            ActionButton $this$updateActions_u24lambda_u246 = actionButton = actionButton3;
            boolean bl = false;
            this.actionsPanel.add((Component)this.closeActionButton);
        }
        this.setBorder(this.actionsPanel.getComponentCount() > 0 ? IdeBorderFactory.createEmptyBorder((Insets)((Insets)new JBInsets(2, 10, 2, 5))) : IdeBorderFactory.createEmptyBorder((Insets)((Insets)new JBInsets(2, 10, 2, 10))));
    }

    private final void updateModifier() {
        if (this.type == ColumnModifierType.None) {
            ActionButton actionButton = this.modifierActionButton;
            if (actionButton != null) {
                ActionButton it = actionButton;
                boolean bl = false;
                this.panel.remove((Component)it);
            }
            this.modifierActionButton = null;
            this.setModifier(ColumnModifier.None);
            this.modifierLabel.setText("");
            this.updateTooltipText();
            return;
        }
        this.modifierActionButton = this.createModifierButton();
        this.updateActions();
        this.modifierLabel.setText((String)(this.modifier == ColumnModifier.None ? "" : " " + this.modifier.getTitle()));
        this.updateTooltipText();
    }

    private final ActionButton createModifierButton() {
        DefaultActionGroup defaultActionGroup;
        ColumnModifier[] modifiers;
        ColumnModifier[] columnModifierArray = modifiers = this.type == ColumnModifierType.Aggregation ? aggregation : grouping;
        if (this.modifier != ColumnModifier.None && !ArraysKt.contains((Object[])modifiers, (Object)((Object)this.modifier))) {
            ColumnModifier columnModifier = (ColumnModifier)((Object)ArraysKt.firstOrNull((Object[])modifiers));
            if (columnModifier == null) {
                columnModifier = ColumnModifier.None;
            }
            this.setModifier(columnModifier);
        }
        DefaultActionGroup $this$createModifierButton_u24lambda_u248 = defaultActionGroup = new DefaultActionGroup(ChartMessagesBundle.message("token.action.modifier", new Object[0]), null, AllIcons.Ide.Notification.Expand);
        boolean bl = false;
        $this$createModifierButton_u24lambda_u248.setPopup(true);
        $this$createModifierButton_u24lambda_u248.getTemplatePresentation().putClientProperty(ActionButton.HIDE_DROPDOWN_ICON, (Object)true);
        $this$createModifierButton_u24lambda_u248.getTemplatePresentation().setHoveredIcon(ChartsIcons.ExpandHover);
        DefaultActionGroup modifierGroup = defaultActionGroup;
        ColumnModifier[] $this$forEach$iv = modifiers;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            DumbAwareAction modifierAction2;
            ColumnModifier element$iv;
            ColumnModifier mod = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            String title = mod == ColumnModifier.None ? ChartMessagesBundle.message("columnModifier.none", new Object[0]) : mod.getTitle();
            Intrinsics.checkNotNullExpressionValue((Object)DumbAwareAction.create((String)title, arg_0 -> TokenFieldElementColumn.createModifierButton$lambda$10$lambda$9((Function1)new Function1<AnActionEvent, Unit>(this, mod){
                final /* synthetic */ TokenFieldElementColumn this$0;
                final /* synthetic */ ColumnModifier $mod;
                {
                    this.this$0 = $receiver;
                    this.$mod = $mod;
                    super(1);
                }

                public final void invoke(AnActionEvent it) {
                    this.this$0.setModifier(this.$mod);
                    Function1<TokenFieldElementColumn, Unit> function1 = this.this$0.getOnChange();
                    if (function1 != null) {
                        function1.invoke((Object)this.this$0);
                    }
                    ChartsUsagesCollector.INSTANCE.getColumnModifierChanged().log((Object)((Object)this.this$0.getModifier()));
                }
            }, arg_0)), (String)"create(...)");
            modifierGroup.add((AnAction)modifierAction2);
        }
        return new ActionButton((AnAction)modifierGroup, null, "CHART_SERIES_PANEL", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
    }

    @NotNull
    public final ColumnSettings getColumnSettings() {
        return new ColumnSettings(this.value.getColumnId(), this.modifier);
    }

    private static final void createCloseButton$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void createModifierButton$lambda$10$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    static {
        ColumnModifier[] columnModifierArray = new ColumnModifier[]{ColumnModifier.None, ColumnModifier.Group, ColumnModifier.GroupAndSort};
        grouping = columnModifierArray;
        columnModifierArray = new ColumnModifier[]{ColumnModifier.None, ColumnModifier.Min, ColumnModifier.Max, ColumnModifier.Mean, ColumnModifier.Median, ColumnModifier.Std, ColumnModifier.Var, ColumnModifier.Mad, ColumnModifier.First, ColumnModifier.Last, ColumnModifier.Sum, ColumnModifier.Prod, ColumnModifier.Count};
        aggregation = columnModifierArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eR\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/bigdatatools/visualization/charts/settings/ui/TokenFieldElementColumn$Companion;", "", "()V", "aggregation", "", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnModifier;", "getAggregation", "()[Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnModifier;", "[Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnModifier;", "grouping", "getGrouping", "getColumnTypeIcon", "Ljavax/swing/Icon;", "column", "Lcom/intellij/bigdatatools/visualization/dataframe/columns/Column;", "intellij.charts"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ColumnModifier[] getGrouping() {
            return grouping;
        }

        @NotNull
        public final ColumnModifier[] getAggregation() {
            return aggregation;
        }

        @NotNull
        public final Icon getColumnTypeIcon(@NotNull Column<?> column) {
            Icon icon;
            Intrinsics.checkNotNullParameter(column, (String)"column");
            if (column.isNumerical()) {
                Icon icon2 = ChartsIcons.Columns.Numeric;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Numeric");
            } else {
                Icon icon3 = ExpUiIcons.FileTypes.Text;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Text");
            }
            return icon;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

