/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bigdatatools.visualization.charts.settings.data;

import com.google.gson.JsonObject;
import com.intellij.bigdatatools.visualization.charts.core.utils.GroupingResult;
import com.intellij.bigdatatools.visualization.charts.settings.data.ColumnModifier;
import com.intellij.bigdatatools.visualization.charts.settings.data.ColumnSettings;
import com.intellij.bigdatatools.visualization.charts.settings.data.SeriesSettings;
import com.intellij.bigdatatools.visualization.charts.settings.data.type.SeriesType;
import com.intellij.bigdatatools.visualization.charts.settings.data.type.SeriesTypes;
import com.intellij.bigdatatools.visualization.dataframe.DataFrame;
import com.intellij.bigdatatools.visualization.dataframe.aggregation.Count;
import com.intellij.bigdatatools.visualization.dataframe.aggregation.First;
import com.intellij.bigdatatools.visualization.dataframe.aggregation.Last;
import com.intellij.bigdatatools.visualization.dataframe.aggregation.Mad;
import com.intellij.bigdatatools.visualization.dataframe.aggregation.Max;
import com.intellij.bigdatatools.visualization.dataframe.aggregation.Mean;
import com.intellij.bigdatatools.visualization.dataframe.aggregation.Median;
import com.intellij.bigdatatools.visualization.dataframe.aggregation.Min;
import com.intellij.bigdatatools.visualization.dataframe.aggregation.Prod;
import com.intellij.bigdatatools.visualization.dataframe.aggregation.Std;
import com.intellij.bigdatatools.visualization.dataframe.aggregation.Sum;
import com.intellij.bigdatatools.visualization.dataframe.aggregation.Var;
import com.intellij.bigdatatools.visualization.dataframe.columns.Column;
import com.intellij.bigdatatools.visualization.dataframe.columns.ColumnId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.intern.Feature;
import org.jetbrains.letsPlot.intern.layer.SamplingOptions;
import org.jetbrains.letsPlot.sampling.SamplingKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u00a6\u0002J\u0010\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fH&J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\b\u0010\u0012\u001a\u00020\bH&J\b\u0010\u0013\u001a\u00020\u0014H&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/intellij/bigdatatools/visualization/charts/settings/data/SeriesSettings;", "", "()V", "type", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/type/SeriesType;", "getType", "()Lcom/intellij/bigdatatools/visualization/charts/settings/data/type/SeriesType;", "equals", "", "other", "filterByNewDataFrame", "dataFrame", "Lcom/intellij/bigdatatools/visualization/dataframe/DataFrame;", "getLetsPlotLayer", "", "Lorg/jetbrains/letsPlot/intern/Feature;", "chartIndex", "", "isEmpty", "toJson", "Lcom/google/gson/JsonObject;", "Companion", "intellij.charts"})
public abstract class SeriesSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    @NotNull
    public abstract SeriesType getType();

    @NotNull
    public abstract SeriesSettings filterByNewDataFrame(@NotNull DataFrame var1);

    @NotNull
    public abstract List<Feature> getLetsPlotLayer(@NotNull DataFrame var1, int var2);

    @NotNull
    public abstract JsonObject toJson();

    public abstract boolean isEmpty();

    public abstract boolean equals(@Nullable Object var1);

    @NotNull
    protected static final Logger getLogger() {
        return Companion.getLogger();
    }

    static {
        Logger logger2 = Logger.getInstance(Companion.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ'\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000e2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0012\"\u00020\f\u00a2\u0006\u0002\u0010\u0013J3\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000e2\u001e\u0010\u0014\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\f0\u00150\u0012\"\b\u0012\u0004\u0012\u00020\f0\u0015\u00a2\u0006\u0002\u0010\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u000eJ\"\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\u0006\u0010\u0010\u001a\u00020\u000eJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001dJ\u001e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\"2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ#\u0010#\u001a\u00070 \u00a2\u0006\u0002\b\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0$2\b\b\u0002\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\u0012\u0010'\u001a\u00020(2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030\"R!\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00058\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u0006,"}, d2={"Lcom/intellij/bigdatatools/visualization/charts/settings/data/SeriesSettings$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger$annotations", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "columnAggregationSupported", "", "y", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnSettings;", "df", "Lcom/intellij/bigdatatools/visualization/dataframe/DataFrame;", "dataFrameHasAllColumns", "dataFrame", "columns", "", "(Lcom/intellij/bigdatatools/visualization/dataframe/DataFrame;[Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnSettings;)Z", "columnsLists", "", "(Lcom/intellij/bigdatatools/visualization/dataframe/DataFrame;[Ljava/util/List;)Z", "filterByDataFrame", "columnSettings", "columnsSettings", "fromJson", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/SeriesSettings;", "json", "Lcom/google/gson/JsonObject;", "fromType", "type", "", "getAggregatedColumn", "Lcom/intellij/bigdatatools/visualization/dataframe/columns/Column;", "getPresentableAxisText", "", "separator", "", "getSampling", "Lorg/jetbrains/letsPlot/intern/layer/SamplingOptions;", "data", "Lcom/intellij/bigdatatools/visualization/charts/core/utils/GroupingResult;", "column", "intellij.charts"})
    @SourceDebugExtension(value={"SMAP\nSeriesSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeriesSettings.kt\ncom/intellij/bigdatatools/visualization/charts/settings/data/SeriesSettings$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,116:1\n1603#2,9:117\n1855#2:126\n1856#2:128\n1612#2:129\n288#2,2:130\n1747#2,3:133\n1#3:127\n12474#4:132\n12475#4:136\n12474#4,2:137\n*S KotlinDebug\n*F\n+ 1 SeriesSettings.kt\ncom/intellij/bigdatatools/visualization/charts/settings/data/SeriesSettings$Companion\n*L\n46#1:117,9\n46#1:126\n46#1:128\n46#1:129\n63#1:130,2\n75#1:133,3\n46#1:127\n74#1:132\n74#1:136\n80#1:137,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Logger getLogger() {
            return logger;
        }

        @JvmStatic
        protected static /* synthetic */ void getLogger$annotations() {
        }

        @NotNull
        public final SamplingOptions getSampling(@NotNull Column<?> column) {
            Intrinsics.checkNotNullParameter(column, (String)"column");
            return column.getSize() > 4000 ? SamplingKt.samplingSystematic(column.getSize() / 2000) : SamplingKt.getSamplingNone();
        }

        @NotNull
        public final SamplingOptions getSampling(@NotNull GroupingResult data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return this.getSampling(data.getXColumn());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ColumnSettings> filterByDataFrame(@NotNull List<ColumnSettings> columnsSettings, @NotNull DataFrame dataFrame) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter(columnsSettings, (String)"columnsSettings");
            Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
            Iterable $this$mapNotNull$iv = columnsSettings;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ColumnSettings it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                ColumnSettings it = (ColumnSettings)element$iv$iv;
                boolean bl2 = false;
                if (Companion.filterByDataFrame(it, dataFrame) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Nullable
        public final ColumnSettings filterByDataFrame(@Nullable ColumnSettings columnSettings, @NotNull DataFrame dataFrame) {
            Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
            if (columnSettings == null) {
                return null;
            }
            if (!dataFrame.has(columnSettings.getColumnId().getName())) {
                return null;
            }
            Column<?> column = dataFrame.get(columnSettings.getColumnId().getName());
            ColumnId columnId = dataFrame.getColumnId(column);
            if (columnId == null) {
                return null;
            }
            ColumnId columnId2 = columnId;
            return new ColumnSettings(columnId2, columnSettings.getModifier());
        }

        @NotNull
        public final String getPresentableAxisText(@NotNull Collection<ColumnSettings> columnSettings, @NotNull CharSequence separator) {
            Intrinsics.checkNotNullParameter(columnSettings, (String)"columnSettings");
            Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
            String string = StringUtil.shortenTextWithEllipsis((String)CollectionsKt.joinToString$default((Iterable)columnSettings, (CharSequence)separator, null, null, (int)0, null, (Function1)getPresentableAxisText.1.INSTANCE, (int)30, null), (int)60, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
            return string;
        }

        public static /* synthetic */ String getPresentableAxisText$default(Companion companion, Collection collection, CharSequence charSequence, int n, Object object) {
            if ((n & 2) != 0) {
                charSequence = ", ";
            }
            return companion.getPresentableAxisText(collection, charSequence);
        }

        @Nullable
        public final SeriesSettings fromJson(@NotNull JsonObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            String string = json.get("type").getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
            return this.fromType(string, json);
        }

        @Nullable
        public final SeriesSettings fromType(@NotNull String type, @NotNull JsonObject json) {
            SeriesSettings seriesSettings;
            Object v0;
            block3: {
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                Iterable $this$firstOrNull$iv = SeriesTypes.INSTANCE.getTypes();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SeriesType it = (SeriesType)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)type)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            SeriesType seriesType = v0;
            if (seriesType == null) {
                SeriesSettings.getLogger().error("Unsupported series type " + type);
                seriesSettings = null;
            } else {
                seriesSettings = seriesType.createSettings(json);
            }
            return seriesSettings;
        }

        public final boolean dataFrameHasAllColumns(@NotNull DataFrame dataFrame, List<ColumnSettings> ... columnsLists) {
            boolean bl;
            block5: {
                Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
                Intrinsics.checkNotNullParameter(columnsLists, (String)"columnsLists");
                List<ColumnSettings>[] $this$any$iv = columnsLists;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    boolean bl2;
                    block4: {
                        List<ColumnSettings> element$iv;
                        List<ColumnSettings> columns = element$iv = $this$any$iv[i];
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = columns;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                ColumnSettings it = (ColumnSettings)element$iv2;
                                boolean bl4 = false;
                                if (!(!dataFrame.has(it.getColumnId()))) continue;
                                bl2 = true;
                                break block4;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            return !bl;
        }

        public final boolean dataFrameHasAllColumns(@NotNull DataFrame dataFrame, ColumnSettings ... columns) {
            boolean bl;
            block1: {
                Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
                Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
                ColumnSettings[] $this$any$iv = columns;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    ColumnSettings element$iv;
                    ColumnSettings it = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!(!dataFrame.has(it.getColumnId()))) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return !bl;
        }

        public final boolean columnAggregationSupported(@NotNull ColumnSettings y2, @NotNull DataFrame df) {
            Intrinsics.checkNotNullParameter((Object)y2, (String)"y");
            Intrinsics.checkNotNullParameter((Object)df, (String)"df");
            return switch (WhenMappings.$EnumSwitchMapping$0[y2.getModifier().ordinal()]) {
                case 1 -> Mean.Companion.supports(df.get(y2.getColumnId()));
                case 2 -> Var.Companion.supports(df.get(y2.getColumnId()));
                case 3 -> Mad.Companion.supports(df.get(y2.getColumnId()));
                case 4 -> Std.Companion.supports(df.get(y2.getColumnId()));
                case 5 -> Prod.Companion.supports(df.get(y2.getColumnId()));
                default -> true;
            };
        }

        @NotNull
        public final Column<Object> getAggregatedColumn(@NotNull ColumnSettings y2, @NotNull DataFrame df) {
            Intrinsics.checkNotNullParameter((Object)y2, (String)"y");
            Intrinsics.checkNotNullParameter((Object)df, (String)"df");
            return switch (WhenMappings.$EnumSwitchMapping$0[y2.getModifier().ordinal()]) {
                case 6 -> Sum.Companion.process(df.get(y2.getColumnId())).cast();
                case 5 -> Prod.Companion.process(df.get(y2.getColumnId())).cast();
                case 7 -> Count.Companion.process(df.get(y2.getColumnId())).cast();
                case 1 -> Mean.Companion.process(df.get(y2.getColumnId())).cast();
                case 2 -> Var.Companion.process(df.get(y2.getColumnId())).cast();
                case 8 -> Median.Companion.process(df.get(y2.getColumnId())).cast();
                case 3 -> Mad.Companion.process(df.get(y2.getColumnId())).cast();
                case 4 -> Std.Companion.process(df.get(y2.getColumnId())).cast();
                case 9 -> First.Companion.process(df.get(y2.getColumnId())).cast();
                case 10 -> Last.Companion.process(df.get(y2.getColumnId())).cast();
                case 11 -> Min.Companion.process(df.get(y2.getColumnId())).cast();
                case 12 -> Max.Companion.process(df.get(y2.getColumnId())).cast();
                default -> df.get(y2.getColumnId()).cast();
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ColumnModifier.values().length];
                try {
                    nArray[ColumnModifier.Mean.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColumnModifier.Var.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColumnModifier.Mad.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColumnModifier.Std.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColumnModifier.Prod.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColumnModifier.Sum.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColumnModifier.Count.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColumnModifier.Median.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColumnModifier.First.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColumnModifier.Last.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColumnModifier.Min.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColumnModifier.Max.ordinal()] = 12;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

