/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bigdatatools.visualization.charts.settings.data;

import com.google.gson.JsonObject;
import com.intellij.bigdatatools.visualization.charts.core.style.ChartStyle;
import com.intellij.bigdatatools.visualization.charts.core.utils.GroupingResult;
import com.intellij.bigdatatools.visualization.charts.core.utils.GroupingUtils;
import com.intellij.bigdatatools.visualization.charts.settings.data.ColumnSettings;
import com.intellij.bigdatatools.visualization.charts.settings.data.SeriesSettings;
import com.intellij.bigdatatools.visualization.charts.settings.data.type.HistogramSeriesType;
import com.intellij.bigdatatools.visualization.charts.utils.ChartJsonUtilsKt;
import com.intellij.bigdatatools.visualization.dataframe.DataFrame;
import com.intellij.bigdatatools.visualization.dataframe.columns.Column;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.geom.geomHistogram;
import org.jetbrains.letsPlot.intern.Feature;
import org.jetbrains.letsPlot.intern.layer.SamplingOptions;
import org.jetbrains.letsPlot.intern.layer.geom.HistogramMapping;
import org.jetbrains.letsPlot.label.LabsKt;
import org.jetbrains.letsPlot.tooltips.layerTooltips;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001BA\b\u0016\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\u0019\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\u0010\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00032\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\bH\u0016J\b\u0010$\u001a\u00020\u000bH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000e\u00a8\u0006%"}, d2={"Lcom/intellij/bigdatatools/visualization/charts/settings/data/HistogramSeriesSettings;", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/SeriesSettings;", "keys", "", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnSettings;", "groups", "values", "showLegend", "", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Z)V", "json", "Lcom/google/gson/JsonObject;", "(Lcom/google/gson/JsonObject;)V", "getGroups", "()Ljava/util/List;", "getKeys", "getShowLegend", "()Z", "setShowLegend", "(Z)V", "type", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/type/HistogramSeriesType;", "getType", "()Lcom/intellij/bigdatatools/visualization/charts/settings/data/type/HistogramSeriesType;", "getValues", "equals", "other", "", "filterByNewDataFrame", "dataFrame", "Lcom/intellij/bigdatatools/visualization/dataframe/DataFrame;", "getLetsPlotLayer", "Lorg/jetbrains/letsPlot/intern/Feature;", "chartIndex", "", "isEmpty", "toJson", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nHistogramSeriesSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HistogramSeriesSettings.kt\ncom/intellij/bigdatatools/visualization/charts/settings/data/HistogramSeriesSettings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1855#2,2:116\n*S KotlinDebug\n*F\n+ 1 HistogramSeriesSettings.kt\ncom/intellij/bigdatatools/visualization/charts/settings/data/HistogramSeriesSettings\n*L\n89#1:116,2\n*E\n"})
public final class HistogramSeriesSettings
extends SeriesSettings {
    @NotNull
    private final HistogramSeriesType type;
    @NotNull
    private final List<ColumnSettings> keys;
    @NotNull
    private final List<ColumnSettings> groups;
    @NotNull
    private final List<ColumnSettings> values;
    private boolean showLegend;

    @Override
    @NotNull
    public HistogramSeriesType getType() {
        return this.type;
    }

    @NotNull
    public final List<ColumnSettings> getKeys() {
        return this.keys;
    }

    @NotNull
    public final List<ColumnSettings> getGroups() {
        return this.groups;
    }

    @NotNull
    public final List<ColumnSettings> getValues() {
        return this.values;
    }

    public final boolean getShowLegend() {
        return this.showLegend;
    }

    public final void setShowLegend(boolean bl) {
        this.showLegend = bl;
    }

    public HistogramSeriesSettings(@NotNull List<ColumnSettings> keys, @NotNull List<ColumnSettings> groups2, @NotNull List<ColumnSettings> values2, boolean showLegend) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter(groups2, (String)"groups");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        this.type = HistogramSeriesType.Companion.getInstance();
        this.keys = keys;
        this.groups = groups2;
        this.values = values2;
        this.showLegend = showLegend;
    }

    public /* synthetic */ HistogramSeriesSettings(List list2, List list3, List list4, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(list2, list3, list4, bl);
    }

    public HistogramSeriesSettings(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.type = HistogramSeriesType.Companion.getInstance();
        this.keys = ChartJsonUtilsKt.optColumnSettingsList(json, "keys");
        this.groups = ChartJsonUtilsKt.optColumnSettingsList(json, "groups");
        this.values = ChartJsonUtilsKt.optColumnSettingsList(json, "values");
        this.showLegend = ChartJsonUtilsKt.optBoolean(json, "showLegend");
    }

    @Override
    @NotNull
    public JsonObject toJson() {
        JsonObject jsonObject;
        JsonObject $this$toJson_u24lambda_u240 = jsonObject = new JsonObject();
        boolean bl = false;
        $this$toJson_u24lambda_u240.addProperty("type", this.getType().getId());
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "keys", this.keys);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "groups", this.groups);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "values", this.values);
        ChartJsonUtilsKt.optSetProperty($this$toJson_u24lambda_u240, "showLegend", this.showLegend);
        return jsonObject;
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty() && this.groups.isEmpty() && this.values.isEmpty();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof HistogramSeriesSettings && Intrinsics.areEqual(((HistogramSeriesSettings)other).keys, this.keys) && Intrinsics.areEqual(((HistogramSeriesSettings)other).groups, this.groups) && Intrinsics.areEqual(((HistogramSeriesSettings)other).values, this.values) && ((HistogramSeriesSettings)other).showLegend == this.showLegend;
    }

    @Override
    @NotNull
    public HistogramSeriesSettings filterByNewDataFrame(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        return new HistogramSeriesSettings(SeriesSettings.Companion.filterByDataFrame(this.keys, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.groups, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.values, dataFrame), this.showLegend);
    }

    @Override
    @NotNull
    public List<Feature> getLetsPlotLayer(@NotNull DataFrame dataFrame, int chartIndex) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        if (this.keys.isEmpty() || this.values.isEmpty()) {
            SeriesSettings.getLogger().warn("Line series should have at least one X and one Y axis.");
            return CollectionsKt.emptyList();
        }
        List[] listArray = new List[]{this.keys, this.groups, this.values};
        if (!SeriesSettings.Companion.dataFrameHasAllColumns(dataFrame, listArray)) {
            return CollectionsKt.emptyList();
        }
        GroupingResult groupingResult = GroupingUtils.INSTANCE.get(dataFrame, this.keys, this.groups, this.values);
        if (groupingResult == null) {
            return CollectionsKt.emptyList();
        }
        GroupingResult res = groupingResult;
        if (!res.getXColumn().isNumerical()) {
            SeriesSettings.getLogger().warn("Histogram series accepts only number column.");
            return CollectionsKt.emptyList();
        }
        List result2 = new ArrayList();
        Iterable $this$forEach$iv = res.getYColumns();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Column it = (Column)element$iv;
            boolean bl = false;
            if (!it.isNumerical()) continue;
            Color color = ChartStyle.Companion.getInstance().getColor(chartIndex + result2.size());
            layerTooltips tooltips = new layerTooltips(new String[0]).line(res.getXColumn().getName() + "|@{" + res.getXColumn().getName() + "}").line(it.getName() + "|@{" + it.getName() + "}");
            Collection collection = result2;
            Object object = new Pair[]{TuplesKt.to((Object)res.getXColumn().getName(), res.getXColumn().toList()), TuplesKt.to((Object)it.getName(), it.toList())};
            Map map2 = MapsKt.mapOf((Pair[])object);
            object = SeriesSettings.Companion.getSampling(res);
            collection.add(new geomHistogram(map2, null, null, false, (SamplingOptions)object, tooltips, null, null, null, null, 0.5, null, color, null, null, null, null, null, null, null, null, (Function1)new Function1<HistogramMapping, Unit>(res, (Column<? extends Object>)it){
                final /* synthetic */ GroupingResult $res;
                final /* synthetic */ Column<? extends Object> $it;
                {
                    this.$res = $res;
                    this.$it = $it;
                    super(1);
                }

                public final void invoke(@NotNull HistogramMapping $this$$receiver) {
                    Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                    $this$$receiver.setX(this.$res.getXColumn().getName());
                    if (this.$res.getYColumns().size() == 1) {
                        $this$$receiver.setY(this.$it.getName());
                    }
                    $this$$receiver.setWeight(this.$it.getName());
                }
            }, 2091974, null));
        }
        return CollectionsKt.plus((Collection)result2, (Object)LabsKt.ylab(SeriesSettings.Companion.getPresentableAxisText$default(SeriesSettings.Companion, this.values, null, 2, null)));
    }
}

