/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bigdatatools.visualization.charts.settings.data;

import com.google.gson.JsonObject;
import com.intellij.bigdatatools.visualization.charts.core.series.AreaSeries;
import com.intellij.bigdatatools.visualization.charts.core.style.ChartStyle;
import com.intellij.bigdatatools.visualization.charts.core.utils.GroupingResult;
import com.intellij.bigdatatools.visualization.charts.core.utils.GroupingUtils;
import com.intellij.bigdatatools.visualization.charts.settings.data.ColumnSettings;
import com.intellij.bigdatatools.visualization.charts.settings.data.SeriesSettings;
import com.intellij.bigdatatools.visualization.charts.settings.data.type.AreaSeriesType;
import com.intellij.bigdatatools.visualization.charts.utils.ChartJsonUtilsKt;
import com.intellij.bigdatatools.visualization.dataframe.DataFrame;
import com.intellij.bigdatatools.visualization.dataframe.columns.Column;
import com.intellij.bigdatatools.visualization.dataframe.columns.ColumnKt;
import com.intellij.bigdatatools.visualization.dataframe.columns.DoubleColumn;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.geom.geomArea;
import org.jetbrains.letsPlot.intern.Feature;
import org.jetbrains.letsPlot.intern.layer.SamplingOptions;
import org.jetbrains.letsPlot.intern.layer.geom.AreaMapping;
import org.jetbrains.letsPlot.label.LabsKt;
import org.jetbrains.letsPlot.tooltips.layerTooltips;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001BK\b\u0016\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u000f\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u001d\u001a\u00020\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\u0010\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"H\u0016J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\nH\u0016J\b\u0010(\u001a\u00020\rH\u0016R\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0007\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013\u00a8\u0006)"}, d2={"Lcom/intellij/bigdatatools/visualization/charts/settings/data/AreaSeriesSettings;", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/SeriesSettings;", "keys", "", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnSettings;", "groups", "values", "type", "Lcom/intellij/bigdatatools/visualization/charts/core/series/AreaSeries$Type;", "showLegend", "", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Lcom/intellij/bigdatatools/visualization/charts/core/series/AreaSeries$Type;Z)V", "json", "Lcom/google/gson/JsonObject;", "(Lcom/google/gson/JsonObject;)V", "areaType", "getAreaType", "()Lcom/intellij/bigdatatools/visualization/charts/core/series/AreaSeries$Type;", "getGroups", "()Ljava/util/List;", "getKeys", "getShowLegend", "()Z", "setShowLegend", "(Z)V", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/type/AreaSeriesType;", "getType", "()Lcom/intellij/bigdatatools/visualization/charts/settings/data/type/AreaSeriesType;", "getValues", "equals", "other", "", "filterByNewDataFrame", "dataFrame", "Lcom/intellij/bigdatatools/visualization/dataframe/DataFrame;", "getLetsPlotLayer", "Lorg/jetbrains/letsPlot/intern/Feature;", "chartIndex", "", "isEmpty", "toJson", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nAreaSeriesSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AreaSeriesSettings.kt\ncom/intellij/bigdatatools/visualization/charts/settings/data/AreaSeriesSettings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n1855#2,2:175\n1855#2,2:177\n1855#2,2:179\n*S KotlinDebug\n*F\n+ 1 AreaSeriesSettings.kt\ncom/intellij/bigdatatools/visualization/charts/settings/data/AreaSeriesSettings\n*L\n108#1:175,2\n122#1:177,2\n135#1:179,2\n*E\n"})
public final class AreaSeriesSettings
extends SeriesSettings {
    @NotNull
    private final AreaSeriesType type;
    @NotNull
    private final List<ColumnSettings> keys;
    @NotNull
    private final List<ColumnSettings> groups;
    @NotNull
    private final List<ColumnSettings> values;
    @NotNull
    private final AreaSeries.Type areaType;
    private boolean showLegend;

    @Override
    @NotNull
    public AreaSeriesType getType() {
        return this.type;
    }

    @NotNull
    public final List<ColumnSettings> getKeys() {
        return this.keys;
    }

    @NotNull
    public final List<ColumnSettings> getGroups() {
        return this.groups;
    }

    @NotNull
    public final List<ColumnSettings> getValues() {
        return this.values;
    }

    @NotNull
    public final AreaSeries.Type getAreaType() {
        return this.areaType;
    }

    public final boolean getShowLegend() {
        return this.showLegend;
    }

    public final void setShowLegend(boolean bl) {
        this.showLegend = bl;
    }

    public AreaSeriesSettings(@NotNull List<ColumnSettings> keys, @NotNull List<ColumnSettings> groups2, @NotNull List<ColumnSettings> values2, @NotNull AreaSeries.Type type, boolean showLegend) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter(groups2, (String)"groups");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.type = AreaSeriesType.Companion.getInstance();
        this.keys = keys;
        this.groups = groups2;
        this.values = values2;
        this.areaType = type;
        this.showLegend = showLegend;
    }

    public /* synthetic */ AreaSeriesSettings(List list2, List list3, List list4, AreaSeries.Type type, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            type = AreaSeries.Type.Stacked;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(list2, list3, list4, type, bl);
    }

    public AreaSeriesSettings(@NotNull JsonObject json) {
        AreaSeries.Type type;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.type = AreaSeriesType.Companion.getInstance();
        this.keys = ChartJsonUtilsKt.optColumnSettingsList(json, "keys");
        this.groups = ChartJsonUtilsKt.optColumnSettingsList(json, "groups");
        this.values = ChartJsonUtilsKt.optColumnSettingsList(json, "values");
        if (json.has("areaType")) {
            String string = json.get("areaType").getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
            type = AreaSeries.Type.valueOf(string);
        } else {
            type = AreaSeries.Type.Stacked;
        }
        this.areaType = type;
        this.showLegend = ChartJsonUtilsKt.optBoolean(json, "showLegend");
    }

    @Override
    @NotNull
    public JsonObject toJson() {
        JsonObject jsonObject;
        JsonObject $this$toJson_u24lambda_u240 = jsonObject = new JsonObject();
        boolean bl = false;
        $this$toJson_u24lambda_u240.addProperty("type", this.getType().getId());
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "keys", this.keys);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "groups", this.groups);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "values", this.values);
        $this$toJson_u24lambda_u240.addProperty("areaType", this.areaType.name());
        ChartJsonUtilsKt.optSetProperty($this$toJson_u24lambda_u240, "showLegend", this.showLegend);
        return jsonObject;
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty() && this.groups.isEmpty() && this.values.isEmpty();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof AreaSeriesSettings && Intrinsics.areEqual(((AreaSeriesSettings)other).keys, this.keys) && Intrinsics.areEqual(((AreaSeriesSettings)other).groups, this.groups) && Intrinsics.areEqual(((AreaSeriesSettings)other).values, this.values) && ((AreaSeriesSettings)other).areaType == this.areaType && ((AreaSeriesSettings)other).showLegend == this.showLegend;
    }

    @Override
    @NotNull
    public AreaSeriesSettings filterByNewDataFrame(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        return new AreaSeriesSettings(SeriesSettings.Companion.filterByDataFrame(this.keys, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.groups, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.values, dataFrame), this.areaType, this.showLegend);
    }

    @Override
    @NotNull
    public List<Feature> getLetsPlotLayer(@NotNull DataFrame dataFrame, int chartIndex) {
        int i;
        int n;
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        if (this.keys.isEmpty() || this.values.isEmpty()) {
            SeriesSettings.getLogger().warn("Area settings series should have at least one X and one Y axis.");
            return CollectionsKt.emptyList();
        }
        List[] listArray = new List[]{this.keys, this.groups, this.values};
        if (!SeriesSettings.Companion.dataFrameHasAllColumns(dataFrame, listArray)) {
            return CollectionsKt.emptyList();
        }
        GroupingResult groupingResult = GroupingUtils.INSTANCE.get(dataFrame, this.keys, this.groups, this.values);
        if (groupingResult == null) {
            return CollectionsKt.emptyList();
        }
        GroupingResult res = groupingResult;
        ArrayList<Double> previousColumnData = new ArrayList<Double>(res.getXColumn().getSize());
        int n2 = res.getXColumn().getSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            previousColumnData.add(0.0);
        }
        DoubleColumn previousColumn = null;
        previousColumn = new DoubleColumn("", (List<Double>)previousColumnData);
        ArrayList<Double> sums = new ArrayList<Double>(res.getXColumn().getSize());
        if (this.areaType == AreaSeries.Type.Expanded) {
            n = res.getXColumn().getSize();
            for (i = 0; i < n; ++i) {
                double sum2 = 0.0;
                Iterable $this$forEach$iv = res.getYColumns();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Column it = (Column)element$iv;
                    boolean bl = false;
                    sum2 += Math.abs(ColumnKt.getDoubleOrZero(it, i));
                }
                sums.add(sum2);
            }
        }
        if (this.areaType == AreaSeries.Type.Stream) {
            n = res.getXColumn().getSize();
            for (i = 0; i < n; ++i) {
                double sum3 = 0.0;
                int count2 = 0;
                Iterable $this$forEach$iv = res.getYColumns();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Column it = (Column)element$iv;
                    boolean bl = false;
                    if (!it.isNotNull(i)) continue;
                    sum3 += Math.abs(ColumnKt.getDoubleOrZero(it, i));
                    ++count2;
                }
                previousColumnData.set(i, count2 == 1 ? sum3 / (double)2 : (count2 > 0 ? sum3 / (double)count2 : 0.0));
            }
        }
        List result2 = new ArrayList();
        Iterable $this$forEach$iv = res.getYColumns();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Column it = (Column)element$iv;
            boolean bl = false;
            ArrayList<Double> data = new ArrayList<Double>(previousColumn.getSize());
            if (WhenMappings.$EnumSwitchMapping$0[this.areaType.ordinal()] == 1) {
                var16_31 = previousColumn.getSize();
                for (i = 0; i < var16_31; ++i) {
                    double d = ColumnKt.getDoubleOrZero(previousColumn, i);
                    double d2 = ColumnKt.getDoubleOrZero(it, i) * (double)100;
                    Object e = sums.get(i);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                    data.add(d + d2 / ((Number)e).doubleValue());
                }
            } else {
                var16_31 = previousColumn.getSize();
                for (i = 0; i < var16_31; ++i) {
                    data.add(ColumnKt.getDoubleOrZero(previousColumn, i) + ColumnKt.getDoubleOrZero(it, i));
                }
            }
            DoubleColumn currentColumn = new DoubleColumn(it.getName(), (List<Double>)data);
            Pair[] i3 = new Pair[]{TuplesKt.to((Object)res.getXColumn().getName(), res.getXColumn().toList()), TuplesKt.to((Object)currentColumn.getName(), currentColumn.toList())};
            Map chartData = MapsKt.mutableMapOf((Pair[])i3);
            Color color = ChartStyle.Companion.getInstance().getColor(chartIndex + result2.size());
            Collection collection = result2;
            SamplingOptions samplingOptions = SeriesSettings.Companion.getSampling(res);
            layerTooltips layerTooltips2 = new layerTooltips(new String[0]).line(res.getXColumn().getName() + "|@{" + res.getXColumn().getName() + "}").line(currentColumn.getName() + "|@{" + currentColumn.getName() + "}");
            collection.add(new geomArea(chartData, null, null, false, samplingOptions, layerTooltips2, null, null, null, 0.3, color, color, null, null, null, null, (Function1)new Function1<AreaMapping, Unit>(res, currentColumn){
                final /* synthetic */ GroupingResult $res;
                final /* synthetic */ DoubleColumn $currentColumn;
                {
                    this.$res = $res;
                    this.$currentColumn = $currentColumn;
                    super(1);
                }

                public final void invoke(@NotNull AreaMapping $this$$receiver) {
                    Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                    $this$$receiver.setX(this.$res.getXColumn().getName());
                    $this$$receiver.setY(this.$currentColumn.getName());
                }
            }, 61894, null));
            previousColumn = currentColumn;
        }
        return CollectionsKt.plus((Collection)result2, (Object)LabsKt.ylab(SeriesSettings.Companion.getPresentableAxisText$default(SeriesSettings.Companion, this.values, null, 2, null)));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AreaSeries.Type.values().length];
            try {
                nArray[AreaSeries.Type.Expanded.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

