/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bigdatatools.visualization.charts.settings.data;

import com.google.gson.JsonObject;
import com.intellij.bigdatatools.visualization.charts.core.style.ChartStyle;
import com.intellij.bigdatatools.visualization.charts.core.utils.GroupingResult;
import com.intellij.bigdatatools.visualization.charts.core.utils.GroupingUtils;
import com.intellij.bigdatatools.visualization.charts.settings.data.ColumnSettings;
import com.intellij.bigdatatools.visualization.charts.settings.data.SeriesSettings;
import com.intellij.bigdatatools.visualization.charts.settings.data.type.AreaRangeSeriesType;
import com.intellij.bigdatatools.visualization.charts.utils.ChartJsonUtilsKt;
import com.intellij.bigdatatools.visualization.dataframe.DataFrame;
import com.intellij.bigdatatools.visualization.dataframe.columns.Column;
import com.intellij.util.containers.UtilKt;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.geom.geomRibbon;
import org.jetbrains.letsPlot.intern.Feature;
import org.jetbrains.letsPlot.intern.layer.SamplingOptions;
import org.jetbrains.letsPlot.intern.layer.geom.RibbonMapping;
import org.jetbrains.letsPlot.label.LabsKt;
import org.jetbrains.letsPlot.tooltips.layerTooltips;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001BI\b\u0016\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\u0010\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!H\u0016J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00032\u0006\u0010 \u001a\u00020!2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\tH\u0016J\b\u0010'\u001a\u00020\fH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001a\u00a8\u0006("}, d2={"Lcom/intellij/bigdatatools/visualization/charts/settings/data/AreaRangeSeriesSettings;", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/SeriesSettings;", "keys", "", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnSettings;", "groups", "yLow", "yHigh", "showLegend", "", "(Ljava/util/List;Ljava/util/List;Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnSettings;Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnSettings;Z)V", "json", "Lcom/google/gson/JsonObject;", "(Lcom/google/gson/JsonObject;)V", "getGroups", "()Ljava/util/List;", "getKeys", "getShowLegend", "()Z", "setShowLegend", "(Z)V", "type", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/type/AreaRangeSeriesType;", "getType", "()Lcom/intellij/bigdatatools/visualization/charts/settings/data/type/AreaRangeSeriesType;", "getYHigh", "()Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnSettings;", "getYLow", "equals", "other", "", "filterByNewDataFrame", "dataFrame", "Lcom/intellij/bigdatatools/visualization/dataframe/DataFrame;", "getLetsPlotLayer", "Lorg/jetbrains/letsPlot/intern/Feature;", "chartIndex", "", "isEmpty", "toJson", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nAreaRangeSeriesSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AreaRangeSeriesSettings.kt\ncom/intellij/bigdatatools/visualization/charts/settings/data/AreaRangeSeriesSettings\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1#2:128\n*E\n"})
public final class AreaRangeSeriesSettings
extends SeriesSettings {
    @NotNull
    private final AreaRangeSeriesType type;
    @NotNull
    private final List<ColumnSettings> keys;
    @NotNull
    private final List<ColumnSettings> groups;
    @Nullable
    private final ColumnSettings yLow;
    @Nullable
    private final ColumnSettings yHigh;
    private boolean showLegend;

    @Override
    @NotNull
    public AreaRangeSeriesType getType() {
        return this.type;
    }

    @NotNull
    public final List<ColumnSettings> getKeys() {
        return this.keys;
    }

    @NotNull
    public final List<ColumnSettings> getGroups() {
        return this.groups;
    }

    @Nullable
    public final ColumnSettings getYLow() {
        return this.yLow;
    }

    @Nullable
    public final ColumnSettings getYHigh() {
        return this.yHigh;
    }

    public final boolean getShowLegend() {
        return this.showLegend;
    }

    public final void setShowLegend(boolean bl) {
        this.showLegend = bl;
    }

    public AreaRangeSeriesSettings(@NotNull List<ColumnSettings> keys, @NotNull List<ColumnSettings> groups2, @Nullable ColumnSettings yLow, @Nullable ColumnSettings yHigh, boolean showLegend) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter(groups2, (String)"groups");
        this.type = AreaRangeSeriesType.Companion.getInstance();
        this.keys = keys;
        this.groups = groups2;
        this.yLow = yLow;
        this.yHigh = yHigh;
        this.showLegend = showLegend;
    }

    public /* synthetic */ AreaRangeSeriesSettings(List list2, List list3, ColumnSettings columnSettings, ColumnSettings columnSettings2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            columnSettings = null;
        }
        if ((n & 8) != 0) {
            columnSettings2 = null;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(list2, list3, columnSettings, columnSettings2, bl);
    }

    public AreaRangeSeriesSettings(@NotNull JsonObject json) {
        ColumnSettings columnSettings;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.type = AreaRangeSeriesType.Companion.getInstance();
        this.keys = ChartJsonUtilsKt.optColumnSettingsList(json, "keys");
        this.groups = ChartJsonUtilsKt.optColumnSettingsList(json, "groups");
        List<ColumnSettings> values2 = ChartJsonUtilsKt.optColumnSettingsList(json, "values");
        ColumnSettings columnSettings2 = ChartJsonUtilsKt.optColumnSettings(json, "yLow");
        if (columnSettings2 == null) {
            columnSettings2 = this.yLow = (ColumnSettings)CollectionsKt.getOrNull(values2, (int)0);
        }
        if ((columnSettings = ChartJsonUtilsKt.optColumnSettings(json, "yHigh")) == null) {
            columnSettings = (ColumnSettings)CollectionsKt.getOrNull(values2, (int)1);
        }
        this.yHigh = columnSettings;
        this.showLegend = ChartJsonUtilsKt.optBoolean(json, "showLegend");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsonObject toJson() {
        void $this$toJson_u24lambda_u241_u24lambda_u240;
        List list2;
        JsonObject jsonObject;
        JsonObject $this$toJson_u24lambda_u241 = jsonObject = new JsonObject();
        boolean bl = false;
        $this$toJson_u24lambda_u241.addProperty("type", this.getType().getId());
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u241, "keys", this.keys);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u241, "groups", this.groups);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u241, "yLow", this.yLow);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u241, "yHigh", this.yHigh);
        List list3 = list2 = (List)new ArrayList();
        String string = "values";
        JsonObject jsonObject2 = $this$toJson_u24lambda_u241;
        boolean bl2 = false;
        UtilKt.addIfNotNull((List)$this$toJson_u24lambda_u241_u24lambda_u240, (Object)this.yLow);
        UtilKt.addIfNotNull((List)$this$toJson_u24lambda_u241_u24lambda_u240, (Object)this.yHigh);
        Unit unit = Unit.INSTANCE;
        ChartJsonUtilsKt.optSet(jsonObject2, string, list2);
        ChartJsonUtilsKt.optSetProperty($this$toJson_u24lambda_u241, "showLegend", this.showLegend);
        return jsonObject;
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty() && this.groups.isEmpty() && this.yLow == null && this.yHigh == null;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof AreaRangeSeriesSettings && Intrinsics.areEqual(((AreaRangeSeriesSettings)other).keys, this.keys) && Intrinsics.areEqual(((AreaRangeSeriesSettings)other).groups, this.groups) && Intrinsics.areEqual((Object)((AreaRangeSeriesSettings)other).yLow, (Object)this.yLow) && Intrinsics.areEqual((Object)((AreaRangeSeriesSettings)other).yHigh, (Object)this.yHigh) && ((AreaRangeSeriesSettings)other).showLegend == this.showLegend;
    }

    @Override
    @NotNull
    public AreaRangeSeriesSettings filterByNewDataFrame(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        return new AreaRangeSeriesSettings(SeriesSettings.Companion.filterByDataFrame(this.keys, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.groups, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.yLow, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.yHigh, dataFrame), this.showLegend);
    }

    @Override
    @NotNull
    public List<Feature> getLetsPlotLayer(@NotNull DataFrame dataFrame, int chartIndex) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        if (this.keys.isEmpty() || this.yLow == null || this.yHigh == null) {
            SeriesSettings.getLogger().warn("AreaRange series should have at least one X and one Y axis.");
            return CollectionsKt.emptyList();
        }
        Object[] objectArray = new List[]{this.keys, this.groups};
        if (!SeriesSettings.Companion.dataFrameHasAllColumns(dataFrame, (List<ColumnSettings>[])objectArray) || !SeriesSettings.Companion.dataFrameHasAllColumns(dataFrame, (ColumnSettings[])(objectArray = new ColumnSettings[]{this.yLow, this.yHigh}))) {
            return CollectionsKt.emptyList();
        }
        Object[] objectArray2 = new ColumnSettings[]{this.yLow, this.yHigh};
        GroupingResult groupingResult = GroupingUtils.INSTANCE.get(dataFrame, this.keys, this.groups, CollectionsKt.listOf((Object[])objectArray2));
        if (groupingResult == null) {
            return CollectionsKt.emptyList();
        }
        GroupingResult res = groupingResult;
        List result2 = new ArrayList();
        int i = 0;
        int n = res.getYColumns().size() + -1;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)2);
        if (i <= n2) {
            while (i + 1 < res.getYColumns().size()) {
                if (res.getYColumns().get(i).isNumerical() && res.getYColumns().get(i + 1).isNumerical()) {
                    Column<? extends Object> yLowColumn = res.getYColumns().get(i);
                    Column<? extends Object> yHighColumn = res.getYColumns().get(i + 1);
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)res.getXColumn().getName(), res.getXColumn().toList()), TuplesKt.to((Object)yLowColumn.getName(), yLowColumn.toList()), TuplesKt.to((Object)yHighColumn.getName(), yHighColumn.toList())};
                    Map data = MapsKt.mutableMapOf((Pair[])pairArray);
                    Color color = ChartStyle.Companion.getInstance().getColor(chartIndex + result2.size());
                    layerTooltips tooltips = new layerTooltips(new String[0]).line(res.getXColumn().getName() + "|@{" + res.getXColumn().getName() + "}").line(yLowColumn.getName() + "|@{" + yLowColumn.getName() + "}").line(yHighColumn.getName() + "|@{" + yHighColumn.getName() + "}");
                    Collection collection = result2;
                    SamplingOptions samplingOptions = SeriesSettings.Companion.getSampling(res);
                    collection.add(new geomRibbon(data, null, null, false, samplingOptions, tooltips, null, null, null, null, null, null, null, null, color, color, 0.3, null, null, (Function1)new Function1<RibbonMapping, Unit>(res, yLowColumn, yHighColumn){
                        final /* synthetic */ GroupingResult $res;
                        final /* synthetic */ Column<? extends Object> $yLowColumn;
                        final /* synthetic */ Column<? extends Object> $yHighColumn;
                        {
                            this.$res = $res;
                            this.$yLowColumn = $yLowColumn;
                            this.$yHighColumn = $yHighColumn;
                            super(1);
                        }

                        public final void invoke(@NotNull RibbonMapping $this$$receiver) {
                            Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                            $this$$receiver.setX(this.$res.getXColumn().getName());
                            $this$$receiver.setYmin(this.$yLowColumn.getName());
                            $this$$receiver.setYmax(this.$yHighColumn.getName());
                        }
                    }, 409542, null));
                }
                if (i == n2) break;
                i += 2;
            }
        }
        Object[] objectArray3 = new ColumnSettings[]{this.yLow, this.yHigh};
        return CollectionsKt.plus((Collection)result2, (Object)LabsKt.ylab(SeriesSettings.Companion.getPresentableAxisText(CollectionsKt.listOf((Object[])objectArray3), " - ")));
    }
}

