/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bigdatatools.visualization.charts.core.style;

import com.intellij.bigdatatools.visualization.charts.style.ChartConfig;
import com.intellij.bigdatatools.visualization.charts.style.ChartsConfig;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\bC\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 h2\u00020\u0001:\u0001hB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010_\u001a\u00020\u00102\u0006\u0010`\u001a\u00020\u0004J\u0010\u0010a\u001a\u00020\u00162\u0006\u0010b\u001a\u00020ZH\u0002J\u000e\u0010c\u001a\u00020d2\u0006\u0010e\u001a\u00020fJ\u0006\u0010g\u001a\u00020dR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0012\"\u0004\b\u001d\u0010\u0014R\u001a\u0010\u001e\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0006\"\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0006R\u001a\u0010$\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0006\"\u0004\b&\u0010!R\u001a\u0010'\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0018\"\u0004\b)\u0010\u001aR\u001a\u0010*\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0012\"\u0004\b,\u0010\u0014R\u001a\u0010-\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0018\"\u0004\b/\u0010\u001aR\u001a\u00100\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u0012\"\u0004\b2\u0010\u0014R\u001a\u00103\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u0018\"\u0004\b5\u0010\u001aR\u001a\u00106\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u0012\"\u0004\b8\u0010\u0014R\u001a\u00109\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u0018\"\u0004\b;\u0010\u001aR\u001a\u0010<\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\u0012\"\u0004\b>\u0010\u0014R\u001a\u0010?\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010\u0012\"\u0004\bA\u0010\u0014R\u001a\u0010B\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010\u0018\"\u0004\bD\u0010\u001aR\u001a\u0010E\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010\u0012\"\u0004\bG\u0010\u0014R\u0011\u0010H\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010\u0006R\u0011\u0010J\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010\u0006R\u0011\u0010L\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010\u0006R\u0011\u0010N\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010\u0006R\u001a\u0010P\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010\u0018\"\u0004\bR\u0010\u001aR\u0011\u0010S\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bT\u0010\u0006R\u0011\u0010U\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010\u0006R\u0011\u0010W\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010\u0006R\u0014\u0010Y\u001a\u00020ZX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010\\R\u0014\u0010]\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u0010\u0006\u00a8\u0006i"}, d2={"Lcom/intellij/bigdatatools/visualization/charts/core/style/ChartStyle;", "", "()V", "areaRangeInnerCircleHalfSize", "", "getAreaRangeInnerCircleHalfSize", "()I", "areaRangeInnerCircleSize", "getAreaRangeInnerCircleSize", "areaRangeOuterCircleHalfSize", "getAreaRangeOuterCircleHalfSize", "areaRangeOuterCircleSize", "getAreaRangeOuterCircleSize", "axisCategoriesTickSize", "getAxisCategoriesTickSize", "axisColor", "Ljava/awt/Color;", "getAxisColor", "()Ljava/awt/Color;", "setAxisColor", "(Ljava/awt/Color;)V", "axisFont", "Ljava/awt/Font;", "getAxisFont", "()Ljava/awt/Font;", "setAxisFont", "(Ljava/awt/Font;)V", "axisFontColor", "getAxisFontColor", "setAxisFontColor", "axisTextOffset", "getAxisTextOffset", "setAxisTextOffset", "(I)V", "axisTickCount", "getAxisTickCount", "axisTickSize", "getAxisTickSize", "setAxisTickSize", "axisTitleFont", "getAxisTitleFont", "setAxisTitleFont", "axisTitleFontColor", "getAxisTitleFontColor", "setAxisTitleFontColor", "axisTitleFontVertical", "getAxisTitleFontVertical", "setAxisTitleFontVertical", "background", "getBackground", "setBackground", "chartTitleFont", "getChartTitleFont", "setChartTitleFont", "chartTitleFontColor", "getChartTitleFontColor", "setChartTitleFontColor", "chartTitleFontVertical", "getChartTitleFontVertical", "setChartTitleFontVertical", "gridColor", "getGridColor", "setGridColor", "labelColor", "getLabelColor", "setLabelColor", "labelFont", "getLabelFont", "setLabelFont", "labelFontColor", "getLabelFontColor", "setLabelFontColor", "labelOffset", "getLabelOffset", "labelTextOffset", "getLabelTextOffset", "labelTriangleHeight", "getLabelTriangleHeight", "labelTriangleWidth", "getLabelTriangleWidth", "legendFont", "getLegendFont", "setLegendFont", "legendHSpacing", "getLegendHSpacing", "legendMarkSize", "getLegendMarkSize", "legendVSpacing", "getLegendVSpacing", "lineSeriesThickness", "", "getLineSeriesThickness", "()F", "scatterPointSize", "getScatterPointSize", "getColor", "index", "getPlatformFont", "size", "loadFromSettings", "", "settings", "Lcom/intellij/bigdatatools/visualization/charts/style/ChartConfig;", "reload", "Companion", "intellij.charts"})
public final class ChartStyle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public Color background;
    public Color axisColor;
    public Font axisFont;
    public Color axisFontColor;
    private final int axisCategoriesTickSize = JBUIScale.scale((int)10);
    private int axisTickSize = JBUIScale.scale((int)5);
    private final int axisTickCount;
    private int axisTextOffset = JBUIScale.scale((int)10);
    public Color gridColor;
    public Font legendFont;
    private final int legendHSpacing = JBUIScale.scale((int)10);
    private final int legendVSpacing = JBUIScale.scale((int)10);
    private final int legendMarkSize = JBUIScale.scale((int)16);
    public Color labelColor;
    public Font labelFont;
    public Color labelFontColor;
    private final int labelTriangleHeight = JBUIScale.scale((int)20);
    private final int labelTriangleWidth = JBUIScale.scale((int)17);
    private final int labelOffset = JBUIScale.scale((int)15);
    private final int labelTextOffset = JBUIScale.scale((int)10);
    public Color axisTitleFontColor;
    public Font axisTitleFont;
    public Font axisTitleFontVertical;
    public Color chartTitleFontColor;
    public Font chartTitleFont;
    public Font chartTitleFontVertical;
    private final int scatterPointSize;
    private final float lineSeriesThickness;
    private final int areaRangeOuterCircleSize = JBUIScale.scale((int)16);
    private final int areaRangeOuterCircleHalfSize = this.areaRangeOuterCircleSize / 2;
    private final int areaRangeInnerCircleSize = JBUIScale.scale((int)12);
    private final int areaRangeInnerCircleHalfSize = this.areaRangeInnerCircleSize / 2;
    @NotNull
    private static final ChartStyle instance = new ChartStyle();

    public ChartStyle() {
        this.axisTickCount = 10;
        this.scatterPointSize = 8;
        this.lineSeriesThickness = 2.0f;
        this.reload();
    }

    @NotNull
    public final Color getBackground() {
        Color color = this.background;
        if (color != null) {
            return color;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"background");
        return null;
    }

    public final void setBackground(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.background = color;
    }

    @NotNull
    public final Color getAxisColor() {
        Color color = this.axisColor;
        if (color != null) {
            return color;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"axisColor");
        return null;
    }

    public final void setAxisColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.axisColor = color;
    }

    @NotNull
    public final Font getAxisFont() {
        Font font = this.axisFont;
        if (font != null) {
            return font;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"axisFont");
        return null;
    }

    public final void setAxisFont(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"<set-?>");
        this.axisFont = font;
    }

    @NotNull
    public final Color getAxisFontColor() {
        Color color = this.axisFontColor;
        if (color != null) {
            return color;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"axisFontColor");
        return null;
    }

    public final void setAxisFontColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.axisFontColor = color;
    }

    public final int getAxisCategoriesTickSize() {
        return this.axisCategoriesTickSize;
    }

    public final int getAxisTickSize() {
        return this.axisTickSize;
    }

    public final void setAxisTickSize(int n) {
        this.axisTickSize = n;
    }

    public final int getAxisTickCount() {
        return this.axisTickCount;
    }

    public final int getAxisTextOffset() {
        return this.axisTextOffset;
    }

    public final void setAxisTextOffset(int n) {
        this.axisTextOffset = n;
    }

    @NotNull
    public final Color getGridColor() {
        Color color = this.gridColor;
        if (color != null) {
            return color;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"gridColor");
        return null;
    }

    public final void setGridColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.gridColor = color;
    }

    @NotNull
    public final Font getLegendFont() {
        Font font = this.legendFont;
        if (font != null) {
            return font;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"legendFont");
        return null;
    }

    public final void setLegendFont(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"<set-?>");
        this.legendFont = font;
    }

    public final int getLegendHSpacing() {
        return this.legendHSpacing;
    }

    public final int getLegendVSpacing() {
        return this.legendVSpacing;
    }

    public final int getLegendMarkSize() {
        return this.legendMarkSize;
    }

    @NotNull
    public final Color getLabelColor() {
        Color color = this.labelColor;
        if (color != null) {
            return color;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"labelColor");
        return null;
    }

    public final void setLabelColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.labelColor = color;
    }

    @NotNull
    public final Font getLabelFont() {
        Font font = this.labelFont;
        if (font != null) {
            return font;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"labelFont");
        return null;
    }

    public final void setLabelFont(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"<set-?>");
        this.labelFont = font;
    }

    @NotNull
    public final Color getLabelFontColor() {
        Color color = this.labelFontColor;
        if (color != null) {
            return color;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"labelFontColor");
        return null;
    }

    public final void setLabelFontColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.labelFontColor = color;
    }

    public final int getLabelTriangleHeight() {
        return this.labelTriangleHeight;
    }

    public final int getLabelTriangleWidth() {
        return this.labelTriangleWidth;
    }

    public final int getLabelOffset() {
        return this.labelOffset;
    }

    public final int getLabelTextOffset() {
        return this.labelTextOffset;
    }

    @NotNull
    public final Color getAxisTitleFontColor() {
        Color color = this.axisTitleFontColor;
        if (color != null) {
            return color;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"axisTitleFontColor");
        return null;
    }

    public final void setAxisTitleFontColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.axisTitleFontColor = color;
    }

    @NotNull
    public final Font getAxisTitleFont() {
        Font font = this.axisTitleFont;
        if (font != null) {
            return font;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"axisTitleFont");
        return null;
    }

    public final void setAxisTitleFont(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"<set-?>");
        this.axisTitleFont = font;
    }

    @NotNull
    public final Font getAxisTitleFontVertical() {
        Font font = this.axisTitleFontVertical;
        if (font != null) {
            return font;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"axisTitleFontVertical");
        return null;
    }

    public final void setAxisTitleFontVertical(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"<set-?>");
        this.axisTitleFontVertical = font;
    }

    @NotNull
    public final Color getChartTitleFontColor() {
        Color color = this.chartTitleFontColor;
        if (color != null) {
            return color;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"chartTitleFontColor");
        return null;
    }

    public final void setChartTitleFontColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.chartTitleFontColor = color;
    }

    @NotNull
    public final Font getChartTitleFont() {
        Font font = this.chartTitleFont;
        if (font != null) {
            return font;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"chartTitleFont");
        return null;
    }

    public final void setChartTitleFont(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"<set-?>");
        this.chartTitleFont = font;
    }

    @NotNull
    public final Font getChartTitleFontVertical() {
        Font font = this.chartTitleFontVertical;
        if (font != null) {
            return font;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"chartTitleFontVertical");
        return null;
    }

    public final void setChartTitleFontVertical(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"<set-?>");
        this.chartTitleFontVertical = font;
    }

    public final int getScatterPointSize() {
        return this.scatterPointSize;
    }

    public final float getLineSeriesThickness() {
        return this.lineSeriesThickness;
    }

    public final int getAreaRangeOuterCircleSize() {
        return this.areaRangeOuterCircleSize;
    }

    public final int getAreaRangeOuterCircleHalfSize() {
        return this.areaRangeOuterCircleHalfSize;
    }

    public final int getAreaRangeInnerCircleSize() {
        return this.areaRangeInnerCircleSize;
    }

    public final int getAreaRangeInnerCircleHalfSize() {
        return this.areaRangeInnerCircleHalfSize;
    }

    public final void reload() {
        if (!ApplicationManager.getApplication().isDisposed()) {
            this.loadFromSettings(ChartsConfig.Companion.getInstance().getSettings());
        }
    }

    @NotNull
    public final Color getColor(int index) {
        return ChartsConfig.Companion.getInstance().getSettings().getPaletteColor(index);
    }

    public final void loadFromSettings(@NotNull ChartConfig settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.setBackground(settings.getBackgroundColor().getColor());
        this.setAxisColor(settings.getAxesColor().getColor());
        this.setAxisFont(this.getPlatformFont(settings.getAxesFont().getSize()));
        this.setAxisFontColor(settings.getAxesFont().getColor().getColor());
        this.axisTickSize = settings.getAxesTickLength();
        this.axisTextOffset = settings.getAxesTextOffset();
        this.setGridColor(settings.getGridColor().getColor());
        this.setLegendFont(this.getPlatformFont(settings.getLegendFont().getSize()));
        this.setLabelColor(settings.getHintBackColor().getColor());
        this.setLabelFont(this.getPlatformFont(settings.getHintFont().getSize()));
        this.setLabelFontColor(settings.getHintFont().getColor().getColor());
        this.setAxisTitleFontColor(settings.getAxesFont().getColor().getColor());
        this.setAxisTitleFont(this.getPlatformFont(settings.getAxesFont().getSize()));
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(Math.toRadians(-90.0), 0.0, 0.0);
        Font font = this.getAxisTitleFont().deriveFont(affineTransform);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"deriveFont(...)");
        this.setAxisTitleFontVertical(font);
        this.setChartTitleFontColor(settings.getChartTitleFont().getColor().getColor());
        this.setChartTitleFont(this.getPlatformFont(settings.getChartTitleFont().getSize()));
        Font font2 = this.getChartTitleFont().deriveFont(affineTransform);
        Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"deriveFont(...)");
        this.setChartTitleFontVertical(font2);
    }

    private final Font getPlatformFont(float size2) {
        Font font;
        if (SystemInfo.isMac) {
            font = new Font("Helvetica", 0, (int)JBUIScale.scale((float)size2));
        } else {
            JBFont jBFont = JBUI.Fonts.label((float)size2);
            Intrinsics.checkNotNullExpressionValue((Object)jBFont, (String)"label(...)");
            font = (Font)jBFont;
        }
        return font;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/bigdatatools/visualization/charts/core/style/ChartStyle$Companion;", "", "()V", "instance", "Lcom/intellij/bigdatatools/visualization/charts/core/style/ChartStyle;", "getInstance", "()Lcom/intellij/bigdatatools/visualization/charts/core/style/ChartStyle;", "intellij.charts"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ChartStyle getInstance() {
            return instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

