/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bigdatatools.visualization.charts.core;

import com.intellij.bigdatatools.visualization.charts.analyser.SeriesSuggester;
import com.intellij.bigdatatools.visualization.charts.core.ChartPage;
import com.intellij.bigdatatools.visualization.charts.core.ChartPageKt;
import com.intellij.bigdatatools.visualization.charts.core.ChartPlotPanel;
import com.intellij.bigdatatools.visualization.charts.core.axes.settings.AxesSettings;
import com.intellij.bigdatatools.visualization.charts.core.settings.ChartSettings;
import com.intellij.bigdatatools.visualization.charts.core.style.ChartStyle;
import com.intellij.bigdatatools.visualization.charts.settings.SeriesSettingsPanel;
import com.intellij.bigdatatools.visualization.charts.settings.data.SeriesSettings;
import com.intellij.bigdatatools.visualization.charts.statistics.ChartsUsagesCollector;
import com.intellij.bigdatatools.visualization.charts.utils.ChartMessagesBundle;
import com.intellij.bigdatatools.visualization.dataframe.DataFrame;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.BeanProperty;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.GgplotKt;
import org.jetbrains.letsPlot.batik.plot.component.DefaultPlotComponentProviderBatik;
import org.jetbrains.letsPlot.core.util.MonolithicCommon;
import org.jetbrains.letsPlot.intern.Feature;
import org.jetbrains.letsPlot.intern.Plot;
import org.jetbrains.letsPlot.intern.ToSpecConvertersKt;
import org.jetbrains.letsPlot.intern.layer.geom.PieAesthetics;
import org.jetbrains.letsPlot.themes.ThemeKt;
import org.jetbrains.letsPlot.themes.ThemeSetKt;
import org.jetbrains.letsPlot.themes.theme;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 G2\u00020\u0001:\u0002FGB\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0019J\u0010\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020'H\u0007J\u0018\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020\u00032\b\b\u0002\u0010*\u001a\u00020\u0014J\u000e\u0010+\u001a\u00020#2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0016J\b\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u000202H\u0002J\u001a\u00103\u001a\u00020\u001b2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020605J\b\u00107\u001a\u000208H\u0014J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020:0-2\u0006\u0010)\u001a\u00020\u0003H\u0002J\b\u0010;\u001a\u00020#H\u0016J\b\u0010<\u001a\u00020#H\u0002J\u0006\u0010=\u001a\u00020\u0003J\u000e\u0010>\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0019J\u000e\u0010?\u001a\u00020#2\u0006\u0010@\u001a\u00020AJ\u001f\u0010B\u001a\u00020#2\u0006\u0010C\u001a\u00020\u00142\n\b\u0002\u0010D\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010ER\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u001bX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0015\u00a8\u0006H"}, d2={"Lcom/intellij/bigdatatools/visualization/charts/core/ChartPage;", "Lcom/intellij/openapi/Disposable;", "chartSettings", "Lcom/intellij/bigdatatools/visualization/charts/core/settings/ChartSettings;", "mode", "Lcom/intellij/bigdatatools/visualization/charts/settings/SeriesSettingsPanel$Mode;", "(Lcom/intellij/bigdatatools/visualization/charts/core/settings/ChartSettings;Lcom/intellij/bigdatatools/visualization/charts/settings/SeriesSettingsPanel$Mode;)V", "chartSplitter", "Lcom/intellij/ui/OnePixelSplitter;", "component", "Ljavax/swing/JPanel;", "getComponent", "()Ljavax/swing/JPanel;", "dataFrame", "Lcom/intellij/bigdatatools/visualization/dataframe/DataFrame;", "getDataFrame", "()Lcom/intellij/bigdatatools/visualization/dataframe/DataFrame;", "setDataFrame", "(Lcom/intellij/bigdatatools/visualization/dataframe/DataFrame;)V", "isEmpty", "", "()Z", "isPlotInitialized", "listeners", "", "Ljavax/swing/event/ChangeListener;", "plot", "Lcom/intellij/bigdatatools/visualization/charts/core/ChartPlotPanel;", "getPlot", "()Lcom/intellij/bigdatatools/visualization/charts/core/ChartPlotPanel;", "setPlot", "(Lcom/intellij/bigdatatools/visualization/charts/core/ChartPlotPanel;)V", "settingsShown", "getSettingsShown", "addChangeListener", "", "listener", "addToolbar", "alignment", "", "applySettings", "settings", "checkModified", "assignDataFrame", "createActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "createEmptyPage", "Lcom/intellij/ui/components/JBPanelWithEmptyText;", "createLetsPlotTheme", "Lorg/jetbrains/letsPlot/themes/theme;", "createPlot", "processedSpec", "", "", "createSeriesSettingsPanel", "Lcom/intellij/bigdatatools/visualization/charts/settings/SeriesSettingsPanel;", "createSettings", "Lorg/jetbrains/letsPlot/intern/Feature;", "dispose", "fireChangeEvent", "getSettings", "removeChangeListener", "saveAsImage", "project", "Lcom/intellij/openapi/project/Project;", "showSeriesSettings", "recreate", "verticalSplit", "(ZLjava/lang/Boolean;)V", "ChartPlotComponentProviderBatik", "Companion", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nChartPage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChartPage.kt\ncom/intellij/bigdatatools/visualization/charts/core/ChartPage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,342:1\n1855#2,2:343\n1855#2,2:345\n1855#2,2:347\n1549#2:350\n1620#2,3:351\n1#3:349\n*S KotlinDebug\n*F\n+ 1 ChartPage.kt\ncom/intellij/bigdatatools/visualization/charts/core/ChartPage\n*L\n112#1:343,2\n224#1:345,2\n249#1:347,2\n292#1:350\n292#1:351,3\n*E\n"})
public class ChartPage
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ChartSettings chartSettings;
    @NotNull
    private final SeriesSettingsPanel.Mode mode;
    protected DataFrame dataFrame;
    protected ChartPlotPanel plot;
    @NotNull
    private final OnePixelSplitter chartSplitter;
    @NotNull
    private final JPanel component;
    @NotNull
    private final List<ChangeListener> listeners;
    @NotNull
    private static final Function1<Function0<Unit>, Unit> IDEA_EDT_EXECUTOR = Companion.IDEA_EDT_EXECUTOR.1.INSTANCE;

    /*
     * WARNING - void declaration
     */
    public ChartPage(@NotNull ChartSettings chartSettings, @NotNull SeriesSettingsPanel.Mode mode) {
        void $this$component_u24lambda_u241;
        Intrinsics.checkNotNullParameter((Object)chartSettings, (String)"chartSettings");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.chartSettings = chartSettings;
        this.mode = mode;
        this.chartSplitter = new OnePixelSplitter(false, 0.75f);
        Serializable serializable = new BorderLayout();
        Serializable serializable2 = serializable = new JPanel((BorderLayout)serializable){

            public void updateUI() {
                super.updateUI();
                this.setBackground(EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground());
            }
        };
        ChartPage chartPage = this;
        boolean bl = false;
        $this$component_u24lambda_u241.add((Component)this.chartSplitter, "Center");
        DataManager.registerDataProvider((JComponent)((JComponent)$this$component_u24lambda_u241), arg_0 -> ChartPage.component$lambda$1$lambda$0(this, arg_0));
        chartPage.component = (JPanel)serializable;
        this.listeners = new ArrayList();
    }

    public /* synthetic */ ChartPage(ChartSettings chartSettings, SeriesSettingsPanel.Mode mode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            chartSettings = new ChartSettings(new AxesSettings(false, false, 3, null), CollectionsKt.emptyList());
        }
        this(chartSettings, mode);
    }

    @NotNull
    protected final DataFrame getDataFrame() {
        DataFrame dataFrame = this.dataFrame;
        if (dataFrame != null) {
            return dataFrame;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dataFrame");
        return null;
    }

    protected final void setDataFrame(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"<set-?>");
        this.dataFrame = dataFrame;
    }

    public final boolean isEmpty() {
        return this.chartSettings.getSeriesSettings().isEmpty() || this.chartSplitter.getFirstComponent() instanceof JBPanelWithEmptyText;
    }

    public final boolean getSettingsShown() {
        return this.chartSplitter.getSecondComponent() != null;
    }

    @NotNull
    protected final ChartPlotPanel getPlot() {
        ChartPlotPanel chartPlotPanel = this.plot;
        if (chartPlotPanel != null) {
            return chartPlotPanel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"plot");
        return null;
    }

    protected final void setPlot(@NotNull ChartPlotPanel chartPlotPanel) {
        Intrinsics.checkNotNullParameter((Object)chartPlotPanel, (String)"<set-?>");
        this.plot = chartPlotPanel;
    }

    private final boolean isPlotInitialized() {
        return this.plot != null;
    }

    @NotNull
    public final JPanel getComponent() {
        return this.component;
    }

    public final void showSeriesSettings(boolean recreate, @Nullable Boolean verticalSplit) {
        if (this.chartSplitter.getSecondComponent() != null) {
            JComponent jComponent = this.chartSplitter.getSecondComponent();
            Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.bigdatatools.visualization.charts.settings.SeriesSettingsPanel");
            SeriesSettingsPanel seriesSettingsPanel = (SeriesSettingsPanel)jComponent;
            Disposer.dispose((Disposable)seriesSettingsPanel);
            this.chartSplitter.setSecondComponent(null);
            if (!recreate) {
                return;
            }
        }
        SeriesSettingsPanel panelMain = this.createSeriesSettingsPanel();
        panelMain.setOnChange((Function0<Unit>)((Function0)new Function0<Unit>(this, panelMain){
            final /* synthetic */ ChartPage this$0;
            final /* synthetic */ SeriesSettingsPanel $panelMain;
            {
                this.this$0 = $receiver;
                this.$panelMain = $panelMain;
                super(0);
            }

            public final void invoke() {
                ChartPage.applySettings$default(this.this$0, this.$panelMain.getSettings(), false, 2, null);
                ChartPage.access$fireChangeEvent(this.this$0);
            }
        }));
        Disposer.register((Disposable)this, (Disposable)panelMain);
        if (verticalSplit != null) {
            this.chartSplitter.setOrientation(verticalSplit.booleanValue());
        }
        this.chartSplitter.setSecondComponent((JComponent)panelMain);
    }

    public static /* synthetic */ void showSeriesSettings$default(ChartPage chartPage, boolean bl, Boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: showSeriesSettings");
        }
        if ((n & 2) != 0) {
            bl2 = null;
        }
        chartPage.showSeriesSettings(bl, bl2);
    }

    private final List<Feature> createSettings(ChartSettings settings) {
        List result2 = new ArrayList();
        Iterable $this$forEach$iv = settings.getSeriesSettings();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SeriesSettings it = (SeriesSettings)element$iv;
            boolean bl = false;
            CollectionsKt.addAll((Collection)result2, (Iterable)it.getLetsPlotLayer(this.getDataFrame(), result2.size()));
        }
        return result2;
    }

    public void dispose() {
        if (this.isPlotInitialized()) {
            this.getPlot().dispose();
        }
    }

    private final theme createLetsPlotTheme() {
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme editorGlobalScheme = editorColorsScheme;
        Map map2 = ThemeKt.elementRect$default(editorGlobalScheme.getDefaultBackground(), null, null, false, 14, null);
        Map map3 = ThemeKt.elementText$default(ChartStyle.Companion.getInstance().getAxisFontColor(), null, null, null, null, null, null, null, false, 510, null);
        Map map4 = ThemeKt.elementRect$default(editorGlobalScheme.getDefaultBackground(), null, null, false, 14, null);
        Map map5 = ThemeKt.elementLine$default(ChartStyle.Companion.getInstance().getAxisColor(), null, false, 6, null);
        int n = editorGlobalScheme.getEditorFontSize();
        Map map6 = ThemeKt.elementText$default(ChartStyle.Companion.getInstance().getAxisFontColor(), null, null, n, null, null, null, null, false, 502, null);
        return new theme(null, null, null, null, null, null, null, null, null, null, null, null, map6, null, null, null, null, null, null, null, null, null, null, null, map2, map3, null, null, null, null, map5, null, null, null, null, null, null, null, null, null, null, map4, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -1124077569, 0xFFFFDFF, null).legendPositionRight();
    }

    @NotNull
    public final ChartPlotPanel createPlot(@NotNull Map<String, Object> processedSpec) {
        Intrinsics.checkNotNullParameter(processedSpec, (String)"processedSpec");
        ChartPlotComponentProviderBatik chartPlotComponentProviderBatik = new ChartPlotComponentProviderBatik(processedSpec);
        return new ChartPlotPanel(this, chartPlotComponentProviderBatik){
            final /* synthetic */ ChartPage this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void updateUI() {
                boolean updateChart = this.ui != null;
                super.updateUI();
                if (updateChart && this.this$0.dataFrame != null) {
                    this.this$0.assignDataFrame(this.this$0.getDataFrame());
                }
            }

            @NotNull
            public Dimension getPreferredSize() {
                return new Dimension(10, super.getPreferredSize().height);
            }
        };
    }

    @BeanProperty(visualUpdate=true, description="The alignment of the toolbar.", enumerationValues={"BorderLayout.EAST", "BorderLayout.WEST", "BorderLayout.NORTH", "BorderLayout.SOUTH"})
    public final void addToolbar(@NotNull String alignment) {
        ActionToolbar actionToolbar;
        Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
        boolean horizontal = Intrinsics.areEqual((Object)alignment, (Object)"North") || Intrinsics.areEqual((Object)alignment, (Object)"South");
        ActionToolbar $this$addToolbar_u24lambda_u243 = actionToolbar = ActionManager.getInstance().createActionToolbar("BDTChartToolbar", (ActionGroup)new DefaultActionGroup(this.createActions()), horizontal);
        boolean bl = false;
        $this$addToolbar_u24lambda_u243.getComponent().setOpaque(false);
        ActionToolbar actionToolbar2 = actionToolbar;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"apply(...)");
        ActionToolbar chartToolbar = actionToolbar2;
        chartToolbar.setTargetComponent((JComponent)this.component);
        this.component.add((Component)chartToolbar.getComponent(), alignment);
    }

    public final void addChangeListener(@NotNull ChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        ((Collection)this.listeners).add(listener2);
    }

    public final void removeChangeListener(@NotNull ChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        ((Collection)this.listeners).remove(listener2);
    }

    private final void fireChangeEvent() {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChangeListener it = (ChangeListener)element$iv;
            boolean bl = false;
            it.stateChanged(null);
        }
    }

    public final void saveAsImage(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (this.isPlotInitialized()) {
            Companion.saveAsImage(project, this.getPlot());
        }
    }

    @NotNull
    public List<AnAction> createActions() {
        AnAction anAction = ActionManager.getInstance().getAction("LetsPlot.Charts.Toolbar.Actions");
        Object actions = anAction instanceof ActionGroup ? (Object)anAction : null;
        Object object = actions;
        if (object == null || (object = object.getChildren(null)) == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final ChartSettings getSettings() {
        return this.chartSettings;
    }

    public final void applySettings(@NotNull ChartSettings settings, boolean checkModified) {
        Feature feature;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (checkModified && Intrinsics.areEqual((Object)settings, (Object)this.chartSettings)) {
            return;
        }
        this.chartSettings = settings;
        Plot data = null;
        data = GgplotKt.letsPlot$default(null, null, 3, null);
        boolean emptyTheme = false;
        Iterable $this$forEach$iv = this.createSettings(settings);
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Feature it = (Feature)element$iv;
            boolean bl = false;
            if (it instanceof PieAesthetics) {
                emptyTheme = true;
            }
            data = data.plus(it);
        }
        if (data.getFeatures().isEmpty()) {
            this.chartSplitter.setFirstComponent((JComponent)this.createEmptyPage());
            ChartPage.showSeriesSettings$default(this, true, null, 2, null);
            return;
        }
        Color color = EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultBackground(...)");
        Color editorBackground = color;
        if (emptyTheme) {
            Map $i$f$forEach2 = ThemeKt.elementText$default(ChartStyle.Companion.getInstance().getAxisFontColor(), null, null, null, null, null, null, null, false, 510, null);
            Map map2 = ThemeKt.elementRect$default(editorBackground, null, null, false, 14, null);
            Map map3 = ThemeKt.elementRect$default(editorBackground, null, null, false, 14, null);
            feature = ThemeSetKt.themeClassic().plus(new theme(null, null, null, null, null, "blank", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, map2, $i$f$forEach2, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, map3, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -50331681, 0xFFFFDFF, null));
        } else {
            feature = this.createLetsPlotTheme();
        }
        data = data.plus(feature);
        Map<String, Object> processedSpec = MonolithicCommon.INSTANCE.processRawSpecs(ToSpecConvertersKt.toSpec(data), false);
        this.setPlot(this.createPlot(processedSpec));
        this.chartSplitter.setFirstComponent((JComponent)this.getPlot());
    }

    public static /* synthetic */ void applySettings$default(ChartPage chartPage, ChartSettings chartSettings, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: applySettings");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        chartPage.applySettings(chartSettings, bl);
    }

    @NotNull
    protected SeriesSettingsPanel createSeriesSettingsPanel() {
        SeriesSettingsPanel seriesSettingsPanel;
        SeriesSettingsPanel $this$createSeriesSettingsPanel_u24lambda_u246 = seriesSettingsPanel = new SeriesSettingsPanel(this.getDataFrame(), this.getSettings(), this.mode);
        boolean bl = false;
        $this$createSeriesSettingsPanel_u24lambda_u246.init();
        return seriesSettingsPanel;
    }

    private final JBPanelWithEmptyText createEmptyPage() {
        JBPanelWithEmptyText jBPanelWithEmptyText;
        JBPanelWithEmptyText $this$createEmptyPage_u24lambda_u248 = jBPanelWithEmptyText = new JBPanelWithEmptyText();
        boolean bl = false;
        $this$createEmptyPage_u24lambda_u248.setOpaque(false);
        $this$createEmptyPage_u24lambda_u248.getEmptyText().appendText(ChartMessagesBundle.message("series.empty", new Object[0]), StatusText.DEFAULT_ATTRIBUTES);
        $this$createEmptyPage_u24lambda_u248.getEmptyText().appendSecondaryText(ChartMessagesBundle.message("series.open.settings", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, arg_0 -> ChartPage.createEmptyPage$lambda$8$lambda$7(this, arg_0));
        return jBPanelWithEmptyText;
    }

    /*
     * WARNING - void declaration
     */
    public final void assignDataFrame(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        this.setDataFrame(dataFrame);
        ChartSettings currentSettings = this.getSettings();
        if (!currentSettings.isSeriesSettingsEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = currentSettings.getSeriesSettings();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SeriesSettings seriesSettings = (SeriesSettings)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.filterByNewDataFrame(dataFrame));
            }
            List newSeriesSettings = (List)destination$iv$iv;
            this.applySettings(new ChartSettings(currentSettings.getAxesSettings(), newSeriesSettings), false);
        } else {
            ChartPage.applySettings$default(this, new ChartSettings(new AxesSettings(false, false, 3, null), SeriesSuggester.INSTANCE.getSingleSuggestion(dataFrame)), false, 2, null);
        }
        if (this.getSettings().isSeriesSettingsEmpty()) {
            this.chartSplitter.setFirstComponent((JComponent)this.createEmptyPage());
            ChartPage.showSeriesSettings$default(this, true, null, 2, null);
        }
    }

    private static final Object component$lambda$1$lambda$0(ChartPage this$0, String key) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return ChartPageKt.getCHART_PAGE_DATA_KEY().is(key) ? this$0 : null;
    }

    private static final void createEmptyPage$lambda$8$lambda$7(ChartPage this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ChartPage.showSeriesSettings$default(this$0, true, null, 2, null);
        ChartsUsagesCollector.INSTANCE.getSettingsOpened().log();
    }

    public static final /* synthetic */ void access$fireChangeEvent(ChartPage $this) {
        $this.fireChangeEvent();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00020\b2\u000b\u0010\t\u001a\u00070\u0004\u00a2\u0006\u0002\b\nH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/bigdatatools/visualization/charts/core/ChartPage$ChartPlotComponentProviderBatik;", "Lorg/jetbrains/letsPlot/batik/plot/component/DefaultPlotComponentProviderBatik;", "processedSpec", "", "", "", "(Ljava/util/Map;)V", "createErrorMessageComponent", "Ljavax/swing/JComponent;", "message", "Lorg/jetbrains/annotations/Nls;", "intellij.charts"})
    public static final class ChartPlotComponentProviderBatik
    extends DefaultPlotComponentProviderBatik {
        public ChartPlotComponentProviderBatik(@NotNull Map<String, Object> processedSpec) {
            Intrinsics.checkNotNullParameter(processedSpec, (String)"processedSpec");
            super(processedSpec, false, Companion.getIDEA_EDT_EXECUTOR(), (Function1<? super List<String>, Unit>)((Function1)1.INSTANCE));
        }

        @Override
        @NotNull
        protected JComponent createErrorMessageComponent(@NotNull String message) {
            DialogPanel dialogPanel;
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            DialogPanel $this$createErrorMessageComponent_u24lambda_u240 = dialogPanel = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(message){
                final /* synthetic */ String $message;
                {
                    this.$message = $message;
                    super(1);
                }

                public final void invoke(@NotNull Panel $this$panel) {
                    Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                    Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$message){
                        final /* synthetic */ String $message;
                        {
                            this.$message = $message;
                            super(1);
                        }

                        public final void invoke(@NotNull Row $this$row) {
                            String string;
                            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                            int firstNewline = StringsKt.indexOf$default((CharSequence)this.$message, (String)"\n", (int)0, (boolean)false, (int)6, null);
                            if (firstNewline != -1) {
                                String string2 = this.$message.substring(0, firstNewline);
                                string = string2;
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                            } else {
                                string = this.$message;
                            }
                            String firstMessageLine = string;
                            Object[] objectArray = new Object[]{firstMessageLine};
                            Row.comment$default((Row)$this$row, (String)ChartMessagesBundle.message("series.error.reason", objectArray), (int)0, null, (int)6, null).resizableColumn();
                            if (firstNewline != -1) {
                                $this$row.link(ChartMessagesBundle.message("series.error.details", new Object[0]), (Function1)new Function1<ActionEvent, Unit>(this.$message){
                                    final /* synthetic */ String $message;
                                    {
                                        this.$message = $message;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull ActionEvent event) {
                                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                                        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder("<html>" + StringsKt.replace$default((String)this.$message, (String)"\n", (String)"<br>", (boolean)false, (int)4, null) + "</html>", MessageType.INFO, null).setShowCallout(true).setHideOnAction(true).setHideOnClickOutside(true);
                                        Intrinsics.checkNotNullExpressionValue((Object)balloonBuilder, (String)"setHideOnClickOutside(...)");
                                        BalloonBuilder balloonBuilder2 = balloonBuilder;
                                        Balloon balloon = balloonBuilder2.createBalloon();
                                        Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
                                        Balloon balloon2 = balloon;
                                        Object object = event.getSource();
                                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JComponent");
                                        balloon2.showInCenterOf((JComponent)object);
                                    }
                                });
                            }
                        }
                    }), (int)1, null);
                }
            }));
            boolean bl = false;
            $this$createErrorMessageComponent_u24lambda_u240.setOpaque(false);
            DialogPanel inner2 = dialogPanel;
            DialogPanel $this$createErrorMessageComponent_u24lambda_u241 = dialogPanel = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(message, inner2){
                final /* synthetic */ String $message;
                final /* synthetic */ DialogPanel $inner;
                {
                    this.$message = $message;
                    this.$inner = $inner;
                    super(1);
                }

                public final void invoke(@NotNull Panel $this$panel) {
                    Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                    Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$message, this.$inner){
                        final /* synthetic */ String $message;
                        final /* synthetic */ DialogPanel $inner;
                        {
                            this.$message = $message;
                            this.$inner = $inner;
                            super(1);
                        }

                        public final void invoke(@NotNull Row $this$row) {
                            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                            $this$row.panel((Function1)new Function1<Panel, Unit>(this.$message, this.$inner){
                                final /* synthetic */ String $message;
                                final /* synthetic */ DialogPanel $inner;
                                {
                                    this.$message = $message;
                                    this.$inner = $inner;
                                    super(1);
                                }

                                public final void invoke(@NotNull Panel $this$panel) {
                                    Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                                    Panel.row$default((Panel)$this$panel, null, (Function1)createErrorMessageComponent.1.INSTANCE, (int)1, null);
                                    if (!StringsKt.isBlank((CharSequence)this.$message)) {
                                        Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$inner){
                                            final /* synthetic */ DialogPanel $inner;
                                            {
                                                this.$inner = $inner;
                                                super(1);
                                            }

                                            public final void invoke(@NotNull Row $this$row) {
                                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                                $this$row.cell((JComponent)this.$inner).align((Align)AlignX.CENTER.INSTANCE);
                                            }
                                        }), (int)1, null);
                                    }
                                }
                            });
                        }
                    }), (int)1, null).resizableRow();
                }
            }));
            boolean bl2 = false;
            $this$createErrorMessageComponent_u24lambda_u241.setOpaque(false);
            $this$createErrorMessageComponent_u24lambda_u241.setBorder(JBUI.Borders.empty((int)10));
            $this$createErrorMessageComponent_u24lambda_u241.setMinimumSize(new Dimension(1, 1));
            return (JComponent)dialogPanel;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR#\u0010\u0003\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/bigdatatools/visualization/charts/core/ChartPage$Companion;", "", "()V", "IDEA_EDT_EXECUTOR", "Lkotlin/Function1;", "Lkotlin/Function0;", "", "getIDEA_EDT_EXECUTOR", "()Lkotlin/jvm/functions/Function1;", "saveAsImage", "project", "Lcom/intellij/openapi/project/Project;", "component", "Ljavax/swing/JComponent;", "intellij.charts"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<Function0<Unit>, Unit> getIDEA_EDT_EXECUTOR() {
            return IDEA_EDT_EXECUTOR;
        }

        public final void saveAsImage(@NotNull Project project, @NotNull JComponent component2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            String[] stringArray = new String[]{"png"};
            FileSaverDescriptor descriptor = new FileSaverDescriptor(ChartMessagesBundle.message("action.Charts.ExportChartToPng.text", new Object[0]), "", stringArray);
            FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, project);
            Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"createSaveFileDialog(...)");
            FileSaverDialog chooser = fileSaverDialog;
            VirtualFileWrapper virtualFileWrapper = chooser.save(null, "chart");
            if (virtualFileWrapper == null) {
                return;
            }
            VirtualFileWrapper fileWrapper = virtualFileWrapper;
            ApplicationManager.getApplication().runWriteAction(() -> Companion.saveAsImage$lambda$1(component2, fileWrapper, project));
        }

        private static final void saveAsImage$lambda$1$lambda$0(Project $project, Exception $e) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
            Messages.showErrorDialog((Project)$project, (String)$e.getMessage(), (String)ChartMessagesBundle.message("chart.exportFailed", new Object[0]));
        }

        private static final void saveAsImage$lambda$1(JComponent $component, VirtualFileWrapper $fileWrapper, Project $project) {
            Intrinsics.checkNotNullParameter((Object)$component, (String)"$component");
            Intrinsics.checkNotNullParameter((Object)$fileWrapper, (String)"$fileWrapper");
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            try {
                File file;
                BufferedImage bufferedImage = ImageUtil.createImage((int)$component.getWidth(), (int)$component.getHeight(), (int)5);
                Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
                BufferedImage paintImage = bufferedImage;
                Graphics2D g = paintImage.createGraphics();
                $component.paint(g);
                g.dispose();
                File file2 = $fileWrapper.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getFile(...)");
                if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)file2), (Object)"png")) {
                    file = new File($fileWrapper.getFile().getPath() + ".png");
                } else {
                    File file3 = $fileWrapper.getFile();
                    Intrinsics.checkNotNull((Object)file3);
                    file = file3;
                }
                File targetFile = file;
                ImageIO.write((RenderedImage)paintImage, "PNG", targetFile);
            }
            catch (Exception e) {
                ApplicationManager.getApplication().invokeLater(() -> Companion.saveAsImage$lambda$1$lambda$0($project, e));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

