/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.ui;

import com.intellij.ide.FileIconProvider;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.GitlabIcons;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/gitlab/ui/GitLabCiConfigIconProvider;", "Lcom/intellij/ide/FileIconProvider;", "()V", "GITLAB_CI_FILE_MASK", "Lkotlin/text/Regex;", "GITLAB_SCHEMAS", "", "", "PARSE_DELAY", "", "yamlExtensions", "getIcon", "Ljavax/swing/Icon;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "flags", "", "project", "Lcom/intellij/openapi/project/Project;", "isGitlabCiFile", "", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabCiConfigIconProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabCiConfigIconProvider.kt\norg/jetbrains/plugins/gitlab/ui/GitLabCiConfigIconProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,39:1\n31#2,2:40\n1747#3,3:42\n*S KotlinDebug\n*F\n+ 1 GitLabCiConfigIconProvider.kt\norg/jetbrains/plugins/gitlab/ui/GitLabCiConfigIconProvider\n*L\n28#1:40,2\n29#1:42,3\n*E\n"})
public final class GitLabCiConfigIconProvider
implements FileIconProvider {
    private final long PARSE_DELAY;
    @NotNull
    private final Regex GITLAB_CI_FILE_MASK = new Regex(".*\\.gitlab-ci(\\..*)?\\.(yaml|yml)");
    @NotNull
    private final Set<String> GITLAB_SCHEMAS = SetsKt.setOf((Object)"ci.json");
    @NotNull
    private final Set<String> yamlExtensions;

    public GitLabCiConfigIconProvider() {
        this.PARSE_DELAY = 250L;
        Object[] objectArray = new String[]{"yml", "yaml"};
        this.yamlExtensions = SetsKt.setOf((Object[])objectArray);
    }

    @Nullable
    public Icon getIcon(@NotNull VirtualFile file, int flags, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getExtension();
        if (string == null) {
            return null;
        }
        String extension = string;
        String string2 = extension.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        if (!this.yamlExtensions.contains(string2)) {
            return null;
        }
        if (this.isGitlabCiFile(file)) {
            return GitlabIcons.GitLabLogo;
        }
        if (project != null) {
            boolean bl;
            block9: {
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<JsonSchemaService> serviceClass$iv = JsonSchemaService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                Collection collection = ((JsonSchemaService)object).getSchemaFilesForFile(file);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSchemaFilesForFile(...)");
                Collection schemaFiles = collection;
                Iterable $this$any$iv = schemaFiles;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        VirtualFile it = (VirtualFile)element$iv;
                        boolean bl2 = false;
                        if (!this.GITLAB_SCHEMAS.contains(it.getName())) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return GitlabIcons.GitLabLogo;
            }
        }
        return null;
    }

    private final boolean isGitlabCiFile(VirtualFile file) {
        CharSequence charSequence = StringUtil.newBombedCharSequence((CharSequence)file.getName(), (long)this.PARSE_DELAY);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"newBombedCharSequence(...)");
        return this.GITLAB_CI_FILE_MASK.matches(charSequence);
    }
}

