/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.ui.actions.ChangeFontSizeActionKt;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionUtil;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.intellij.plugins.markdown.ui.preview.PreviewLAFThemeStyles;
import org.intellij.plugins.markdown.ui.preview.jcef.MarkdownJCEFHtmlPanel;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0003\r\u000e\u000fB\u001b\b\u0004\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0003\u0010\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/ChangeFontSizeAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "transform", "Lkotlin/Function1;", "", "(Lkotlin/jvm/functions/Function1;)V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "Decrease", "Increase", "Reset", "Lorg/intellij/plugins/markdown/ui/actions/ChangeFontSizeAction$Decrease;", "Lorg/intellij/plugins/markdown/ui/actions/ChangeFontSizeAction$Increase;", "Lorg/intellij/plugins/markdown/ui/actions/ChangeFontSizeAction$Reset;", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nChangeFontSizeAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeFontSizeAction.kt\norg/intellij/plugins/markdown/ui/actions/ChangeFontSizeAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public abstract class ChangeFontSizeAction
extends DumbAwareAction {
    @NotNull
    private final Function1<Integer, Integer> transform;

    private ChangeFontSizeAction(Function1<? super Integer, Integer> transform) {
        this.transform = transform;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MarkdownPreviewFileEditor editor2 = MarkdownActionUtil.findMarkdownPreviewEditor(event);
        if (editor2 == null) {
            boolean $i$a$-checkNotNull-ChangeFontSizeAction$actionPerformed$22 = false;
            String $i$a$-checkNotNull-ChangeFontSizeAction$actionPerformed$22 = "Preview editor should be obtainable from the action event";
            throw new IllegalStateException($i$a$-checkNotNull-ChangeFontSizeAction$actionPerformed$22.toString());
        }
        Object object = (WeakReference)editor2.getUserData(MarkdownPreviewFileEditor.PREVIEW_BROWSER);
        if (object == null || (object = (MarkdownHtmlPanel)((Reference)object).get()) == null) {
            return;
        }
        Object preview = object;
        if (!(preview instanceof MarkdownJCEFHtmlPanel)) {
            return;
        }
        Integer n = (Integer)((MarkdownJCEFHtmlPanel)preview).getUserData(ChangeFontSizeActionKt.access$getFontSize$p());
        if (n == null) {
            n = PreviewLAFThemeStyles.INSTANCE.getDefaultFontSize();
        }
        int currentSize = ((Number)n).intValue();
        int newSize = ((Number)this.transform.invoke((Object)currentSize)).intValue();
        ((MarkdownJCEFHtmlPanel)preview).putUserData(ChangeFontSizeActionKt.access$getFontSize$p(), newSize);
        ChangeFontSizeActionKt.changeFontSize((MarkdownJCEFHtmlPanel)preview, newSize);
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MarkdownPreviewFileEditor editor2 = MarkdownActionUtil.findMarkdownPreviewEditor(event);
        event.getPresentation().setEnabledAndVisible(editor2 != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public /* synthetic */ ChangeFontSizeAction(Function1 transform, DefaultConstructorMarker $constructor_marker) {
        this((Function1<? super Integer, Integer>)transform);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/ChangeFontSizeAction$Decrease;", "Lorg/intellij/plugins/markdown/ui/actions/ChangeFontSizeAction;", "()V", "intellij.markdown"})
    public static final class Decrease
    extends ChangeFontSizeAction {
        public Decrease() {
            super(1.INSTANCE, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/ChangeFontSizeAction$Increase;", "Lorg/intellij/plugins/markdown/ui/actions/ChangeFontSizeAction;", "()V", "intellij.markdown"})
    public static final class Increase
    extends ChangeFontSizeAction {
        public Increase() {
            super(1.INSTANCE, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/ChangeFontSizeAction$Reset;", "Lorg/intellij/plugins/markdown/ui/actions/ChangeFontSizeAction;", "()V", "intellij.markdown"})
    public static final class Reset
    extends ChangeFontSizeAction {
        public Reset() {
            super(1.INSTANCE, null);
        }
    }
}

