/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.highlighting;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.highlighting.MarkdownHighlighterColors;
import org.intellij.plugins.markdown.highlighting.MarkdownHighlightingAnnotator;
import org.intellij.plugins.markdown.highlighting.MarkdownSyntaxHighlighter;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J.\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/intellij/plugins/markdown/highlighting/MarkdownHighlightingAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "annotateBasedOnParent", "predicate", "Lkotlin/Function1;", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "annotateWithHighlighter", "Companion", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdownHighlightingAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownHighlightingAnnotator.kt\norg/intellij/plugins/markdown/highlighting/MarkdownHighlightingAnnotator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class MarkdownHighlightingAnnotator
implements Annotator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final MarkdownSyntaxHighlighter syntaxHighlighter = new MarkdownSyntaxHighlighter();

    public void annotate(@NotNull PsiElement element2, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        IElementType iElementType = PsiUtilCore.getElementType((PsiElement)element2);
        if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EMPH)) {
            this.annotateBasedOnParent(element2, holder, (Function1<? super IElementType, TextAttributesKey>)((Function1)annotate.1.INSTANCE));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.BACKTICK)) {
            this.annotateBasedOnParent(element2, holder, (Function1<? super IElementType, TextAttributesKey>)((Function1)annotate.2.INSTANCE));
        } else {
            this.annotateWithHighlighter(element2, holder);
        }
    }

    private final void annotateBasedOnParent(PsiElement element2, AnnotationHolder holder, Function1<? super IElementType, TextAttributesKey> predicate) {
        IElementType iElementType;
        PsiElement psiElement = element2.getParent();
        if (psiElement != null) {
            PsiElement p0 = psiElement;
            boolean bl = false;
            iElementType = PsiUtilCore.getElementType((PsiElement)p0);
        } else {
            iElementType = null;
        }
        if (iElementType == null) {
            return;
        }
        IElementType parentType = iElementType;
        TextAttributesKey attributes = (TextAttributesKey)predicate.invoke((Object)parentType);
        if (attributes != null) {
            holder.newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(attributes).create();
        }
    }

    private final void annotateWithHighlighter(PsiElement element2, AnnotationHolder holder) {
        IElementType iElementType = MarkdownTokenTypes.CODE_FENCE_CONTENT;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"CODE_FENCE_CONTENT");
        if (PsiUtilsKt.hasType(element2, iElementType)) {
            PsiElement psiElement = element2.getParent();
            MarkdownCodeFence markdownCodeFence = psiElement instanceof MarkdownCodeFence ? (MarkdownCodeFence)psiElement : null;
            if ((markdownCodeFence != null ? markdownCodeFence.getFenceLanguage() : null) != null) {
                return;
            }
        }
        Object[] objectArray = syntaxHighlighter.getTokenHighlights(PsiUtilCore.getElementType((PsiElement)element2));
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getTokenHighlights(...)");
        Object[] highlights = objectArray;
        if (!(highlights.length == 0) && !Intrinsics.areEqual((Object)ArraysKt.first((Object[])highlights), (Object)MarkdownHighlighterColors.TEXT)) {
            holder.newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes((TextAttributesKey)ArraysKt.first((Object[])highlights)).create();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/intellij/plugins/markdown/highlighting/MarkdownHighlightingAnnotator$Companion;", "", "()V", "syntaxHighlighter", "Lorg/intellij/plugins/markdown/highlighting/MarkdownSyntaxHighlighter;", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

