/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.attributetotag;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.xrp.intention.Intention;
import com.sixrr.xrp.intention.PsiElementPredicate;
import com.sixrr.xrp.utils.RefactorXBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AttributeToTagIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Editor editor) throws IncorrectOperationException {
        if (element == null) {
            AttributeToTagIntention.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            AttributeToTagIntention.$$$reportNull$$$0(1);
        }
        XmlAttribute attribute = (XmlAttribute)element;
        XmlTag tag = attribute.getParent();
        String value = attribute.getValue();
        String name = attribute.getName();
        String escapedValue = StringUtil.escapeXmlEntities((String)(value != null ? value : ""));
        boolean preserve = AttributeToTagIntention.enforcePreserveWhitespaces(tag, escapedValue);
        XmlAttribute next = (XmlAttribute)PsiTreeUtil.getNextSiblingOfType((PsiElement)attribute, XmlAttribute.class);
        XmlTag newTag = tag.createChildTag(name, attribute.getNamespace(), escapedValue, false);
        newTag = tag.addSubTag(newTag, true);
        if (preserve) {
            newTag.setAttribute("xml:space", "preserve");
        }
        attribute.delete();
        if (next != null) {
            editor.getCaretModel().moveToOffset(next.getTextOffset());
        } else if (escapedValue.isEmpty()) {
            ASTNode child = XmlChildRole.START_TAG_END_FINDER.findChild(newTag.getNode());
            assert (child != null);
            editor.getCaretModel().moveToOffset(child.getStartOffset() + 1);
        } else {
            ASTNode child = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode());
            assert (child != null);
            editor.getCaretModel().moveToOffset(child.getStartOffset());
        }
    }

    public static boolean enforcePreserveWhitespaces(XmlTag tag, String escapedValue) {
        if (StringUtil.startsWithWhitespace((String)escapedValue) || !escapedValue.isEmpty() && Character.isWhitespace(escapedValue.charAt(escapedValue.length() - 1))) {
            do {
                XmlAttribute space;
                if ((space = tag.getAttribute("xml:space")) != null && "preserve".equals(space.getValue())) {
                    return false;
                }
                if (space == null || !"default".equals(space.getValue())) continue;
                return true;
            } while ((tag = tag.getParentTag()) != null);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = element -> element instanceof XmlAttribute && !"xml:space".equals(((XmlAttribute)element).getName()) && element.getLanguage().isKindOf((Language)XMLLanguage.INSTANCE) && !element.getLanguage().isKindOf((Language)HTMLLanguage.INSTANCE);
        if (psiElementPredicate == null) {
            AttributeToTagIntention.$$$reportNull$$$0(2);
        }
        return psiElementPredicate;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            AttributeToTagIntention.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = RefactorXBundle.message("intention.text.convert.attribute.to.child.element", new Object[0]);
        if (string == null) {
            AttributeToTagIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            AttributeToTagIntention.$$$reportNull$$$0(5);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/sixrr/xrp/attributetotag/AttributeToTagIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/sixrr/xrp/attributetotag/AttributeToTagIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

