/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.dialects.CHouseIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.dialects.ExasolExceptionRecognizer;
import com.intellij.database.remote.jdba.util.Version;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.TypedKey;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.database.remote.jdbc.impl.UnparsedValueKind;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ReflectionUtilRt;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CHouseJdbcHelper
extends JdbcHelperImpl {
    public static final TypedKey<Boolean> AUTO_SESSION = TypedKey.create("clickhouse.auto.session");
    private static final String DRIVER_VERSION_PREFIX = "clickhouse-jdbc ";
    @Nullable
    private final Version myParsedDriverVersion;
    private static final String IP4_AS_IP6_PREFIX = "0:0:0:0:0:ffff:";

    public CHouseJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("CLICKHOUSE", version, connection);
        this.myParsedDriverVersion = CHouseJdbcHelper.getParsedDriverVersion(connection);
    }

    public CHouseJdbcHelper() {
        this(null, null);
    }

    @Nullable
    private static Version getParsedDriverVersion(@Nullable Connection connection) {
        if (connection == null) {
            return null;
        }
        try {
            DatabaseMetaData metadata = connection.getMetaData();
            String driverVersion = metadata.getDriverVersion();
            driverVersion = driverVersion.startsWith(DRIVER_VERSION_PREFIX) ? driverVersion.substring(DRIVER_VERSION_PREFIX.length()) : driverVersion;
            driverVersion = driverVersion.replace("-patch", ".");
            return Version.of(driverVersion);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return CHouseJdbcHelper.extractVersion(version);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection) {
        return new CHouseJdbcHelper(version, connection);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull JdbcConnectionProvider ds) {
        if (ds == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(0);
        }
        return new CHouseIntermediateFacade(ds, ExasolExceptionRecognizer.INSTANCE, this);
    }

    @Override
    @Nullable
    public UnparsedValueKind detectUnparsedValueKind(@Nullable String typeName, int jdbcType) {
        if (jdbcType == 91) {
            return UnparsedValueKind.DATE;
        }
        if (jdbcType == 93) {
            return UnparsedValueKind.TIMESTAMP;
        }
        return super.detectUnparsedValueKind(typeName, jdbcType);
    }

    @Override
    protected void setTimestamp(@NotNull RemotePreparedStatement statement, int idx, Timestamp timestamp) throws Exception {
        if (statement == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(1);
        }
        statement.setTimestamp(idx, timestamp);
    }

    @Override
    protected void setTime(@NotNull RemotePreparedStatement statement, int idx, Time time) throws RemoteException, SQLException {
        if (statement == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(2);
        }
        statement.setTime(idx, time);
    }

    @Override
    public char getEscapeChar() {
        return '\\';
    }

    @Override
    @NotNull
    protected String getCharsToEscape() {
        return "%_\\";
    }

    @Override
    public boolean supportsEscape() {
        return false;
    }

    @Override
    protected boolean isDriverFailsOnType(int jdbcType, String typeName) {
        return super.isDriverFailsOnType(jdbcType, typeName) || this.myParsedDriverVersion != null && this.myParsedDriverVersion.less(0, 3, 2) && (jdbcType == 2003 || jdbcType == 1111 && typeName.startsWith("Map("));
    }

    @Override
    public int fixJdbcType(@Nullable String typeName, @Nullable String clazz, int type) {
        if (type == 1111 && "uuid".equalsIgnoreCase(typeName)) {
            return 12;
        }
        return super.fixJdbcType(typeName, clazz, type);
    }

    @Override
    public Object getObject(@NotNull RemoteResultSet.DataRetrievingOptions options, @NotNull JdbcRemoteObject exporter, @NotNull ResultSet resultSet, @NotNull ResultSetMetaData metaData, int jdbcType, int index) throws SQLException {
        String typeName;
        boolean isIPv6;
        if (exporter == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(3);
        }
        if (resultSet == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(4);
        }
        if (metaData == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(5);
        }
        if (options == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(6);
        }
        if ((isIPv6 = "IPv6".equalsIgnoreCase(typeName = metaData.getColumnTypeName(index))) && !options.raw) {
            return CHouseJdbcHelper.adjustIPv6(resultSet, index);
        }
        return super.getObject(options, exporter, resultSet, metaData, jdbcType, index);
    }

    @Override
    @Nullable
    protected Object tryGetObject(@NotNull RemoteResultSet.DataRetrievingOptions options, @NotNull ResultSet resultSet, @NotNull ResultSetMetaData metaData, int index) throws SQLException {
        String typeName;
        if (options == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(7);
        }
        if (resultSet == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(8);
        }
        if (metaData == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(9);
        }
        switch (typeName = metaData.getColumnTypeName(index)) {
            case "UInt8": {
                return resultSet.getShort(index);
            }
            case "UInt16": {
                return resultSet.getInt(index);
            }
            case "UInt32": 
            case "UInt64": {
                return resultSet.getLong(index);
            }
        }
        return super.tryGetObject(options, resultSet, metaData, index);
    }

    @NotNull
    private static CharSequence adjustIPv6(@NotNull ResultSet resultSet, int index) throws SQLException {
        String addr;
        if (resultSet == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(10);
        }
        if ((addr = resultSet.getString(index)).startsWith(IP4_AS_IP6_PREFIX)) {
            String[] ip4Fields;
            StringBuilder result = new StringBuilder("::ffff:");
            int startLength = result.length();
            for (String ip4Field : ip4Fields = addr.substring(IP4_AS_IP6_PREFIX.length()).split(":")) {
                if (result.length() > startLength) {
                    result.append('.');
                }
                int n = Integer.parseInt(ip4Field, 16);
                result.append(n >> 8);
                result.append('.');
                result.append(n & 0xFF);
            }
            StringBuilder stringBuilder = result;
            if (stringBuilder == null) {
                CHouseJdbcHelper.$$$reportNull$$$0(11);
            }
            return stringBuilder;
        }
        String string = addr;
        if (string == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(13);
        }
        String nullable = "Nullable(";
        if (e.typeName != null && e.typeName.startsWith(nullable) && e.typeName.endsWith(")")) {
            e.nullable = true;
            e.typeName = e.typeName.substring(nullable.length(), e.typeName.length() - 1);
        }
        if (!"fixedstring".equalsIgnoreCase(e.typeName)) {
            e.length = -1;
        }
    }

    @Override
    public boolean supportsCalendarInPreparedStatement() {
        return false;
    }

    @Override
    public boolean supportsLimitMaxRows() {
        return false;
    }

    @Override
    @Nullable
    public JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer, @Nullable JdbcHelperImpl connectHelper) throws Exception {
        if (!JdbcNativeUtil.detectString(product, "ClickHouse")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return CHouseJdbcHelper.create(delegate, productVer);
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(14);
        }
        return CHouseJdbcHelper.classNameContains(driver, "clickhouse");
    }

    @Override
    @Nullable
    public Connection connect(@NotNull Driver driver, String url, @NotNull Properties properties, @NotNull Map<String, Serializable> extra) throws SQLException {
        if (driver == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(15);
        }
        if (properties == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(16);
        }
        if (extra == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(17);
        }
        if (!Boolean.FALSE.equals(AUTO_SESSION.get(extra))) {
            boolean isNew = driver.getClass().getCanonicalName().startsWith("com.clickhouse");
            if (isNew && driver.getMajorVersion() == 0 && driver.getMinorVersion() < 4) {
                String params = properties.getProperty("custom_http_params");
                if (params == null || !params.contains("session_id=")) {
                    String newParams = (StringUtilRt.isEmpty((CharSequence)params) ? "session_id=" : params + ",session_id=") + CHouseJdbcHelper.generateSessionId();
                    properties.setProperty("custom_http_params", newParams);
                }
            } else if (!properties.containsKey("session_id")) {
                properties.setProperty("session_id", CHouseJdbcHelper.generateSessionId());
            }
        }
        return super.connect(driver, url, properties, extra);
    }

    @NotNull
    private static String generateSessionId() {
        String sessionId = "DataGrip_" + UUID.randomUUID();
        JdbcNativeUtil.logInfo("Generated session_id: " + sessionId);
        String string = sessionId;
        if (string == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Override
    public JdbcSettings.SslMode[] supportedSslModes() {
        return new JdbcSettings.SslMode[]{JdbcSettings.SslMode.REQUIRE, JdbcSettings.SslMode.VERIFY_FULL};
    }

    @Override
    protected void enableSsl(@NotNull Driver driver, @NotNull Properties properties, @NotNull JdbcSettings.SslMode sslMode) {
        if (driver == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(19);
        }
        if (properties == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(20);
        }
        if (sslMode == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(21);
        }
        properties.setProperty("ssl", "true");
        String sslModeStr = sslMode == JdbcSettings.SslMode.REQUIRE ? "none" : "strict";
        boolean isNew = driver.getClass().getName().startsWith("com.");
        CHouseJdbcHelper.setIfEmpty(properties, "sslmode", isNew ? sslModeStr.toUpperCase(Locale.ENGLISH) : sslModeStr);
    }

    @NotNull
    private static CHouseJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) throws Exception {
        String versionStr = delegate == null ? productVer : JdbcNativeUtil.getString(delegate, "select version()");
        JdbcNativeUtil.logInfo("version: " + versionStr);
        return new CHouseJdbcHelper(CHouseJdbcHelper.extractVersion(versionStr), delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    public boolean getAutoCommit(Connection delegate) {
        return true;
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public void cancel(@NotNull Statement stmt) throws SQLException {
        if (stmt == null) {
            CHouseJdbcHelper.$$$reportNull$$$0(22);
        }
        try {
            Class<?> qpClass = this.classForName("ru.yandex.clickhouse.settings.ClickHouseQueryParam");
            Object sessionId = ReflectionUtilRt.getField(qpClass, null, qpClass, (String)"SESSION_ID");
            ReflectionHelper.tryInvokeMethod(stmt, "addDbParam", new Class[]{qpClass, String.class}, new Object[]{sessionId, ""});
        }
        catch (Throwable th) {
            JdbcNativeUtil.logWarn("Failed to reset session id before cancel", th);
        }
        super.cancel(stmt);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exporter";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 11: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/CHouseJdbcHelper";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 14: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extra";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sslMode";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stmt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/CHouseJdbcHelper";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustIPv6";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "generateSessionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFacade";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setTimestamp";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setTime";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getObject";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tryGetObject";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "adjustIPv6";
                break;
            }
            case 11: 
            case 12: 
            case 18: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "enableSsl";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "cancel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

