/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.visualEditing.utils;

import com.intellij.swagger.core.visualEditing.utils.SwInterval;
import com.intellij.swagger.core.visualEditing.utils.SwIntervalTree;
import com.intellij.swagger.core.visualEditing.utils.SwIntervalTreeKt;
import com.intellij.swagger.core.visualEditing.utils.SwTreeSearchData;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/swagger/core/visualEditing/utils/SwIntervalTreeBlockingHolder;", "Lcom/intellij/swagger/core/visualEditing/utils/SwIntervalTree;", "minOffset", "", "maxOffset", "(II)V", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "findSmallestSubtreeDataUnderLock", "Lcom/intellij/swagger/core/visualEditing/utils/SwTreeSearchData;", "offset", "insertUnderLock", "", "newNodes", "", "Lcom/intellij/swagger/core/visualEditing/utils/SwInterval;", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwIntervalTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwIntervalTree.kt\ncom/intellij/swagger/core/visualEditing/utils/SwIntervalTreeBlockingHolder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n1855#2,2:159\n*S KotlinDebug\n*F\n+ 1 SwIntervalTree.kt\ncom/intellij/swagger/core/visualEditing/utils/SwIntervalTreeBlockingHolder\n*L\n15#1:159,2\n*E\n"})
public final class SwIntervalTreeBlockingHolder
extends SwIntervalTree {
    @NotNull
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public SwIntervalTreeBlockingHolder(int minOffset, int maxOffset) {
        super(new SwInterval(minOffset, maxOffset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void insertUnderLock(@NotNull List<SwInterval> newNodes) {
        Intrinsics.checkNotNullParameter(newNodes, (String)"newNodes");
        List nodesSortedByLength = CollectionsKt.sortedWith((Iterable)newNodes, SwIntervalTreeKt.getDESCENDING_RANGE_COMPARATOR_BY_LENGTH());
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            Iterable $this$forEach$iv = nodesSortedByLength;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SwInterval newNode = (SwInterval)element$iv;
                boolean bl2 = false;
                this.insert(this, newNode);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SwTreeSearchData findSmallestSubtreeDataUnderLock(int offset) {
        SwTreeSearchData swTreeSearchData;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            swTreeSearchData = this.findSmallestSubtreeWithOffset(offset);
        }
        finally {
            readLock.unlock();
        }
        return swTreeSearchData;
    }
}

