/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.ui.rest;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.swagger.core.ui.SwPreviewType;
import com.intellij.swagger.core.ui.rest.SpecificationId;
import com.intellij.swagger.core.ui.rest.SwUrlParser;
import com.intellij.swagger.core.ui.rest.SwWebServerRequestType;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.NettyKt;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.cef.network.CefRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001:\u0001>B\u0019\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J!\u0010\u001f\u001a\u00020\u001b2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0!\"\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001eH\u0002J\u0010\u0010%\u001a\u0004\u0018\u00010\u000b2\u0006\u0010&\u001a\u00020\u000bJ\u0006\u0010'\u001a\u00020(J\b\u0010)\u001a\u00020\u001bH\u0002J\u0006\u0010*\u001a\u00020(J\u0006\u0010+\u001a\u00020(J\u001f\u0010,\u001a\u00020(2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0!\"\u00020\u000b\u00a2\u0006\u0002\u0010-J\b\u0010.\u001a\u0004\u0018\u00010/J\u0010\u00100\u001a\u0004\u0018\u00010\u000b2\u0006\u0010&\u001a\u00020\u000bJ\b\u00101\u001a\u0004\u0018\u000102J\b\u00103\u001a\u0004\u0018\u00010\u000bJ\u0015\u00104\u001a\u0004\u0018\u000105\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b6\u00107J\u0010\u00108\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001eH\u0002J\u0018\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0013*\u00020\u000bH\u0002J\u0012\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015*\u00020\u000bH\u0002J\u000e\u0010;\u001a\u0004\u0018\u00010\u000b*\u00020\u001bH\u0002J\u001c\u0010<\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010=\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u0004\u0018\u00010\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006?"}, d2={"Lcom/intellij/swagger/core/ui/rest/SwUrlParser;", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "(Lio/netty/handler/codec/http/FullHttpRequest;Lio/netty/handler/codec/http/QueryStringDecoder;)V", "browserRequest", "Lorg/cef/network/CefRequest;", "(Lorg/cef/network/CefRequest;)V", "authority", "", "bundledWebServerUrl", "Lcom/intellij/util/Url;", "getBundledWebServerUrl", "()Lcom/intellij/util/Url;", "bundledWebServerUrl$delegate", "Lkotlin/Lazy;", "headers", "", "pathSegments", "", "presentableUrl", "getPresentableUrl$intellij_swagger_core", "()Ljava/lang/String;", "queryParameters", "compareSegments", "Lcom/intellij/swagger/core/ui/rest/SwUrlParser$UrlMatchResult;", "expectedSegment", "segmentIndexToCompare", "", "doMatchPathSegments", "segments", "", "([Ljava/lang/String;)Lcom/intellij/swagger/core/ui/rest/SwUrlParser$UrlMatchResult;", "failedMatch", "comparedIndex", "getHeader", "name", "hasQueryParameters", "", "initialiseUrlMatching", "isRequestFromPreviewEditor", "isRequestToBundledWebServer", "pathStartsWith", "([Ljava/lang/String;)Z", "recognizePreviewType", "Lcom/intellij/swagger/core/ui/SwPreviewType;", "recognizeQueryParameter", "recognizeRequestType", "Lcom/intellij/swagger/core/ui/rest/SwWebServerRequestType;", "recognizeResourcePath", "recognizeSpecificationId", "Lcom/intellij/swagger/core/ui/rest/SpecificationId;", "recognizeSpecificationId-2Wqz4Ao", "()Ljava/util/UUID;", "successfulMatch", "parseParameters", "parsePath", "unmatchedTail", "withNextSegment", "segment", "UrlMatchResult", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwUrlParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwUrlParser.kt\ncom/intellij/swagger/core/ui/rest/SwUrlParser\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,168:1\n453#2:169\n403#2:170\n1238#3,4:171\n1179#3,2:175\n1253#3,4:177\n1179#3,2:188\n1253#3,4:190\n1#4:181\n1282#5,2:182\n12720#5,3:185\n9#6:184\n*S KotlinDebug\n*F\n+ 1 SwUrlParser.kt\ncom/intellij/swagger/core/ui/rest/SwUrlParser\n*L\n17#1:169\n17#1:170\n17#1:171,4\n20#1:175,2\n20#1:177,4\n152#1:188,2\n152#1:190,4\n67#1:182,2\n107#1:185,3\n76#1:184\n*E\n"})
public final class SwUrlParser {
    @NotNull
    private final List<String> pathSegments;
    @NotNull
    private final Map<String, String> queryParameters;
    @NotNull
    private final String authority;
    @NotNull
    private final Map<String, String> headers;
    @NotNull
    private final String presentableUrl;
    @NotNull
    private final Lazy bundledWebServerUrl$delegate;

    /*
     * WARNING - void declaration
     */
    public SwUrlParser(@NotNull FullHttpRequest request, @NotNull QueryStringDecoder urlDecoder) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Map.Entry entry;
        void $this$mapValuesTo$iv$iv;
        Iterable $this$mapValues$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        this.bundledWebServerUrl$delegate = LazyKt.lazy((Function0)bundledWebServerUrl.2.INSTANCE);
        String string = request.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
        this.pathSegments = this.parsePath(string);
        Map map = urlDecoder.parameters();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"parameters(...)");
        Map map2 = map;
        SwUrlParser swUrlParser = this;
        boolean $i$f$mapValues = false;
        void var5_6 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void entry2;
            void it$iv$iv;
            entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            Object v = entry2.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            String string2 = (String)CollectionsKt.lastOrNull((List)((List)v));
            map4.put(k, string2);
        }
        swUrlParser.queryParameters = destination$iv$iv;
        String string3 = request.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"uri(...)");
        this.presentableUrl = string3;
        String string4 = NettyKt.getHost((HttpRequest)((HttpRequest)request));
        if (string4 == null) {
            string4 = "";
        }
        this.authority = string4;
        HttpHeaders httpHeaders = request.headers();
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"headers(...)");
        $this$mapValues$iv = (Iterable)httpHeaders;
        swUrlParser = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map5 = destination$iv$iv2;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            entry = TuplesKt.to(it.getKey(), it.getValue());
            map5.put(entry.getFirst(), entry.getSecond());
        }
        swUrlParser.headers = destination$iv$iv2;
    }

    public /* synthetic */ SwUrlParser(FullHttpRequest fullHttpRequest, QueryStringDecoder queryStringDecoder, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            queryStringDecoder = new QueryStringDecoder(fullHttpRequest.uri());
        }
        this(fullHttpRequest, queryStringDecoder);
    }

    /*
     * WARNING - void declaration
     */
    public SwUrlParser(@NotNull CefRequest browserRequest) {
        void p0;
        Map map;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)browserRequest, (String)"browserRequest");
        this.bundledWebServerUrl$delegate = LazyKt.lazy((Function0)bundledWebServerUrl.2.INSTANCE);
        String string = browserRequest.getURL();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getURL(...)");
        Url parsedUrl = Urls.parseEncoded((String)string);
        boolean bl2 = bl = parsedUrl != null;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-SwUrlParser$42 = false;
            String $i$a$-assert-SwUrlParser$42 = "invalid url passed to a cef request handler - code should not be reached";
            throw new AssertionError((Object)$i$a$-assert-SwUrlParser$42);
        }
        Intrinsics.checkNotNull((Object)parsedUrl);
        String string2 = parsedUrl.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        this.pathSegments = this.parsePath(string2);
        String string3 = parsedUrl.getParameters();
        Map map2 = string3 != null ? this.parseParameters(string3) : null;
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        this.queryParameters = map2;
        String string4 = parsedUrl.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
        this.presentableUrl = string4;
        String string5 = parsedUrl.getAuthority();
        if (string5 == null) {
            string5 = "";
        }
        this.authority = string5;
        Map $i$a$-assert-SwUrlParser$42 = map = (Map)new LinkedHashMap();
        SwUrlParser swUrlParser = this;
        boolean bl3 = false;
        browserRequest.getHeaderMap((Map)p0);
        swUrlParser.headers = map;
    }

    @NotNull
    public final String getPresentableUrl$intellij_swagger_core() {
        return this.presentableUrl;
    }

    private final Url getBundledWebServerUrl() {
        Lazy lazy = this.bundledWebServerUrl$delegate;
        return (Url)lazy.getValue();
    }

    public final boolean hasQueryParameters() {
        return !this.queryParameters.isEmpty();
    }

    @Nullable
    public final String recognizeQueryParameter(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.queryParameters.get(name2);
    }

    public final boolean isRequestFromPreviewEditor() {
        String[] stringArray = new String[]{"__ij-openapi-plugin"};
        return this.pathStartsWith(stringArray);
    }

    public final boolean isRequestToBundledWebServer() {
        Url url2 = this.getBundledWebServerUrl();
        return Intrinsics.areEqual((Object)this.authority, (Object)(url2 != null ? url2.getAuthority() : null));
    }

    @Nullable
    public final String getHeader(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.headers.get(name2);
    }

    @Nullable
    public final SwPreviewType recognizePreviewType() {
        SwPreviewType swPreviewType;
        block2: {
            String string = this.queryParameters.get("previewType");
            if (string == null) {
                return null;
            }
            String specificationKey = string;
            SwPreviewType[] $this$firstOrNull$iv = SwPreviewType.values();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                SwPreviewType element$iv;
                SwPreviewType it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUniqueId(), (Object)specificationKey)) continue;
                swPreviewType = element$iv;
                break block2;
            }
            swPreviewType = null;
        }
        return swPreviewType;
    }

    @Nullable
    public final UUID recognizeSpecificationId-2Wqz4Ao() {
        Object object;
        String string = this.queryParameters.get("specificationKey");
        if (string == null) {
            return null;
        }
        String serializedSpecificationId = string;
        Object object2 = this;
        try {
            SwUrlParser $this$recognizeSpecificationId_2Wqz4Ao_u24lambda_u244 = object2;
            boolean bl = false;
            UUID uUID = UUID.fromString(serializedSpecificationId);
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
            object = Result.constructor-impl((Object)SpecificationId.box-impl(SpecificationId.constructor-impl(uUID)));
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object it = object = throwable;
            boolean bl = false;
            SwUrlParser $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(SwUrlParser.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("Could not get UUID from string: " + serializedSpecificationId);
        }
        SpecificationId specificationId = (SpecificationId)(Result.isFailure-impl((Object)object2) ? null : object2);
        return specificationId != null ? specificationId.unbox-impl() : null;
    }

    @Nullable
    public final String recognizeResourcePath() {
        String string = this.queryParameters.get("resourcePath");
        if (string == null) {
            String[] stringArray = new String[]{"__ij-openapi-plugin"};
            string = this.unmatchedTail(this.doMatchPathSegments(stringArray));
        }
        return string;
    }

    @Nullable
    public final SwWebServerRequestType recognizeRequestType() {
        SwWebServerRequestType swWebServerRequestType;
        if (this.pathSegments.isEmpty()) {
            swWebServerRequestType = null;
        } else {
            String[] stringArray = new String[]{"__ij-openapi-plugin", "specification"};
            if (this.pathStartsWith(stringArray)) {
                swWebServerRequestType = SwWebServerRequestType.SPECIFICATION_FILE;
            } else {
                stringArray = new String[]{"__ij-openapi-plugin", "customResource"};
                if (this.pathStartsWith(stringArray)) {
                    swWebServerRequestType = SwWebServerRequestType.CUSTOM_BUNDLED_RESOURCE;
                } else {
                    stringArray = new String[]{"__ij-openapi-plugin", "html"};
                    if (this.pathStartsWith(stringArray)) {
                        swWebServerRequestType = SwWebServerRequestType.HTML_FILE;
                    } else {
                        stringArray = new String[]{"__ij-openapi-plugin", "libraryResource"};
                        if (this.pathStartsWith(stringArray)) {
                            swWebServerRequestType = SwWebServerRequestType.LIBRARY_RESOURCE;
                        } else {
                            stringArray = new String[]{"__ij-openapi-plugin", "errorTemplate"};
                            if (this.pathStartsWith(stringArray)) {
                                swWebServerRequestType = SwWebServerRequestType.ERROR_PAGE_TEMPLATE;
                            } else {
                                stringArray = new String[]{"__ij-openapi-plugin", "errorHandler"};
                                if (this.pathStartsWith(stringArray)) {
                                    swWebServerRequestType = SwWebServerRequestType.ERROR_SCRIPT;
                                } else {
                                    stringArray = new String[]{"__ij-openapi-plugin"};
                                    swWebServerRequestType = this.pathStartsWith(stringArray) ? SwWebServerRequestType.LIBRARY_RESOURCE : null;
                                }
                            }
                        }
                    }
                }
            }
        }
        return swWebServerRequestType;
    }

    public final boolean pathStartsWith(String ... segments) {
        Intrinsics.checkNotNullParameter((Object)segments, (String)"segments");
        return this.doMatchPathSegments(Arrays.copyOf(segments, segments.length)).isMatch();
    }

    /*
     * WARNING - void declaration
     */
    private final UrlMatchResult doMatchPathSegments(String ... segments) {
        void $this$fold$iv;
        String[] stringArray = segments;
        UrlMatchResult initial$iv = this.initialiseUrlMatching();
        boolean $i$f$fold = false;
        UrlMatchResult accumulator$iv = initial$iv;
        int n = ((void)$this$fold$iv).length;
        for (int i = 0; i < n; ++i) {
            void nextSegment;
            void element$iv;
            void var9_9 = element$iv = $this$fold$iv[i];
            UrlMatchResult previousSegmentMatchResult = accumulator$iv;
            boolean bl = false;
            accumulator$iv = this.withNextSegment(previousSegmentMatchResult, (String)nextSegment, previousSegmentMatchResult.getLastProcessedSegmentIndex() + 1);
        }
        return accumulator$iv;
    }

    private final String unmatchedTail(UrlMatchResult $this$unmatchedTail) {
        if (!$this$unmatchedTail.isMatch()) {
            return null;
        }
        int firstUnprocessedSegmentIndex = $this$unmatchedTail.getLastProcessedSegmentIndex() + 1;
        if (firstUnprocessedSegmentIndex >= this.pathSegments.size()) {
            return null;
        }
        return CollectionsKt.joinToString$default((Iterable)this.pathSegments.subList(firstUnprocessedSegmentIndex, this.pathSegments.size()), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
    }

    private final UrlMatchResult withNextSegment(UrlMatchResult $this$withNextSegment, String segment, int segmentIndexToCompare) {
        return $this$withNextSegment.isMatch() ? this.compareSegments(segment, segmentIndexToCompare) : $this$withNextSegment;
    }

    private final UrlMatchResult compareSegments(String expectedSegment, int segmentIndexToCompare) {
        return this.pathSegments.size() <= segmentIndexToCompare ? this.failedMatch(segmentIndexToCompare) : (Intrinsics.areEqual((Object)this.pathSegments.get(segmentIndexToCompare), (Object)expectedSegment) ? this.successfulMatch(segmentIndexToCompare) : this.failedMatch(segmentIndexToCompare));
    }

    private final UrlMatchResult initialiseUrlMatching() {
        return new UrlMatchResult(-1, true);
    }

    private final UrlMatchResult failedMatch(int comparedIndex) {
        return new UrlMatchResult(comparedIndex, false);
    }

    private final UrlMatchResult successfulMatch(int comparedIndex) {
        return new UrlMatchResult(comparedIndex, true);
    }

    private final List<String> parsePath(String $this$parsePath) {
        char[] cArray = new char[]{'/'};
        CharSequence charSequence = StringsKt.trim((String)StringsKt.substringBefore$default((String)$this$parsePath, (char)'?', null, (int)2, null), (char[])cArray);
        cArray = new char[]{'/'};
        return StringsKt.split$default((CharSequence)charSequence, (char[])cArray, (boolean)false, (int)0, (int)6, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> parseParameters(String $this$parseParameters) {
        void $this$associateTo$iv$iv;
        char[] cArray = new char[]{'&'};
        Iterable $this$associate$iv = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)$this$parseParameters, (CharSequence)"?"), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            String it = (String)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)StringsKt.substringBefore$default((String)it, (char)'=', null, (int)2, null), (Object)StringsKt.substringAfter$default((String)it, (char)'=', null, (int)2, null));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/intellij/swagger/core/ui/rest/SwUrlParser$UrlMatchResult;", "", "lastProcessedSegmentIndex", "", "isMatch", "", "(IZ)V", "()Z", "getLastProcessedSegmentIndex", "()I", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "", "intellij.swagger.core"})
    private static final class UrlMatchResult {
        private final int lastProcessedSegmentIndex;
        private final boolean isMatch;

        public UrlMatchResult(int lastProcessedSegmentIndex, boolean isMatch) {
            this.lastProcessedSegmentIndex = lastProcessedSegmentIndex;
            this.isMatch = isMatch;
        }

        public final int getLastProcessedSegmentIndex() {
            return this.lastProcessedSegmentIndex;
        }

        public final boolean isMatch() {
            return this.isMatch;
        }

        public final int component1() {
            return this.lastProcessedSegmentIndex;
        }

        public final boolean component2() {
            return this.isMatch;
        }

        @NotNull
        public final UrlMatchResult copy(int lastProcessedSegmentIndex, boolean isMatch) {
            return new UrlMatchResult(lastProcessedSegmentIndex, isMatch);
        }

        public static /* synthetic */ UrlMatchResult copy$default(UrlMatchResult urlMatchResult, int n, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = urlMatchResult.lastProcessedSegmentIndex;
            }
            if ((n2 & 2) != 0) {
                bl = urlMatchResult.isMatch;
            }
            return urlMatchResult.copy(n, bl);
        }

        @NotNull
        public String toString() {
            return "UrlMatchResult(lastProcessedSegmentIndex=" + this.lastProcessedSegmentIndex + ", isMatch=" + this.isMatch + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.lastProcessedSegmentIndex);
            result2 = result2 * 31 + Boolean.hashCode(this.isMatch);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UrlMatchResult)) {
                return false;
            }
            UrlMatchResult urlMatchResult = (UrlMatchResult)other;
            if (this.lastProcessedSegmentIndex != urlMatchResult.lastProcessedSegmentIndex) {
                return false;
            }
            return this.isMatch == urlMatchResult.isMatch;
        }
    }
}

