/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.settings.ui;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.icons.AllIcons;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.SwaggerCoreIcons;
import com.intellij.swagger.core.hub.SwaggerHubManager;
import com.intellij.swagger.core.model.remote.RemoteSpecificationModel;
import com.intellij.swagger.core.settings.SwSettingsChangedListener;
import com.intellij.swagger.core.settings.SwaggerSettings;
import com.intellij.swagger.core.settings.SwaggerSettingsState;
import com.intellij.swagger.core.settings.UrlInfo;
import com.intellij.swagger.core.settings.ui.SwaggerConfigurable;
import com.intellij.swagger.core.settings.ui.SwaggerConfigurableKt;
import com.intellij.swagger.core.settings.ui.UrlsTableView;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010!\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0012H\u0002J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0017J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020\u0015H\u0002J\b\u0010!\u001a\u00020\u0015H\u0016J\b\u0010\"\u001a\u00020\u0015H\u0002J\b\u0010#\u001a\u00020\u0012H\u0016J\u0018\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00170%*\b\u0012\u0004\u0012\u00020\u00170%H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/swagger/core/settings/ui/SwaggerConfigurable;", "Lcom/intellij/openapi/options/Configurable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "hubTokenField", "Ljavax/swing/JPasswordField;", "localHubAddressField", "Lcom/intellij/ui/components/JBTextField;", "remoteSpecificationUrlsView", "Lcom/intellij/swagger/core/settings/ui/UrlsTableView;", "settings", "Lcom/intellij/swagger/core/settings/SwaggerSettings;", "getSettings", "()Lcom/intellij/swagger/core/settings/SwaggerSettings;", "visualEditingEnabledCB", "Lcom/intellij/ui/components/JBCheckBox;", "addUrl", "", "apply", "contentFilter", "", "urlInfo", "Lcom/intellij/swagger/core/settings/UrlInfo;", "copySettingsFromStorageToView", "copySettingsFromViewTo", "Lcom/intellij/swagger/core/settings/SwaggerSettingsState;", "createComponent", "Ljavax/swing/JComponent;", "getDisplayName", "", "getHelpTopic", "isHubTokenModified", "isModified", "needUpdateRemoteSpecificationsModel", "reset", "copyMeaningfulContents", "", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwaggerConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwaggerConfigurable.kt\ncom/intellij/swagger/core/settings/ui/SwaggerConfigurable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n1#2:194\n766#3:195\n857#3,2:196\n1549#3:198\n1620#3,3:199\n*S KotlinDebug\n*F\n+ 1 SwaggerConfigurable.kt\ncom/intellij/swagger/core/settings/ui/SwaggerConfigurable\n*L\n180#1:195\n180#1:196,2\n180#1:198\n180#1:199,3\n*E\n"})
public final class SwaggerConfigurable
implements Configurable {
    @NotNull
    private final Project project;
    private JBTextField localHubAddressField;
    private JBCheckBox visualEditingEnabledCB;
    @NotNull
    private final JPasswordField hubTokenField;
    @NotNull
    private final UrlsTableView remoteSpecificationUrlsView;

    public SwaggerConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.hubTokenField = new JPasswordField();
        this.remoteSpecificationUrlsView = new UrlsTableView(this.project);
    }

    private final SwaggerSettings getSettings() {
        return SwaggerSettings.Companion.getInstance(this.project);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return SwaggerBundle.message("settings.display.name", new Object[0]);
    }

    @NotNull
    public String getHelpTopic() {
        return "OpenAPI";
    }

    @NotNull
    public JComponent createComponent() {
        String string = SwaggerBundle.message("actions.reload.all.remote.specifications", new Object[0]);
        Icon icon = AllIcons.Actions.Refresh;
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)((JTable)((Object)this.remoteSpecificationUrlsView))).setAddIcon(LayeredIcon.ADD_WITH_DROPDOWN).setAddAction(arg_0 -> SwaggerConfigurable.createComponent$lambda$1(this, arg_0)).setRemoveAction(arg_0 -> SwaggerConfigurable.createComponent$lambda$2(this, arg_0)).disableUpDownActions().addExtraAction((AnAction)new DumbAwareAction(this, string, icon){
            final /* synthetic */ SwaggerConfigurable this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, null, $super_call_param$2);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                RemoteSpecificationModel.updateCachedRemoteSpecifications$default(RemoteSpecificationModel.Companion.getInstance(SwaggerConfigurable.access$getProject$p(this.this$0)), true, false, 2, null);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Presentation presentation = e.getPresentation();
                List list = SwaggerConfigurable.access$getRemoteSpecificationUrlsView$p(this.this$0).getItems();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
                presentation.setEnabled(!((Collection)list).isEmpty());
            }
        }).setVisibleRowCount(6).createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        JPanel remoteSpecificationUrlsPanel2 = jPanel;
        return (JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this, remoteSpecificationUrlsPanel2){
            final /* synthetic */ SwaggerConfigurable this$0;
            final /* synthetic */ JPanel $remoteSpecificationUrlsPanel;
            {
                this.this$0 = $receiver;
                this.$remoteSpecificationUrlsPanel = $remoteSpecificationUrlsPanel;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.group$default((Panel)$this$panel, (String)SwaggerBundle.message("settings.editor.features.title", new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Panel, Unit>(this.this$0){
                    final /* synthetic */ SwaggerConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$group) {
                        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
                        Panel.row$default((Panel)$this$group, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ SwaggerConfigurable this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                SwaggerConfigurable.access$setVisualEditingEnabledCB$p(this.this$0, (JBCheckBox)$this$row.checkBox(SwaggerBundle.message("settings.editor.visual.editing", new Object[0])).getComponent());
                            }
                        }), (int)1, null);
                    }
                }), (int)2, null);
                Panel.group$default((Panel)$this$panel, (String)SwaggerBundle.message("settings.hub.title", new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Panel, Unit>(this.this$0){
                    final /* synthetic */ SwaggerConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$group) {
                        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
                        $this$group.row(SwaggerBundle.message("settings.hub.custom.host", new Object[0]) + ":", (Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ SwaggerConfigurable this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                SwaggerConfigurable.access$setLocalHubAddressField$p(this.this$0, (JBTextField)Cell.comment$default((Cell)$this$row.textField().align((Align)AlignX.FILL.INSTANCE), (String)SwaggerBundle.message("settings.hub.custom.host.info", new Object[0]), (int)0, null, (int)6, null).applyToComponent((Function1)createComponent.1.INSTANCE).getComponent());
                            }
                        });
                        $this$group.row(SwaggerBundle.message("settings.hub.token.field.label", new Object[0]), (Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ SwaggerConfigurable this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                Cell.comment$default((Cell)$this$row.cell((JComponent)SwaggerConfigurable.access$getHubTokenField$p(this.this$0)).align((Align)AlignX.FILL.INSTANCE), (String)SwaggerBundle.message("settings.hub.token.field.comment", new Object[0]), (int)0, null, (int)6, null);
                            }
                        });
                    }
                }), (int)2, null);
                Panel.group$default((Panel)$this$panel, (String)SwaggerBundle.message("settings.remote.specifications.title", new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Panel, Unit>(this.$remoteSpecificationUrlsPanel){
                    final /* synthetic */ JPanel $remoteSpecificationUrlsPanel;
                    {
                        this.$remoteSpecificationUrlsPanel = $remoteSpecificationUrlsPanel;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$group) {
                        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
                        Panel.row$default((Panel)$this$group, null, (Function1)((Function1)new Function1<Row, Unit>(this.$remoteSpecificationUrlsPanel){
                            final /* synthetic */ JPanel $remoteSpecificationUrlsPanel;
                            {
                                this.$remoteSpecificationUrlsPanel = $remoteSpecificationUrlsPanel;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                Cell.comment$default((Cell)$this$row.cell((JComponent)this.$remoteSpecificationUrlsPanel).align(Align.FILL), (String)SwaggerBundle.message("settings.remote.specifications.hint.text", new Object[0]), (int)0, null, (int)6, null);
                            }
                        }), (int)1, null).resizableRow();
                    }
                }), (int)2, null).resizableRow();
            }
        }));
    }

    public boolean isModified() {
        SwaggerSettingsState swaggerSettingsState;
        SwaggerSettingsState it = swaggerSettingsState = new SwaggerSettingsState();
        boolean bl = false;
        this.copySettingsFromViewTo(it);
        return !Intrinsics.areEqual((Object)((Object)swaggerSettingsState), (Object)this.getSettings().getState()) || this.isHubTokenModified();
    }

    public void apply() {
        boolean needUpdate = this.needUpdateRemoteSpecificationsModel();
        this.copySettingsFromViewTo((SwaggerSettingsState)this.getSettings().getState());
        PasswordSafe passwordSafe = PasswordSafe.Companion.getInstance();
        CredentialAttributes credentialAttributes = SwaggerHubManager.INSTANCE.getPASSWORD_SAFE_ATTRIBUTES$intellij_swagger_core();
        char[] cArray = this.hubTokenField.getPassword();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
        char[] cArray2 = cArray;
        passwordSafe.setPassword(credentialAttributes, new String(cArray2));
        if (needUpdate) {
            RemoteSpecificationModel.updateCachedRemoteSpecifications$default(RemoteSpecificationModel.Companion.getInstance(this.project), false, false, 2, null);
        }
        ((SwSettingsChangedListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SwSettingsChangedListener.Companion.getTOPIC())).settingsChanged(this.getSettings());
    }

    public void reset() {
        this.copySettingsFromStorageToView();
    }

    private final boolean isHubTokenModified() {
        Credentials credentials;
        Credentials credentials2 = credentials = PasswordSafe.Companion.getInstance().get(SwaggerHubManager.INSTANCE.getPASSWORD_SAFE_ATTRIBUTES$intellij_swagger_core());
        if ((credentials2 != null ? credentials2.getPassword() : null) == null) {
            char[] cArray = this.hubTokenField.getPassword();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
            if (cArray.length == 0) {
                return false;
            }
        }
        return !Intrinsics.areEqual((Object)new Credentials(null, this.hubTokenField.getPassword()), (Object)credentials);
    }

    private final boolean needUpdateRemoteSpecificationsModel() {
        List fromView;
        List<UrlInfo> fromSettings = ((SwaggerSettingsState)this.getSettings().getState()).getRemoteSpecificationUrls();
        return !Intrinsics.areEqual(fromSettings, (Object)(fromView = this.remoteSpecificationUrlsView.getItems()));
    }

    private final void addUrl() {
        UrlsTableView.addUrl$default(this.remoteSpecificationUrlsView, null, 1, null);
    }

    private final void copySettingsFromViewTo(SwaggerSettingsState settings) {
        List<UrlInfo> $this$copySettingsFromViewTo_u24lambda_u244 = settings.getRemoteSpecificationUrls();
        boolean bl = false;
        $this$copySettingsFromViewTo_u24lambda_u244.clear();
        List list = this.remoteSpecificationUrlsView.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        $this$copySettingsFromViewTo_u24lambda_u244.addAll((Collection<UrlInfo>)this.copyMeaningfulContents(list));
        JBTextField jBTextField = this.localHubAddressField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localHubAddressField");
            jBTextField = null;
        }
        settings.setLocalHubAddress(jBTextField.getText());
        JBCheckBox jBCheckBox = this.visualEditingEnabledCB;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"visualEditingEnabledCB");
            jBCheckBox = null;
        }
        settings.setVisualEditingEnabled(jBCheckBox.isSelected());
    }

    private final void copySettingsFromStorageToView() {
        String string;
        this.remoteSpecificationUrlsView.setUrls(this.copyMeaningfulContents(((SwaggerSettingsState)this.getSettings().getState()).getRemoteSpecificationUrls()));
        JBTextField jBTextField = this.localHubAddressField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localHubAddressField");
            jBTextField = null;
        }
        if ((string = ((SwaggerSettingsState)this.getSettings().getState()).getLocalHubAddress()) == null) {
            string = "";
        }
        jBTextField.setText(string);
        JBCheckBox jBCheckBox = this.visualEditingEnabledCB;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"visualEditingEnabledCB");
            jBCheckBox = null;
        }
        jBCheckBox.setSelected(((SwaggerSettingsState)this.getSettings().getState()).getVisualEditingEnabled());
        String string2 = SwaggerHubManager.INSTANCE.retrieveToken();
        if (string2 == null) {
            string2 = "";
        }
        this.hubTokenField.setText(string2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<UrlInfo> copyMeaningfulContents(List<UrlInfo> $this$copyMeaningfulContents) {
        void $this$mapTo$iv$iv;
        UrlInfo p0;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$copyMeaningfulContents;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            p0 = (UrlInfo)element$iv$iv;
            boolean bl = false;
            if (!this.contentFilter(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            p0 = (UrlInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UrlInfo.copy$default((UrlInfo)it, null, 1, null));
        }
        Collection collection = (List)destination$iv$iv;
        return new ArrayList(collection);
    }

    private final boolean contentFilter(UrlInfo urlInfo) {
        CharSequence charSequence = urlInfo.getUrlString();
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
    }

    private static final void createComponent$lambda$1(SwaggerConfigurable this$0, AnActionButton it) {
        DefaultActionGroup defaultActionGroup;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DefaultActionGroup $this$createComponent_u24lambda_u241_u24lambda_u240 = defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        String string = SwaggerBundle.message("settings.remote.specification.add.url", new Object[0]);
        Icon icon = AllIcons.Nodes.PpWeb;
        $this$createComponent_u24lambda_u241_u24lambda_u240.add((AnAction)new DumbAwareAction(this$0, string, icon){
            final /* synthetic */ SwaggerConfigurable this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, null, $super_call_param$2);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SwaggerConfigurable.access$addUrl(this.this$0);
            }
        });
        string = SwaggerBundle.message("settings.remote.specification.add.from.hub", new Object[0]);
        icon = SwaggerCoreIcons.Swagger;
        $this$createComponent_u24lambda_u241_u24lambda_u240.add((AnAction)new DumbAwareAction(this$0, string, icon){
            final /* synthetic */ SwaggerConfigurable this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, null, $super_call_param$2);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SwaggerConfigurableKt.showSwaggerHubSearchDialog(SwaggerConfigurable.access$getProject$p(this.this$0), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this.this$0){
                    final /* synthetic */ SwaggerConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull String url2) {
                        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
                        SwaggerConfigurable.access$getRemoteSpecificationUrlsView$p(this.this$0).addUrl(url2);
                    }
                }));
            }
        });
        DefaultActionGroup group2 = defaultActionGroup;
        JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group2, it.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false).show(it.getPreferredPopupPoint());
    }

    private static final void createComponent$lambda$2(SwaggerConfigurable this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        TableUtil.removeSelectedItems((JTable)((JTable)((Object)this$0.remoteSpecificationUrlsView)));
    }

    public static final /* synthetic */ Project access$getProject$p(SwaggerConfigurable $this) {
        return $this.project;
    }

    public static final /* synthetic */ UrlsTableView access$getRemoteSpecificationUrlsView$p(SwaggerConfigurable $this) {
        return $this.remoteSpecificationUrlsView;
    }

    public static final /* synthetic */ void access$setVisualEditingEnabledCB$p(SwaggerConfigurable $this, JBCheckBox jBCheckBox) {
        $this.visualEditingEnabledCB = jBCheckBox;
    }

    public static final /* synthetic */ void access$setLocalHubAddressField$p(SwaggerConfigurable $this, JBTextField jBTextField) {
        $this.localHubAddressField = jBTextField;
    }

    public static final /* synthetic */ JPasswordField access$getHubTokenField$p(SwaggerConfigurable $this) {
        return $this.hubTokenField;
    }

    public static final /* synthetic */ void access$addUrl(SwaggerConfigurable $this) {
        $this.addUrl();
    }
}

