/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.remote;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.json.JsonFileType;
import com.intellij.microservices.endpoints.EndpointsViewListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.swagger.core.FileCoordinates;
import com.intellij.swagger.core.SwDownloadManager;
import com.intellij.swagger.core.SwDownloadableFileType;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.model.remote.RemoteSpecificationFile;
import com.intellij.swagger.core.model.remote.openapi.v3.Openapi3RemoteSpecificationFile;
import com.intellij.swagger.core.model.remote.openapi.v31.Openapi31RemoteSpecificationFile;
import com.intellij.swagger.core.model.remote.swagger.v2.Swagger2RemoteSpecificationFile;
import com.intellij.swagger.core.model.specification.SwSpecificationFile;
import com.intellij.swagger.core.model.specification.SwaggerFileHelper;
import com.intellij.swagger.core.notifications.SwaggerNotifications;
import com.intellij.swagger.core.remote.RemoteSpecificationEnricher;
import com.intellij.swagger.core.remote.RemoteSpecificationManager;
import com.intellij.swagger.core.remote.RemoteSpecificationManagerKt;
import com.intellij.swagger.core.settings.SwaggerSettings;
import com.intellij.swagger.core.settings.SwaggerSettingsState;
import com.intellij.swagger.core.settings.UrlInfo;
import com.intellij.util.Url;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010\u0018\u001a\f\u0012\u0006\b\u0001\u0012\u00020\b\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J:\u0010\u001c\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u001a\b\u0002\u0010\u001d\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\u00130\u001eJ\u0018\u0010\u001f\u001a\u0004\u0018\u00010\b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/swagger/core/remote/RemoteSpecificationManager;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "downloadFilesAndNotify", "", "Lcom/intellij/swagger/core/model/specification/SwSpecificationFile;", "rawSpecificationUrls", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "force", "", "notify", "project", "Lcom/intellij/openapi/project/Project;", "fireSpecificationsAdded", "", "guessMapperByFileType", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "guessSpecificationClass", "Ljava/lang/Class;", "specificationType", "Lcom/intellij/swagger/core/SwSpecificationType;", "queueUpdateRemoteSpecifications", "onFinishHandler", "Lkotlin/Function1;", "tryParseSpecification", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "Lcom/intellij/util/Url;", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nRemoteSpecificationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteSpecificationManager.kt\ncom/intellij/swagger/core/remote/RemoteSpecificationManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,141:1\n1603#2,9:142\n1855#2:151\n1856#2:153\n1612#2:154\n1603#2,9:155\n1855#2:164\n1856#2:166\n1612#2:167\n1549#2:168\n1620#2,3:169\n1603#2,9:172\n1855#2:181\n1856#2:183\n1612#2:184\n1#3:152\n1#3:165\n1#3:182\n1#3:187\n11#4:185\n14#5:186\n*S KotlinDebug\n*F\n+ 1 RemoteSpecificationManager.kt\ncom/intellij/swagger/core/remote/RemoteSpecificationManager\n*L\n40#1:142,9\n40#1:151\n40#1:153\n40#1:154\n62#1:155,9\n62#1:164\n62#1:166\n62#1:167\n65#1:168\n65#1:169,3\n66#1:172,9\n66#1:181\n66#1:183\n66#1:184\n40#1:152\n62#1:165\n66#1:182\n87#1:185\n105#1:186\n*E\n"})
public final class RemoteSpecificationManager {
    @NotNull
    public static final RemoteSpecificationManager INSTANCE = new RemoteSpecificationManager();
    @NotNull
    private static final Logger LOG;

    private RemoteSpecificationManager() {
    }

    /*
     * WARNING - void declaration
     */
    public final void queueUpdateRemoteSpecifications(boolean force, boolean notify, @NotNull Project project, @NotNull Function1<? super List<? extends SwSpecificationFile>, Unit> onFinishHandler) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(onFinishHandler, (String)"onFinishHandler");
        Iterable $this$mapNotNull$iv = ((SwaggerSettingsState)SwaggerSettings.Companion.getInstance(project).getState()).getRemoteSpecificationUrls();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            UrlInfo it = (UrlInfo)element$iv$iv;
            boolean bl2 = false;
            if (it.getUrlString() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List urls2 = (List)destination$iv$iv;
        String string = SwaggerBundle.message("actions.reload.all.remote.specifications.title", new Object[0]);
        new Task.Backgroundable(project, urls2, onFinishHandler, force, notify, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ List<String> $urls;
            final /* synthetic */ Function1<List<? extends SwSpecificationFile>, Unit> $onFinishHandler;
            final /* synthetic */ boolean $force;
            final /* synthetic */ boolean $notify;
            {
                this.$project = $project;
                this.$urls = $urls;
                this.$onFinishHandler = $onFinishHandler;
                this.$force = $force;
                this.$notify = $notify;
                super($project, $super_call_param$1, true);
            }

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Iterable $this$mapNotNull$iv = this.$urls;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Object object = $this$forEach$iv$iv$iv.iterator();
                while (object.hasNext()) {
                    FileCoordinates it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = object.next();
                    boolean bl = false;
                    String it = (String)element$iv$iv;
                    boolean bl2 = false;
                    if (SwDownloadManager.calculateLocalUrlFromRemote$default(SwDownloadManager.INSTANCE, it, SwDownloadableFileType.REMOTE_SPECIFICATION, false, 4, null) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List filesToDownload = (List)destination$iv$iv;
                $this$mapNotNull$iv = filesToDownload;
                SwDownloadManager swDownloadManager = SwDownloadManager.INSTANCE;
                boolean $i$f$map = false;
                $this$mapNotNullTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    object = (FileCoordinates)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getPath().toFile());
                }
                swDownloadManager.deleteOutdatedDownloads(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)), SwDownloadableFileType.REMOTE_SPECIFICATION);
                this.$onFinishHandler.invoke((Object)RemoteSpecificationManager.access$downloadFilesAndNotify(RemoteSpecificationManager.INSTANCE, this.$urls, indicator, this.$force, this.$notify, this.$project));
            }
        }.queue();
    }

    public static /* synthetic */ void queueUpdateRemoteSpecifications$default(RemoteSpecificationManager remoteSpecificationManager, boolean bl, boolean bl2, Project project, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            function1 = queueUpdateRemoteSpecifications.1.INSTANCE;
        }
        remoteSpecificationManager.queueUpdateRemoteSpecifications(bl, bl2, project, (Function1<? super List<? extends SwSpecificationFile>, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SwSpecificationFile> downloadFilesAndNotify(List<String> rawSpecificationUrls, ProgressIndicator progressIndicator, boolean force, boolean notify, Project project) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNull$iv2;
        Iterable iterable = rawSpecificationUrls;
        boolean $i$f$mapNotNull22 = false;
        void var9_9 = $this$mapNotNull$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            FileCoordinates it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (SwDownloadManager.calculateLocalUrlFromRemote$default(SwDownloadManager.INSTANCE, it, SwDownloadableFileType.REMOTE_SPECIFICATION, false, 4, null) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List filesToDownload = (List)destination$iv$iv;
        Iterable $i$f$mapNotNull22 = filesToDownload;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            element$iv$iv$iv = (FileCoordinates)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)SwDownloadManager.INSTANCE.downloadFile((FileCoordinates)it, progressIndicator, force), (Object)it.getRemoteUrl()));
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            SwSpecificationFile it$iv$iv;
            Object element$iv$iv$iv2;
            Object element$iv$iv = element$iv$iv$iv2 = iterator2.next();
            boolean bl = false;
            Pair pair = (Pair)element$iv$iv;
            boolean bl4 = false;
            VirtualFile virtualFile2 = (VirtualFile)pair.component1();
            Url url2 = (Url)pair.component2();
            VirtualFile virtualFile3 = virtualFile2;
            if ((virtualFile3 != null ? INSTANCE.tryParseSpecification(virtualFile3, url2) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List processedSpecifications = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
        if (notify && !((Collection)rawSpecificationUrls).isEmpty()) {
            if (processedSpecifications.size() == rawSpecificationUrls.size()) {
                SwaggerNotifications.INSTANCE.notifySuccessfulSpecificationsLoading$intellij_swagger_core(processedSpecifications, project);
            } else {
                SwaggerNotifications.INSTANCE.notifyFailedSpecificationsLoading$intellij_swagger_core(processedSpecifications.size(), rawSpecificationUrls.size(), project);
            }
        }
        this.fireSpecificationsAdded(project);
        return processedSpecifications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final SwSpecificationFile tryParseSpecification(@NotNull VirtualFile file2, @NotNull Url url2) {
        Object object;
        block12: {
            RemoteSpecificationFile remoteSpecificationFile;
            RemoteSpecificationFile remoteSpecificationFile2;
            RemoteSpecificationFile remoteSpecificationFile3;
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
            SwSpecificationType specificationKind = SwaggerFileHelper.computeSpecificationType$intellij_swagger_core$default(SwaggerFileHelper.INSTANCE, file2, null, 2, null);
            FileType fileType = file2.getFileType();
            Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
            ObjectMapper objectMapper = this.guessMapperByFileType(fileType);
            if (objectMapper == null) {
                return null;
            }
            ObjectMapper mapper = objectMapper;
            Class<? extends SwSpecificationFile> specificationClass = this.guessSpecificationClass(specificationKind);
            if (specificationClass == null) {
                boolean $i$f$logger = false;
                Logger logger2 = Logger.getInstance(RemoteSpecificationManager.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                logger2.warn("Unable to determine specification type for file with url: '" + url2.toDecodedForm() + "'");
                return null;
            }
            object = new InputStreamReader(file2.getInputStream());
            Throwable throwable = null;
            try {
                SwSpecificationFile swSpecificationFile;
                Object it = (InputStreamReader)object;
                boolean bl = false;
                try {
                    swSpecificationFile = (SwSpecificationFile)mapper.readValue((Reader)it, specificationClass);
                }
                catch (IOException ex) {
                    if (!(ex instanceof JsonParseException) && !(ex instanceof JsonMappingException)) {
                        throw ex;
                    }
                    LOG.warn("Unable to read " + specificationKind + " specification into " + specificationClass + " class", (Throwable)ex);
                    swSpecificationFile = null;
                }
                it = swSpecificationFile;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            Object it = object = it;
            boolean bl = false;
            Object $this$asSafely$iv = it;
            boolean $i$f$asSafely = false;
            Object object2 = $this$asSafely$iv;
            if (!(object2 instanceof RemoteSpecificationFile)) {
                object2 = null;
            }
            if ((remoteSpecificationFile3 = (RemoteSpecificationFile)object2) == null || (remoteSpecificationFile2 = RemoteSpecificationEnricher.INSTANCE.withExternalUrl(remoteSpecificationFile3, url2)) == null || (remoteSpecificationFile = RemoteSpecificationEnricher.INSTANCE.withVirtualFile(remoteSpecificationFile2, file2)) == null) break block12;
            FileType fileType2 = file2.getFileType();
            Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileType(...)");
            RemoteSpecificationEnricher.INSTANCE.reformatAndWriteToTheDisk(remoteSpecificationFile, INSTANCE.guessMapperByFileType(fileType2));
        }
        return object;
    }

    private final void fireSpecificationsAdded(Project project) {
        block0: {
            EndpointsViewListener endpointsViewListener;
            Project project2;
            Project project3;
            Project it = project3 = project;
            boolean bl = false;
            Object object = project2 = !it.isDisposed() ? project3 : null;
            if (project2 == null || (project3 = project2.getMessageBus()) == null || (endpointsViewListener = (EndpointsViewListener)project3.syncPublisher(EndpointsViewListener.Companion.getTOPIC())) == null) break block0;
            endpointsViewListener.endpointsChanged(new EndpointsViewListener.ChangeEvent(project, EndpointsViewListener.ChangeType.ITEMS));
        }
    }

    private final ObjectMapper guessMapperByFileType(FileType fileType) {
        FileType fileType2 = fileType;
        return fileType2 instanceof JsonFileType ? RemoteSpecificationManagerKt.access$getJsonMapper() : (fileType2 instanceof YAMLFileType ? RemoteSpecificationManagerKt.access$getYamlMapper() : null);
    }

    private final Class<? extends SwSpecificationFile> guessSpecificationClass(SwSpecificationType specificationType2) {
        SwSpecificationType swSpecificationType = specificationType2;
        return swSpecificationType instanceof SwSpecificationType.Swagger2Family ? Swagger2RemoteSpecificationFile.class : (swSpecificationType instanceof SwSpecificationType.OPENAPI_3 ? Openapi3RemoteSpecificationFile.class : (swSpecificationType instanceof SwSpecificationType.OPENAPI_3_1 ? Openapi31RemoteSpecificationFile.class : null));
    }

    public static final /* synthetic */ List access$downloadFilesAndNotify(RemoteSpecificationManager $this, List rawSpecificationUrls, ProgressIndicator progressIndicator, boolean force, boolean notify, Project project) {
        return $this.downloadFilesAndNotify(rawSpecificationUrls, progressIndicator, force, notify, project);
    }

    static {
        Logger logger2 = Logger.getInstance(RemoteSpecificationManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }
}

