/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.model.specification;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.json.JsonFileType;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.swagger.core.SwaggerUtilsKt;
import com.intellij.swagger.core.index.OpenapiSpecificationContentIndexKt;
import com.intellij.swagger.core.index.SwIndexUtilsKt;
import com.intellij.swagger.core.model.SwSecondarySpecificationModelComputationKt;
import com.intellij.swagger.core.model.SwUserDefinedSpecifications;
import com.intellij.swagger.core.model.specification.SwSpecificationFile;
import com.intellij.swagger.core.model.specification.SwaggerFileHelper;
import com.intellij.swagger.core.model.specification.SwaggerFileHelperKt;
import com.intellij.swagger.core.model.specification.asyncapi.AsyncapiSpecificationFile;
import com.intellij.swagger.core.model.specification.light.LightSpecificationFileUtils;
import com.intellij.swagger.core.model.specification.openapi.v3.Openapi3LightSpecificationFile;
import com.intellij.swagger.core.model.specification.openapi.v31.Openapi31LightSpecificationFile;
import com.intellij.swagger.core.model.specification.swagger.v2.Swagger2LightSpecificationFile;
import com.intellij.swagger.core.traverser.SwTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0011J!\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0000\u00a2\u0006\u0002\b\u0018J4\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u001a\u001a\u00020\u00122\b\b\u0002\u0010\u001b\u001a\u00020\u0012J%\u0010\u001c\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b J\u001d\u0010!\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\"J0\u0010#\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u001a\u001a\u00020\u00122\b\b\u0002\u0010\u001b\u001a\u00020\u0012J\u001d\u0010$\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\b'J\u001a\u0010(\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u001a\u0010)\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u001a\u0010*\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0018\u0010+\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\"\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u001a\u0010/\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0015\u00100\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b1J\u001a\u00102\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002R-\u0010\u0003\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0007*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/swagger/core/model/specification/SwaggerFileHelper;", "", "()V", "SPECIFICATION_TYPE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "Lcom/intellij/swagger/core/SwSpecificationType;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "collectSpecificationFiles", "Lkotlin/sequences/Sequence;", "Lcom/intellij/swagger/core/model/specification/SwSpecificationFile;", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "specificationFilter", "Lkotlin/Function1;", "", "computeSpecificationType", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "psiFile", "Lcom/intellij/psi/PsiFile;", "computeSpecificationType$intellij_swagger_core", "createSpecificationFile", "isLight", "isRemote", "getOrComputePrimarySpecificationType", "getOrComputePrimarySpecificationType$intellij_swagger_core", "getOrComputeSecondarySpecificationType", "specificationPart", "getOrComputeSecondarySpecificationType$intellij_swagger_core", "getOrComputeSpecificationType", "getOrComputeSpecificationType$intellij_swagger_core", "getSpecificationFileFor", "getUserDefinedSpecificationType", "fileUrl", "", "getUserDefinedSpecificationType$intellij_swagger_core", "isAsyncapi2File", "isOpenapi31File", "isOpenapi3File", "isSpecificationFastCheck", "isSpecificationFileOfKind", "specificationVersionPattern", "Lkotlin/text/Regex;", "isSuitableFile", "isSuitableFileType", "isSuitableFileType$intellij_swagger_core", "isSwagger2File", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwaggerFileHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwaggerFileHelper.kt\ncom/intellij/swagger/core/model/specification/SwaggerFileHelper\n+ 2 SwTreeUtil.kt\ncom/intellij/swagger/core/traverser/SwTreeUtil\n+ 3 SwaggerCacheUtils.kt\ncom/intellij/swagger/core/SwaggerCacheUtilsKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n35#2,2:177\n22#3,4:179\n13#3,4:183\n31#4,2:187\n1#5:189\n*S KotlinDebug\n*F\n+ 1 SwaggerFileHelper.kt\ncom/intellij/swagger/core/model/specification/SwaggerFileHelper\n*L\n73#1:177,2\n113#1:179,4\n120#1:183,4\n126#1:187,2\n*E\n"})
public final class SwaggerFileHelper {
    @NotNull
    public static final SwaggerFileHelper INSTANCE = new SwaggerFileHelper();
    @NotNull
    private static final Key<CachedValue<SwSpecificationType>> SPECIFICATION_TYPE_KEY;

    private SwaggerFileHelper() {
    }

    @NotNull
    public final Sequence<SwSpecificationFile> collectSpecificationFiles(@NotNull Project project, @NotNull GlobalSearchScope searchScope, @NotNull Function1<? super SwSpecificationFile, Boolean> specificationFilter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        Intrinsics.checkNotNullParameter(specificationFilter, (String)"specificationFilter");
        return SequencesKt.filter((Sequence)SequencesKt.mapNotNull(OpenapiSpecificationContentIndexKt.getAllOpenApiIndexedFiles(searchScope), (Function1)((Function1)new Function1<VirtualFile, SwSpecificationFile>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            @Nullable
            public final SwSpecificationFile invoke(@NotNull VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return SwaggerFileHelper.getSpecificationFileFor$default(SwaggerFileHelper.INSTANCE, it, this.$project, false, false, 12, null);
            }
        })), (Function1)((Function1)new Function1<SwSpecificationFile, Boolean>(specificationFilter){
            final /* synthetic */ Function1<SwSpecificationFile, Boolean> $specificationFilter;
            {
                this.$specificationFilter = $specificationFilter;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull SwSpecificationFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (Boolean)this.$specificationFilter.invoke((Object)it);
            }
        }));
    }

    public static /* synthetic */ Sequence collectSpecificationFiles$default(SwaggerFileHelper swaggerFileHelper, Project project, GlobalSearchScope globalSearchScope, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = collectSpecificationFiles.1.INSTANCE;
        }
        return swaggerFileHelper.collectSpecificationFiles(project, globalSearchScope, (Function1<? super SwSpecificationFile, Boolean>)function1);
    }

    @Nullable
    public final SwSpecificationFile getSpecificationFileFor(@Nullable VirtualFile virtualFile2, @Nullable Project project, boolean isLight, boolean isRemote) {
        if (virtualFile2 == null || project == null || !virtualFile2.isValid()) {
            return null;
        }
        PsiFile psiFile2 = PsiManager.getInstance((Project)project).findFile(virtualFile2);
        if (psiFile2 == null) {
            return null;
        }
        PsiFile psiFile3 = psiFile2;
        return this.createSpecificationFile(psiFile3, virtualFile2, project, isLight, isRemote);
    }

    public static /* synthetic */ SwSpecificationFile getSpecificationFileFor$default(SwaggerFileHelper swaggerFileHelper, VirtualFile virtualFile2, Project project, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return swaggerFileHelper.getSpecificationFileFor(virtualFile2, project, bl, bl2);
    }

    @Nullable
    public final SwSpecificationFile createSpecificationFile(@NotNull PsiFile psiFile2, @NotNull VirtualFile virtualFile2, @NotNull Project project, boolean isLight, boolean isRemote) {
        SwSpecificationType specificationType2;
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SwSpecificationType swSpecificationType = specificationType2 = isLight ? OpenapiSpecificationContentIndexKt.getIndexedSpecificationType(virtualFile2, project) : this.getOrComputePrimarySpecificationType$intellij_swagger_core(project, psiFile2, virtualFile2);
        if (!isLight) {
            SwTreeUtil $this$iv = SwTreeUtil.INSTANCE;
            boolean withSelf$iv = true;
            boolean $i$f$getParentOfType = false;
            return $this$iv.getParentOfType((PsiElement)psiFile2, SwSpecificationFile.class, withSelf$iv);
        }
        SmartPsiElementPointer<PsiElement> pointer = SwaggerUtilsKt.createPointer((PsiElement)psiFile2);
        SwSpecificationType swSpecificationType2 = specificationType2;
        return swSpecificationType2 instanceof SwSpecificationType.Swagger2Family ? (SwSpecificationFile)new Swagger2LightSpecificationFile(pointer, isRemote) : (swSpecificationType2 instanceof SwSpecificationType.OpenAPI30Family ? (SwSpecificationFile)new Openapi3LightSpecificationFile(pointer, isRemote) : (swSpecificationType2 instanceof SwSpecificationType.OpenAPI31Family ? (SwSpecificationFile)new Openapi31LightSpecificationFile(pointer, isRemote) : (swSpecificationType2 instanceof SwSpecificationType.AsyncAPIFamily ? (SwSpecificationFile)new AsyncapiSpecificationFile(pointer) : null)));
    }

    public static /* synthetic */ SwSpecificationFile createSpecificationFile$default(SwaggerFileHelper swaggerFileHelper, PsiFile psiFile2, VirtualFile virtualFile2, Project project, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return swaggerFileHelper.createSpecificationFile(psiFile2, virtualFile2, project, bl, bl2);
    }

    @NotNull
    public final SwSpecificationType computeSpecificationType$intellij_swagger_core(@NotNull VirtualFile virtualFile2, @Nullable PsiFile psiFile2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        return !this.isSuitableFile(virtualFile2, psiFile2) ? (SwSpecificationType)SwSpecificationType.UNKNOWN.INSTANCE : (this.isSwagger2File(virtualFile2, psiFile2) ? (SwSpecificationType)SwSpecificationType.SWAGGER_2.INSTANCE : (this.isOpenapi3File(virtualFile2, psiFile2) ? (SwSpecificationType)SwSpecificationType.OPENAPI_3.INSTANCE : (this.isOpenapi31File(virtualFile2, psiFile2) ? (SwSpecificationType)SwSpecificationType.OPENAPI_3_1.INSTANCE : (this.isAsyncapi2File(virtualFile2, psiFile2) ? (SwSpecificationType)SwSpecificationType.ASYNCAPI_2_6.INSTANCE : (SwSpecificationType)SwSpecificationType.UNKNOWN.INSTANCE))));
    }

    public static /* synthetic */ SwSpecificationType computeSpecificationType$intellij_swagger_core$default(SwaggerFileHelper swaggerFileHelper, VirtualFile virtualFile2, PsiFile psiFile2, int n, Object object) {
        if ((n & 2) != 0) {
            psiFile2 = null;
        }
        return swaggerFileHelper.computeSpecificationType$intellij_swagger_core(virtualFile2, psiFile2);
    }

    @NotNull
    public final SwSpecificationType getOrComputeSpecificationType$intellij_swagger_core(@NotNull VirtualFile virtualFile2, @NotNull PsiFile psiFile2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        SwSpecificationType givenSpecificationType = LightSpecificationFileUtils.INSTANCE.getGivenSpecificationType$intellij_swagger_core(psiFile2);
        if (givenSpecificationType != null) {
            return givenSpecificationType;
        }
        Project project = psiFile2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (!this.isSuitableFileType$intellij_swagger_core(virtualFile2)) {
            return SwSpecificationType.UNKNOWN.INSTANCE;
        }
        String string = virtualFile2.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        SwSpecificationType userDefinedSpecificationType = this.getUserDefinedSpecificationType$intellij_swagger_core(project2, string);
        if (!(userDefinedSpecificationType instanceof SwSpecificationType.UNKNOWN)) {
            return userDefinedSpecificationType;
        }
        SwSpecificationType primaryType = this.getOrComputePrimarySpecificationType$intellij_swagger_core(project2, psiFile2, virtualFile2);
        if (!(primaryType instanceof SwSpecificationType.UNKNOWN)) {
            return primaryType;
        }
        return this.getOrComputeSecondarySpecificationType$intellij_swagger_core(psiFile2);
    }

    @NotNull
    public final SwSpecificationType getOrComputePrimarySpecificationType$intellij_swagger_core(@NotNull Project project, @NotNull PsiFile psiFile2, @NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Key<CachedValue<SwSpecificationType>> key$iv = SPECIFICATION_TYPE_KEY;
        boolean $i$f$cacheOnFileTypeTracker = false;
        return (SwSpecificationType)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)psiFile2, key$iv, new CachedValueProvider(project, virtualFile2, psiFile2){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $virtualFile$inlined;
            final /* synthetic */ PsiFile $psiFile$inlined;
            {
                this.$project = $project;
                this.$virtualFile$inlined = virtualFile2;
                this.$psiFile$inlined = psiFile2;
            }

            @Nullable
            public final CachedValueProvider.Result<T> compute() {
                boolean bl = false;
                SwSpecificationType result2 = SwaggerFileHelper.INSTANCE.computeSpecificationType$intellij_swagger_core(this.$virtualFile$inlined, this.$psiFile$inlined);
                Object[] objectArray = new Object[]{SwaggerUtilsKt.getYamlJsonModificationTracker(this.$project)};
                return new CachedValueProvider.Result((Object)result2, objectArray);
            }
        }, false);
    }

    @NotNull
    public final SwSpecificationType getOrComputeSecondarySpecificationType$intellij_swagger_core(@NotNull PsiFile specificationPart) {
        Intrinsics.checkNotNullParameter((Object)specificationPart, (String)"specificationPart");
        Project project = specificationPart.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (SwIndexUtilsKt.isIndexingRightNow(project)) {
            return SwSpecificationType.UNKNOWN.INSTANCE;
        }
        Project project2 = specificationPart.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project$iv = project2;
        boolean $i$f$cacheOnFileTypeTracker = false;
        return (SwSpecificationType)CachedValuesManager.getManager((Project)project$iv).getCachedValue((UserDataHolder)specificationPart, new CachedValueProvider(project$iv, specificationPart){
            final /* synthetic */ Project $project;
            final /* synthetic */ PsiFile $specificationPart$inlined;
            {
                this.$project = $project;
                this.$specificationPart$inlined = psiFile2;
            }

            @Nullable
            public final CachedValueProvider.Result<T> compute() {
                boolean bl = false;
                SwSpecificationType result2 = SwSecondarySpecificationModelComputationKt.computeSecondarySpecificationType(this.$specificationPart$inlined);
                Object[] objectArray = new Object[]{SwaggerUtilsKt.getYamlJsonModificationTracker(this.$project)};
                return new CachedValueProvider.Result((Object)result2, objectArray);
            }
        });
    }

    @NotNull
    public final SwSpecificationType getUserDefinedSpecificationType$intellij_swagger_core(@NotNull Project project, @NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<SwUserDefinedSpecifications> serviceClass$iv = SwUserDefinedSpecifications.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((SwUserDefinedSpecifications)object).getSpecificationType(fileUrl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSpecificationFastCheck(VirtualFile virtualFile2, PsiFile psiFile2) {
        String string;
        String string2 = virtualFile2.getNameWithoutExtension();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNameWithoutExtension(...)");
        String nameWithoutExtension = string2;
        switch (nameWithoutExtension.hashCode()) {
            case -1263192176: {
                if (nameWithoutExtension.equals("openapi")) return true;
                break;
            }
            case -193620450: {
                if (nameWithoutExtension.equals("asyncapi")) return true;
                break;
            }
            case -1811637878: {
                if (!nameWithoutExtension.equals("swagger")) break;
                return true;
            }
        }
        String string3 = psiFile2.getText();
        String string4 = string3;
        if (string3 == null) return false;
        String it = string = string4;
        boolean bl = false;
        if (StringsKt.isBlank((CharSequence)it)) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        String string5 = string;
        string4 = string5;
        if (string5 == null) {
            return false;
        }
        String fileText = string4;
        if (StringsKt.contains$default((CharSequence)fileText, (CharSequence)"swagger", (boolean)false, (int)2, null)) return true;
        if (StringsKt.contains$default((CharSequence)fileText, (CharSequence)"openapi", (boolean)false, (int)2, null)) return true;
        if (!StringsKt.contains$default((CharSequence)fileText, (CharSequence)"asyncapi", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public final boolean isSuitableFileType$intellij_swagger_core(@NotNull VirtualFile virtualFile2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        if (virtualFile2.getFileType() instanceof YAMLFileType) {
            bl = true;
        } else if (virtualFile2.getFileType() instanceof JsonFileType) {
            bl = true;
        } else if (ScratchUtil.isScratch((VirtualFile)virtualFile2)) {
            String $this$isSuitableFileType_u24lambda_u243 = virtualFile2.getExtension();
            boolean bl2 = false;
            bl = StringsKt.equals$default((String)$this$isSuitableFileType_u24lambda_u243, (String)"yaml", (boolean)false, (int)2, null) || StringsKt.equals$default((String)$this$isSuitableFileType_u24lambda_u243, (String)"yml", (boolean)false, (int)2, null) || StringsKt.equals$default((String)$this$isSuitableFileType_u24lambda_u243, (String)"json", (boolean)false, (int)2, null);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isSuitableFile(VirtualFile virtualFile2, PsiFile psiFile2) {
        return !virtualFile2.isDirectory() && virtualFile2.isValid() && this.isSuitableFileType$intellij_swagger_core(virtualFile2) && !SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)virtualFile2) && (psiFile2 == null || this.isSpecificationFastCheck(virtualFile2, psiFile2));
    }

    private final boolean isSwagger2File(VirtualFile virtualFile2, PsiFile psiFile2) {
        return this.isSpecificationFileOfKind(SwaggerFileHelperKt.access$getSWAGGER_2_PATTERN$p(), virtualFile2, psiFile2);
    }

    private final boolean isOpenapi3File(VirtualFile virtualFile2, PsiFile psiFile2) {
        return this.isSpecificationFileOfKind(SwaggerFileHelperKt.access$getOPENAPI_3_0_PATTERN$p(), virtualFile2, psiFile2);
    }

    private final boolean isOpenapi31File(VirtualFile virtualFile2, PsiFile psiFile2) {
        return this.isSpecificationFileOfKind(SwaggerFileHelperKt.access$getOPENAPI_3_1_PATTERN$p(), virtualFile2, psiFile2);
    }

    private final boolean isAsyncapi2File(VirtualFile virtualFile2, PsiFile psiFile2) {
        return this.isSpecificationFileOfKind(SwaggerFileHelperKt.access$getASYNCAPI_2_PATTERN$p(), virtualFile2, psiFile2);
    }

    private final boolean isSpecificationFileOfKind(Regex specificationVersionPattern, VirtualFile virtualFile2, PsiFile psiFile2) {
        boolean bl;
        Object object = psiFile2;
        if (object != null && (object = object.getText()) != null) {
            bl = specificationVersionPattern.containsMatchIn((CharSequence)object);
        } else {
            CharSequence charSequence = LoadTextUtil.loadText((VirtualFile)virtualFile2);
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"loadText(...)");
            bl = specificationVersionPattern.containsMatchIn(charSequence);
        }
        return bl;
    }

    static {
        Key key = Key.create((String)"swSpecificationType");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SPECIFICATION_TYPE_KEY = key;
    }
}

