/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.model;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.swagger.core.SwSpecificationDetectionKt;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.swagger.core.index.SwReferenceData;
import com.intellij.swagger.core.index.SwReferenceDataWithSource;
import com.intellij.swagger.core.index.SwReferenceIndexAccessorKt;
import com.intellij.swagger.core.model.SwSecondarySpecificationSchemaAssemblyKt;
import com.intellij.swagger.core.model.SwUserDefinedSpecifications;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\u00a8\u0006\t"}, d2={"computeReferencesChainFromRoot", "", "Lcom/intellij/swagger/core/index/SwReferenceDataWithSource;", "root", "Lcom/intellij/psi/PsiFile;", "computeSecondarySpecificationType", "Lcom/intellij/swagger/core/SwSpecificationType;", "specificationPart", "computeSecondaryTypeInner", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwSecondarySpecificationModelComputation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwSecondarySpecificationModelComputation.kt\ncom/intellij/swagger/core/model/SwSecondarySpecificationModelComputationKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,78:1\n31#2,2:79\n*S KotlinDebug\n*F\n+ 1 SwSecondarySpecificationModelComputation.kt\ncom/intellij/swagger/core/model/SwSecondarySpecificationModelComputationKt\n*L\n21#1:79,2\n*E\n"})
public final class SwSecondarySpecificationModelComputationKt {
    @NotNull
    public static final SwSpecificationType computeSecondarySpecificationType(@NotNull PsiFile specificationPart) {
        SwSpecificationType swSpecificationType;
        Intrinsics.checkNotNullParameter((Object)specificationPart, (String)"specificationPart");
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            swSpecificationType = SwSecondarySpecificationModelComputationKt.computeSecondaryTypeInner(specificationPart);
        } else {
            NonBlockingReadAction nonBlockingReadAction = ReadAction.nonBlocking(() -> SwSecondarySpecificationModelComputationKt.computeSecondarySpecificationType$lambda$0(specificationPart)).inSmartMode(specificationPart.getProject());
            Project project = specificationPart.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<SwUserDefinedSpecifications> serviceClass$iv = SwUserDefinedSpecifications.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            Object object2 = nonBlockingReadAction.expireWith((Disposable)object).executeSynchronously();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"executeSynchronously(...)");
            swSpecificationType = (SwSpecificationType)object2;
        }
        return swSpecificationType;
    }

    private static final SwSpecificationType computeSecondaryTypeInner(PsiFile specificationPart) {
        List<SwReferenceDataWithSource> referencesChainToRoot = SwSecondarySpecificationModelComputationKt.computeReferencesChainFromRoot(specificationPart);
        Collection collection = referencesChainToRoot;
        if (collection == null || collection.isEmpty()) {
            return SwSpecificationType.UNKNOWN.INSTANCE;
        }
        SwReferenceDataWithSource referenceToCurrentFile = (SwReferenceDataWithSource)CollectionsKt.last(referencesChainToRoot);
        PsiElement psiElement = referenceToCurrentFile.getSourcePsiFile().findElementAt(referenceToCurrentFile.getReferenceData().getReferenceOffsetInFile());
        if (psiElement == null) {
            return SwSpecificationType.UNKNOWN.INSTANCE;
        }
        PsiElement elementWithReference = psiElement;
        return SwSecondarySpecificationSchemaAssemblyKt.inheritSecondarySpecificationTypeFromCurrentFileConsideringLocation(elementWithReference, !referenceToCurrentFile.getReferenceData().getReferencesEntireFile());
    }

    private static final List<SwReferenceDataWithSource> computeReferencesChainFromRoot(PsiFile root) {
        VirtualFile virtualFile2 = root.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        if (!(SwSpecificationDetectionKt.detectPrimarySpecificationType(virtualFile2, root) instanceof SwSpecificationType.NONE)) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)root);
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module module2 = module;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module2).uniteWith(module2.getModuleContentScope());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"uniteWith(...)");
        GlobalSearchScope searchScope = globalSearchScope;
        Set visitedFileUrls = new LinkedHashSet();
        SwReferenceDataWithSource wrappedSearchRoot = new SwReferenceDataWithSource(root, new SwReferenceData("", -1, false));
        return CollectionsKt.dropLast(SwSecondarySpecificationModelComputationKt.computeReferencesChainFromRoot$findReferencesChainDfs(searchScope, visitedFileUrls, wrappedSearchRoot), (int)1);
    }

    private static final SwSpecificationType computeSecondarySpecificationType$lambda$0(PsiFile $specificationPart) {
        Intrinsics.checkNotNullParameter((Object)$specificationPart, (String)"$specificationPart");
        return SwSecondarySpecificationModelComputationKt.computeSecondaryTypeInner($specificationPart);
    }

    private static final boolean computeReferencesChainFromRoot$isVisited(SwReferenceDataWithSource $this$computeReferencesChainFromRoot_u24isVisited, Set<String> visitedFileUrls) {
        return visitedFileUrls.contains($this$computeReferencesChainFromRoot_u24isVisited.getSourcePsiFile().getVirtualFile().getUrl());
    }

    private static final void computeReferencesChainFromRoot$markVisited(SwReferenceDataWithSource $this$computeReferencesChainFromRoot_u24markVisited, Set<String> visitedFileUrls) {
        String string = $this$computeReferencesChainFromRoot_u24markVisited.getSourcePsiFile().getVirtualFile().getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        visitedFileUrls.add(string);
    }

    private static final boolean computeReferencesChainFromRoot$shouldContinueSearch(SwReferenceDataWithSource $this$computeReferencesChainFromRoot_u24shouldContinueSearch) {
        VirtualFile virtualFile2 = $this$computeReferencesChainFromRoot_u24shouldContinueSearch.getSourcePsiFile().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        return SwSpecificationDetectionKt.detectPrimarySpecificationType(virtualFile2, $this$computeReferencesChainFromRoot_u24shouldContinueSearch.getSourcePsiFile()) instanceof SwSpecificationType.UNKNOWN;
    }

    private static final List<SwReferenceDataWithSource> computeReferencesChainFromRoot$findReferencesChainDfs(GlobalSearchScope searchScope, Set<String> visitedFileUrls, SwReferenceDataWithSource currentRoot) {
        if (SwSecondarySpecificationModelComputationKt.computeReferencesChainFromRoot$isVisited(currentRoot, visitedFileUrls)) {
            return CollectionsKt.emptyList();
        }
        if (!SwSecondarySpecificationModelComputationKt.computeReferencesChainFromRoot$shouldContinueSearch(currentRoot)) {
            return CollectionsKt.listOf((Object)currentRoot);
        }
        SwSecondarySpecificationModelComputationKt.computeReferencesChainFromRoot$markVisited(currentRoot, visitedFileUrls);
        for (SwReferenceDataWithSource nextReference : SwReferenceIndexAccessorKt.findReferencesToCurrentFile(currentRoot.getSourcePsiFile(), searchScope)) {
            List<SwReferenceDataWithSource> maybePath = SwSecondarySpecificationModelComputationKt.computeReferencesChainFromRoot$findReferencesChainDfs(searchScope, visitedFileUrls, nextReference);
            if (!(!((Collection)maybePath).isEmpty())) continue;
            return CollectionsKt.plus((Collection)maybePath, (Object)currentRoot);
        }
        return CollectionsKt.emptyList();
    }
}

