/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.index;

import com.intellij.json.JsonFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.swagger.core.index.SwIndexUtilsKt;
import com.intellij.swagger.core.index.SwReferenceData;
import com.intellij.swagger.core.index.SwReferenceIndexer;
import com.intellij.swagger.core.index.SwReferencesIndexKt;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLFileType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0016H\u0016J\u0014\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/swagger/core/index/SwReferencesIndex;", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "", "", "Lcom/intellij/swagger/core/index/SwReferenceData;", "()V", "DATA_EXTERNALIZER", "Lcom/intellij/swagger/core/index/SwReferencesIndex$SwReferenceDataExternalizer;", "INDEXER", "Lcom/intellij/swagger/core/index/SwReferenceIndexer;", "INPUT_FILTER", "Lcom/intellij/util/indexing/DefaultFileTypeSpecificInputFilter;", "dependsOnFileContent", "", "getIndexer", "Lcom/intellij/util/indexing/DataIndexer;", "Lcom/intellij/util/indexing/FileContent;", "getInputFilter", "Lcom/intellij/util/indexing/FileBasedIndex$InputFilter;", "getKeyDescriptor", "Lcom/intellij/util/io/KeyDescriptor;", "getName", "Lcom/intellij/util/indexing/ID;", "getValueExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "getVersion", "", "SwReferenceDataExternalizer", "intellij.swagger.core"})
public final class SwReferencesIndex
extends FileBasedIndexExtension<String, List<? extends SwReferenceData>> {
    @NotNull
    private final DefaultFileTypeSpecificInputFilter INPUT_FILTER;
    @NotNull
    private final SwReferenceDataExternalizer DATA_EXTERNALIZER;
    @NotNull
    private final SwReferenceIndexer INDEXER;

    public SwReferencesIndex() {
        FileType[] fileTypeArray = new FileType[]{YAMLFileType.YML, JsonFileType.INSTANCE};
        this.INPUT_FILTER = new DefaultFileTypeSpecificInputFilter(fileTypeArray);
        this.DATA_EXTERNALIZER = new SwReferenceDataExternalizer();
        this.INDEXER = new SwReferenceIndexer();
    }

    public int getVersion() {
        return 1;
    }

    @NotNull
    public ID<String, List<SwReferenceData>> getName() {
        return SwReferencesIndexKt.getSW_REFERENCES_INDEX_ID();
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return (FileBasedIndex.InputFilter)this.INPUT_FILTER;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)enumeratorStringDescriptor, (String)"INSTANCE");
        return (KeyDescriptor)enumeratorStringDescriptor;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public DataExternalizer<List<SwReferenceData>> getValueExternalizer() {
        return this.DATA_EXTERNALIZER;
    }

    @NotNull
    public DataIndexer<String, List<SwReferenceData>, FileContent> getIndexer() {
        return this.INDEXER;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/swagger/core/index/SwReferencesIndex$SwReferenceDataExternalizer;", "Lcom/intellij/util/io/DataExternalizer;", "", "Lcom/intellij/swagger/core/index/SwReferenceData;", "()V", "read", "dataInput", "Ljava/io/DataInput;", "save", "", "out", "Ljava/io/DataOutput;", "value", "intellij.swagger.core"})
    private static final class SwReferenceDataExternalizer
    implements DataExternalizer<List<? extends SwReferenceData>> {
        public void save(@NotNull DataOutput out, @NotNull List<SwReferenceData> value) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter(value, (String)"value");
            SwIndexUtilsKt.writeListOfObjects(out, value, (Function1)new Function1<SwReferenceData, Unit>(out){
                final /* synthetic */ DataOutput $out;
                {
                    this.$out = $out;
                    super(1);
                }

                public final void invoke(@NotNull SwReferenceData referenceData) {
                    Intrinsics.checkNotNullParameter((Object)referenceData, (String)"referenceData");
                    EnumeratorStringDescriptor.INSTANCE.save(this.$out, referenceData.getTargetFileRelativePath());
                    DataInputOutputUtil.writeINT((DataOutput)this.$out, (int)referenceData.getReferenceOffsetInFile());
                    EnumeratorStringDescriptor.INSTANCE.save(this.$out, String.valueOf(referenceData.getReferencesEntireFile()));
                }
            });
        }

        @NotNull
        public List<SwReferenceData> read(@NotNull DataInput dataInput) {
            Intrinsics.checkNotNullParameter((Object)dataInput, (String)"dataInput");
            return SwIndexUtilsKt.readListOfObjects(dataInput, (Function0)new Function0<SwReferenceData>(dataInput){
                final /* synthetic */ DataInput $dataInput;
                {
                    this.$dataInput = $dataInput;
                    super(0);
                }

                @NotNull
                public final SwReferenceData invoke() {
                    String targetFileUrl = EnumeratorStringDescriptor.INSTANCE.read(this.$dataInput);
                    int referenceOffsetInFile = DataInputOutputUtil.readINT((DataInput)this.$dataInput);
                    boolean referencesEntireFile = Boolean.parseBoolean(EnumeratorStringDescriptor.INSTANCE.read(this.$dataInput));
                    Intrinsics.checkNotNull((Object)targetFileUrl);
                    return new SwReferenceData(targetFileUrl, referenceOffsetInFile, referencesEntireFile);
                }
            });
        }
    }
}

