/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.index;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.swagger.core.index.SwReferenceData;
import com.intellij.swagger.core.reference.definitions.SwObjectCoordinates;
import com.intellij.swagger.core.reference.definitions.SwObjectDefinitionResolverKt;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tH\u0002\u00a8\u0006\f"}, d2={"hasReferenceMarker", "", "maybeReferenceMarker", "", "parseAndStoreReferenceData", "", "elementWithReference", "Lcom/intellij/psi/PsiElement;", "referencesStorage", "", "", "Lcom/intellij/swagger/core/index/SwReferenceData;", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwReferenceIndexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwReferenceIndexer.kt\ncom/intellij/swagger/core/index/SwReferenceIndexerKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,69:1\n372#2,7:70\n*S KotlinDebug\n*F\n+ 1 SwReferenceIndexer.kt\ncom/intellij/swagger/core/index/SwReferenceIndexerKt\n*L\n62#1:70,7\n*E\n"})
public final class SwReferenceIndexerKt {
    private static final void parseAndStoreReferenceData(PsiElement elementWithReference, Map<String, List<SwReferenceData>> referencesStorage) {
        CharSequence charSequence;
        SwObjectCoordinates coordinates = SwObjectDefinitionResolverKt.parseObjectCoordinates(elementWithReference);
        String targetFileRelativePath = coordinates.getUriValue();
        boolean referencesEntireFile = coordinates.referencesEntireFile();
        if (coordinates.isLocalPathCoordinates() && !((charSequence = (CharSequence)targetFileRelativePath) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            List list;
            String string = PathUtil.getFileName((String)targetFileRelativePath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
            String targetFileName = string;
            SwReferenceData referenceData = new SwReferenceData(targetFileRelativePath, elementWithReference.getTextOffset(), referencesEntireFile);
            Map<String, List<SwReferenceData>> $this$getOrPut$iv = referencesStorage;
            boolean $i$f$getOrPut = false;
            List value$iv = $this$getOrPut$iv.get(targetFileName);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(targetFileName, answer$iv);
                list = answer$iv;
            } else {
                list = value$iv;
            }
            list.add((SwReferenceData)referenceData);
        }
    }

    private static final boolean hasReferenceMarker(String maybeReferenceMarker) {
        return Intrinsics.areEqual((Object)StringUtil.unquoteString((String)maybeReferenceMarker), (Object)"$ref");
    }

    public static final /* synthetic */ boolean access$hasReferenceMarker(String maybeReferenceMarker) {
        return SwReferenceIndexerKt.hasReferenceMarker(maybeReferenceMarker);
    }

    public static final /* synthetic */ void access$parseAndStoreReferenceData(PsiElement elementWithReference, Map referencesStorage) {
        SwReferenceIndexerKt.parseAndStoreReferenceData(elementWithReference, referencesStorage);
    }
}

