/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.index;

import com.intellij.json.psi.JsonFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.swagger.core.index.SwJsonPropertyVisitor;
import com.intellij.swagger.core.index.SwReferenceData;
import com.intellij.swagger.core.index.SwYamlKeyValueVisitor;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileContent;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0002\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\u00050\u0001B\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\b2\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/swagger/core/index/SwReferenceIndexer;", "Lcom/intellij/util/indexing/DataIndexer;", "", "", "Lcom/intellij/swagger/core/index/SwReferenceData;", "Lcom/intellij/util/indexing/FileContent;", "()V", "map", "", "", "inputData", "intellij.swagger.core"})
public final class SwReferenceIndexer
implements DataIndexer<String, List<? extends SwReferenceData>, FileContent> {
    @NotNull
    public Map<String, List<SwReferenceData>> map(@NotNull FileContent inputData) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
        Map indexedReferences = new LinkedHashMap();
        PsiFile psiFile2 = inputData.getPsiFile();
        if (psiFile2 instanceof YAMLFile) {
            object = new SwYamlKeyValueVisitor(indexedReferences);
        } else if (psiFile2 instanceof JsonFile) {
            object = new SwJsonPropertyVisitor(indexedReferences);
        } else {
            return indexedReferences;
        }
        Object visitor = object;
        inputData.getPsiFile().accept((PsiElementVisitor)visitor);
        return indexedReferences;
    }
}

