/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.index;

import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.json.psi.impl.JsonRecursiveElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.swagger.core.index.SwReferenceData;
import com.intellij.swagger.core.index.SwReferenceIndexerKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/swagger/core/index/SwJsonPropertyVisitor;", "Lcom/intellij/json/psi/impl/JsonRecursiveElementVisitor;", "referencesStorage", "", "", "", "Lcom/intellij/swagger/core/index/SwReferenceData;", "(Ljava/util/Map;)V", "visitProperty", "", "property", "Lcom/intellij/json/psi/JsonProperty;", "intellij.swagger.core"})
final class SwJsonPropertyVisitor
extends JsonRecursiveElementVisitor {
    @NotNull
    private final Map<String, List<SwReferenceData>> referencesStorage;

    public SwJsonPropertyVisitor(@NotNull Map<String, List<SwReferenceData>> referencesStorage) {
        Intrinsics.checkNotNullParameter(referencesStorage, (String)"referencesStorage");
        this.referencesStorage = referencesStorage;
    }

    public void visitProperty(@NotNull JsonProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        JsonValue value = property.getValue();
        if (value != null) {
            String string = property.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (SwReferenceIndexerKt.access$hasReferenceMarker(string)) {
                SwReferenceIndexerKt.access$parseAndStoreReferenceData((PsiElement)value, this.referencesStorage);
            }
        }
        super.visitProperty(property);
    }
}

