/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.diff.model;

import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.diff.SwDiffResult;
import com.intellij.swagger.core.diff.SwDiffUtilsKt;
import com.intellij.swagger.core.diff.model.SwModifiedElement;
import com.intellij.swagger.core.diff.model.SwModifiedPrimitive;
import com.intellij.swagger.core.diff.model.SwModifiedProperty;
import com.intellij.swagger.core.diff.model.SwModifiedRootElement;
import com.intellij.swagger.core.model.api.SwObjectSchema;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u001e\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150$H\u0016R\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0012\u0010\u000eR!\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0010\u001a\u0004\b\u0016\u0010\u0017R!\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0010\u001a\u0004\b\u001b\u0010\u000eR!\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0010\u001a\u0004\b\u001e\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006%"}, d2={"Lcom/intellij/swagger/core/diff/model/SwModifiedProperty;", "Lcom/intellij/swagger/core/diff/model/SwModifiedElement;", "Lcom/intellij/swagger/core/model/api/SwObjectSchema;", "original", "modified", "root", "Lcom/intellij/swagger/core/diff/model/SwModifiedRootElement;", "(Lcom/intellij/swagger/core/model/api/SwObjectSchema;Lcom/intellij/swagger/core/model/api/SwObjectSchema;Lcom/intellij/swagger/core/diff/model/SwModifiedRootElement;)V", "getModified", "()Lcom/intellij/swagger/core/model/api/SwObjectSchema;", "myFormatModified", "Lcom/intellij/swagger/core/diff/model/SwModifiedPrimitive;", "", "getMyFormatModified", "()Lcom/intellij/swagger/core/diff/model/SwModifiedPrimitive;", "myFormatModified$delegate", "Lkotlin/Lazy;", "myNameModified", "getMyNameModified", "myNameModified$delegate", "myPropertiesDiff", "Lcom/intellij/swagger/core/diff/SwDiffResult;", "getMyPropertiesDiff", "()Lcom/intellij/swagger/core/diff/SwDiffResult;", "myPropertiesDiff$delegate", "myRequiredModified", "", "getMyRequiredModified", "myRequiredModified$delegate", "myTypeModified", "getMyTypeModified", "myTypeModified$delegate", "getOriginal", "getRoot", "()Lcom/intellij/swagger/core/diff/model/SwModifiedRootElement;", "computeChildrenDiffs", "", "intellij.swagger.core"})
public final class SwModifiedProperty
implements SwModifiedElement<SwObjectSchema> {
    @NotNull
    private final SwObjectSchema original;
    @NotNull
    private final SwObjectSchema modified;
    @NotNull
    private final SwModifiedRootElement root;
    @NotNull
    private final Lazy myNameModified$delegate;
    @NotNull
    private final Lazy myTypeModified$delegate;
    @NotNull
    private final Lazy myFormatModified$delegate;
    @NotNull
    private final Lazy myRequiredModified$delegate;
    @NotNull
    private final Lazy myPropertiesDiff$delegate;

    public SwModifiedProperty(@NotNull SwObjectSchema original, @NotNull SwObjectSchema modified, @NotNull SwModifiedRootElement root) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)modified, (String)"modified");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.original = original;
        this.modified = modified;
        this.root = root;
        this.myNameModified$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SwModifiedPrimitive<String>>(this){
            final /* synthetic */ SwModifiedProperty this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SwModifiedPrimitive<String> invoke() {
                return new SwModifiedPrimitive<String>(SwaggerBundle.message("diff.fields.name.title", new Object[0]), this.this$0.getOriginal().getName().getValue(), this.this$0.getModified().getName().getValue(), this.this$0.getRoot(), null, 16, null);
            }
        }));
        this.myTypeModified$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SwModifiedPrimitive<String>>(this){
            final /* synthetic */ SwModifiedProperty this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SwModifiedPrimitive<String> invoke() {
                return new SwModifiedPrimitive<String>(SwaggerBundle.message("diff.fields.type.title", new Object[0]), this.this$0.getOriginal().getType().getValue(), this.this$0.getModified().getType().getValue(), this.this$0.getRoot(), null, 16, null);
            }
        }));
        this.myFormatModified$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SwModifiedPrimitive<String>>(this){
            final /* synthetic */ SwModifiedProperty this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SwModifiedPrimitive<String> invoke() {
                return new SwModifiedPrimitive<String>(SwaggerBundle.message("diff.fields.format.title", new Object[0]), this.this$0.getOriginal().getFormat().getValue(), this.this$0.getModified().getFormat().getValue(), this.this$0.getRoot(), null, 16, null);
            }
        }));
        this.myRequiredModified$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SwModifiedPrimitive<Boolean>>(this){
            final /* synthetic */ SwModifiedProperty this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SwModifiedPrimitive<Boolean> invoke() {
                return new SwModifiedPrimitive<Boolean>(SwaggerBundle.message("diff.fields.required.title", new Object[0]), this.this$0.getOriginal().isRequired().getValue(), this.this$0.getModified().isRequired().getValue(), this.this$0.getRoot(), myRequiredModified.1.INSTANCE);
            }
        }));
        this.myPropertiesDiff$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SwDiffResult<SwObjectSchema>>(this){
            final /* synthetic */ SwModifiedProperty this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SwDiffResult<SwObjectSchema> invoke() {
                return SwDiffUtilsKt.calculateDiffBetween(this.this$0.getOriginal().getChildrenProperties(), this.this$0.getModified().getChildrenProperties(), (Function1)myPropertiesDiff.1.INSTANCE, (Function2)new Function2<SwObjectSchema, SwObjectSchema, SwModifiedElement<?>>(this.this$0){
                    final /* synthetic */ SwModifiedProperty this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    @NotNull
                    public final SwModifiedElement<?> invoke(@NotNull SwObjectSchema before, @NotNull SwObjectSchema after) {
                        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
                        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
                        return new SwModifiedProperty(before, after, this.this$0.getRoot());
                    }
                });
            }
        }));
    }

    @Override
    @NotNull
    public SwObjectSchema getOriginal() {
        return this.original;
    }

    @Override
    @NotNull
    public SwObjectSchema getModified() {
        return this.modified;
    }

    @Override
    @NotNull
    public SwModifiedRootElement getRoot() {
        return this.root;
    }

    private final SwModifiedPrimitive<String> getMyNameModified() {
        Lazy lazy = this.myNameModified$delegate;
        return (SwModifiedPrimitive)lazy.getValue();
    }

    private final SwModifiedPrimitive<String> getMyTypeModified() {
        Lazy lazy = this.myTypeModified$delegate;
        return (SwModifiedPrimitive)lazy.getValue();
    }

    private final SwModifiedPrimitive<String> getMyFormatModified() {
        Lazy lazy = this.myFormatModified$delegate;
        return (SwModifiedPrimitive)lazy.getValue();
    }

    private final SwModifiedPrimitive<Boolean> getMyRequiredModified() {
        Lazy lazy = this.myRequiredModified$delegate;
        return (SwModifiedPrimitive)lazy.getValue();
    }

    private final SwDiffResult<SwObjectSchema> getMyPropertiesDiff() {
        Lazy lazy = this.myPropertiesDiff$delegate;
        return (SwDiffResult)lazy.getValue();
    }

    @Override
    @NotNull
    public Collection<SwDiffResult<?>> computeChildrenDiffs() {
        Object[] objectArray = new SwDiffResult[2];
        SwModifiedElement[] swModifiedElementArray = new SwModifiedElement[]{this.getMyNameModified(), this.getMyTypeModified(), this.getMyFormatModified(), this.getMyRequiredModified()};
        objectArray[0] = SwDiffResult.Companion.fromModifications(swModifiedElementArray);
        objectArray[1] = this.getMyPropertiesDiff();
        return SetsKt.setOf((Object[])objectArray);
    }
}

