/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.swagger.core.SwaggerLanguagesModificationTracker;
import com.intellij.swagger.core.hub.SwaggerHubManager;
import com.intellij.swagger.core.model.api.SwAuthority;
import com.intellij.swagger.core.model.api.SwModelElement;
import com.intellij.swagger.core.model.api.SwUrl;
import com.intellij.swagger.core.model.specification.SwSpecificationFile;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLPsiElement;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000p\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u001a#\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0006\"\u00020\u0003H\u0000\u00a2\u0006\u0002\u0010\u0007\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0003H\u0000\u001a,\u0010\u000b\u001a\u00020\u00032\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u001a\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u001e\u0010\u001b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u0014\u0010\u001e\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u0003H\u0000\u001a\u001e\u0010 \u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u0000\u001a&\u0010!\u001a\u0004\u0018\u0001H\"\"\u0006\b\u0000\u0010\"\u0018\u0001*\f\u0012\u0006\b\u0001\u0012\u00020$\u0018\u00010#H\u0080\b\u00a2\u0006\u0002\u0010%\u001a\u0012\u0010&\u001a\b\u0012\u0004\u0012\u00020$0#*\u00020$H\u0000\u001a\f\u0010'\u001a\u00020(*\u0004\u0018\u00010)\u001a\u0014\u0010*\u001a\u00020(*\u00020\u001a2\u0006\u0010+\u001a\u00020,H\u0000\u001a!\u0010-\u001a\u0002H\"\"\u0004\b\u0000\u0010\"*\u0004\u0018\u0001H\"2\u0006\u0010.\u001a\u0002H\"H\u0000\u00a2\u0006\u0002\u0010/\u001a\u000e\u00100\u001a\u00020\u0003*\u0004\u0018\u00010\u0003H\u0000\u001a9\u00101\u001a\b\u0012\u0004\u0012\u0002H\"0\u000e\"\u0004\b\u0000\u0010\"*\n\u0012\u0004\u0012\u0002H\"\u0018\u00010\u000e2\u0012\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\"0\u0006\"\u0002H\"H\u0000\u00a2\u0006\u0002\u00103\u001a \u00104\u001a\b\u0012\u0004\u0012\u0002H\"0\u000e\"\u0004\b\u0000\u0010\"*\n\u0012\u0004\u0012\u0002H\"\u0018\u000105H\u0000\u001a\u000e\u00106\u001a\u00020\u0003*\u0004\u0018\u00010\u0003H\u0000\u001a\f\u00107\u001a\u00020\u0003*\u00020\u0003H\u0000\u001a\f\u00108\u001a\u00020\u0003*\u00020\u0003H\u0000\u00a8\u00069"}, d2={"buildUrlFrom", "Lorg/apache/http/client/utils/URIBuilder;", "url", "", "buildUrlFromSegments", "segments", "", "([Ljava/lang/String;)Ljava/lang/String;", "getBundledResource", "Lcom/intellij/openapi/vfs/VirtualFile;", "resourceName", "getEndpointLocation", "authority", "basePaths", "", "Lcom/intellij/swagger/core/model/api/SwUrl;", "endpointUrl", "getYamlIndent", "property", "Lorg/jetbrains/yaml/psi/YAMLPsiElement;", "getYamlJsonModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "suggestRemoteSpecificationUrl", "specification", "Lcom/intellij/swagger/core/model/specification/SwSpecificationFile;", "addParameterIfNotNull", "name", "value", "addPathSegment", "segment", "addQueryParameter", "castOrNull", "T", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/SmartPsiElementPointer;)Ljava/lang/Object;", "createPointer", "isElementValid", "", "Lcom/intellij/swagger/core/model/api/SwModelElement;", "isLocatedInScope", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "or", "default", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "orDefaultPath", "orDefaultValues", "defaultValues", "(Ljava/util/List;[Ljava/lang/Object;)Ljava/util/List;", "toListOrEmpty", "Lkotlin/sequences/Sequence;", "toSystemDependentPath", "withEndingSlash", "withLeadingSlash", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwaggerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwaggerUtils.kt\ncom/intellij/swagger/core/SwaggerUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,121:1\n1#2:122\n11#3:123\n*S KotlinDebug\n*F\n+ 1 SwaggerUtils.kt\ncom/intellij/swagger/core/SwaggerUtilsKt\n*L\n92#1:123\n*E\n"})
public final class SwaggerUtilsKt {
    @NotNull
    public static final String orDefaultPath(@Nullable String $this$orDefaultPath) {
        String string = $this$orDefaultPath;
        if (string == null) {
            string = "/";
        }
        return string;
    }

    @NotNull
    public static final String getYamlIndent(@NotNull YAMLPsiElement property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        String string = StringUtil.repeatSymbol((char)' ', (int)YAMLUtil.getIndentInThisLine((PsiElement)((PsiElement)property)));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repeatSymbol(...)");
        return string;
    }

    @NotNull
    public static final SmartPsiElementPointer<PsiElement> createPointer(@NotNull PsiElement $this$createPointer) {
        Intrinsics.checkNotNullParameter((Object)$this$createPointer, (String)"<this>");
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)$this$createPointer);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        return smartPsiElementPointer;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ <T> T castOrNull(SmartPsiElementPointer<? extends PsiElement> $this$castOrNull) {
        PsiElement psiElement;
        PsiElement element;
        boolean $i$f$castOrNull = false;
        SmartPsiElementPointer<? extends PsiElement> smartPsiElementPointer = $this$castOrNull;
        Object object = element = smartPsiElementPointer != null ? smartPsiElementPointer.getElement() : null;
        if (element != null) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (element instanceof Object && element.isValid()) {
                psiElement = element;
                return (T)psiElement;
            }
        }
        psiElement = null;
        return (T)psiElement;
    }

    @Nullable
    public static final String buildUrlFromSegments(String ... segments) {
        Intrinsics.checkNotNullParameter((Object)segments, (String)"segments");
        StringBuilder stringBuilder = new StringBuilder();
        for (String segment : segments) {
            if (StringsKt.endsWith$default((CharSequence)stringBuilder, (CharSequence)"/", (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)segment, (String)"/", (boolean)false, (int)2, null)) {
                stringBuilder.append(StringsKt.drop((String)segment, (int)1));
                continue;
            }
            stringBuilder.append(segment);
        }
        return ((CharSequence)stringBuilder).length() == 0 ? null : stringBuilder.toString();
    }

    public static final boolean isElementValid(@Nullable SwModelElement $this$isElementValid) {
        SwModelElement swModelElement = $this$isElementValid;
        return swModelElement != null && (swModelElement = swModelElement.getSourcePsi()) != null ? swModelElement.isValid() : false;
    }

    @NotNull
    public static final ModificationTracker getYamlJsonModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = project.getService(SwaggerLanguagesModificationTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
        return (ModificationTracker)object;
    }

    @NotNull
    public static final String withLeadingSlash(@NotNull String $this$withLeadingSlash) {
        Intrinsics.checkNotNullParameter((Object)$this$withLeadingSlash, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$withLeadingSlash, (String)"/", (boolean)false, (int)2, null) ? $this$withLeadingSlash : "/" + $this$withLeadingSlash;
    }

    @NotNull
    public static final String withEndingSlash(@NotNull String $this$withEndingSlash) {
        Intrinsics.checkNotNullParameter((Object)$this$withEndingSlash, (String)"<this>");
        return StringsKt.endsWith$default((String)$this$withEndingSlash, (String)"://", (boolean)false, (int)2, null) ? $this$withEndingSlash : $this$withEndingSlash + "://";
    }

    public static final boolean isLocatedInScope(@NotNull SwSpecificationFile $this$isLocatedInScope, @NotNull GlobalSearchScope scope) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isLocatedInScope, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        PsiFile psiFile2 = $this$isLocatedInScope.getSourcePsi();
        if (psiFile2 != null && (psiFile2 = psiFile2.getVirtualFile()) != null) {
            PsiFile it = psiFile2;
            boolean bl2 = false;
            bl = scope.contains((VirtualFile)it);
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final <T> List<T> orDefaultValues(@Nullable List<? extends T> $this$orDefaultValues, T ... defaultValues) {
        Intrinsics.checkNotNullParameter(defaultValues, (String)"defaultValues");
        Collection collection = $this$orDefaultValues;
        return collection == null || collection.isEmpty() ? ArraysKt.asList((Object[])defaultValues) : $this$orDefaultValues;
    }

    public static final <T> T or(@Nullable T $this$or, T t) {
        T t2 = $this$or;
        if (t2 == null) {
            t2 = t;
        }
        return t2;
    }

    @NotNull
    public static final <T> List<T> toListOrEmpty(@Nullable Sequence<? extends T> $this$toListOrEmpty) {
        Sequence<? extends T> sequence = $this$toListOrEmpty;
        List list = sequence != null ? SequencesKt.toList(sequence) : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final VirtualFile getBundledResource(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        PluginId pluginId = PluginId.findId((String)"com.intellij.swagger");
        if (pluginId == null) return null;
        PluginId it = pluginId;
        boolean bl = false;
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)it);
        if (ideaPluginDescriptor == null) return null;
        ClassLoader classLoader = ideaPluginDescriptor.getPluginClassLoader();
        if (classLoader == null) return null;
        URL uRL = classLoader.getResource(resourceName);
        if (uRL == null) return null;
        URL it2 = uRL;
        boolean bl2 = false;
        VirtualFile virtualFile2 = VfsUtil.findFileByURL((URL)it2);
        return virtualFile2;
    }

    @Nullable
    public static final String suggestRemoteSpecificationUrl(@NotNull SwSpecificationFile specification) {
        String string;
        Intrinsics.checkNotNullParameter((Object)specification, (String)"specification");
        if (specification.isRemote()) {
            String location;
            String string2;
            SwModelElement swModelElement = specification;
            String authority = swModelElement != null && (swModelElement = swModelElement.getAuthorities()) != null && (swModelElement = (SwAuthority)CollectionsKt.firstOrNull((List)((Object)swModelElement))) != null && (swModelElement = ((SwAuthority)swModelElement).getAuthorityValue()) != null ? swModelElement.getValue() : null;
            String it = string2 = (location = SwaggerUtilsKt.getEndpointLocation$default(authority, specification.getBasePaths(), null, 4, null));
            boolean bl = false;
            string = ((CharSequence)it).length() > 0 ? string2 : null;
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public static final URIBuilder buildUrlFrom(@Nullable String url2) {
        CharSequence charSequence = url2;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        try {
            URIBuilder builder = new URIBuilder(url2);
            charSequence = builder.getHost() == null ? null : charSequence;
        }
        catch (URISyntaxException e) {
            boolean $i$f$logger = false;
            Logger logger2 = Logger.getInstance(SwaggerHubManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("Unable to parse URL: " + url2);
            charSequence = null;
        }
        return charSequence;
    }

    @NotNull
    public static final URIBuilder addPathSegment(@NotNull URIBuilder $this$addPathSegment, @NotNull String segment) {
        Intrinsics.checkNotNullParameter((Object)$this$addPathSegment, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        List list = $this$addPathSegment.getPathSegments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPathSegments(...)");
        $this$addPathSegment.setPathSegments(CollectionsKt.plus((Collection)list, (Object)segment));
        return $this$addPathSegment;
    }

    @NotNull
    public static final URIBuilder addQueryParameter(@NotNull URIBuilder $this$addQueryParameter, @NotNull String name2, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)$this$addQueryParameter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        $this$addQueryParameter.setParameter(name2, value);
        return $this$addQueryParameter;
    }

    @NotNull
    public static final URIBuilder addParameterIfNotNull(@NotNull URIBuilder $this$addParameterIfNotNull, @NotNull String name2, @Nullable String value) {
        String string;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$addParameterIfNotNull, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                string = value;
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                URIBuilder uRIBuilder = SwaggerUtilsKt.addQueryParameter($this$addParameterIfNotNull, name2, it);
                string = uRIBuilder;
                if (uRIBuilder != null) break block3;
            }
            string = $this$addParameterIfNotNull;
        }
        return string;
    }

    @NotNull
    public static final String getEndpointLocation(@Nullable String authority, @NotNull List<? extends SwUrl> basePaths2, @Nullable String endpointUrl) {
        Intrinsics.checkNotNullParameter(basePaths2, (String)"basePaths");
        SwUrl swUrl = (SwUrl)CollectionsKt.firstOrNull(basePaths2);
        String string = swUrl != null ? swUrl.getUrlString() : null;
        if (string == null) {
            string = "";
        }
        String string2 = StringsKt.removeSuffix((String)string, (CharSequence)"/");
        String string3 = endpointUrl;
        if (string3 == null) {
            string3 = "";
        }
        String presentablePath = string2 + string3;
        return authority != null ? StringsKt.removeSuffix((String)authority, (CharSequence)"/") + presentablePath : presentablePath;
    }

    public static /* synthetic */ String getEndpointLocation$default(String string, List list, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        return SwaggerUtilsKt.getEndpointLocation(string, list, string2);
    }

    @NotNull
    public static final String toSystemDependentPath(@Nullable String $this$toSystemDependentPath) {
        String string;
        String string2 = $this$toSystemDependentPath;
        if (string2 == null) {
            string = "";
        } else {
            String string3 = FileUtil.toSystemDependentName((String)string2);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toSystemDependentName(...)");
        }
        return string;
    }
}

