/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.shape.fractal;

import org.locationtech.jts.geom.Coordinate;

public class MortonCode {
    public static final int MAX_LEVEL = 16;

    public static int size(int level) {
        MortonCode.checkLevel(level);
        return (int)Math.pow(2.0, 2 * level);
    }

    public static int maxOrdinate(int level) {
        MortonCode.checkLevel(level);
        return (int)Math.pow(2.0, level) - 1;
    }

    public static int level(int numPoints) {
        int pow2 = (int)(Math.log(numPoints) / Math.log(2.0));
        int level = pow2 / 2;
        int size = MortonCode.size(level);
        if (size < numPoints) {
            ++level;
        }
        return level;
    }

    private static void checkLevel(int level) {
        if (level > 16) {
            throw new IllegalArgumentException("Level must be in range 0 to 16");
        }
    }

    public static int encode(int x, int y) {
        return (MortonCode.interleave(y) << 1) + MortonCode.interleave(x);
    }

    private static int interleave(int x) {
        x &= 0xFFFF;
        x = (x ^ x << 8) & 0xFF00FF;
        x = (x ^ x << 4) & 0xF0F0F0F;
        x = (x ^ x << 2) & 0x33333333;
        x = (x ^ x << 1) & 0x55555555;
        return x;
    }

    public static Coordinate decode(int index2) {
        long x = MortonCode.deinterleave(index2);
        long y = MortonCode.deinterleave(index2 >> 1);
        return new Coordinate(x, y);
    }

    private static long deinterleave(int x) {
        x &= 0x55555555;
        x = (x | x >> 1) & 0x33333333;
        x = (x | x >> 2) & 0xF0F0F0F;
        x = (x | x >> 4) & 0xFF00FF;
        x = (x | x >> 8) & 0xFFFF;
        return x;
    }
}

