/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class RepeatedPointTester {
    private Coordinate repeatedCoord;

    public Coordinate getCoordinate() {
        return this.repeatedCoord;
    }

    public boolean hasRepeatedPoint(Geometry g2) {
        if (g2.isEmpty()) {
            return false;
        }
        if (g2 instanceof Point) {
            return false;
        }
        if (g2 instanceof MultiPoint) {
            return false;
        }
        if (g2 instanceof LineString) {
            return this.hasRepeatedPoint(((LineString)g2).getCoordinates());
        }
        if (g2 instanceof Polygon) {
            return this.hasRepeatedPoint((Polygon)g2);
        }
        if (g2 instanceof GeometryCollection) {
            return this.hasRepeatedPoint((GeometryCollection)g2);
        }
        throw new UnsupportedOperationException(g2.getClass().getName());
    }

    public boolean hasRepeatedPoint(Coordinate[] coord) {
        for (int i2 = 1; i2 < coord.length; ++i2) {
            if (!coord[i2 - 1].equals(coord[i2])) continue;
            this.repeatedCoord = coord[i2];
            return true;
        }
        return false;
    }

    private boolean hasRepeatedPoint(Polygon p2) {
        if (this.hasRepeatedPoint(p2.getExteriorRing().getCoordinates())) {
            return true;
        }
        for (int i2 = 0; i2 < p2.getNumInteriorRing(); ++i2) {
            if (!this.hasRepeatedPoint(p2.getInteriorRingN(i2).getCoordinates())) continue;
            return true;
        }
        return false;
    }

    private boolean hasRepeatedPoint(GeometryCollection gc) {
        for (int i2 = 0; i2 < gc.getNumGeometries(); ++i2) {
            Geometry g2 = gc.getGeometryN(i2);
            if (!this.hasRepeatedPoint(g2)) continue;
            return true;
        }
        return false;
    }
}

