/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.noding.SegmentIntersector;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.operation.valid.PolygonNode;
import org.locationtech.jts.operation.valid.PolygonRing;

class PolygonIntersectionAnalyzer
implements SegmentIntersector {
    private static final int NO_INVALID_INTERSECTION = -1;
    private boolean isInvertedRingValid;
    private LineIntersector li = new RobustLineIntersector();
    private int invalidCode = -1;
    private Coordinate invalidLocation = null;
    private boolean hasDoubleTouch = false;
    private Coordinate doubleTouchLocation;

    PolygonIntersectionAnalyzer(boolean isInvertedRingValid) {
        this.isInvertedRingValid = isInvertedRingValid;
    }

    @Override
    public boolean isDone() {
        return this.isInvalid() || this.hasDoubleTouch;
    }

    public boolean isInvalid() {
        return this.invalidCode >= 0;
    }

    public int getInvalidCode() {
        return this.invalidCode;
    }

    public Coordinate getInvalidLocation() {
        return this.invalidLocation;
    }

    public boolean hasDoubleTouch() {
        return this.hasDoubleTouch;
    }

    public Coordinate getDoubleTouchLocation() {
        return this.doubleTouchLocation;
    }

    @Override
    public void processIntersections(SegmentString ss0, int segIndex0, SegmentString ss1, int segIndex1) {
        boolean isSameSegment;
        boolean isSameSegString = ss0 == ss1;
        boolean bl = isSameSegment = isSameSegString && segIndex0 == segIndex1;
        if (isSameSegment) {
            return;
        }
        int code = this.findInvalidIntersection(ss0, segIndex0, ss1, segIndex1);
        if (code != -1) {
            this.invalidCode = code;
            this.invalidLocation = this.li.getIntersection(0);
        }
    }

    private int findInvalidIntersection(SegmentString ss0, int segIndex0, SegmentString ss1, int segIndex1) {
        boolean isDoubleTouch;
        boolean hasCrossing;
        boolean isAdjacentSegments;
        boolean isSameSegString;
        Coordinate p00 = ss0.getCoordinate(segIndex0);
        Coordinate p01 = ss0.getCoordinate(segIndex0 + 1);
        Coordinate p10 = ss1.getCoordinate(segIndex1);
        Coordinate p11 = ss1.getCoordinate(segIndex1 + 1);
        this.li.computeIntersection(p00, p01, p10, p11);
        if (!this.li.hasIntersection()) {
            return -1;
        }
        boolean bl = isSameSegString = ss0 == ss1;
        if (this.li.isProper() || this.li.getIntersectionNum() >= 2) {
            return 5;
        }
        Coordinate intPt = this.li.getIntersection(0);
        boolean bl2 = isAdjacentSegments = isSameSegString && PolygonIntersectionAnalyzer.isAdjacentInRing(ss0, segIndex0, segIndex1);
        if (isAdjacentSegments) {
            return -1;
        }
        if (isSameSegString && !this.isInvertedRingValid) {
            return 6;
        }
        if (intPt.equals2D(p01) || intPt.equals2D(p11)) {
            return -1;
        }
        Coordinate e00 = p00;
        Coordinate e01 = p01;
        if (intPt.equals2D(p00)) {
            e00 = PolygonIntersectionAnalyzer.prevCoordinateInRing(ss0, segIndex0);
            e01 = p01;
        }
        Coordinate e10 = p10;
        Coordinate e11 = p11;
        if (intPt.equals2D(p10)) {
            e10 = PolygonIntersectionAnalyzer.prevCoordinateInRing(ss1, segIndex1);
            e11 = p11;
        }
        if (hasCrossing = PolygonNode.isCrossing(intPt, e00, e01, e10, e11)) {
            return 5;
        }
        if (isSameSegString && this.isInvertedRingValid) {
            this.addSelfTouch(ss0, intPt, e00, e01, e10, e11);
        }
        if ((isDoubleTouch = this.addDoubleTouch(ss0, ss1, intPt)) && !isSameSegString) {
            this.hasDoubleTouch = true;
            this.doubleTouchLocation = intPt;
        }
        return -1;
    }

    private boolean addDoubleTouch(SegmentString ss0, SegmentString ss1, Coordinate intPt) {
        return PolygonRing.addTouch((PolygonRing)ss0.getData(), (PolygonRing)ss1.getData(), intPt);
    }

    private void addSelfTouch(SegmentString ss2, Coordinate intPt, Coordinate e00, Coordinate e01, Coordinate e10, Coordinate e11) {
        PolygonRing polyRing = (PolygonRing)ss2.getData();
        if (polyRing == null) {
            throw new IllegalStateException("SegmentString missing PolygonRing data when checking self-touches");
        }
        polyRing.addSelfTouch(intPt, e00, e01, e10, e11);
    }

    private static Coordinate prevCoordinateInRing(SegmentString ringSS, int segIndex) {
        int prevIndex = segIndex - 1;
        if (prevIndex < 0) {
            prevIndex = ringSS.size() - 2;
        }
        return ringSS.getCoordinate(prevIndex);
    }

    private static boolean isAdjacentInRing(SegmentString ringSS, int segIndex0, int segIndex1) {
        int delta = Math.abs(segIndex1 - segIndex0);
        if (delta <= 1) {
            return true;
        }
        return delta >= ringSS.size() - 2;
    }
}

