/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlay;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.PointLocator;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.geomgraph.DirectedEdgeStar;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.operation.overlay.OverlayOp;
import org.locationtech.jts.util.Assert;

public class LineBuilder {
    private OverlayOp op;
    private GeometryFactory geometryFactory;
    private PointLocator ptLocator;
    private List lineEdgesList = new ArrayList();
    private List resultLineList = new ArrayList();

    public LineBuilder(OverlayOp op, GeometryFactory geometryFactory, PointLocator ptLocator) {
        this.op = op;
        this.geometryFactory = geometryFactory;
        this.ptLocator = ptLocator;
    }

    public List build(int opCode) {
        this.findCoveredLineEdges();
        this.collectLines(opCode);
        this.buildLines(opCode);
        return this.resultLineList;
    }

    private void findCoveredLineEdges() {
        for (Node node2 : this.op.getGraph().getNodes()) {
            ((DirectedEdgeStar)node2.getEdges()).findCoveredLineEdges();
        }
        for (DirectedEdge de : this.op.getGraph().getEdgeEnds()) {
            Edge e2 = de.getEdge();
            if (!de.isLineEdge() || e2.isCoveredSet()) continue;
            boolean isCovered = this.op.isCoveredByA(de.getCoordinate());
            e2.setCovered(isCovered);
        }
    }

    private void collectLines(int opCode) {
        for (DirectedEdge de : this.op.getGraph().getEdgeEnds()) {
            this.collectLineEdge(de, opCode, this.lineEdgesList);
            this.collectBoundaryTouchEdge(de, opCode, this.lineEdgesList);
        }
    }

    private void collectLineEdge(DirectedEdge de, int opCode, List edges) {
        Label label2 = de.getLabel();
        Edge e2 = de.getEdge();
        if (de.isLineEdge() && !de.isVisited() && OverlayOp.isResultOfOp(label2, opCode) && !e2.isCovered()) {
            edges.add(e2);
            de.setVisitedEdge(true);
        }
    }

    private void collectBoundaryTouchEdge(DirectedEdge de, int opCode, List edges) {
        Label label2 = de.getLabel();
        if (de.isLineEdge()) {
            return;
        }
        if (de.isVisited()) {
            return;
        }
        if (de.isInteriorAreaEdge()) {
            return;
        }
        if (de.getEdge().isInResult()) {
            return;
        }
        Assert.isTrue(!de.isInResult() && !de.getSym().isInResult() || !de.getEdge().isInResult());
        if (OverlayOp.isResultOfOp(label2, opCode) && opCode == 1) {
            edges.add(de.getEdge());
            de.setVisitedEdge(true);
        }
    }

    private void buildLines(int opCode) {
        for (Edge e2 : this.lineEdgesList) {
            LineString line = this.geometryFactory.createLineString(e2.getCoordinates());
            this.resultLineList.add(line);
            e2.setInResult(true);
        }
    }

    private void labelIsolatedLines(List edgesList) {
        for (Edge e2 : edgesList) {
            Label label2 = e2.getLabel();
            if (!e2.isIsolated()) continue;
            if (label2.isNull(0)) {
                this.labelIsolatedLine(e2, 0);
                continue;
            }
            this.labelIsolatedLine(e2, 1);
        }
    }

    private void labelIsolatedLine(Edge e2, int targetIndex) {
        int loc = this.ptLocator.locate(e2.getCoordinate(), this.op.getArgGeometry(targetIndex));
        e2.getLabel().setLocation(targetIndex, loc);
    }
}

