/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.linemerge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.operation.linemerge.EdgeString;
import org.locationtech.jts.operation.linemerge.LineMergeDirectedEdge;
import org.locationtech.jts.operation.linemerge.LineMergeGraph;
import org.locationtech.jts.planargraph.DirectedEdge;
import org.locationtech.jts.planargraph.GraphComponent;
import org.locationtech.jts.planargraph.Node;
import org.locationtech.jts.util.Assert;

public class LineMerger {
    private LineMergeGraph graph = new LineMergeGraph();
    private Collection mergedLineStrings = null;
    private GeometryFactory factory = null;
    private Collection edgeStrings = null;

    public void add(Geometry geometry) {
        geometry.apply(new GeometryComponentFilter(){

            @Override
            public void filter(Geometry component2) {
                if (component2 instanceof LineString) {
                    LineMerger.this.add((LineString)component2);
                }
            }
        });
    }

    public void add(Collection geometries) {
        this.mergedLineStrings = null;
        for (Geometry geometry : geometries) {
            this.add(geometry);
        }
    }

    private void add(LineString lineString) {
        if (this.factory == null) {
            this.factory = lineString.getFactory();
        }
        this.graph.addEdge(lineString);
    }

    private void merge() {
        if (this.mergedLineStrings != null) {
            return;
        }
        GraphComponent.setMarked(this.graph.nodeIterator(), false);
        GraphComponent.setMarked(this.graph.edgeIterator(), false);
        this.edgeStrings = new ArrayList();
        this.buildEdgeStringsForObviousStartNodes();
        this.buildEdgeStringsForIsolatedLoops();
        this.mergedLineStrings = new ArrayList();
        for (EdgeString edgeString : this.edgeStrings) {
            this.mergedLineStrings.add(edgeString.toLineString());
        }
    }

    private void buildEdgeStringsForObviousStartNodes() {
        this.buildEdgeStringsForNonDegree2Nodes();
    }

    private void buildEdgeStringsForIsolatedLoops() {
        this.buildEdgeStringsForUnprocessedNodes();
    }

    private void buildEdgeStringsForUnprocessedNodes() {
        for (Node node2 : this.graph.getNodes()) {
            if (node2.isMarked()) continue;
            Assert.isTrue(node2.getDegree() == 2);
            this.buildEdgeStringsStartingAt(node2);
            node2.setMarked(true);
        }
    }

    private void buildEdgeStringsForNonDegree2Nodes() {
        for (Node node2 : this.graph.getNodes()) {
            if (node2.getDegree() == 2) continue;
            this.buildEdgeStringsStartingAt(node2);
            node2.setMarked(true);
        }
    }

    private void buildEdgeStringsStartingAt(Node node2) {
        Iterator<DirectedEdge> i2 = node2.getOutEdges().iterator();
        while (i2.hasNext()) {
            LineMergeDirectedEdge directedEdge = (LineMergeDirectedEdge)i2.next();
            if (directedEdge.getEdge().isMarked()) continue;
            this.edgeStrings.add(this.buildEdgeStringStartingWith(directedEdge));
        }
    }

    private EdgeString buildEdgeStringStartingWith(LineMergeDirectedEdge start2) {
        EdgeString edgeString = new EdgeString(this.factory);
        LineMergeDirectedEdge current = start2;
        do {
            edgeString.add(current);
            current.getEdge().setMarked(true);
        } while ((current = current.getNext()) != null && current != start2);
        return edgeString;
    }

    public Collection getMergedLineStrings() {
        this.merge();
        return this.mergedLineStrings;
    }
}

