/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.distance3d;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;

public class AxisPlaneCoordinateSequence
implements CoordinateSequence {
    private static final int[] XY_INDEX = new int[]{0, 1};
    private static final int[] XZ_INDEX = new int[]{0, 2};
    private static final int[] YZ_INDEX = new int[]{1, 2};
    private CoordinateSequence seq;
    private int[] indexMap;

    public static CoordinateSequence projectToXY(CoordinateSequence seq) {
        return new AxisPlaneCoordinateSequence(seq, XY_INDEX);
    }

    public static CoordinateSequence projectToXZ(CoordinateSequence seq) {
        return new AxisPlaneCoordinateSequence(seq, XZ_INDEX);
    }

    public static CoordinateSequence projectToYZ(CoordinateSequence seq) {
        return new AxisPlaneCoordinateSequence(seq, YZ_INDEX);
    }

    private AxisPlaneCoordinateSequence(CoordinateSequence seq, int[] indexMap) {
        this.seq = seq;
        this.indexMap = indexMap;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public Coordinate getCoordinate(int i2) {
        return this.getCoordinateCopy(i2);
    }

    @Override
    public Coordinate getCoordinateCopy(int i2) {
        return new Coordinate(this.getX(i2), this.getY(i2), this.getZ(i2));
    }

    @Override
    public void getCoordinate(int index2, Coordinate coord) {
        coord.x = this.getOrdinate(index2, 0);
        coord.y = this.getOrdinate(index2, 1);
        coord.setZ(this.getOrdinate(index2, 2));
    }

    @Override
    public double getX(int index2) {
        return this.getOrdinate(index2, 0);
    }

    @Override
    public double getY(int index2) {
        return this.getOrdinate(index2, 1);
    }

    @Override
    public double getZ(int index2) {
        return this.getOrdinate(index2, 2);
    }

    @Override
    public double getOrdinate(int index2, int ordinateIndex) {
        if (ordinateIndex > 1) {
            return 0.0;
        }
        return this.seq.getOrdinate(index2, this.indexMap[ordinateIndex]);
    }

    @Override
    public int size() {
        return this.seq.size();
    }

    @Override
    public void setOrdinate(int index2, int ordinateIndex, double value2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Coordinate[] toCoordinateArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Envelope expandEnvelope(Envelope env) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AxisPlaneCoordinateSequence copy() {
        throw new UnsupportedOperationException();
    }
}

