/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io.kml;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.StringUtil;

public class KMLWriter {
    public static String ALTITUDE_MODE_CLAMPTOGROUND = "clampToGround ";
    public static String ALTITUDE_MODE_RELATIVETOGROUND = "relativeToGround  ";
    public static String ALTITUDE_MODE_ABSOLUTE = "absolute";
    private static final int INDENT_SIZE = 2;
    private static final String COORDINATE_SEPARATOR = ",";
    private static final String TUPLE_SEPARATOR = " ";
    private String linePrefix = null;
    private int maxCoordinatesPerLine = 5;
    private double zVal = Double.NaN;
    private boolean extrude = false;
    private boolean tesselate;
    private String altitudeMode = null;
    private DecimalFormat numberFormatter = null;

    public static String writeGeometry(Geometry geometry, double z) {
        KMLWriter writer = new KMLWriter();
        writer.setZ(z);
        return writer.write(geometry);
    }

    public static String writeGeometry(Geometry geometry, double z, int precision, boolean extrude, String altitudeMode) {
        KMLWriter writer = new KMLWriter();
        writer.setZ(z);
        writer.setPrecision(precision);
        writer.setExtrude(extrude);
        writer.setAltitudeMode(altitudeMode);
        return writer.write(geometry);
    }

    public void setLinePrefix(String linePrefix) {
        this.linePrefix = linePrefix;
    }

    public void setMaximumCoordinatesPerLine(int maxCoordinatesPerLine) {
        if (maxCoordinatesPerLine <= 0) {
            maxCoordinatesPerLine = 1;
            return;
        }
        this.maxCoordinatesPerLine = maxCoordinatesPerLine;
    }

    public void setZ(double zVal) {
        this.zVal = zVal;
    }

    public void setExtrude(boolean extrude) {
        this.extrude = extrude;
    }

    public void setTesselate(boolean tesselate) {
        this.tesselate = tesselate;
    }

    public void setAltitudeMode(String altitudeMode) {
        this.altitudeMode = altitudeMode;
    }

    public void setPrecision(int precision) {
        if (precision >= 0) {
            this.numberFormatter = KMLWriter.createFormatter(precision);
        }
    }

    public String write(Geometry geom) {
        StringBuffer buf = new StringBuffer();
        this.write(geom, buf);
        return buf.toString();
    }

    public void write(Geometry geometry, Writer writer) throws IOException {
        writer.write(this.write(geometry));
    }

    public void write(Geometry geometry, StringBuffer buf) {
        this.writeGeometry(geometry, 0, buf);
    }

    private void writeGeometry(Geometry g2, int level, StringBuffer buf) {
        String attributes2 = "";
        if (g2 instanceof Point) {
            this.writePoint((Point)g2, attributes2, level, buf);
        } else if (g2 instanceof LinearRing) {
            this.writeLinearRing((LinearRing)g2, attributes2, true, level, buf);
        } else if (g2 instanceof LineString) {
            this.writeLineString((LineString)g2, attributes2, level, buf);
        } else if (g2 instanceof Polygon) {
            this.writePolygon((Polygon)g2, attributes2, level, buf);
        } else if (g2 instanceof GeometryCollection) {
            this.writeGeometryCollection((GeometryCollection)g2, attributes2, level, buf);
        } else {
            throw new IllegalArgumentException("Geometry type not supported: " + g2.getGeometryType());
        }
    }

    private void startLine(String text2, int level, StringBuffer buf) {
        if (this.linePrefix != null) {
            buf.append(this.linePrefix);
        }
        buf.append(StringUtil.spaces(2 * level));
        buf.append(text2);
    }

    private String geometryTag(String geometryName, String attributes2) {
        StringBuffer buf = new StringBuffer();
        buf.append("<");
        buf.append(geometryName);
        if (attributes2 != null && attributes2.length() > 0) {
            buf.append(TUPLE_SEPARATOR);
            buf.append(attributes2);
        }
        buf.append(">");
        return buf.toString();
    }

    private void writeModifiers(int level, StringBuffer buf) {
        if (this.extrude) {
            this.startLine("<extrude>1</extrude>\n", level, buf);
        }
        if (this.tesselate) {
            this.startLine("<tesselate>1</tesselate>\n", level, buf);
        }
        if (this.altitudeMode != null) {
            this.startLine("<altitudeMode>" + this.altitudeMode + "</altitudeMode>\n", level, buf);
        }
    }

    private void writePoint(Point p2, String attributes2, int level, StringBuffer buf) {
        this.startLine(this.geometryTag("Point", attributes2) + "\n", level, buf);
        this.writeModifiers(level, buf);
        this.write(new Coordinate[]{p2.getCoordinate()}, level + 1, buf);
        this.startLine("</Point>\n", level, buf);
    }

    private void writeLineString(LineString ls, String attributes2, int level, StringBuffer buf) {
        this.startLine(this.geometryTag("LineString", attributes2) + "\n", level, buf);
        this.writeModifiers(level, buf);
        this.write(ls.getCoordinates(), level + 1, buf);
        this.startLine("</LineString>\n", level, buf);
    }

    private void writeLinearRing(LinearRing lr, String attributes2, boolean writeModifiers, int level, StringBuffer buf) {
        this.startLine(this.geometryTag("LinearRing", attributes2) + "\n", level, buf);
        if (writeModifiers) {
            this.writeModifiers(level, buf);
        }
        this.write(lr.getCoordinates(), level + 1, buf);
        this.startLine("</LinearRing>\n", level, buf);
    }

    private void writePolygon(Polygon p2, String attributes2, int level, StringBuffer buf) {
        this.startLine(this.geometryTag("Polygon", attributes2) + "\n", level, buf);
        this.writeModifiers(level, buf);
        this.startLine("  <outerBoundaryIs>\n", level, buf);
        this.writeLinearRing(p2.getExteriorRing(), null, false, level + 1, buf);
        this.startLine("  </outerBoundaryIs>\n", level, buf);
        for (int t = 0; t < p2.getNumInteriorRing(); ++t) {
            this.startLine("  <innerBoundaryIs>\n", level, buf);
            this.writeLinearRing(p2.getInteriorRingN(t), null, false, level + 1, buf);
            this.startLine("  </innerBoundaryIs>\n", level, buf);
        }
        this.startLine("</Polygon>\n", level, buf);
    }

    private void writeGeometryCollection(GeometryCollection gc, String attributes2, int level, StringBuffer buf) {
        this.startLine("<MultiGeometry>\n", level, buf);
        for (int t = 0; t < gc.getNumGeometries(); ++t) {
            this.writeGeometry(gc.getGeometryN(t), level + 1, buf);
        }
        this.startLine("</MultiGeometry>\n", level, buf);
    }

    private void write(Coordinate[] coords, int level, StringBuffer buf) {
        this.startLine("<coordinates>", level, buf);
        boolean isNewLine = false;
        for (int i2 = 0; i2 < coords.length; ++i2) {
            if (i2 > 0) {
                buf.append(TUPLE_SEPARATOR);
            }
            if (isNewLine) {
                this.startLine("  ", level, buf);
                isNewLine = false;
            }
            this.write(coords[i2], buf);
            if ((i2 + 1) % this.maxCoordinatesPerLine != 0 || i2 >= coords.length - 1) continue;
            buf.append("\n");
            isNewLine = true;
        }
        buf.append("</coordinates>\n");
    }

    private void write(Coordinate p2, StringBuffer buf) {
        this.write(p2.x, buf);
        buf.append(COORDINATE_SEPARATOR);
        this.write(p2.y, buf);
        double z = p2.getZ();
        if (!Double.isNaN(this.zVal)) {
            z = this.zVal;
        }
        if (!Double.isNaN(z)) {
            buf.append(COORDINATE_SEPARATOR);
            this.write(z, buf);
        }
    }

    private void write(double num, StringBuffer buf) {
        if (this.numberFormatter != null) {
            buf.append(this.numberFormatter.format(num));
        } else {
            buf.append(num);
        }
    }

    private static DecimalFormat createFormatter(int precision) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DecimalFormat format2 = new DecimalFormat("0." + StringUtil.chars('#', precision), symbols);
        format2.setDecimalSeparatorAlwaysShown(false);
        return format2;
    }
}

