/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.quadtree;

public class DoubleBits {
    public static final int EXPONENT_BIAS = 1023;
    private double x;
    private long xBits;

    public static double powerOf2(int exp) {
        if (exp > 1023 || exp < -1022) {
            throw new IllegalArgumentException("Exponent out of bounds");
        }
        long expBias = exp + 1023;
        long bits = expBias << 52;
        return Double.longBitsToDouble(bits);
    }

    public static int exponent(double d2) {
        DoubleBits db = new DoubleBits(d2);
        return db.getExponent();
    }

    public static double truncateToPowerOfTwo(double d2) {
        DoubleBits db = new DoubleBits(d2);
        db.zeroLowerBits(52);
        return db.getDouble();
    }

    public static String toBinaryString(double d2) {
        DoubleBits db = new DoubleBits(d2);
        return db.toString();
    }

    public static double maximumCommonMantissa(double d1, double d2) {
        if (d1 == 0.0 || d2 == 0.0) {
            return 0.0;
        }
        DoubleBits db1 = new DoubleBits(d1);
        DoubleBits db2 = new DoubleBits(d2);
        if (db1.getExponent() != db2.getExponent()) {
            return 0.0;
        }
        int maxCommon = db1.numCommonMantissaBits(db2);
        db1.zeroLowerBits(64 - (12 + maxCommon));
        return db1.getDouble();
    }

    public DoubleBits(double x) {
        this.x = x;
        this.xBits = Double.doubleToLongBits(x);
    }

    public double getDouble() {
        return Double.longBitsToDouble(this.xBits);
    }

    public int biasedExponent() {
        int signExp = (int)(this.xBits >> 52);
        int exp = signExp & 0x7FF;
        return exp;
    }

    public int getExponent() {
        return this.biasedExponent() - 1023;
    }

    public void zeroLowerBits(int nBits) {
        long invMask = (1L << nBits) - 1L;
        long mask = invMask ^ 0xFFFFFFFFFFFFFFFFL;
        this.xBits &= mask;
    }

    public int getBit(int i2) {
        long mask = 1L << i2;
        return (this.xBits & mask) != 0L ? 1 : 0;
    }

    public int numCommonMantissaBits(DoubleBits db) {
        for (int i2 = 0; i2 < 52; ++i2) {
            if (this.getBit(i2) == db.getBit(i2)) continue;
            return i2;
        }
        return 52;
    }

    public String toString() {
        String numStr = Long.toBinaryString(this.xBits);
        String zero64 = "0000000000000000000000000000000000000000000000000000000000000000";
        String padStr = zero64 + numStr;
        String bitStr = padStr.substring(padStr.length() - 64);
        String str = bitStr.substring(0, 1) + "  " + bitStr.substring(1, 12) + "(" + this.getExponent() + ") " + bitStr.substring(12) + " [ " + this.x + " ]";
        return str;
    }
}

