/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class GeometryCombiner {
    private GeometryFactory geomFactory;
    private boolean skipEmpty = false;
    private Collection inputGeoms;

    public static Geometry combine(Collection geoms) {
        GeometryCombiner combiner = new GeometryCombiner(geoms);
        return combiner.combine();
    }

    public static Geometry combine(Geometry g0, Geometry g1) {
        GeometryCombiner combiner = new GeometryCombiner(GeometryCombiner.createList(g0, g1));
        return combiner.combine();
    }

    public static Geometry combine(Geometry g0, Geometry g1, Geometry g2) {
        GeometryCombiner combiner = new GeometryCombiner(GeometryCombiner.createList(g0, g1, g2));
        return combiner.combine();
    }

    private static List createList(Object obj0, Object obj1) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(obj0);
        list.add(obj1);
        return list;
    }

    private static List createList(Object obj0, Object obj1, Object obj2) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(obj0);
        list.add(obj1);
        list.add(obj2);
        return list;
    }

    public GeometryCombiner(Collection geoms) {
        this.geomFactory = GeometryCombiner.extractFactory(geoms);
        this.inputGeoms = geoms;
    }

    public static GeometryFactory extractFactory(Collection geoms) {
        if (geoms.isEmpty()) {
            return null;
        }
        return ((Geometry)geoms.iterator().next()).getFactory();
    }

    public Geometry combine() {
        ArrayList elems = new ArrayList();
        for (Geometry g2 : this.inputGeoms) {
            this.extractElements(g2, elems);
        }
        if (elems.size() == 0) {
            if (this.geomFactory != null) {
                return this.geomFactory.createGeometryCollection();
            }
            return null;
        }
        return this.geomFactory.buildGeometry(elems);
    }

    private void extractElements(Geometry geom, List elems) {
        if (geom == null) {
            return;
        }
        for (int i2 = 0; i2 < geom.getNumGeometries(); ++i2) {
            Geometry elemGeom = geom.getGeometryN(i2);
            if (this.skipEmpty && elemGeom.isEmpty()) continue;
            elems.add(elemGeom);
        }
    }
}

