/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.hull;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.hull.HullTri;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Triangle;
import org.locationtech.jts.operation.overlayng.CoverageUnion;
import org.locationtech.jts.triangulate.DelaunayTriangulationBuilder;
import org.locationtech.jts.triangulate.quadedge.QuadEdge;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;
import org.locationtech.jts.triangulate.quadedge.TriangleVisitor;
import org.locationtech.jts.triangulate.tri.Tri;
import org.locationtech.jts.triangulate.tri.TriangulationBuilder;
import org.locationtech.jts.util.Assert;

class HullTriangulation {
    HullTriangulation() {
    }

    public static List<HullTri> createDelaunayTriangulation(Geometry geom) {
        DelaunayTriangulationBuilder dt = new DelaunayTriangulationBuilder();
        dt.setSites(geom);
        QuadEdgeSubdivision subdiv = dt.getSubdivision();
        List<HullTri> triList = HullTriangulation.toTris(subdiv);
        return triList;
    }

    private static List<HullTri> toTris(QuadEdgeSubdivision subdiv) {
        HullTriVisitor visitor2 = new HullTriVisitor();
        subdiv.visitTriangles(visitor2, false);
        List<HullTri> triList = visitor2.getTriangles();
        TriangulationBuilder.build(triList);
        return triList;
    }

    public static Geometry union(List<? extends Tri> triList, GeometryFactory geomFactory) {
        ArrayList<Polygon> polys = new ArrayList<Polygon>();
        for (Tri tri : triList) {
            Polygon poly = tri.toPolygon(geomFactory);
            polys.add(poly);
        }
        return CoverageUnion.union(geomFactory.buildGeometry(polys));
    }

    public static Geometry traceBoundaryPolygon(List<HullTri> triList, GeometryFactory geomFactory) {
        if (triList.size() == 1) {
            Tri tri = triList.get(0);
            return tri.toPolygon(geomFactory);
        }
        Coordinate[] pts = HullTriangulation.traceBoundary(triList);
        return geomFactory.createPolygon(pts);
    }

    private static Coordinate[] traceBoundary(List<HullTri> triList) {
        HullTri triStart = HullTriangulation.findBorderTri(triList);
        CoordinateList coordList = new CoordinateList();
        HullTri tri = triStart;
        do {
            int boundaryIndex = tri.boundaryIndexCCW();
            coordList.add(tri.getCoordinate(boundaryIndex).copy(), false);
            int nextIndex = Tri.next(boundaryIndex);
            if (!tri.isBoundary(nextIndex)) continue;
            coordList.add(tri.getCoordinate(nextIndex).copy(), false);
            boundaryIndex = nextIndex;
        } while ((tri = HullTriangulation.nextBorderTri(tri)) != triStart);
        coordList.closeRing();
        return coordList.toCoordinateArray();
    }

    private static HullTri findBorderTri(List<HullTri> triList) {
        for (HullTri tri : triList) {
            if (!tri.isBorder()) continue;
            return tri;
        }
        Assert.shouldNeverReachHere("No border triangles found");
        return null;
    }

    public static HullTri nextBorderTri(HullTri triStart) {
        HullTri adjTri;
        HullTri tri = triStart;
        int index2 = Tri.next(tri.boundaryIndexCW());
        do {
            if ((adjTri = (HullTri)tri.getAdjacent(index2)) != tri) continue;
            throw new IllegalStateException("No outgoing border edge found");
        } while (!(tri = adjTri).isBoundary(index2 = Tri.next(adjTri.getIndex(tri))));
        return tri;
    }

    private static class HullTriVisitor
    implements TriangleVisitor {
        private List<HullTri> triList = new ArrayList<HullTri>();

        @Override
        public void visit(QuadEdge[] triEdges) {
            Coordinate p2;
            Coordinate p1;
            Coordinate p0 = triEdges[0].orig().getCoordinate();
            HullTri tri = Triangle.isCCW(p0, p1 = triEdges[1].orig().getCoordinate(), p2 = triEdges[2].orig().getCoordinate()) ? new HullTri(p0, p2, p1) : new HullTri(p0, p1, p2);
            this.triList.add(tri);
        }

        public List<HullTri> getTriangles() {
            return this.triList;
        }
    }
}

